/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import com.sun.jdi.AbsentInformationException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.Vector;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.modules.debugger.jpda.ui.models.BoldVariablesTableModelFilterFirst;
import org.netbeans.modules.debugger.jpda.ui.models.CallStackNodeModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class ThreadsNodeModel
implements NodeModel {
    public static final String CURRENT_THREAD = "org/netbeans/modules/debugger/resources/threadsView/CurrentThread";
    public static final String RUNNING_THREAD = "org/netbeans/modules/debugger/resources/threadsView/RunningThread";
    public static final String SUSPENDED_THREAD = "org/netbeans/modules/debugger/resources/threadsView/SuspendedThread";
    public static final String THREAD_GROUP = "org/netbeans/modules/debugger/resources/threadsView/ThreadGroup";
    public static final String CURRENT_THREAD_GROUP = "org/netbeans/modules/debugger/resources/threadsView/CurrentThreadGroup";
    private JPDADebugger debugger;
    private Session session;
    private Vector listeners = new Vector();

    public ThreadsNodeModel(ContextProvider contextProvider) {
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        this.session = (Session)contextProvider.lookupFirst(null, Session.class);
        new Listener(this, this.debugger);
    }

    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return NbBundle.getBundle((Class)ThreadsNodeModel.class).getString("CTL_ThreadsModel_Column_Name_Name");
        }
        if (object instanceof JPDAThread) {
            if (this.debugger.getCurrentThread() == object) {
                return BoldVariablesTableModelFilterFirst.toHTML(((JPDAThread)object).getName(), true, false, null);
            }
            return ((JPDAThread)object).getName();
        }
        if (object instanceof JPDAThreadGroup) {
            if (this.isCurrent((JPDAThreadGroup)object)) {
                return BoldVariablesTableModelFilterFirst.toHTML(((JPDAThreadGroup)object).getName(), true, false, null);
            }
            return ((JPDAThreadGroup)object).getName();
        }
        throw new UnknownTypeException(object);
    }

    public String getShortDescription(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return NbBundle.getBundle((Class)ThreadsNodeModel.class).getString("CTL_ThreadsModel_Column_Name_Desc");
        }
        if (object instanceof JPDAThread) {
            ObjectVariable objectVariable;
            JPDAThread jPDAThread = (JPDAThread)object;
            int n = jPDAThread.getState();
            String string = "";
            switch (n) {
                case -1: {
                    string = NbBundle.getBundle((Class)ThreadsNodeModel.class).getString("CTL_ThreadsModel_State_Unknown");
                    break;
                }
                case 3: {
                    objectVariable = jPDAThread.getContendedMonitor();
                    if (objectVariable == null) {
                        string = NbBundle.getBundle((Class)ThreadsNodeModel.class).getString("CTL_ThreadsModel_State_Monitor");
                        break;
                    }
                    try {
                        string = MessageFormat.format(NbBundle.getBundle((Class)ThreadsNodeModel.class).getString("CTL_ThreadsModel_State_ConcreteMonitor"), objectVariable.getToStringValue());
                    }
                    catch (InvalidExpressionException invalidExpressionException) {
                        string = invalidExpressionException.getLocalizedMessage();
                    }
                    break;
                }
                case 5: {
                    string = NbBundle.getBundle((Class)ThreadsNodeModel.class).getString("CTL_ThreadsModel_State_NotStarted");
                    break;
                }
                case 1: {
                    string = NbBundle.getBundle((Class)ThreadsNodeModel.class).getString("CTL_ThreadsModel_State_Running");
                    break;
                }
                case 2: {
                    string = NbBundle.getBundle((Class)ThreadsNodeModel.class).getString("CTL_ThreadsModel_State_Sleeping");
                    break;
                }
                case 4: {
                    objectVariable = jPDAThread.getContendedMonitor();
                    if (objectVariable == null) {
                        string = NbBundle.getBundle((Class)ThreadsNodeModel.class).getString("CTL_ThreadsModel_State_Waiting");
                        break;
                    }
                    try {
                        string = MessageFormat.format(NbBundle.getBundle((Class)ThreadsNodeModel.class).getString("CTL_ThreadsModel_State_WaitingOn"), objectVariable.getToStringValue());
                    }
                    catch (InvalidExpressionException invalidExpressionException) {
                        string = invalidExpressionException.getLocalizedMessage();
                    }
                    break;
                }
                case 0: {
                    string = NbBundle.getBundle((Class)ThreadsNodeModel.class).getString("CTL_ThreadsModel_State_Zombie");
                }
            }
            if (jPDAThread.isSuspended() && jPDAThread.getStackDepth() > 0) {
                try {
                    objectVariable = jPDAThread.getCallStack(0, 1)[0];
                    string = string + " " + CallStackNodeModel.getCSFName(this.session, (CallStackFrame)objectVariable, true);
                }
                catch (AbsentInformationException absentInformationException) {
                    // empty catch block
                }
            }
            return string;
        }
        if (object instanceof JPDAThreadGroup) {
            return ((JPDAThreadGroup)object).getName();
        }
        throw new UnknownTypeException(object);
    }

    public String getIconBase(Object object) throws UnknownTypeException {
        if (object instanceof String) {
            return THREAD_GROUP;
        }
        if (object instanceof JPDAThread) {
            if (object == this.debugger.getCurrentThread()) {
                return CURRENT_THREAD;
            }
            return ((JPDAThread)object).isSuspended() ? SUSPENDED_THREAD : RUNNING_THREAD;
        }
        if (object instanceof JPDAThreadGroup) {
            if (this.isCurrent((JPDAThreadGroup)object)) {
                return CURRENT_THREAD_GROUP;
            }
            return THREAD_GROUP;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    private void fireTreeChanged() {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged(null);
        }
    }

    private boolean isCurrent(JPDAThreadGroup jPDAThreadGroup) {
        JPDAThread jPDAThread = this.debugger.getCurrentThread();
        if (jPDAThread == null) {
            return false;
        }
        for (JPDAThreadGroup jPDAThreadGroup2 = jPDAThread.getParentThreadGroup(); jPDAThreadGroup2 != null; jPDAThreadGroup2 = jPDAThreadGroup2.getParentThreadGroup()) {
            if (jPDAThreadGroup2 != jPDAThreadGroup) continue;
            return true;
        }
        return false;
    }

    private static class Listener
    implements PropertyChangeListener {
        private WeakReference ref;
        private JPDADebugger debugger;

        private Listener(ThreadsNodeModel threadsNodeModel, JPDADebugger jPDADebugger) {
            this.ref = new WeakReference<ThreadsNodeModel>(threadsNodeModel);
            this.debugger = jPDADebugger;
            jPDADebugger.addPropertyChangeListener("currentThread", (PropertyChangeListener)this);
        }

        private ThreadsNodeModel getModel() {
            ThreadsNodeModel threadsNodeModel = (ThreadsNodeModel)this.ref.get();
            if (threadsNodeModel == null) {
                this.debugger.removePropertyChangeListener("currentThread", (PropertyChangeListener)this);
            }
            return threadsNodeModel;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ThreadsNodeModel threadsNodeModel = this.getModel();
            if (threadsNodeModel == null) {
                return;
            }
            threadsNodeModel.fireTreeChanged();
        }
    }
}

