/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.util.Vector;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.modules.debugger.jpda.ui.models.MonitorModel;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class ThreadsTableModel
implements TableModel,
Constants {
    private Vector listeners = new Vector();

    public Object getValueAt(Object object, String string) throws UnknownTypeException {
        if (object instanceof MonitorModel.ThreadWithBordel) {
            object = ((MonitorModel.ThreadWithBordel)object).originalThread;
        }
        if (object instanceof JPDAThreadGroup) {
            if (string.equals("ThreadState")) {
                return "";
            }
            if (string.equals("ThreadSuspended")) {
                JPDAThreadGroup jPDAThreadGroup = (JPDAThreadGroup)object;
                JPDAThread[] jPDAThreadArray = jPDAThreadGroup.getThreads();
                if (jPDAThreadArray.length < 1) {
                    return Boolean.FALSE;
                }
                return new Boolean(jPDAThreadArray[0].isSuspended());
            }
        }
        if (object instanceof JPDAThread) {
            if (string.equals("ThreadState")) {
                switch (((JPDAThread)object).getState()) {
                    case 3: {
                        return NbBundle.getMessage((Class)ThreadsTableModel.class, (String)"CTL_Thread_State_OnMonitor");
                    }
                    case 5: {
                        return NbBundle.getMessage((Class)ThreadsTableModel.class, (String)"CTL_Thread_State_NotStarted");
                    }
                    case 1: {
                        return NbBundle.getMessage((Class)ThreadsTableModel.class, (String)"CTL_Thread_State_Running");
                    }
                    case 2: {
                        return NbBundle.getMessage((Class)ThreadsTableModel.class, (String)"CTL_Thread_State_Sleeping");
                    }
                    case -1: {
                        return NbBundle.getMessage((Class)ThreadsTableModel.class, (String)"CTL_Thread_State_Unknown");
                    }
                    case 4: {
                        return NbBundle.getMessage((Class)ThreadsTableModel.class, (String)"CTL_Thread_State_Waiting");
                    }
                    case 0: {
                        return NbBundle.getMessage((Class)ThreadsTableModel.class, (String)"CTL_Thread_State_Zombie");
                    }
                }
            } else if (string.equals("ThreadSuspended")) {
                return ((JPDAThread)object).isSuspended();
            }
        }
        throw new UnknownTypeException(object);
    }

    public boolean isReadOnly(Object object, String string) throws UnknownTypeException {
        if (object instanceof MonitorModel.ThreadWithBordel) {
            object = ((MonitorModel.ThreadWithBordel)object).originalThread;
        }
        if (object instanceof JPDAThreadGroup) {
            if (string.equals("ThreadState")) {
                return true;
            }
            if (string.equals("ThreadSuspended")) {
                return false;
            }
        }
        if (object instanceof JPDAThread) {
            if (string.equals("ThreadState")) {
                return true;
            }
            if (string.equals("ThreadSuspended")) {
                return false;
            }
        }
        throw new UnknownTypeException(object);
    }

    public void setValueAt(Object object, String string, Object object2) throws UnknownTypeException {
        if (object instanceof MonitorModel.ThreadWithBordel) {
            object = ((MonitorModel.ThreadWithBordel)object).originalThread;
        }
        if (object instanceof JPDAThreadGroup && string.equals("ThreadSuspended")) {
            if (((Boolean)object2).booleanValue()) {
                ((JPDAThreadGroup)object).suspend();
            } else {
                ((JPDAThreadGroup)object).resume();
            }
            this.fireTableValueChanged(object, "ThreadSuspended");
            return;
        }
        if (object instanceof JPDAThread && string.equals("ThreadSuspended")) {
            if (object2.equals(Boolean.TRUE)) {
                ((JPDAThread)object).suspend();
            } else {
                ((JPDAThread)object).resume();
            }
            this.fireTableValueChanged(object, "ThreadSuspended");
            return;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    private void fireTableValueChanged(Object object, String string) {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged((ModelEvent)new ModelEvent.TableValueChanged((Object)this, object, string));
        }
    }
}

