/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.LocalVariable;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Super;
import org.netbeans.api.debugger.jpda.This;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class VariablesNodeModel
implements NodeModel {
    public static final String FIELD = "org/netbeans/modules/debugger/resources/watchesView/Field";
    public static final String LOCAL = "org/netbeans/modules/debugger/resources/localsView/LocalVariable";
    public static final String FIXED_WATCH = "org/netbeans/modules/debugger/resources/watchesView/FixedWatch";
    public static final String STATIC_FIELD = "org/netbeans/modules/debugger/resources/watchesView/StaticField";
    public static final String SUPER = "org/netbeans/modules/debugger/resources/watchesView/SuperVariable";
    private JPDADebugger debugger;
    private RequestProcessor evaluationRP = new RequestProcessor();
    private final Collection modelListeners = new HashSet();
    private Map shortDescriptionMap = new HashMap();

    public VariablesNodeModel(ContextProvider contextProvider) {
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
    }

    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return NbBundle.getBundle((Class)VariablesNodeModel.class).getString("CTL_LocalsModel_Column_Name_Name");
        }
        if (object instanceof Field) {
            return ((Field)object).getName();
        }
        if (object instanceof LocalVariable) {
            return ((LocalVariable)object).getName();
        }
        if (object instanceof Super) {
            return "super";
        }
        if (object instanceof This) {
            return "this";
        }
        if (object == "NoInfo") {
            return NbBundle.getMessage((Class)VariablesNodeModel.class, (String)"CTL_No_Info");
        }
        if (object == "No current thread") {
            return NbBundle.getMessage((Class)VariablesNodeModel.class, (String)"NoCurrentThreadVar");
        }
        String string = object.toString();
        if (string.startsWith("SubArray")) {
            int n = string.indexOf(45);
            return NbBundle.getMessage((Class)VariablesNodeModel.class, (String)"CTL_LocalsModel_Column_Name_SubArray", (Object)string.substring(8, n), (Object)string.substring(n + 1));
        }
        throw new UnknownTypeException(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShortDescription(final Object object) throws UnknownTypeException {
        Map map = this.shortDescriptionMap;
        synchronized (map) {
            Object v = this.shortDescriptionMap.remove(object);
            if (v instanceof String) {
                return (String)v;
            }
            if (v instanceof UnknownTypeException) {
                throw (UnknownTypeException)((Object)v);
            }
        }
        this.testKnown(object);
        this.evaluationRP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String string = VariablesNodeModel.this.getShortDescriptionSynch(object);
                if (string != null && !"".equals(string)) {
                    Map map = VariablesNodeModel.this.shortDescriptionMap;
                    synchronized (map) {
                        VariablesNodeModel.this.shortDescriptionMap.put(object, string);
                    }
                    VariablesNodeModel.this.fireModelChange((ModelEvent)new ModelEvent.NodeChanged((Object)VariablesNodeModel.this, object, 4));
                }
            }
        });
        return "";
    }

    private String getShortDescriptionSynch(Object object) {
        if (object == "Root") {
            return NbBundle.getBundle((Class)VariablesNodeModel.class).getString("CTL_LocalsModel_Column_Name_Desc");
        }
        if (object instanceof Field) {
            if (object instanceof ObjectVariable) {
                String string;
                String string2 = ((ObjectVariable)object).getType();
                if (string2.equals(string = ((Field)object).getDeclaredType())) {
                    try {
                        return "(" + string2 + ") " + ((ObjectVariable)object).getToStringValue();
                    }
                    catch (InvalidExpressionException invalidExpressionException) {
                        return invalidExpressionException.getLocalizedMessage();
                    }
                }
                try {
                    return "(" + string + ") " + "(" + string2 + ") " + ((ObjectVariable)object).getToStringValue();
                }
                catch (InvalidExpressionException invalidExpressionException) {
                    return invalidExpressionException.getLocalizedMessage();
                }
            }
            return "(" + ((Field)object).getDeclaredType() + ") " + ((Field)object).getValue();
        }
        if (object instanceof LocalVariable) {
            if (object instanceof ObjectVariable) {
                String string;
                String string3 = ((ObjectVariable)object).getType();
                if (string3.equals(string = ((LocalVariable)object).getDeclaredType())) {
                    try {
                        return "(" + string3 + ") " + ((ObjectVariable)object).getToStringValue();
                    }
                    catch (InvalidExpressionException invalidExpressionException) {
                        return invalidExpressionException.getLocalizedMessage();
                    }
                }
                try {
                    return "(" + string + ") " + "(" + string3 + ") " + ((ObjectVariable)object).getToStringValue();
                }
                catch (InvalidExpressionException invalidExpressionException) {
                    return invalidExpressionException.getLocalizedMessage();
                }
            }
            return "(" + ((LocalVariable)object).getDeclaredType() + ") " + ((LocalVariable)object).getValue();
        }
        if (object instanceof Super) {
            return ((Super)object).getType();
        }
        if (object instanceof This) {
            try {
                return "(" + ((This)object).getType() + ") " + ((This)object).getToStringValue();
            }
            catch (InvalidExpressionException invalidExpressionException) {
                return invalidExpressionException.getLocalizedMessage();
            }
        }
        String string = object.toString();
        if (string.startsWith("SubArray")) {
            int n = string.indexOf(45);
            return NbBundle.getMessage((Class)VariablesNodeModel.class, (String)"CTL_LocalsModel_Column_Descr_SubArray", (Object)string.substring(8, n), (Object)string.substring(n + 1));
        }
        if (object == "NoInfo") {
            return NbBundle.getMessage((Class)VariablesNodeModel.class, (String)"CTL_No_Info_descr");
        }
        if (object == "No current thread") {
            return NbBundle.getMessage((Class)VariablesNodeModel.class, (String)"NoCurrentThreadVar");
        }
        return null;
    }

    private void testKnown(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return;
        }
        if (object instanceof Field) {
            return;
        }
        if (object instanceof LocalVariable) {
            return;
        }
        if (object instanceof Super) {
            return;
        }
        if (object instanceof This) {
            return;
        }
        String string = object.toString();
        if (string.startsWith("SubArray")) {
            return;
        }
        if (object == "NoInfo") {
            return;
        }
        if (object == "No current thread") {
            return;
        }
        throw new UnknownTypeException(object);
    }

    public String getIconBase(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return FIELD;
        }
        if (object instanceof Field) {
            if (((Field)object).isStatic()) {
                return STATIC_FIELD;
            }
            return FIELD;
        }
        if (object instanceof LocalVariable) {
            return LOCAL;
        }
        if (object instanceof Super) {
            return SUPER;
        }
        if (object instanceof This) {
            return FIELD;
        }
        if (object.toString().startsWith("SubArray")) {
            return LOCAL;
        }
        if (object == "NoInfo" || object == "No current thread") {
            return null;
        }
        throw new UnknownTypeException(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener modelListener) {
        Collection collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.add(modelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener modelListener) {
        Collection collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.remove(modelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireModelChange(ModelEvent modelEvent) {
        Object[] objectArray;
        Collection collection = this.modelListeners;
        synchronized (collection) {
            objectArray = this.modelListeners.toArray();
        }
        for (int i = 0; i < objectArray.length; ++i) {
            ((ModelListener)objectArray[i]).modelChanged(modelEvent);
        }
    }
}

