/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAWatch;
import org.netbeans.api.debugger.jpda.LocalVariable;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Super;
import org.netbeans.api.debugger.jpda.This;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class VariablesTableModel
implements TableModel,
Constants {
    private JPDADebugger debugger;

    public VariablesTableModel(ContextProvider contextProvider) {
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
    }

    public Object getValueAt(Object object, String string) throws UnknownTypeException {
        if (string.equals("LocalsToString") || string.equals("WatchToString")) {
            if (object instanceof Super) {
                return "";
            }
            if (object instanceof ObjectVariable) {
                try {
                    return ((ObjectVariable)object).getToStringValue();
                }
                catch (InvalidExpressionException invalidExpressionException) {
                    return VariablesTableModel.getMessage(invalidExpressionException);
                }
            }
            if (object instanceof Variable) {
                return ((Variable)object).getValue();
            }
        } else if (string.equals("LocalsType") || string.equals("WatchType")) {
            if (object instanceof Variable) {
                return VariablesTableModel.getShort(((Variable)object).getType());
            }
        } else if (string.equals("LocalsValue") || string.equals("WatchValue")) {
            if (object instanceof JPDAWatch) {
                JPDAWatch jPDAWatch = (JPDAWatch)object;
                String string2 = jPDAWatch.getExceptionDescription();
                if (string2 != null) {
                    return ">" + string2 + "<";
                }
                return jPDAWatch.getValue();
            }
            if (object instanceof Variable) {
                return ((Variable)object).getValue();
            }
        }
        if (object.toString().startsWith("SubArray")) {
            return "";
        }
        throw new UnknownTypeException(object);
    }

    public boolean isReadOnly(Object object, String string) throws UnknownTypeException {
        if (object instanceof Variable) {
            if (string.equals("LocalsToString") || string.equals("WatchToString") || string.equals("LocalsType") || string.equals("WatchType")) {
                return true;
            }
            if (string.equals("LocalsValue") || string.equals("WatchValue")) {
                if (object instanceof This) {
                    return true;
                }
                if (object instanceof LocalVariable || object instanceof Field || object instanceof JPDAWatch) {
                    return !this.debugger.canBeModified();
                }
                return true;
            }
        }
        if (object.toString().startsWith("SubArray")) {
            return true;
        }
        throw new UnknownTypeException(object);
    }

    public void setValueAt(Object object, String string, Object object2) throws UnknownTypeException {
        if (object instanceof LocalVariable && string.equals("LocalsValue")) {
            try {
                ((LocalVariable)object).setValue((String)object2);
            }
            catch (InvalidExpressionException invalidExpressionException) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)invalidExpressionException.getLocalizedMessage(), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
            return;
        }
        if (object instanceof Field && (string.equals("LocalsValue") || string.equals("WatchValue"))) {
            try {
                ((Field)object).setValue((String)object2);
            }
            catch (InvalidExpressionException invalidExpressionException) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)invalidExpressionException.getLocalizedMessage(), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
            return;
        }
        if (object instanceof JPDAWatch && (string.equals("LocalsValue") || string.equals("WatchValue"))) {
            try {
                ((JPDAWatch)object).setValue((String)object2);
            }
            catch (InvalidExpressionException invalidExpressionException) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)invalidExpressionException.getLocalizedMessage(), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
            return;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
    }

    public void removeModelListener(ModelListener modelListener) {
    }

    static String getShort(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    private static String getMessage(InvalidExpressionException invalidExpressionException) {
        String string = invalidExpressionException.getLocalizedMessage();
        if (string == null) {
            string = invalidExpressionException.getMessage();
        }
        return ">" + string + "<";
    }
}

