/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAWatch;
import org.netbeans.modules.debugger.jpda.ui.models.VariablesNodeModel;
import org.netbeans.modules.debugger.jpda.ui.models.VariablesTreeModelFilter;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class WatchesNodeModel
extends VariablesNodeModel {
    public static final String WATCH = "org/netbeans/modules/debugger/resources/watchesView/Watch";

    public WatchesNodeModel(ContextProvider contextProvider) {
        super(contextProvider);
    }

    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return NbBundle.getBundle((Class)WatchesNodeModel.class).getString("CTL_WatchesModel_Column_Name_Name");
        }
        if (object instanceof JPDAWatch) {
            return ((JPDAWatch)object).getExpression();
        }
        return super.getDisplayName(object);
    }

    public String getShortDescription(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return "Root";
        }
        if (object instanceof JPDAWatch) {
            JPDAWatch jPDAWatch = (JPDAWatch)object;
            boolean bl = VariablesTreeModelFilter.isEvaluated(object);
            if (!bl) {
                return jPDAWatch.getExpression();
            }
            String string = jPDAWatch.getExceptionDescription();
            if (string != null) {
                return jPDAWatch.getExpression() + " = >" + string + "<";
            }
            String string2 = jPDAWatch.getType();
            if (string2 == null) {
                return jPDAWatch.getExpression() + " = " + jPDAWatch.getValue();
            }
            try {
                return jPDAWatch.getExpression() + " = (" + jPDAWatch.getType() + ") " + jPDAWatch.getToStringValue();
            }
            catch (InvalidExpressionException invalidExpressionException) {
                return invalidExpressionException.getLocalizedMessage();
            }
        }
        return super.getShortDescription(object);
    }

    public String getIconBase(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return WATCH;
        }
        if (object instanceof JPDAWatch) {
            return WATCH;
        }
        return super.getIconBase(object);
    }

    public void addModelListener(ModelListener modelListener) {
    }

    public void removeModelListener(ModelListener modelListener) {
    }
}

