/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.httpserver;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.httpserver.HostPropertyEditor;
import org.netbeans.modules.httpserver.HttpServerNode;
import org.netbeans.modules.httpserver.HttpServerSettings;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class HostPropertyCustomEditor
extends JPanel
implements HelpCtx.Provider,
ActionListener,
EnhancedCustomPropertyEditor {
    private HostPropertyEditor editor;
    private JScrollPane grantScrollPane;
    private JRadioButton anyRadioButton;
    private JRadioButton selectedRadioButton;
    private JTextArea grantTextArea;
    private ButtonGroup buttonGroup;
    private JLabel hostLabel;
    private JLabel grantLabel;

    public HostPropertyCustomEditor(HostPropertyEditor hostPropertyEditor) {
        this.editor = hostPropertyEditor;
        this.initComponents();
        this.initAccessibility();
        this.anyRadioButton.addActionListener(this);
        this.selectedRadioButton.addActionListener(this);
        this.anyRadioButton.setMnemonic(NbBundle.getBundle((Class)HostPropertyCustomEditor.class).getString("CTL_AnyRadioButton_Mnemonic").charAt(0));
        this.selectedRadioButton.setMnemonic(NbBundle.getBundle((Class)HostPropertyCustomEditor.class).getString("CTL_SelectedRadioButton_Mnemonic").charAt(0));
        this.grantLabel.setDisplayedMnemonic(NbBundle.getBundle((Class)HostPropertyCustomEditor.class).getString("CTL_GrantLabel_Mnemonic").charAt(0));
        this.setPreferredSize(new Dimension(300, 200));
        HttpServerSettings.HostProperty hostProperty = (HttpServerSettings.HostProperty)this.editor.getValue();
        if ("any".equals(hostProperty.getHost())) {
            this.anyRadioButton.setSelected(true);
            this.grantTextArea.setText("");
        } else if ("local".equals(hostProperty.getHost())) {
            this.selectedRadioButton.setSelected(true);
            this.grantTextArea.setText(hostProperty.getGrantedAddresses());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            if (actionEvent.getSource() == this.anyRadioButton) {
                this.grantLabel.setEnabled(false);
                this.grantTextArea.setEnabled(false);
            } else if (actionEvent.getSource() == this.selectedRadioButton) {
                this.grantLabel.setEnabled(true);
                this.grantTextArea.setEnabled(true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initAccessibility() {
        this.hostLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)HostPropertyCustomEditor.class).getString("ACS_HostLabelA11yDesc"));
        this.grantLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)HostPropertyCustomEditor.class).getString("ACS_GrantLabelA11yDesc"));
        this.grantTextArea.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)HostPropertyCustomEditor.class).getString("ACS_GrantTextAreaA11yName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)HostPropertyCustomEditor.class).getString("ACS_HostPropertyPanelA11yDesc"));
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.hostLabel = new JLabel();
        this.anyRadioButton = new JRadioButton();
        this.selectedRadioButton = new JRadioButton();
        this.grantLabel = new JLabel();
        this.grantScrollPane = new JScrollPane();
        this.grantTextArea = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(12, 12, 11, 11)));
        this.hostLabel.setText(NbBundle.getBundle((String)"org/netbeans/modules/httpserver/Bundle").getString("CTL_HostLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.add((Component)this.hostLabel, gridBagConstraints);
        this.anyRadioButton.setToolTipText(NbBundle.getBundle((Class)HostPropertyCustomEditor.class).getString("ACS_AnyRadioButtonA11yDesc"));
        this.anyRadioButton.setText(NbBundle.getBundle((String)"org/netbeans/modules/httpserver/Bundle").getString("CTL_AnyRadioButton"));
        this.buttonGroup.add(this.anyRadioButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.anyRadioButton, gridBagConstraints);
        this.selectedRadioButton.setToolTipText(NbBundle.getBundle((Class)HostPropertyCustomEditor.class).getString("ACS_SelectedRadioButtonA11yDesc"));
        this.selectedRadioButton.setSelected(true);
        this.selectedRadioButton.setText(NbBundle.getBundle((String)"org/netbeans/modules/httpserver/Bundle").getString("CTL_SelectedRadioButton"));
        this.buttonGroup.add(this.selectedRadioButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.selectedRadioButton, gridBagConstraints);
        this.grantLabel.setText(NbBundle.getBundle((String)"org/netbeans/modules/httpserver/Bundle").getString("CTL_GrantLabel"));
        this.grantLabel.setLabelFor(this.grantTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 2, 0);
        this.add((Component)this.grantLabel, gridBagConstraints);
        this.grantTextArea.setToolTipText(NbBundle.getBundle((Class)HostPropertyCustomEditor.class).getString("ACS_GrantTextAreaA11yDesc"));
        this.grantScrollPane.setViewportView(this.grantTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.grantScrollPane, gridBagConstraints);
    }

    public Object getPropertyValue() throws IllegalStateException {
        if (this.anyRadioButton.isSelected()) {
            return new HttpServerSettings.HostProperty("", "any");
        }
        if (this.selectedRadioButton.isSelected()) {
            return new HttpServerSettings.HostProperty(this.grantTextArea.getText(), "local");
        }
        throw new IllegalStateException();
    }

    public HelpCtx getHelpCtx() {
        String string = HttpServerNode.class.getName() + "_properties";
        return new HelpCtx(string);
    }
}

