/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.httpserver;

import java.awt.Dialog;
import java.io.Serializable;
import java.net.BindException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.httpserver.GrantAccessEvent;
import org.netbeans.modules.httpserver.GrantAccessListener;
import org.netbeans.modules.httpserver.GrantAccessPanel;
import org.netbeans.modules.httpserver.HttpServerModule;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.options.SystemOption;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class HttpServerSettings
extends SystemOption {
    private static final int MAX_START_RETRIES = 20;
    private static int currentRetries = 0;
    protected static EventListenerList listenerList = new EventListenerList();
    static boolean inited = false;
    private static Hashtable whoAsking = new Hashtable();
    public static final int SERVER_STARTUP_TIMEOUT = 3000;
    public static final String LOCALHOST = "local";
    public static final String ANYHOST = "any";
    public static final HostProperty hostProperty = new HostProperty("", "local");
    public static final String PROP_PORT = "port";
    public static final String PROP_HOST_PROPERTY = "hostProperty";
    static final String PROP_WRAPPER_BASEURL = "wrapperBaseURL";
    public static final String PROP_RUNNING = "running";
    private static final String PROP_SHOW_GRANT_ACCESS = "showGrantAccess";
    private static final int DEFAULT_PORT = 8082;
    private static String wrapperBaseURL = "/resource/";
    static boolean running = false;
    private static boolean startStopMessages = true;
    private static Properties mappedServlets = new Properties();
    public static HttpServerSettings OPTIONS = null;
    private static Object httpLock;
    static final long serialVersionUID = 7387407495740535307L;

    static final Object httpLock() {
        if (httpLock == null) {
            httpLock = new Object();
        }
        return httpLock;
    }

    protected void initialize() {
        super.initialize();
    }

    public String displayName() {
        return NbBundle.getMessage((Class)HttpServerSettings.class, (String)"CTL_HTTP_settings");
    }

    public boolean isRunning() {
        if (this.isWriteExternal()) {
            if (inited) {
                return running;
            }
            return true;
        }
        if (inited) {
            return running;
        }
        this.setRunning(false);
        return running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runSuccess() {
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            currentRetries = 0;
            running = true;
            HttpServerSettings.httpLock().notifyAll();
        }
    }

    void runFailure(Throwable throwable) {
        running = false;
        if (throwable instanceof IncompatibleClassChangeError) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)HttpServerSettings.class, (String)"MSG_HTTP_SERVER_incompatbleClasses"), 2));
        } else if (throwable instanceof BindException) {
            if (++currentRetries <= 20) {
                this.setPort(this.getPort() + 1);
                this.setRunning(true);
            } else {
                currentRetries = 0;
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)HttpServerSettings.class, (String)"MSG_HTTP_SERVER_START_FAIL"), 2));
                int n = this.getPort();
                if (n < 1024 && inited && Utilities.isUnix()) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)HttpServerSettings.class, (String)"MSG_onlyRootOnUnix"), 2));
                }
            }
        } else {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)HttpServerSettings.class, (String)"MSG_HTTP_SERVER_START_FAIL_unknown"), 2));
        }
    }

    private void restartIfNecessary(boolean bl) {
        if (this.isReadExternal()) {
            return;
        }
        if (running) {
            if (!bl) {
                this.setStartStopMessages(false);
            }
            HttpServerModule.stopHTTPServer();
            HttpServerModule.initHTTPServer();
        }
    }

    private String getCanonicalRelativeURL(String string) {
        String string2;
        if (string.length() == 0) {
            string2 = "/";
        } else {
            string2 = string.charAt(0) != '/' ? "/" + string : string;
            if (string2.charAt(string2.length() - 1) != '/') {
                string2 = string2 + "/";
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRunning(boolean bl) {
        if (this.isReadExternal()) {
            return;
        }
        inited = true;
        if (running == bl) {
            return;
        }
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            if (bl) {
                HttpServerModule.initHTTPServer();
            } else {
                running = false;
                HttpServerModule.stopHTTPServer();
            }
        }
        this.firePropertyChange(PROP_RUNNING, !bl ? Boolean.TRUE : Boolean.FALSE, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    String getWrapperBaseURL() {
        return wrapperBaseURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setWrapperBaseURL(String string) {
        String string2;
        String string3 = this.getCanonicalRelativeURL(string);
        if (wrapperBaseURL.equals(string3)) {
            return;
        }
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            string2 = wrapperBaseURL;
            wrapperBaseURL = string3;
            this.restartIfNecessary(false);
        }
        this.firePropertyChange(PROP_WRAPPER_BASEURL, string2, wrapperBaseURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPort(int n) {
        if (n <= 0 || n > 65535) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)HttpServerSettings.class, (String)"ERR_PortNumberOutOfRange", (Object)new Integer(n)), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        Object object = this.getProperty(PROP_PORT);
        int n2 = object == null ? 8082 : (Integer)object;
        Object object2 = HttpServerSettings.httpLock();
        synchronized (object2) {
            object = this.putProperty(PROP_PORT, new Integer(n), false);
            if (object != null && n == (Integer)object) {
                return;
            }
            this.restartIfNecessary(true);
        }
        this.firePropertyChange(PROP_PORT, object, new Integer(n));
    }

    public int getPort() {
        Object object = this.getProperty(PROP_PORT);
        return object == null ? 8082 : (Integer)object;
    }

    public void setStartStopMessages(boolean bl) {
        startStopMessages = bl;
    }

    public boolean isStartStopMessages() {
        return startStopMessages;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HttpServerSettings.class);
    }

    void firePropertyChange0(String string, Object object, Object object2) {
        this.firePropertyChange(string, object, object2);
    }

    private String getLocalHost() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "localhost";
        }
    }

    public void addGrantAccessListener(GrantAccessListener grantAccessListener) {
        listenerList.add(GrantAccessListener.class, grantAccessListener);
    }

    public void removeGrantAccessListener(GrantAccessListener grantAccessListener) {
        listenerList.remove(GrantAccessListener.class, grantAccessListener);
    }

    protected boolean fireGrantAccessEvent(InetAddress inetAddress, String string) {
        Object[] objectArray = listenerList.getListenerList();
        GrantAccessEvent grantAccessEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$org$netbeans$modules$httpserver$GrantAccessListener == null ? HttpServerSettings.class$("org.netbeans.modules.httpserver.GrantAccessListener") : class$org$netbeans$modules$httpserver$GrantAccessListener)) continue;
            if (grantAccessEvent == null) {
                grantAccessEvent = new GrantAccessEvent((Object)this, inetAddress, string);
            }
            ((GrantAccessListener)objectArray[i + 1]).grantAccess(grantAccessEvent);
        }
        return grantAccessEvent == null ? false : grantAccessEvent.isGranted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean allowAccess(InetAddress inetAddress, String string) {
        if (this.accessAllowedNow(inetAddress, string)) {
            return true;
        }
        Thread thread = null;
        Serializable serializable = whoAsking;
        synchronized (serializable) {
            if (this.accessAllowedNow(inetAddress, string)) {
                return true;
            }
            thread = (Thread)whoAsking.get(inetAddress);
            if (thread == null) {
                thread = Thread.currentThread();
                whoAsking.put(inetAddress, thread);
            }
        }
        serializable = HttpServerSettings.class;
        synchronized (serializable) {
            if (thread != Thread.currentThread()) {
                return this.accessAllowedNow(inetAddress, string);
            }
            try {
                if (!this.isShowGrantAccessDialog()) {
                    boolean bl = false;
                    return bl;
                }
                String string2 = NbBundle.getMessage((Class)HttpServerSettings.class, (String)"MSG_AddAddress", (Object)inetAddress.getHostAddress());
                GrantAccessPanel grantAccessPanel = new GrantAccessPanel(string2);
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)grantAccessPanel, NbBundle.getMessage((Class)HttpServerSettings.class, (String)"CTL_GrantAccessTitle"), true, 0, NotifyDescriptor.NO_OPTION, null);
                dialogDescriptor.setMessageType(3);
                Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                dialog.setSize(580, 180);
                dialog.setVisible(true);
                this.setShowGrantAccessDialog(grantAccessPanel.getShowDialog());
                if (NotifyDescriptor.YES_OPTION.equals(dialogDescriptor.getValue())) {
                    this.appendAddressToGranted(inetAddress.getHostAddress());
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                whoAsking.remove(inetAddress);
            }
        }
    }

    private boolean accessAllowedNow(InetAddress inetAddress, String string) {
        if (hostProperty.getHost().equals(ANYHOST)) {
            return true;
        }
        HashSet hashSet = this.getGrantedAddressesSet();
        if (hashSet.contains(inetAddress.getHostAddress())) {
            return true;
        }
        return this.fireGrantAccessEvent(inetAddress, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendAddressToGranted(String string) {
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            String string2 = hostProperty.getGrantedAddresses().trim();
            if (string2.length() > 0 && string2.charAt(string2.length() - 1) != ';' && string2.charAt(string2.length() - 1) != ',') {
                string2 = string2 + ',';
            }
            string2 = string2 + string;
            hostProperty.setGrantedAddresses(string2);
        }
    }

    HashSet getGrantedAddressesSet() {
        HashSet<String> hashSet = new HashSet<String>();
        try {
            hashSet.add(InetAddress.getByName("localhost").getHostAddress());
            hashSet.add(InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        StringTokenizer stringTokenizer = new StringTokenizer(hostProperty.getGrantedAddresses(), ",;");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            string = string.trim();
            try {
                hashSet.add(InetAddress.getByName(string).getHostAddress());
            }
            catch (UnknownHostException unknownHostException) {}
        }
        return hashSet;
    }

    Properties getMappedServlets() {
        return mappedServlets;
    }

    static String mangle(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isLetterOrDigit(string.charAt(i)) || string.charAt(i) == '.') {
                stringBuffer.append(string.charAt(i));
                continue;
            }
            String string2 = Integer.toHexString(string.charAt(i)).toUpperCase();
            if (string2.length() < 2) {
                string2 = string2.length() == 0 ? "00" : "0" + string2;
            }
            stringBuffer.append("%").append(string2.length() == 2 ? string2 : string2.substring(string2.length() - 2));
        }
        return stringBuffer.toString();
    }

    static String demangle(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) != '%') {
                    stringBuffer.append(string.charAt(i));
                    continue;
                }
                stringBuffer.append((char)Integer.parseInt(string.substring(i + 1, i + 3), 16));
                i += 2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return "";
        }
        return stringBuffer.toString();
    }

    public HostProperty getHostProperty() {
        return hostProperty;
    }

    public void setHostProperty(HostProperty hostProperty) {
        if (ANYHOST.equals(hostProperty.getHost()) || LOCALHOST.equals(hostProperty.getHost())) {
            this.firePropertyChange(PROP_HOST_PROPERTY, null, hostProperty);
        }
    }

    public boolean isShowGrantAccessDialog() {
        Boolean bl = (Boolean)this.getProperty(PROP_SHOW_GRANT_ACCESS);
        if (bl != null) {
            return bl;
        }
        return true;
    }

    public void setShowGrantAccessDialog(boolean bl) {
        this.putProperty(PROP_SHOW_GRANT_ACCESS, bl ? Boolean.TRUE : Boolean.FALSE, true);
    }

    public static class HostProperty
    implements Serializable {
        private String grantedAddresses;
        private String host;
        private static final long serialVersionUID = 1927848926692414249L;

        HostProperty(String string, String string2) {
            this.grantedAddresses = string;
            this.host = string2;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String string) {
            this.host = string;
        }

        public String getGrantedAddresses() {
            return this.grantedAddresses;
        }

        public void setGrantedAddresses(String string) {
            this.grantedAddresses = string;
        }
    }
}

