/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.httpserver;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.netbeans.modules.httpserver.HttpServerSettings;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.SharedClassObject;

public class HttpServerURLMapper
extends URLMapper {
    static final /* synthetic */ boolean $assertionsDisabled;

    public FileObject[] getFileObjects(URL uRL) {
        String string = uRL.getPath();
        String string2 = HttpServerURLMapper.httpserverSettings().getWrapperBaseURL();
        if (string == null || !string.startsWith(string2)) {
            return null;
        }
        if ((string = string.substring(string2.length())).startsWith("/")) {
            string = string.substring(1);
        }
        if (string.length() == 0) {
            return new FileObject[0];
        }
        URL uRL2 = this.decodeURL(string);
        if (uRL2 == null) {
            return new FileObject[0];
        }
        return URLMapper.findFileObjects((URL)uRL2);
    }

    private URL decodeURL(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/", true);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("/")) {
                stringBuffer.append(string2);
                continue;
            }
            try {
                stringBuffer.append(URLDecoder.decode(string2, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)unsupportedEncodingException);
                }
                return null;
            }
        }
        try {
            return new URL(stringBuffer.toString());
        }
        catch (MalformedURLException malformedURLException) {
            ErrorManager.getDefault().notify(1, (Throwable)malformedURLException);
            return null;
        }
    }

    public URL getURL(FileObject fileObject, int n) {
        if (n != 2) {
            return null;
        }
        if (fileObject == null) {
            return null;
        }
        URL uRL = URLMapper.findURL((FileObject)fileObject, (int)1);
        if (uRL == null && (uRL = URLMapper.findURL((FileObject)fileObject, (int)0)) == null) {
            return null;
        }
        String string = this.encodeURL(uRL);
        HttpServerSettings httpServerSettings = HttpServerURLMapper.httpserverSettings();
        httpServerSettings.setRunning(true);
        try {
            URL uRL2 = new URL("http", HttpServerURLMapper.getLocalHost(), httpServerSettings.getPort(), httpServerSettings.getWrapperBaseURL() + string);
            return uRL2;
        }
        catch (MalformedURLException malformedURLException) {
            ErrorManager.getDefault().notify(16, (Throwable)malformedURLException);
            return null;
        }
    }

    private String encodeURL(URL uRL) {
        String string = uRL.toExternalForm();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/", true);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("/")) {
                stringBuffer.append(string2);
                continue;
            }
            try {
                stringBuffer.append(URLEncoder.encode(string2, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)unsupportedEncodingException);
                }
                return null;
            }
        }
        return stringBuffer.toString();
    }

    private static String getLocalHost() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "localhost";
        }
    }

    static HttpServerSettings httpserverSettings() {
        return (HttpServerSettings)SharedClassObject.findObject((Class)HttpServerSettings.class, (boolean)true);
    }

    static {
        $assertionsDisabled = !HttpServerURLMapper.class.desiredAssertionStatus();
    }
}

