/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.httpserver;

import java.io.IOException;
import java.net.InetAddress;
import java.util.HashSet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.netbeans.modules.httpserver.HttpServerSettings;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;

public abstract class NbBaseServlet
extends HttpServlet {
    public void init() throws ServletException {
    }

    protected abstract void processRequest(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    public String getServletInfo() {
        return NbBundle.getBundle((Class)NbBaseServlet.class).getString("MSG_BaseServletDescr");
    }

    protected boolean checkAccess(HttpServletRequest httpServletRequest) throws IOException {
        HttpServerSettings httpServerSettings = (HttpServerSettings)SharedClassObject.findObject((Class)HttpServerSettings.class);
        if (httpServerSettings == null) {
            return false;
        }
        if (httpServerSettings.getHostProperty().getHost().equals("any")) {
            return true;
        }
        HashSet hashSet = httpServerSettings.getGrantedAddressesSet();
        if (hashSet.contains(httpServletRequest.getRemoteAddr().trim())) {
            return true;
        }
        String string = httpServletRequest.getPathInfo();
        if (string == null) {
            string = "";
        }
        try {
            String string2 = httpServletRequest.getRemoteAddr().trim();
            if (httpServerSettings.allowAccess(InetAddress.getByName(string2), string)) {
                return true;
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
            return false;
        }
        return false;
    }
}

