/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xsl.scenario;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.netbeans.modules.xml.core.actions.InputOutputReporter;
import org.netbeans.modules.xml.core.lib.FileUtilities;
import org.netbeans.modules.xml.core.lib.GuiUtil;
import org.netbeans.modules.xsl.api.XSLScenario;
import org.netbeans.modules.xsl.scenario.Util;
import org.netbeans.modules.xsl.transform.TransformServlet;
import org.netbeans.modules.xsl.ui.TransformPanel;
import org.netbeans.modules.xsl.utils.TransformUtil;
import org.openide.ErrorManager;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FileXSLScenario
implements Serializable,
XSLScenario,
PropertyChangeListener {
    protected Data data = new Data();
    protected String name = "";
    private transient Document sourceDoc;
    private transient TransformPanel transPanel;
    private transient DataObject lastDataObject;
    private transient PropertyChangeSupport support;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(DataObject dataObject) {
        InputOutputReporter inputOutputReporter;
        block21: {
            inputOutputReporter = new InputOutputReporter(Util.THIS.getString("PROP_transformation_io_name"));
            try {
                FileLock fileLock;
                block22: {
                    SaveCookie saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class);
                    if (saveCookie != null) {
                        try {
                            saveCookie.save();
                        }
                        catch (IOException iOException) {
                            inputOutputReporter.message("Could not save file: " + iOException.getMessage());
                        }
                    }
                    FileObject fileObject = dataObject.getPrimaryFile();
                    URL uRL = this.preferFileURL(fileObject);
                    Source source = TransformUtil.createSource(uRL, this.data.getSourceXML());
                    if (Util.THIS.isLoggable()) {
                        Util.THIS.debug("    xmlSource = " + source.getSystemId());
                    }
                    String string = TransformUtil.getURLName(fileObject);
                    Source source2 = TransformUtil.createSource(uRL, string);
                    if (Util.THIS.isLoggable()) {
                        Util.THIS.debug("    xslSource = " + source2.getSystemId());
                    }
                    if (this.data.getOutput() == null) {
                        TransformServlet.prepare(null, source, source2);
                        this.showURL(TransformServlet.getServletURL());
                        break block21;
                    }
                    String string2 = this.data.getOutput().replace('\\', '/');
                    FileObject fileObject2 = FileUtilities.createFileObject((FileObject)fileObject.getParent(), (String)string2, (boolean)this.data.isOverwrite());
                    if (Util.THIS.isLoggable()) {
                        Util.THIS.debug("    resultFO = " + fileObject2);
                    }
                    OutputStream outputStream = null;
                    fileLock = null;
                    try {
                        try {
                            fileLock = fileObject2.lock();
                            outputStream = fileObject2.getOutputStream(fileLock);
                            StreamResult streamResult = new StreamResult(outputStream);
                            if (Util.THIS.isLoggable()) {
                                Util.THIS.debug("    resultFO = " + fileObject2);
                                Util.THIS.debug("    outputResult = " + streamResult);
                            }
                            String string3 = this.data.getSourceXML();
                            inputOutputReporter.message(Util.THIS.getString("MSG_transformation_1", string3, string));
                            TransformUtil.transform(source, null, source2, streamResult, null);
                            if (this.data.getProcess() == 1) {
                                GuiUtil.performDefaultAction((FileObject)fileObject2);
                                GuiUtil.performDefaultAction((FileObject)fileObject2);
                            } else if (this.data.getProcess() == 2) {
                                this.showURL(fileObject2.getURL());
                            }
                            GuiUtil.setStatusText((String)Util.THIS.getString("MSG_opening_browser"));
                        }
                        catch (FileAlreadyLockedException fileAlreadyLockedException) {
                            throw (FileAlreadyLockedException)ErrorManager.getDefault().annotate((Throwable)fileAlreadyLockedException, Util.THIS.getString("ERR_FileAlreadyLockedException_output"));
                        }
                        Object var16_19 = null;
                        if (outputStream == null) break block22;
                    }
                    catch (Throwable throwable) {
                        Object var16_20 = null;
                        if (outputStream != null) {
                            outputStream.close();
                        }
                        if (fileLock != null) {
                            fileLock.releaseLock();
                        }
                        throw throwable;
                    }
                    outputStream.close();
                }
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
            }
            catch (TransformerException transformerException) {
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(16, (Throwable)exception);
            }
        }
        inputOutputReporter.message(Util.THIS.getString("MSG_transformation_2"));
        inputOutputReporter.moveToFront(true);
        this.sourceDoc = null;
    }

    public Component getCustomizer(DataObject dataObject, boolean bl) {
        try {
            Object object;
            this.transPanel = new TransformPanel(null, null, dataObject);
            this.lastDataObject = dataObject;
            String string = this.data.getSourceXML();
            if (string.length() > 0) {
                object = dataObject.getPrimaryFile();
                URL uRL = this.preferFileURL(object.getParent());
                URL uRL2 = new URL(uRL, this.data.getSourceXML());
                string = uRL2.toExternalForm();
            }
            object = new TransformPanel.Data(string, this.transPanel.getData().getXSL(), this.data.getOutput(), this.data.isOverwrite(), this.data.getProcess());
            this.transPanel.setData((TransformPanel.Data)object);
            if (bl) {
                this.transPanel.addPropertyChangeListener(this);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.transPanel = null;
        }
        return this.transPanel;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        String string2 = this.name;
        this.name = string;
    }

    public void saveChanges() {
        if (this.transPanel != null) {
            String string;
            TransformPanel.Data data = this.transPanel.getData();
            String string2 = data.getInput();
            FileObject fileObject = this.lastDataObject.getPrimaryFile();
            try {
                string = this.preferFileURL(fileObject.getParent()).toExternalForm();
                string2 = this.relativize(string, string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.data.setSourceXML(string2);
            string = null;
            if (data.getOutput() != null) {
                string = data.getOutput().toString();
            }
            this.data.setOutput(string);
            this.data.setOverwrite(data.isOverwriteOutput());
            this.data.setProcess(data.getProcessOutput());
            this.sourceDoc = null;
        }
    }

    public Document getSourceDocument(DataObject dataObject, boolean bl) throws SAXException, IOException {
        if (this.sourceDoc == null || bl) {
            String string = this.data.getSourceXML();
            if (string == null || string.length() == 0) {
                return null;
            }
            FileObject fileObject = dataObject.getPrimaryFile();
            URL uRL = this.preferFileURL(fileObject);
            URL uRL2 = new URL(uRL, string);
            this.sourceDoc = XMLUtil.parse((InputSource)new InputSource(uRL2.toExternalForm()), (boolean)false, (boolean)true, null, (EntityResolver)TransformUtil.getEntityResolver());
        }
        return this.sourceDoc;
    }

    public String toString() {
        return this.getName();
    }

    protected URL preferFileURL(FileObject fileObject) throws MalformedURLException, FileStateInvalidException {
        URL uRL = null;
        File file = FileUtil.toFile((FileObject)fileObject);
        uRL = file != null ? file.toURL() : fileObject.getURL();
        return uRL;
    }

    private void showURL(URL uRL) {
        HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
        GuiUtil.setStatusText((String)Util.THIS.getString("MSG_opening_browser"));
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.support == null) {
            this.support = new PropertyChangeSupport(this);
        }
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.support == null) {
            this.support = new PropertyChangeSupport(this);
        }
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.support == null) {
            this.support = new PropertyChangeSupport(this);
        }
        if (propertyChangeEvent.getPropertyName().equals("DATA_XML_MODIFIED") || propertyChangeEvent.getPropertyName().equals("DATA_XSL_MODIFIED") || propertyChangeEvent.getPropertyName().equals("DATA_OUTPUT_MODIFIED") || propertyChangeEvent.getPropertyName().equals("DATA_OVERWRITE_MODIFIED") || propertyChangeEvent.getPropertyName().equals("DATA_PROCESS_MODIFIED")) {
            this.support.firePropertyChange("SCENARIO_MODIFIED", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    }

    private String relativize(String string, String string2) {
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "/");
        String string3 = null;
        int n2 = n = stringTokenizer.countTokens();
        while (stringTokenizer.hasMoreTokens()) {
            if (!stringTokenizer2.hasMoreTokens()) {
                string3 = null;
                break;
            }
            string3 = stringTokenizer2.nextToken();
            if (!string3.equals(stringTokenizer.nextToken())) break;
            --n;
        }
        if (n == n2) {
            return string2;
        }
        String string4 = "";
        for (int i = 0; i < n; ++i) {
            string4 = string4 + "../";
        }
        if (string3 != null) {
            if (n != 0) {
                string4 = string4 + string3;
                if (stringTokenizer2.hasMoreTokens()) {
                    string4 = string4 + "/";
                }
            }
            while (stringTokenizer2.hasMoreTokens()) {
                string4 = string4 + stringTokenizer2.nextToken();
                if (!stringTokenizer2.hasMoreTokens()) continue;
                string4 = string4 + "/";
            }
        }
        return string4;
    }

    public class Data
    implements Serializable {
        private String sourceXML = "";
        private String output = null;
        private boolean overwrite = true;
        private int process = -1;

        public String getSourceXML() {
            return this.sourceXML;
        }

        public void setSourceXML(String string) {
            this.sourceXML = string;
        }

        public String getOutput() {
            return this.output;
        }

        public void setOutput(String string) {
            this.output = string;
        }

        public boolean isOverwrite() {
            return this.overwrite;
        }

        public void setOverwrite(boolean bl) {
            this.overwrite = bl;
        }

        public int getProcess() {
            return this.process;
        }

        public void setProcess(int n) {
            this.process = n;
        }
    }
}

