/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xsl.settings;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.xsl.settings.Util;
import org.netbeans.modules.xsl.utils.TransformUtil;
import org.openide.filesystems.FileObject;

public final class TransformHistory
implements Serializable {
    private static final long serialVersionUID = -6268945703343989727L;
    private ListMap xmlOutputMap = null;
    private ListMap xslOutputMap = null;
    private boolean overwriteOutput = false;
    private int processOutput = 2;
    public static final int DO_NOTHING = 0;
    public static final int APPLY_DEFAULT_ACTION = 1;
    public static final int OPEN_IN_BROWSER = 2;
    public static final String TRANSFORM_HISTORY_ATTRIBUTE = "org.netbeans.modules.xsl.settings.TransformHistory";

    public String[] getXMLs() {
        return this.getXMLOutputMap().getInputs();
    }

    public String getLastXML() {
        return this.getXMLOutputMap().getLastInput();
    }

    public String[] getXSLs() {
        return this.getXSLOutputMap().getInputs();
    }

    public String getLastXSL() {
        return this.getXSLOutputMap().getLastInput();
    }

    public String getXMLOutput(String string) {
        return this.getXMLOutputMap().getOutput(string);
    }

    public String getLastXMLOutput() {
        return this.getXMLOutput(this.getLastXML());
    }

    public String getXSLOutput(String string) {
        return this.getXSLOutputMap().getOutput(string);
    }

    public String getLastXSLOutput() {
        return this.getXSLOutput(this.getLastXSL());
    }

    public void addXML(String string, String string2) {
        this.getXMLOutputMap().put(string, string2);
    }

    public void addXSL(String string, String string2) {
        this.getXSLOutputMap().put(string, string2);
    }

    public boolean isOverwriteOutput() {
        return this.overwriteOutput;
    }

    public void setOverwriteOutput(boolean bl) {
        this.overwriteOutput = bl;
    }

    public int getProcessOutput() {
        return this.processOutput;
    }

    public void setProcessOutput(int n) {
        this.processOutput = n;
    }

    private ListMap getXMLOutputMap() {
        if (this.xmlOutputMap == null) {
            this.xmlOutputMap = new ListMap();
        }
        return this.xmlOutputMap;
    }

    private ListMap getXSLOutputMap() {
        if (this.xslOutputMap == null) {
            this.xslOutputMap = new ListMap();
        }
        return this.xslOutputMap;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" [ xmlOutputMap= ").append(this.xmlOutputMap);
        stringBuffer.append(", xslOutputMap= ").append(this.xslOutputMap);
        stringBuffer.append(", overwriteOutput= ").append(this.overwriteOutput);
        stringBuffer.append(", processOutput= ").append(this.processOutput).append(" ]");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof TransformHistory)) {
            return false;
        }
        TransformHistory transformHistory = (TransformHistory)object;
        if (!TransformHistory.equals(this.xmlOutputMap, transformHistory.xmlOutputMap)) {
            return false;
        }
        if (!TransformHistory.equals(this.xslOutputMap, transformHistory.xslOutputMap)) {
            return false;
        }
        if (this.overwriteOutput != transformHistory.overwriteOutput) {
            return false;
        }
        return this.processOutput == transformHistory.processOutput;
    }

    static boolean equals(Object object, Object object2) {
        if (object != null) {
            return object.equals(object2);
        }
        return object == object2;
    }

    private static class ListMap
    implements Serializable {
        private static final long serialVersionUID = 6341102578706167575L;
        public static final int MAX = 5;
        private transient List inputList;
        private transient Map inputOutputMap;
        private Object[] inputOutputArray;

        public ListMap() {
            this.init();
        }

        private void init() {
            this.inputList = new LinkedList();
            this.inputOutputMap = new HashMap();
            if (this.inputOutputArray == null) {
                return;
            }
            for (int i = 0; i < this.inputOutputArray.length; i += 2) {
                Object object = this.inputOutputArray[i];
                Object object2 = this.inputOutputArray[i + 1];
                try {
                    if (object instanceof FileObject) {
                        object = TransformUtil.getURLName((FileObject)object);
                    } else if (object != null && !(object instanceof String)) {
                        object = object.toString();
                    }
                    if (object2 instanceof FileObject) {
                        object2 = TransformUtil.getURLName((FileObject)object2);
                    } else if (object2 != null && !(object2 instanceof String)) {
                        object2 = object2.toString();
                    }
                    this.inputList.add(object);
                    this.inputOutputMap.put(object, object2);
                    continue;
                }
                catch (IOException iOException) {
                    Util.THIS.debug(iOException);
                }
            }
        }

        public void put(String string, String string2) {
            Object v = this.inputOutputMap.remove(string);
            this.inputList.remove(string);
            this.inputOutputMap.put(string, string2);
            this.inputList.add(0, string);
            if (this.inputList.size() > 5) {
                Object e = this.inputList.remove(this.inputList.size() - 1);
                this.inputOutputMap.remove(e);
            }
        }

        public String[] getInputs() {
            return this.inputList.toArray(new String[0]);
        }

        public String getLastInput() {
            if (this.inputList.isEmpty()) {
                return null;
            }
            return (String)this.inputList.get(0);
        }

        public String getOutput(String string) {
            return (String)this.inputOutputMap.get(string);
        }

        public String[] getArray() {
            if (this.inputList.size() == 0) {
                return null;
            }
            String[] stringArray = new String[2 * this.inputList.size()];
            for (int i = 0; i < this.inputList.size(); ++i) {
                String string;
                stringArray[2 * i] = string = (String)this.inputList.get(i);
                stringArray[2 * i + 1] = (String)this.inputOutputMap.get(string);
            }
            return stringArray;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(super.toString());
            stringBuffer.append(" [ inputList= ").append(this.inputList);
            stringBuffer.append(", inputOutputMap.keySet= ").append(this.inputOutputMap.keySet());
            stringBuffer.append(", inputOutputMap.values= ").append(this.inputOutputMap.values());
            stringBuffer.append(", xmlOutputArray= ").append(this.inputOutputArray == null ? "null" : Arrays.asList(this.inputOutputArray).toString());
            stringBuffer.append(" ]");
            return stringBuffer.toString();
        }

        public boolean equals(Object object) {
            if (!(object instanceof ListMap)) {
                return false;
            }
            ListMap listMap = (ListMap)object;
            if (!TransformHistory.equals(this.inputList, listMap.inputList)) {
                return false;
            }
            return TransformHistory.equals(this.inputOutputMap, listMap.inputOutputMap);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.init();
            this.inputOutputArray = null;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            this.inputOutputArray = this.getArray();
            objectOutputStream.defaultWriteObject();
            this.inputOutputArray = null;
        }
    }
}

