/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xsl.transform;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.netbeans.api.xml.cookies.CookieObserver;
import org.netbeans.api.xml.cookies.TransformableCookie;
import org.netbeans.modules.xml.core.actions.InputOutputReporter;
import org.netbeans.modules.xml.core.lib.FileUtilities;
import org.netbeans.modules.xml.core.lib.GuiUtil;
import org.netbeans.modules.xsl.settings.TransformHistory;
import org.netbeans.modules.xsl.transform.TransformServlet;
import org.netbeans.modules.xsl.transform.Util;
import org.netbeans.modules.xsl.ui.TransformPanel;
import org.netbeans.modules.xsl.utils.TransformUtil;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;
import org.xml.sax.SAXException;

public class TransformPerformer {
    private InputOutputReporter cookieObserver = null;
    private Node[] nodes;
    private volatile boolean stalled = false;
    private volatile boolean active = true;
    static /* synthetic */ Class class$org$netbeans$modules$xsl$actions$TransformAction;

    public TransformPerformer(Node[] nodeArray) {
        this.nodes = nodeArray;
    }

    private void saveBeforeTransformation(DataObject dataObject) {
        SaveCookie saveCookie;
        if (dataObject.isModified() && (saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class)) != null) {
            try {
                saveCookie.save();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform() {
        if (this.stalled) {
            throw new IllegalStateException();
        }
        try {
            if (this.nodes.length == 2) {
                DataObject dataObject = (DataObject)this.nodes[0].getCookie(DataObject.class);
                boolean bl = TransformUtil.isXSLTransformation(dataObject);
                DataObject dataObject2 = (DataObject)this.nodes[1].getCookie(DataObject.class);
                boolean bl2 = TransformUtil.isXSLTransformation(dataObject2);
                this.saveBeforeTransformation(dataObject);
                this.saveBeforeTransformation(dataObject2);
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("TransformAction.performAction:");
                    Util.THIS.debug("    do1 [" + bl + "] = " + dataObject);
                    Util.THIS.debug("    do2 [" + bl2 + "] = " + dataObject2);
                }
                if (bl != bl2) {
                    DataObject dataObject3;
                    DataObject dataObject4;
                    TransformableCookie transformableCookie;
                    if (bl) {
                        transformableCookie = (TransformableCookie)this.nodes[1].getCookie(TransformableCookie.class);
                        dataObject4 = dataObject2;
                        dataObject3 = dataObject;
                    } else {
                        transformableCookie = (TransformableCookie)this.nodes[0].getCookie(TransformableCookie.class);
                        dataObject4 = dataObject;
                        dataObject3 = dataObject2;
                    }
                    DoublePerformer doublePerformer = new DoublePerformer(transformableCookie, dataObject4, dataObject3);
                    doublePerformer.perform();
                } else {
                    TransformableCookie transformableCookie = (TransformableCookie)this.nodes[0].getCookie(TransformableCookie.class);
                    SinglePerformer singlePerformer = new SinglePerformer(transformableCookie, dataObject, bl);
                    singlePerformer.setLastInBatch(false);
                    singlePerformer.perform();
                    TransformableCookie transformableCookie2 = (TransformableCookie)this.nodes[1].getCookie(TransformableCookie.class);
                    singlePerformer = new SinglePerformer(transformableCookie2, dataObject2, bl2);
                    singlePerformer.perform();
                }
            } else {
                for (int i = 0; i < this.nodes.length; ++i) {
                    DataObject dataObject = (DataObject)this.nodes[i].getCookie(class$org$openide$loaders$DataObject == null ? TransformPerformer.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                    this.saveBeforeTransformation(dataObject);
                    TransformableCookie transformableCookie = null;
                    boolean bl = TransformUtil.isXSLTransformation(dataObject);
                    if (!bl) {
                        transformableCookie = (TransformableCookie)this.nodes[i].getCookie(class$org$netbeans$api$xml$cookies$TransformableCookie == null ? TransformPerformer.class$("org.netbeans.api.xml.cookies.TransformableCookie") : class$org$netbeans$api$xml$cookies$TransformableCookie);
                    }
                    SinglePerformer singlePerformer = new SinglePerformer(transformableCookie, dataObject, bl);
                    singlePerformer.setLastInBatch(i == this.nodes.length - 1);
                    singlePerformer.perform();
                }
            }
        }
        finally {
            this.stalled = true;
        }
    }

    public boolean isActive() {
        return this.active;
    }

    private InputOutputReporter getCookieObserver() {
        if (this.cookieObserver == null) {
            String string = Util.THIS.getString("PROP_transformation_io_name");
            this.cookieObserver = new InputOutputReporter(string);
        }
        return this.cookieObserver;
    }

    private class DoublePerformer
    extends AbstractPerformer {
        public DoublePerformer(TransformableCookie transformableCookie, DataObject dataObject, DataObject dataObject2) {
            super(transformableCookie);
            this.xmlDO = dataObject;
            this.xslDO = dataObject2;
        }

        protected void init() throws IOException {
            this.baseFO = this.xmlDO.getPrimaryFile();
            this.baseURL = this.preferFileURL(this.baseFO);
        }

        protected void storeData() {
            this.updateHistory(this.xmlDO, false);
            this.updateHistory(this.xslDO, true);
        }
    }

    private class SinglePerformer
    extends AbstractPerformer {
        private DataObject dataObject;
        private boolean xslt;

        public SinglePerformer(TransformableCookie transformableCookie, DataObject dataObject, boolean bl) {
            super(transformableCookie);
            this.dataObject = dataObject;
            this.xslt = bl;
        }

        protected void init() throws IOException {
            this.baseFO = this.dataObject.getPrimaryFile();
            this.baseURL = this.preferFileURL(this.baseFO);
            if (this.xslt) {
                this.xmlDO = null;
                this.xmlStylesheetSource = null;
                this.xslDO = this.dataObject;
            } else {
                this.xmlDO = this.dataObject;
                this.xmlStylesheetSource = TransformUtil.getAssociatedStylesheet(this.baseURL);
                this.xslDO = null;
            }
        }

        protected void storeData() {
            this.updateHistory(this.dataObject, this.xslt);
        }
    }

    private abstract class AbstractPerformer
    extends WindowAdapter
    implements ActionListener {
        private TransformableCookie transformableCookie;
        protected DataObject xmlDO;
        protected Source xmlStylesheetSource;
        protected DataObject xslDO;
        protected FileObject baseFO;
        protected URL baseURL;
        private Source xmlSource;
        private Source xslSource;
        private FileObject resultFO;
        private TransformPanel transformPanel;
        private DialogDescriptor dialogDescriptor;
        private Dialog dialog;
        private TransformPanel.Data data;
        private boolean last = true;
        private boolean workaround31850 = true;

        public AbstractPerformer(TransformableCookie transformableCookie) {
            this.transformableCookie = transformableCookie;
        }

        public final void perform() {
            block3: {
                try {
                    this.init();
                    this.showDialog();
                }
                catch (IOException iOException) {
                    if (Util.THIS.isLoggable()) {
                        Util.THIS.debug(iOException);
                    }
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)iOException.getLocalizedMessage(), 2);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    if (!this.isLastInBatch()) break block3;
                    TransformPerformer.this.active = false;
                }
            }
        }

        protected abstract void init() throws IOException;

        protected abstract void storeData();

        private void showDialog() throws IOException {
            String string = null;
            if (this.xmlStylesheetSource != null) {
                string = this.xmlStylesheetSource.getSystemId();
            }
            this.transformPanel = new TransformPanel(this.xmlDO, string, this.xslDO);
            this.dialogDescriptor = new DialogDescriptor((Object)this.transformPanel, Util.THIS.getString("NAME_transform_panel_title"), true, 2, DialogDescriptor.OK_OPTION, 0, new HelpCtx(class$org$netbeans$modules$xsl$actions$TransformAction == null ? (class$org$netbeans$modules$xsl$actions$TransformAction = TransformPerformer.class$("org.netbeans.modules.xsl.actions.TransformAction")) : class$org$netbeans$modules$xsl$actions$TransformAction), null);
            this.dialogDescriptor.setClosingOptions(new Object[]{DialogDescriptor.CANCEL_OPTION});
            this.dialogDescriptor.setButtonListener((ActionListener)this);
            this.dialog = DialogDisplayer.getDefault().createDialog(this.dialogDescriptor);
            this.dialog.addWindowListener(this);
            this.dialog.show();
        }

        protected void prepareData() throws IOException, FileStateInvalidException, MalformedURLException, ParserConfigurationException, SAXException {
            this.data = this.transformPanel.getData();
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("TransformPerformer...performTransformation");
                Util.THIS.debug("    transformable = " + this.transformableCookie);
                Util.THIS.debug("    baseFileObject = " + this.baseFO);
                Util.THIS.debug("    data = " + this.data);
            }
            try {
                this.xmlSource = TransformUtil.createSource(this.baseURL, this.data.getInput());
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().annotate((Throwable)iOException, Util.THIS.getString("MSG_sourceError"));
                throw iOException;
            }
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("    xmlSource = " + this.xmlSource.getSystemId());
            }
            if (this.data.getXSL() != null) {
                try {
                    this.xslSource = TransformUtil.createSource(this.baseURL, this.data.getXSL());
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().annotate((Throwable)iOException, Util.THIS.getString("MSG_transError"));
                    throw iOException;
                }
            } else {
                this.xslSource = this.xmlStylesheetSource;
            }
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("    xslSource = " + this.xslSource.getSystemId());
            }
            if (this.data.getOutput() != null) {
                String string = this.data.getOutput().toString().replace('\\', '/');
                try {
                    this.resultFO = FileUtilities.createFileObject((FileObject)this.baseFO.getParent(), (String)string, (boolean)this.data.isOverwriteOutput());
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().annotate((Throwable)iOException, Util.THIS.getString("MSG_resultError"));
                    throw iOException;
                }
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("    resultFO = " + this.resultFO);
                }
            }
        }

        protected void updateHistory(DataObject dataObject, boolean bl) {
            FileObject fileObject = dataObject.getPrimaryFile();
            TransformHistory transformHistory = (TransformHistory)fileObject.getAttribute("org.netbeans.modules.xsl.settings.TransformHistory");
            if (transformHistory == null) {
                transformHistory = new TransformHistory();
            }
            String string = null;
            if (this.data.getOutput() != null) {
                string = this.data.getOutput().toString();
            }
            if (bl) {
                transformHistory.addXML(this.data.getInput(), string);
            } else {
                transformHistory.addXSL(this.data.getXSL(), string);
            }
            transformHistory.setOverwriteOutput(this.data.isOverwriteOutput());
            transformHistory.setProcessOutput(this.data.getProcessOutput());
            try {
                fileObject.setAttribute("org.netbeans.modules.xsl.settings.TransformHistory", (Object)transformHistory);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }

        private void previewOutput() throws MalformedURLException, UnknownHostException {
            TransformServlet.prepare(this.transformableCookie, this.xmlSource, this.xslSource);
            this.showURL(TransformServlet.getServletURL());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void fileOutput() throws IOException, FileStateInvalidException, TransformerException {
            FileLock fileLock;
            block13: {
                OutputStream outputStream = null;
                fileLock = null;
                try {
                    block12: {
                        try {
                            fileLock = this.resultFO.lock();
                            outputStream = this.resultFO.getOutputStream(fileLock);
                            StreamResult streamResult = new StreamResult(outputStream);
                            if (Util.THIS.isLoggable()) {
                                Util.THIS.debug("    resultFO = " + this.resultFO);
                                Util.THIS.debug("    outputResult = " + streamResult);
                            }
                            String string = this.data.getInput();
                            String string2 = this.data.getXSL();
                            TransformPerformer.this.getCookieObserver().message(Util.THIS.getString("MSG_transformation_1", string, string2));
                            TransformUtil.transform(this.xmlSource, this.transformableCookie, this.xslSource, streamResult, (CookieObserver)TransformPerformer.this.getCookieObserver());
                            try {
                                DataObject dataObject = DataObject.find((FileObject)this.resultFO);
                                dataObject.setValid(false);
                            }
                            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                                throw new IllegalStateException();
                            }
                            catch (PropertyVetoException propertyVetoException) {
                                ErrorManager.getDefault().log(1, "Cannot invalidate " + this.resultFO);
                            }
                            if (this.data.getProcessOutput() == 1) {
                                GuiUtil.performDefaultAction((FileObject)this.resultFO);
                                GuiUtil.performDefaultAction((FileObject)this.resultFO);
                                break block12;
                            }
                            if (this.data.getProcessOutput() == 2) {
                                this.showURL(this.resultFO.getURL());
                            }
                        }
                        catch (FileAlreadyLockedException fileAlreadyLockedException) {
                            throw (FileAlreadyLockedException)ErrorManager.getDefault().annotate((Throwable)fileAlreadyLockedException, Util.THIS.getString("ERR_FileAlreadyLockedException_output"));
                        }
                    }
                    Object var8_10 = null;
                    if (outputStream == null) break block13;
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    if (fileLock == null) throw throwable;
                    fileLock.releaseLock();
                    throw throwable;
                }
                outputStream.close();
            }
            if (fileLock == null) return;
            fileLock.releaseLock();
        }

        private void showURL(URL uRL) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
            GuiUtil.setStatusText((String)Util.THIS.getString("MSG_opening_browser"));
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("[TransformPerformer::AbstractPerformer] actionPerformed: " + actionEvent);
                Util.THIS.debug("    ActionEvent.getSource(): " + actionEvent.getSource());
            }
            this.workaround31850 = false;
            if (DialogDescriptor.OK_OPTION.equals(actionEvent.getSource())) {
                try {
                    this.prepareData();
                    if (this.data.getOutput() != null && this.resultFO == null) {
                        return;
                    }
                    this.dialog.dispose();
                    this.storeData();
                    this.async();
                }
                catch (Exception exception) {
                    if (Util.THIS.isLoggable()) {
                        Util.THIS.debug(exception);
                    }
                    ErrorManager.getDefault().notify(16, (Throwable)exception);
                    if (this.isLastInBatch()) {
                        TransformPerformer.this.active = false;
                    }
                }
            } else {
                TransformPerformer.this.active = false;
            }
        }

        public void windowClosed(WindowEvent windowEvent) {
            super.windowClosed(windowEvent);
            if (this.workaround31850) {
                TransformPerformer.this.active = false;
            }
        }

        private void async() {
            RequestProcessor requestProcessor = RequestProcessor.getDefault();
            requestProcessor.post(new Runnable(this){
                private final /* synthetic */ AbstractPerformer this$1;
                {
                    this.this$1 = abstractPerformer;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    try {
                        try {
                            if (AbstractPerformer.access$200(this.this$1).getOutput() == null) {
                                AbstractPerformer.access$300(this.this$1);
                            }
                            AbstractPerformer.access$400(this.this$1);
                        }
                        catch (TransformerException transformerException) {
                            Object var3_2 = null;
                            if (!this.this$1.isLastInBatch()) return;
                            InputOutputReporter inputOutputReporter2 = TransformPerformer.access$100(AbstractPerformer.access$500(this.this$1));
                            if (inputOutputReporter2 != null) {
                                inputOutputReporter2.message(Util.THIS.getString("MSG_transformation_2"));
                                inputOutputReporter2.moveToFront(true);
                            }
                            TransformPerformer.access$002(AbstractPerformer.access$500(this.this$1), false);
                            return;
                        }
                        catch (Exception exception) {
                            if (Util.THIS.isLoggable()) {
                                Util.THIS.debug(exception);
                            }
                            ErrorManager.getDefault().notify(16, (Throwable)exception);
                            Object var3_3 = null;
                            if (!this.this$1.isLastInBatch()) return;
                            InputOutputReporter inputOutputReporter3 = TransformPerformer.access$100(AbstractPerformer.access$500(this.this$1));
                            if (inputOutputReporter3 != null) {
                                inputOutputReporter3.message(Util.THIS.getString("MSG_transformation_2"));
                                inputOutputReporter3.moveToFront(true);
                            }
                            TransformPerformer.access$002(AbstractPerformer.access$500(this.this$1), false);
                            return;
                        }
                        Object var3_1 = null;
                        if (!this.this$1.isLastInBatch()) return;
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        if (!this.this$1.isLastInBatch()) throw throwable;
                        InputOutputReporter inputOutputReporter = TransformPerformer.access$100(AbstractPerformer.access$500(this.this$1));
                        if (inputOutputReporter != null) {
                            inputOutputReporter.message(Util.THIS.getString("MSG_transformation_2"));
                            inputOutputReporter.moveToFront(true);
                        }
                        TransformPerformer.access$002(AbstractPerformer.access$500(this.this$1), false);
                        throw throwable;
                    }
                    InputOutputReporter inputOutputReporter = TransformPerformer.access$100(AbstractPerformer.access$500(this.this$1));
                    if (inputOutputReporter != null) {
                        inputOutputReporter.message(Util.THIS.getString("MSG_transformation_2"));
                        inputOutputReporter.moveToFront(true);
                    }
                    TransformPerformer.access$002(AbstractPerformer.access$500(this.this$1), false);
                }
            });
        }

        protected URL preferFileURL(FileObject fileObject) throws MalformedURLException, FileStateInvalidException {
            URL uRL = null;
            File file = FileUtil.toFile((FileObject)fileObject);
            uRL = file != null ? file.toURL() : fileObject.getURL();
            return uRL;
        }

        public final void setLastInBatch(boolean bl) {
            this.last = bl;
        }

        public final boolean isLastInBatch() {
            return this.last;
        }

        static /* synthetic */ TransformPanel.Data access$200(AbstractPerformer abstractPerformer) {
            return abstractPerformer.data;
        }

        static /* synthetic */ void access$300(AbstractPerformer abstractPerformer) throws MalformedURLException, UnknownHostException {
            abstractPerformer.previewOutput();
        }

        static /* synthetic */ void access$400(AbstractPerformer abstractPerformer) throws IOException, FileStateInvalidException, TransformerException {
            abstractPerformer.fileOutput();
        }

        static /* synthetic */ TransformPerformer access$500(AbstractPerformer abstractPerformer) {
            return abstractPerformer.TransformPerformer.this;
        }
    }
}

