/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xsl.transform;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.netbeans.api.xml.cookies.CookieMessage;
import org.netbeans.api.xml.cookies.CookieObserver;
import org.netbeans.api.xml.cookies.TransformableCookie;
import org.netbeans.api.xml.cookies.XMLProcessorDetail;
import org.netbeans.modules.xsl.transform.Util;
import org.netbeans.modules.xsl.utils.TransformUtil;
import org.netbeans.spi.xml.cookies.DefaultXMLProcessorDetail;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;
import org.xml.sax.SAXParseException;

public class TransformServlet
extends HttpServlet {
    private static final long serialVersionUID = 1632869007241230624L;
    private static TransformableCookie transformable;
    private static Source xmlSource;
    private static Source xslSource;
    static /* synthetic */ Class class$org$netbeans$api$xml$cookies$XMLProcessorDetail;

    public static void prepare(TransformableCookie transformableCookie, Source source, Source source2) {
        transformable = transformableCookie;
        xmlSource = source;
        xslSource = source2;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    public void destroy() {
        xmlSource = null;
        xslSource = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        PrintWriter printWriter = httpServletResponse.getWriter();
        StreamResult streamResult = new StreamResult(printWriter);
        Observer observer = new Observer();
        try {
            String string = TransformUtil.guessOutputExt(xslSource);
            String string2 = string.equals("txt") ? "text/plain" : (string.equals("xml") ? "text/xml" : (string.equals("html") ? "text/html" : null));
            if (string2 != null) {
                httpServletResponse.setContentType(string2);
            }
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("[TransformServlet] Response MIME Type: '" + string2 + "'");
                Util.THIS.debug("    xmlSource.getSystemId() = " + xmlSource.getSystemId());
                Util.THIS.debug("    transformable = " + transformable);
                Util.THIS.debug("    xslSource.getSystemId() = " + xslSource.getSystemId());
            }
            TransformUtil.transform(xmlSource, transformable, xslSource, streamResult, observer);
        }
        catch (Exception exception) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("    EXCEPTION!!!: " + exception.getClass().getName(), exception);
            }
            CookieMessage cookieMessage = null;
            if (!(exception instanceof TransformerException)) {
                cookieMessage = exception instanceof SAXParseException ? new CookieMessage(TransformUtil.unwrapException(exception).getLocalizedMessage(), 3, (Object)new DefaultXMLProcessorDetail((SAXParseException)exception)) : new CookieMessage(exception.getLocalizedMessage(), 3);
            }
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("    message  = " + cookieMessage);
                Util.THIS.debug("    notifier = " + observer);
            }
            if (cookieMessage != null) {
                observer.receive(cookieMessage);
            }
            httpServletResponse.setContentType("text/html");
            printWriter.println("<html><head>");
            printWriter.println("    <title>" + Util.THIS.getString("MSG_error_html_title") + "</title>");
            printWriter.println("    <style>" + Util.THIS.getString("MSG_error_html_style") + "</style>");
            printWriter.println("</head><body>");
            printWriter.println("    <h2>" + Util.THIS.getString("MSG_error_page_title") + "</h2>");
            printWriter.println("    <p>" + Util.THIS.getString("MSG_error_page_message") + "</p>");
            printWriter.println("    <hr size=\"1\" noshade=\"\" />\n" + this.generateReport(observer.getList()) + "<hr size=\"1\" noshade=\"\" />");
            printWriter.println("    <p>" + Util.THIS.getString("MSG_error_bottom_message") + "</p>");
            printWriter.println("</body></html>");
        }
        finally {
            printWriter.close();
        }
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    public String getServletInfo() {
        return "XSL Transformation Preview Servlet";
    }

    public static URL getServletURL() throws MalformedURLException, UnknownHostException {
        URL uRL = TransformServlet.getSampleHTTPServerURL();
        URL uRL2 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), "/servlet/" + TransformServlet.class.getName() + "/");
        return uRL2;
    }

    private static URL getSampleHTTPServerURL() {
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource("HTTPServer_DUMMY");
        if (fileObject == null) {
            return null;
        }
        URL uRL = URLMapper.findURL((FileObject)fileObject, (int)2);
        return uRL;
    }

    private String generateReport(List list) {
        StringBuffer stringBuffer;
        block5: {
            stringBuffer = new StringBuffer();
            try {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string;
                    CookieMessage cookieMessage = (CookieMessage)iterator.next();
                    XMLProcessorDetail xMLProcessorDetail = (XMLProcessorDetail)cookieMessage.getDetail(class$org$netbeans$api$xml$cookies$XMLProcessorDetail == null ? TransformServlet.class$("org.netbeans.api.xml.cookies.XMLProcessorDetail") : class$org$netbeans$api$xml$cookies$XMLProcessorDetail);
                    stringBuffer.append("    &nbsp;&nbsp;&nbsp;&nbsp;<font class=\"").append(this.levelName(cookieMessage.getLevel())).append("\">").append(cookieMessage.getMessage()).append("</font>");
                    if (xMLProcessorDetail == null || (string = this.preferFileName(xMLProcessorDetail.getSystemId())) == null) continue;
                    stringBuffer.append("&nbsp;(<font class=\"system-id\">");
                    boolean bl = string.startsWith("file:");
                    if (bl) {
                        stringBuffer.append("<a href=\"").append(string).append("\">");
                    }
                    stringBuffer.append(string);
                    if (bl) {
                        stringBuffer.append("</a>");
                    }
                    stringBuffer.append("</font>\n");
                    stringBuffer.append("&nbsp;[<font class=\"line-number\">").append(xMLProcessorDetail.getLineNumber()).append("</font>])<br>");
                }
            }
            catch (Exception exception) {
                if (!Util.THIS.isLoggable()) break block5;
                Util.THIS.debug(exception);
            }
        }
        return stringBuffer.toString();
    }

    private String preferFileName(String string) {
        String string2;
        block3: {
            string2 = string;
            try {
                URL uRL = new URL(string);
                FileObject fileObject = URLMapper.findFileObject((URL)uRL);
                if (fileObject != null) {
                    string2 = TransformUtil.getURLName(fileObject);
                }
            }
            catch (Exception exception) {
                if (!Util.THIS.isLoggable()) break block3;
                Util.THIS.debug(exception);
            }
        }
        return string2;
    }

    private String levelName(int n) {
        if (n == 3) {
            return "fatal-error";
        }
        if (n == 2) {
            return "error";
        }
        if (n == 1) {
            return "warning";
        }
        return "informational";
    }

    private static class Observer
    implements CookieObserver {
        private final List msgList = new Vector();

        public void receive(CookieMessage cookieMessage) {
            this.msgList.add(cookieMessage);
        }

        public List getList() {
            return this.msgList;
        }
    }
}

