/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xsl.ui;

import java.awt.Image;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.xml.core.lib.AbstractUtil;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.lookup.Lookups;

class Util
extends AbstractUtil {
    public static final Util THIS = new Util();
    static Node icons = null;

    private Util() {
    }

    static Node projectView() {
        Children.SortedArray sortedArray = new Children.SortedArray();
        sortedArray.setComparator(new Comparator(){

            public int compare(Object object, Object object2) {
                return ((Node)object).getDisplayName().compareToIgnoreCase(((Node)object2).getDisplayName());
            }
        });
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projectArray.length; ++i) {
            Project project = projectArray[i];
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] sourceGroupArray = sources.getSourceGroups("generic");
            Arrays.sort(sourceGroupArray, new Comparator(){

                public int compare(Object object, Object object2) {
                    return ((SourceGroup)object).getDisplayName().compareToIgnoreCase(((SourceGroup)object2).getDisplayName());
                }
            });
            for (int j = 0; j < sourceGroupArray.length; ++j) {
                ErrorManager errorManager;
                FileObject fileObject = sourceGroupArray[j].getRootFolder();
                if (fileObject.isFolder()) {
                    sortedArray.add(new Node[]{new FolderNode(fileObject, sourceGroupArray[j])});
                    if (icons != null) continue;
                    try {
                        DataObject dataObject = DataObject.find((FileObject)fileObject);
                        icons = dataObject.getNodeDelegate();
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        errorManager = ErrorManager.getDefault();
                        errorManager.notify((Throwable)dataObjectNotFoundException);
                    }
                    continue;
                }
                try {
                    sortedArray.add(new Node[]{new FilterNode(DataObject.find((FileObject)fileObject).getNodeDelegate())});
                    continue;
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    errorManager = ErrorManager.getDefault();
                    errorManager.notify((Throwable)dataObjectNotFoundException);
                }
            }
        }
        AbstractNode abstractNode = new AbstractNode((Children)sortedArray){

            public void setName(String string) {
                super.setName(string);
                super.setIconBase("org/netbeans/modules/xsl/resources/repository");
            }
        };
        abstractNode.setName(THIS.getString("projects"));
        return abstractNode;
    }

    private static class FolderNode
    extends AbstractNode {
        private final FileObject fileObject;
        private SourceGroup group;

        public FolderNode(FileObject fileObject, SourceGroup sourceGroup) {
            super((Children)new FolderContent(fileObject, sourceGroup), Lookups.singleton((Object)fileObject));
            this.fileObject = fileObject;
            this.group = sourceGroup;
        }

        public FolderNode(FileObject fileObject) {
            super((Children)new FolderContent(fileObject), Lookups.singleton((Object)fileObject));
            this.fileObject = fileObject;
        }

        public String getDisplayName() {
            if (this.group != null) {
                return this.group.getDisplayName();
            }
            return this.fileObject.getName();
        }

        public Image getIcon(int n) {
            if (icons != null) {
                return icons.getIcon(n);
            }
            return super.getIcon(n);
        }

        public Image getOpenedIcon(int n) {
            if (icons != null) {
                return icons.getOpenedIcon(n);
            }
            return super.getOpenedIcon(n);
        }

        private static class FolderContent
        extends Children.Keys {
            private final FileObject fileObject;
            private final SourceGroup group;

            public FolderContent(FileObject fileObject) {
                this(fileObject, null);
            }

            public FolderContent(FileObject fileObject, SourceGroup sourceGroup) {
                this.fileObject = fileObject;
                this.group = sourceGroup;
            }

            protected void addNotify() {
                FileObject[] fileObjectArray = this.fileObject.getChildren();
                Arrays.sort(fileObjectArray, new Comparator(this){
                    private final /* synthetic */ FolderContent this$0;
                    {
                        this.this$0 = folderContent;
                    }

                    public int compare(Object object, Object object2) {
                        return ((FileObject)object).getNameExt().compareToIgnoreCase(((FileObject)object2).getNameExt());
                    }
                });
                this.setKeys(Arrays.asList(fileObjectArray));
            }

            protected void removeNotify() {
                this.setKeys(Collections.EMPTY_SET);
            }

            protected Node[] createNodes(Object object) {
                FileObject fileObject = (FileObject)object;
                if (this.group == null || this.group.contains(fileObject)) {
                    if (fileObject.isFolder()) {
                        return new Node[]{new FolderNode(fileObject)};
                    }
                    try {
                        return new Node[]{new FilterNode(DataObject.find((FileObject)fileObject).getNodeDelegate())};
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        ErrorManager errorManager = ErrorManager.getDefault();
                        errorManager.notify((Throwable)dataObjectNotFoundException);
                    }
                }
                return new Node[0];
            }
        }
    }
}

