/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.util.NbBundle;

final class Boolean3WayEditor
implements ExPropertyEditor,
InplaceEditor.Factory {
    Boolean v = null;
    private transient List propertyChangeListenerList;
    private Boolean3Inplace renderer = null;

    public String getAsText() {
        if (this.v == null) {
            return NbBundle.getMessage((Class)Boolean3WayEditor.class, (String)"CTL_Different_Values");
        }
        if (Boolean.TRUE.equals(this.v)) {
            return Boolean.TRUE.toString();
        }
        return Boolean.FALSE.toString();
    }

    public Component getCustomEditor() {
        return null;
    }

    public String getJavaInitializationString() {
        if (this.v == null) {
            return "null";
        }
        if (Boolean.TRUE.equals(this.v)) {
            return "Boolean.TRUE";
        }
        return "Boolean.FALSE";
    }

    public String[] getTags() {
        return null;
    }

    public Object getValue() {
        return this.v;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        if (this.renderer == null) {
            this.renderer = new Boolean3Inplace();
        }
        this.renderer.setSize(rectangle.width, rectangle.height);
        this.renderer.doLayout();
        Graphics graphics2 = graphics.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.renderer.setOpaque(false);
        this.renderer.paint(graphics2);
        graphics2.dispose();
    }

    public void setAsText(String string) {
        if (Boolean.TRUE.toString().compareToIgnoreCase(string) == 0) {
            this.setValue(Boolean.TRUE);
        } else {
            this.setValue(Boolean.FALSE);
        }
    }

    public void setValue(Object object) {
        if (this.v != object) {
            this.v = (Boolean)object;
            this.firePropertyChange();
        }
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        propertyEnv.registerInplaceEditorFactory(this);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertyChangeListenerList == null) {
            this.propertyChangeListenerList = new ArrayList();
        }
        this.propertyChangeListenerList.add(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertyChangeListenerList != null) {
            this.propertyChangeListenerList.remove(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChange() {
        List list;
        Object object = this;
        synchronized (object) {
            if (this.propertyChangeListenerList == null) {
                return;
            }
            list = (List)((ArrayList)this.propertyChangeListenerList).clone();
        }
        object = new PropertyChangeEvent(this, null, null, null);
        for (int i = 0; i < list.size(); ++i) {
            ((PropertyChangeListener)list.get(i)).propertyChange((PropertyChangeEvent)object);
        }
    }

    public InplaceEditor getInplaceEditor() {
        return new Boolean3Inplace();
    }

    private class ButtonModel3Way
    extends DefaultButtonModel {
        private ButtonModel3Way() {
        }

        public boolean isPressed() {
            return Boolean3WayEditor.this.v == null;
        }

        public boolean isArmed() {
            return true;
        }

        public boolean isSelected() {
            if (Boolean3WayEditor.this.v == null) {
                return true;
            }
            return super.isSelected();
        }
    }

    class Boolean3Inplace
    extends JCheckBox
    implements InplaceEditor {
        private PropertyModel propertyModel = null;

        Boolean3Inplace() {
            this.setModel(new ButtonModel3Way());
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }

        public String getText() {
            return PropUtils.noCheckboxCaption ? "" : NbBundle.getMessage((Class)(class$org$openide$explorer$propertysheet$Boolean3WayEditor == null ? (class$org$openide$explorer$propertysheet$Boolean3WayEditor = Boolean3WayEditor.class$("org.openide.explorer.propertysheet.Boolean3WayEditor")) : class$org$openide$explorer$propertysheet$Boolean3WayEditor), (String)"CTL_Different_Values");
        }

        public void clear() {
            this.propertyModel = null;
        }

        public void connect(PropertyEditor propertyEditor, PropertyEnv propertyEnv) {
        }

        public JComponent getComponent() {
            return this;
        }

        public KeyStroke[] getKeyStrokes() {
            return null;
        }

        public PropertyEditor getPropertyEditor() {
            return Boolean3WayEditor.this;
        }

        public Object getValue() {
            return Boolean3WayEditor.this.getValue();
        }

        public void reset() {
        }

        public void setValue(Object object) {
        }

        public boolean supportsTextEntry() {
            return false;
        }

        public void setPropertyModel(PropertyModel propertyModel) {
            this.propertyModel = propertyModel;
        }

        public PropertyModel getPropertyModel() {
            return this.propertyModel;
        }

        public boolean isKnownComponent(Component component) {
            return false;
        }
    }
}

