/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashSet;
import org.openide.ErrorManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

final class ProxyNode
extends AbstractNode {
    private static final int MAX_NAMES = 2;
    private Node[] original;
    private NodeListener pcl;
    String displayName = null;
    private String shortDescription = null;
    static /* synthetic */ Class class$org$openide$nodes$NodeListener;

    ProxyNode(Node[] nodeArray) {
        super(Children.LEAF);
        this.original = nodeArray;
        this.pcl = new NodeAdapter(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if ("cookie".equals(string)) {
                    ProxyNode.this.fireCookieChange();
                } else if ("displayName".equals(string)) {
                    ProxyNode.this.displayName = null;
                    ProxyNode.this.fireDisplayNameChange((String)propertyChangeEvent.getOldValue(), ProxyNode.this.getDisplayName());
                } else if ("icon".equals(string)) {
                    ProxyNode.this.fireIconChange();
                } else if ("openedIcon".equals(string)) {
                    ProxyNode.this.fireOpenedIconChange();
                } else if ("name".equals(string)) {
                    ProxyNode.this.fireNameChange((String)propertyChangeEvent.getOldValue(), ProxyNode.this.getName());
                } else if ("propertySets".equals(string)) {
                    Node.PropertySet[] propertySetArray = ProxyNode.this.getPropertySets();
                    ProxyNode.this.setSheet(ProxyNode.this.createSheet());
                    ProxyNode.this.firePropertySetsChange(propertySetArray, ProxyNode.this.getPropertySets());
                } else if ("shortDescription".equals(string)) {
                    ProxyNode.this.fireShortDescriptionChange((String)propertyChangeEvent.getOldValue(), ProxyNode.this.getShortDescription());
                } else if (!"leaf".equals(string) && !"parentNode".equals(string)) {
                    Node.PropertySet[] propertySetArray = ProxyNode.this.getPropertySets();
                    boolean bl = false;
                    for (int i = 0; i < propertySetArray.length && !bl; ++i) {
                        Node.Property[] propertyArray = propertySetArray[i].getProperties();
                        for (int j = 0; j < propertyArray.length && !bl; ++j) {
                            if (!propertyArray[j].getName().equals(string)) continue;
                            bl = true;
                        }
                    }
                    if (bl) {
                        ProxyNode.this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                    }
                }
            }

            public void nodeDestroyed(NodeEvent nodeEvent) {
                int n = Arrays.asList(ProxyNode.this.original).indexOf((Node)nodeEvent.getSource());
                if (n != -1) {
                    HashSet<Node> hashSet = new HashSet<Node>(Arrays.asList(ProxyNode.this.original));
                    hashSet.remove(nodeEvent.getSource());
                    ProxyNode.access$902(ProxyNode.this, hashSet.toArray(new Node[0]));
                    if (hashSet.size() == 0) {
                        ProxyNode.this.fireNodeDestroyed();
                    }
                }
            }
        };
        for (int i = 0; i < nodeArray.length; ++i) {
            nodeArray[i].addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.pcl, (Object)nodeArray[i]));
            nodeArray[i].addNodeListener((NodeListener)WeakListeners.create((Class)(class$org$openide$nodes$NodeListener == null ? ProxyNode.class$("org.openide.nodes.NodeListener") : class$org$openide$nodes$NodeListener), (EventListener)this.pcl, (Object)nodeArray[i]));
        }
    }

    public HelpCtx getHelpCtx() {
        for (int i = 0; i < this.original.length; ++i) {
            if (this.original[i].getHelpCtx() == HelpCtx.DEFAULT_HELP) continue;
            return this.original[i].getHelpCtx();
        }
        return HelpCtx.DEFAULT_HELP;
    }

    public Node cloneNode() {
        return new ProxyNode(this.original);
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set[] setArray = this.computePropertySets();
        for (int i = 0; i < setArray.length; ++i) {
            sheet.put(setArray[i]);
        }
        return sheet;
    }

    Node[] getOriginalNodes() {
        return this.original;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            this.displayName = this.getConcatenatedName(2);
        }
        return this.displayName;
    }

    private String getConcatenatedName(int n) {
        Node[] nodeArray = this.getOriginalNodes();
        StringBuffer stringBuffer = new StringBuffer();
        String string = NbBundle.getMessage((Class)ProxyNode.class, (String)"CTL_List_Delimiter");
        for (int i = 0; i < nodeArray.length; ++i) {
            stringBuffer.append(nodeArray[i].getDisplayName());
            if (i != nodeArray.length - 1) {
                stringBuffer.append(string);
            }
            if (i < n || i == nodeArray.length - 1) continue;
            stringBuffer.append(NbBundle.getMessage((Class)ProxyNode.class, (String)"MSG_ELLIPSIS"));
            break;
        }
        return stringBuffer.toString();
    }

    public String getShortDescription() {
        if (this.getOriginalNodes().length < 2) {
            return NbBundle.getMessage((Class)ProxyNode.class, (String)"CTL_Multiple_Selection");
        }
        if (this.shortDescription == null) {
            this.shortDescription = this.getConcatenatedName(Integer.MAX_VALUE);
        }
        return this.shortDescription;
    }

    private Sheet.Set[] computePropertySets() {
        if (this.original.length > 0) {
            Node.PropertySet[] propertySetArray = this.original[0].getPropertySets();
            HashSet<Node.PropertySet> hashSet = new HashSet<Node.PropertySet>(Arrays.asList(propertySetArray));
            for (int i = 1; i < this.original.length; ++i) {
                hashSet.retainAll(new HashSet<Node.PropertySet>(Arrays.asList(this.original[i].getPropertySets())));
            }
            ArrayList<Sheet.Set> arrayList = new ArrayList<Sheet.Set>(hashSet.size());
            for (int i = 0; i < propertySetArray.length; ++i) {
                if (!hashSet.contains(propertySetArray[i]) || propertySetArray[i].isHidden()) continue;
                Node.PropertySet propertySet = propertySetArray[i];
                Sheet.Set set = new Sheet.Set();
                set.setName(propertySet.getName());
                set.setDisplayName(propertySet.getDisplayName());
                set.setShortDescription(propertySet.getShortDescription());
                String string = (String)propertySet.getValue("tabName");
                if (string != null) {
                    set.setValue("tabName", (Object)string);
                }
                HashSet<Node.Property> hashSet2 = new HashSet<Node.Property>(Arrays.asList(propertySet.getProperties()));
                Object var9_10 = null;
                for (int j = 0; j < this.original.length; ++j) {
                    Node.PropertySet[] propertySetArray2 = this.original[j].getPropertySets();
                    for (int k = 0; k < propertySetArray2.length; ++k) {
                        if (!propertySet.getName().equals(propertySetArray2[k].getName())) continue;
                        hashSet2.retainAll(new HashSet<Node.Property>(Arrays.asList(propertySetArray2[k].getProperties())));
                    }
                }
                Node.Property[] propertyArray = propertySet.getProperties();
                for (int j = 0; j < propertyArray.length; ++j) {
                    if (!hashSet2.contains(propertyArray[j]) || propertyArray[j].isHidden()) continue;
                    ProxyProperty proxyProperty = this.createProxyProperty(propertyArray[j].getName(), set.getName());
                    set.put((Node.Property)proxyProperty);
                }
                arrayList.add(set);
            }
            return arrayList.toArray(new Sheet.Set[arrayList.size()]);
        }
        return new Sheet.Set[0];
    }

    private ProxyProperty createProxyProperty(String string, String string2) {
        Node.Property[] propertyArray = new Node.Property[this.original.length];
        for (int i = 0; i < this.original.length; ++i) {
            Node.PropertySet[] propertySetArray = this.original[i].getPropertySets();
            for (int j = 0; j < propertySetArray.length; ++j) {
                if (!propertySetArray[j].getName().equals(string2)) continue;
                Node.Property[] propertyArray2 = propertySetArray[j].getProperties();
                for (int k = 0; k < propertyArray2.length; ++k) {
                    if (!propertyArray2[k].getName().equals(string)) continue;
                    propertyArray[i] = propertyArray2[k];
                }
            }
        }
        return new ProxyProperty(propertyArray);
    }

    static /* synthetic */ Node[] access$902(ProxyNode proxyNode, Node[] nodeArray) {
        proxyNode.original = nodeArray;
        return nodeArray;
    }

    static class DifferentValuesException
    extends RuntimeException {
        public DifferentValuesException() {
        }

        public DifferentValuesException(String string) {
            super(string);
        }
    }

    private static class ProxyProperty
    extends Node.Property {
        private Node.Property[] original;

        public ProxyProperty(Node.Property[] propertyArray) {
            super(propertyArray[0].getValueType());
            this.original = propertyArray;
            this.setName(propertyArray[0].getName());
            this.setDisplayName(propertyArray[0].getDisplayName());
            this.setShortDescription(propertyArray[0].getShortDescription());
        }

        public boolean canWrite() {
            for (int i = 0; i < this.original.length; ++i) {
                if (this.original[i].canWrite()) continue;
                return false;
            }
            return true;
        }

        public boolean canRead() {
            for (int i = 0; i < this.original.length; ++i) {
                if (this.original[i].canRead()) continue;
                return false;
            }
            return true;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            Object object = this.original[0].getValue();
            if (object == null) {
                return null;
            }
            for (int i = 0; i < this.original.length; ++i) {
                if (object.equals(this.original[i].getValue())) continue;
                throw new DifferentValuesException();
            }
            return object;
        }

        public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            for (int i = 0; i < this.original.length; ++i) {
                this.original[i].setValue(object);
            }
        }

        public Object getValue(String string) {
            Object object = this.original[0].getValue(string);
            if (Boolean.FALSE.equals(object)) {
                return object;
            }
            if (object == null) {
                return null;
            }
            for (int i = 1; i < this.original.length; ++i) {
                if (Boolean.FALSE.equals(this.original[i])) {
                    return this.original[i];
                }
                if (object.equals(this.original[i].getValue(string))) continue;
                if (Boolean.getBoolean("netbeans.ps.logDifferentValues")) {
                    ErrorManager.getDefault().notify(1, (Throwable)new DifferentValuesException("Different values in attribute " + string + " for proxy property " + this.getDisplayName() + "(" + (Object)((Object)this) + ") first value=" + object + " property " + i + "(" + this.original[i].getClass().getName() + " returns " + this.original[i].getValue(string)));
                }
                return null;
            }
            return object;
        }

        public void setValue(String string, Object object) {
            for (int i = 0; i < this.original.length; ++i) {
                this.original[i].setValue(string, object);
            }
        }

        public PropertyEditor getPropertyEditor() {
            return this.original[0].getPropertyEditor();
        }

        public boolean supportsDefaultValue() {
            for (int i = 0; i < this.original.length; ++i) {
                if (this.original[i].supportsDefaultValue()) continue;
                return false;
            }
            return true;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            for (int i = 0; i < this.original.length; ++i) {
                this.original[i].restoreDefaultValue();
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("Proxy property for: ");
            stringBuffer.append(this.getDisplayName());
            stringBuffer.append('[');
            for (int i = 0; i < this.original.length; ++i) {
                stringBuffer.append(this.original[i].getClass().getName());
                if (i >= this.original.length - 1) continue;
                stringBuffer.append(',');
            }
            stringBuffer.append(']');
            return stringBuffer.toString();
        }
    }
}

