/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import org.openide.explorer.view.DragDropUtilities;
import org.openide.explorer.view.ExplorerDnDManager;
import org.openide.explorer.view.ListView;
import org.openide.explorer.view.NodeRenderer;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.util.datatransfer.PasteType;

final class ListViewDropSupport
implements DropTargetListener,
Runnable {
    boolean active = false;
    boolean dropTargetPopupAllowed;
    DropTarget dropTarget;
    int lastIndex = -1;
    protected ListView view;
    protected JList list;

    public ListViewDropSupport(ListView listView, JList jList) {
        this(listView, jList, true);
    }

    public ListViewDropSupport(ListView listView, JList jList, boolean bl) {
        this.view = listView;
        this.list = jList;
        this.dropTargetPopupAllowed = bl;
    }

    public void setDropTargetPopupAllowed(boolean bl) {
        this.dropTargetPopupAllowed = bl;
    }

    public boolean isDropTargetPopupAllowed() {
        return this.dropTargetPopupAllowed;
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        int n = ExplorerDnDManager.getDefault().getAdjustedDropAction(dropTargetDragEvent.getDropAction(), this.view.getAllowedDropActions());
        ExplorerDnDManager.getDefault().prepareCursor(DragDropUtilities.chooseCursor(dropTargetDragEvent.getDropTargetContext().getComponent(), n, (n & this.view.getAllowedDropActions()) != 0));
        this.lastIndex = this.indexWithCheck(dropTargetDragEvent);
        if (this.lastIndex < 0) {
            dropTargetDragEvent.rejectDrag();
        } else {
            dropTargetDragEvent.acceptDrag(n);
            NodeRenderer.dragEnter(this.list.getModel().getElementAt(this.lastIndex));
            this.list.repaint(this.list.getCellBounds(this.lastIndex, this.lastIndex));
        }
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        int n = ExplorerDnDManager.getDefault().getAdjustedDropAction(dropTargetDragEvent.getDropAction(), this.view.getAllowedDropActions());
        ExplorerDnDManager.getDefault().prepareCursor(DragDropUtilities.chooseCursor(dropTargetDragEvent.getDropTargetContext().getComponent(), n, (n & this.view.getAllowedDropActions()) != 0));
        int n2 = this.indexWithCheck(dropTargetDragEvent);
        if (n2 < 0) {
            dropTargetDragEvent.rejectDrag();
            if (this.lastIndex >= 0) {
                NodeRenderer.dragExit();
                this.list.repaint(this.list.getCellBounds(this.lastIndex, this.lastIndex));
                this.lastIndex = -1;
            }
        } else {
            dropTargetDragEvent.acceptDrag(n);
            if (this.lastIndex != n2) {
                if (this.lastIndex < 0) {
                    this.lastIndex = n2;
                }
                NodeRenderer.dragExit();
                NodeRenderer.dragEnter(this.list.getModel().getElementAt(n2));
                this.list.repaint(this.list.getCellBounds(this.lastIndex, n2));
                this.lastIndex = n2;
            }
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        if (this.lastIndex >= 0) {
            NodeRenderer.dragExit();
            this.list.repaint(this.list.getCellBounds(this.lastIndex, this.lastIndex));
        }
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        int n = this.list.locationToIndex(dropTargetDropEvent.getLocation());
        Object e = this.list.getModel().getElementAt(n);
        Node node = null;
        if (e instanceof VisualizerNode) {
            node = ((VisualizerNode)e).node;
        }
        int n2 = ExplorerDnDManager.getDefault().getAdjustedDropAction(dropTargetDropEvent.getDropAction(), this.view.getAllowedDropActions());
        if (n < 0 || !this.canDrop(node, n2)) {
            dropTargetDropEvent.rejectDrop();
            return;
        }
        PasteType pasteType = DragDropUtilities.getDropType(node, ExplorerDnDManager.getDefault().getDraggedTransferable((2 & n2) != 0), n2);
        if (pasteType == null) {
            dropTargetDropEvent.dropComplete(false);
            RequestProcessor.getDefault().post((Runnable)this, 500);
            return;
        }
        dropTargetDropEvent.acceptDrop(n2);
        if (n2 != 0x40000000) {
            DragDropUtilities.performPaste(pasteType, null);
        }
    }

    private boolean canDrop(Node node, int n) {
        Object object;
        if (node == null) {
            return false;
        }
        if (ExplorerDnDManager.getDefault().getNodeAllowedActions() == 0) {
            return false;
        }
        if ((2 & n) != 0) {
            object = ExplorerDnDManager.getDefault().getDraggedNodes();
            for (int i = 0; i < ((Node[])object).length; ++i) {
                if (!node.equals((Object)object[i].getParentNode())) continue;
                return false;
            }
        }
        if ((object = ExplorerDnDManager.getDefault().getDraggedTransferable((2 & n) != 0)) == null) {
            return false;
        }
        PasteType pasteType = DragDropUtilities.getDropType(node, (Transferable)object, n);
        return pasteType != null;
    }

    public void activate(boolean bl) {
        if (this.active == bl) {
            return;
        }
        this.active = bl;
        this.getDropTarget().setActive(bl);
    }

    public void run() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this);
            return;
        }
        DragDropUtilities.dropNotSuccesfull();
    }

    int indexWithCheck(DropTargetDragEvent dropTargetDragEvent) {
        int n = ExplorerDnDManager.getDefault().getAdjustedDropAction(dropTargetDragEvent.getDropAction(), this.view.getAllowedDropActions());
        if ((n & this.view.getAllowedDropActions()) == 0) {
            return -1;
        }
        int n2 = this.list.locationToIndex(dropTargetDragEvent.getLocation());
        if (n2 == -1) {
            return -1;
        }
        Object object = this.list.getModel().getElementAt(n2);
        if (object instanceof VisualizerNode) {
            object = ((VisualizerNode)object).node;
        }
        if (n2 < 0) {
            return -1;
        }
        if (!(object instanceof Node)) {
            return -1;
        }
        return n2;
    }

    DropTarget getDropTarget() {
        if (this.dropTarget == null) {
            this.dropTarget = new DropTarget(this.list, this.view.getAllowedDropActions(), this, false);
        }
        return this.dropTarget;
    }
}

