/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.text.Position;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.RowMapper;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openide.ErrorManager;
import org.openide.awt.MouseUtils;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.AutoscrollSupport;
import org.openide.explorer.view.DragDropUtilities;
import org.openide.explorer.view.ExplorerDnDManager;
import org.openide.explorer.view.NodeRenderer;
import org.openide.explorer.view.NodeTreeModel;
import org.openide.explorer.view.TreeView;
import org.openide.explorer.view.TreeViewCellEditor;
import org.openide.explorer.view.TreeViewDragSupport;
import org.openide.explorer.view.TreeViewDropSupport;
import org.openide.explorer.view.ViewTooltips;
import org.openide.explorer.view.Visualizer;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public abstract class TreeView
extends JScrollPane {
    static final long serialVersionUID = -1639001987693376168L;
    private static final int TIME_TO_COLLAPSE;
    private static final int MIN_TREEVIEW_WIDTH = 400;
    private static final int MIN_TREEVIEW_HEIGHT = 400;
    private static boolean isSynth;
    protected transient JTree tree;
    transient NodeTreeModel treeModel;
    transient ExplorerManager manager;
    transient PopupSupport defaultActionListener;
    transient boolean defaultActionEnabled;
    transient PopupAdapter popupListener;
    transient TreePropertyListener managerListener = null;
    transient PropertyChangeListener wlpc;
    transient VetoableChangeListener wlvc;
    private transient boolean dragActive = true;
    private transient boolean dropActive = true;
    transient TreeViewDragSupport dragSupport;
    transient TreeViewDropSupport dropSupport;
    transient boolean dropTargetPopupAllowed = true;
    private transient Container contentPane;
    private transient List storeSelectedPaths;
    private transient int allowedDragActions = 0x40000003;
    private transient int allowedDropActions = 0x40000003;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$awt$event$KeyListener;

    public TreeView() {
        this(true, true);
    }

    public TreeView(boolean bl, boolean bl2) {
        this.initializeTree();
        if (DragDropUtilities.dragAndDropEnabled) {
            ExplorerDnDManager.getDefault().addFutureDropTarget(this);
        }
        this.setPopupAllowed(bl2);
        this.setDefaultActionAllowed(bl);
        Dimension dimension = null;
        try {
            dimension = this.getPreferredSize();
            if (dimension == null) {
                dimension = new Dimension(400, 400);
            }
        }
        catch (NullPointerException nullPointerException) {
            dimension = new Dimension(400, 400);
        }
        if (dimension.width < 400) {
            dimension.width = 400;
        }
        if (dimension.height < 400) {
            dimension.height = 400;
        }
        this.setPreferredSize(dimension);
    }

    public void updateUI() {
        super.updateUI();
        this.setViewportBorder(BorderFactory.createEmptyBorder());
        this.setBorder(BorderFactory.createEmptyBorder());
    }

    public Border getBorder() {
        if (isSynth) {
            return BorderFactory.createEmptyBorder();
        }
        return super.getBorder();
    }

    void initializeTree() {
        this.treeModel = this.createModel();
        this.tree = new ExplorerTree(this.treeModel);
        NodeRenderer nodeRenderer = new NodeRenderer();
        this.tree.setCellRenderer(nodeRenderer);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.setViewportView(this.tree);
        this.tree.setCellEditor(new TreeViewCellEditor(this.tree));
        this.tree.setEditable(true);
        this.setSelectionMode(4);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.managerListener = new TreePropertyListener();
        this.tree.addTreeExpansionListener(this.managerListener);
        this.tree.addTreeWillExpandListener(this.managerListener);
        this.setRequestFocusEnabled(false);
        this.defaultActionListener = new PopupSupport();
        this.getInputMap(0).put(KeyStroke.getKeyStroke(121, 64), "org.openide.actions.PopupAction");
        this.getActionMap().put("org.openide.actions.PopupAction", this.defaultActionListener.popup);
        this.tree.addFocusListener(this.defaultActionListener);
        this.tree.addMouseListener(this.defaultActionListener);
    }

    public boolean isPopupAllowed() {
        return this.popupListener != null;
    }

    public void setPopupAllowed(boolean bl) {
        if (this.popupListener == null && bl) {
            this.popupListener = new PopupAdapter();
            this.tree.addMouseListener((MouseListener)((Object)this.popupListener));
            return;
        }
        if (this.popupListener != null && !bl) {
            this.tree.removeMouseListener((MouseListener)((Object)this.popupListener));
            this.popupListener = null;
            return;
        }
    }

    void setDropTargetPopupAllowed(boolean bl) {
        this.dropTargetPopupAllowed = bl;
        if (this.dropSupport != null) {
            this.dropSupport.setDropTargetPopupAllowed(bl);
        }
    }

    boolean isDropTargetPopupAllowed() {
        return this.dropSupport != null ? this.dropSupport.isDropTargetPopupAllowed() : this.dropTargetPopupAllowed;
    }

    public boolean isDefaultActionEnabled() {
        return this.defaultActionEnabled;
    }

    public void requestFocus() {
        this.tree.requestFocus();
    }

    public boolean requestFocusInWindow() {
        return this.tree.requestFocusInWindow();
    }

    public void setDefaultActionAllowed(boolean bl) {
        this.defaultActionEnabled = bl;
        if (bl) {
            this.tree.registerKeyboardAction(this.defaultActionListener, KeyStroke.getKeyStroke(10, 0, false), 0);
        } else {
            this.tree.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0, false));
        }
    }

    public boolean isRootVisible() {
        return this.tree.isRootVisible();
    }

    public void setRootVisible(boolean bl) {
        this.tree.setRootVisible(bl);
        this.tree.setShowsRootHandles(!bl);
    }

    public boolean isDragSource() {
        return this.dragActive;
    }

    public void setDragSource(boolean bl) {
        if (bl && this.dragSupport == null) {
            this.dragSupport = new TreeViewDragSupport(this, this.tree);
        }
        this.dragActive = bl;
        if (this.dragSupport != null) {
            this.dragSupport.activate(this.dragActive);
        }
    }

    public boolean isDropTarget() {
        return this.dropActive;
    }

    public void setDropTarget(boolean bl) {
        if (this.dropActive && this.dropSupport == null) {
            this.dropSupport = new TreeViewDropSupport(this, this.tree, this.dropTargetPopupAllowed);
        }
        this.dropActive = bl;
        if (this.dropSupport != null) {
            this.dropSupport.activate(this.dropActive);
        }
    }

    public int getAllowedDragActions() {
        return this.allowedDragActions;
    }

    public void setAllowedDragActions(int n) {
        this.allowedDragActions = n;
    }

    public int getAllowedDropActions() {
        return this.allowedDropActions;
    }

    public void setAllowedDropActions(int n) {
        this.allowedDropActions = n;
    }

    public void collapseNode(Node node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        TreePath treePath = new TreePath(this.treeModel.getPathToRoot(VisualizerNode.getVisualizer(null, node)));
        this.tree.collapsePath(treePath);
    }

    public void expandNode(Node node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        this.lookupExplorerManager();
        TreePath treePath = new TreePath(this.treeModel.getPathToRoot(VisualizerNode.getVisualizer(null, node)));
        this.tree.expandPath(treePath);
    }

    public boolean isExpanded(Node node) {
        TreePath treePath = new TreePath(this.treeModel.getPathToRoot(VisualizerNode.getVisualizer(null, node)));
        return this.tree.isExpanded(treePath);
    }

    public void expandAll() {
        int n;
        int n2 = 0;
        do {
            n = this.tree.getRowCount();
            this.tree.expandRow(n2);
        } while (n != this.tree.getRowCount() || ++n2 < this.tree.getRowCount());
    }

    public void addNotify() {
        super.addNotify();
        this.lookupExplorerManager();
    }

    private void lookupExplorerManager() {
        ExplorerManager explorerManager = ExplorerManager.find(this);
        if (explorerManager != this.manager) {
            if (this.manager != null) {
                this.manager.removeVetoableChangeListener(this.wlvc);
                this.manager.removePropertyChangeListener(this.wlpc);
            }
            this.manager = explorerManager;
            this.wlvc = WeakListeners.vetoableChange((VetoableChangeListener)this.managerListener, (Object)this.manager);
            this.manager.addVetoableChangeListener(this.wlvc);
            this.wlpc = WeakListeners.propertyChange((PropertyChangeListener)this.managerListener, (Object)this.manager);
            this.manager.addPropertyChangeListener(this.wlpc);
            this.synchronizeRootContext();
            this.synchronizeExploredContext();
            this.synchronizeSelectedNodes();
        }
        this.tree.getSelectionModel().removeTreeSelectionListener(this.managerListener);
        this.tree.getSelectionModel().addTreeSelectionListener(this.managerListener);
    }

    public void removeNotify() {
        super.removeNotify();
        this.tree.getSelectionModel().removeTreeSelectionListener(this.managerListener);
    }

    protected abstract NodeTreeModel createModel();

    protected abstract void selectionChanged(Node[] var1, ExplorerManager var2) throws PropertyVetoException;

    protected abstract boolean selectionAccept(Node[] var1);

    protected abstract void showPath(TreePath var1);

    protected abstract void showSelection(TreePath[] var1);

    protected boolean useExploredContextMenu() {
        return false;
    }

    private boolean isSelectionModeBroken(Node[] nodeArray) {
        if (nodeArray.length <= 1 || this.getSelectionMode() == 4) {
            return false;
        }
        if (this.getSelectionMode() == 1) {
            return true;
        }
        TreePath[] treePathArray = new TreePath[nodeArray.length];
        RowMapper rowMapper = this.tree.getSelectionModel().getRowMapper();
        if (rowMapper == null) {
            return false;
        }
        ArrayList<Node> arrayList = new ArrayList<Node>(3);
        for (int i = 0; i < nodeArray.length; ++i) {
            TreePath treePath;
            arrayList.clear();
            Node node = nodeArray[i];
            while (node.getParentNode() != null) {
                if (!this.isExpanded(node)) {
                    arrayList.add(node);
                }
                node = node.getParentNode();
            }
            for (int j = arrayList.size() - 1; j >= 0; --j) {
                this.expandNode((Node)arrayList.get(j));
            }
            treePathArray[i] = treePath = new TreePath(this.treeModel.getPathToRoot(VisualizerNode.getVisualizer(null, nodeArray[i])));
        }
        int[] nArray = rowMapper.getRowsForPaths(treePathArray);
        Arrays.sort(nArray);
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] == nArray[i - 1] + 1) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void callSelectionChanged(Node[] nodeArray) {
        this.manager.removePropertyChangeListener(this.wlpc);
        this.manager.removeVetoableChangeListener(this.wlvc);
        try {
            try {
                this.selectionChanged(nodeArray, this.manager);
            }
            catch (PropertyVetoException propertyVetoException) {
                this.synchronizeSelectedNodes();
                Object var4_3 = null;
                this.manager.addPropertyChangeListener(this.wlpc);
                this.manager.addVetoableChangeListener(this.wlvc);
            }
            Object var4_2 = null;
            this.manager.addPropertyChangeListener(this.wlpc);
            this.manager.addVetoableChangeListener(this.wlvc);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.manager.addPropertyChangeListener(this.wlpc);
            this.manager.addVetoableChangeListener(this.wlvc);
            throw throwable;
        }
    }

    final void synchronizeRootContext() {
        this.treeModel.setNode(this.manager.getRootContext());
    }

    final void synchronizeExploredContext() {
        Node node = this.manager.getExploredContext();
        if (node != null) {
            TreePath treePath = new TreePath(this.treeModel.getPathToRoot(VisualizerNode.getVisualizer(null, node)));
            this.showPath(treePath);
        }
    }

    public void setSelectionMode(int n) {
        this.tree.getSelectionModel().setSelectionMode(n);
    }

    public int getSelectionMode() {
        return this.tree.getSelectionModel().getSelectionMode();
    }

    private void showWaitCursor() {
        if (this.getRootPane() == null) {
            return;
        }
        this.contentPane = this.getRootPane().getContentPane();
        if (SwingUtilities.isEventDispatchThread()) {
            this.contentPane.setCursor(Utilities.createProgressCursor((Component)this.contentPane));
        } else {
            SwingUtilities.invokeLater(new CursorR(this.contentPane, Utilities.createProgressCursor((Component)this.contentPane)));
        }
    }

    private void showNormalCursor() {
        if (this.contentPane == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.contentPane.setCursor(null);
        } else {
            SwingUtilities.invokeLater(new CursorR(this.contentPane, null));
        }
    }

    private void prepareWaitCursor(final Node node) {
        if (node == null) {
            this.showNormalCursor();
        }
        this.showWaitCursor();
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    node.getChildren().getNodes(true);
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify(1, (Throwable)exception);
                }
                finally {
                    TreeView.this.showNormalCursor();
                }
            }
        });
    }

    final void synchronizeSelectedNodes() {
        VisualizerNode.runQueue();
        Node[] nodeArray = this.manager.getSelectedNodes();
        TreePath[] treePathArray = new TreePath[nodeArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            TreePath treePath;
            treePathArray[i] = treePath = new TreePath(this.treeModel.getPathToRoot(VisualizerNode.getVisualizer(null, nodeArray[i])));
        }
        this.tree.getSelectionModel().removeTreeSelectionListener(this.managerListener);
        this.showSelection(treePathArray);
        this.tree.getSelectionModel().addTreeSelectionListener(this.managerListener);
    }

    void scrollTreeToVisible(TreePath treePath, TreeNode treeNode) {
        Rectangle rectangle = this.tree.getVisibleRect();
        Rectangle rectangle2 = this.tree.getPathBounds(treePath);
        Rectangle rectangle3 = this.tree.getPathBounds(new TreePath(this.treeModel.getPathToRoot(treeNode)));
        if (rectangle != null && rectangle2 != null && rectangle3 != null) {
            this.tree.scrollRectToVisible(new Rectangle(rectangle.x, rectangle2.y, 1, rectangle3.y - rectangle2.y + rectangle3.height));
        }
    }

    private void createPopup(int n, int n2, JPopupMenu jPopupMenu) {
        if (jPopupMenu.getSubElements().length > 0) {
            jPopupMenu.show(this, n, n2);
        }
    }

    void createPopup(int n, int n2) {
        if (this.isPopupAllowed()) {
            Action[] actionArray;
            Node[] nodeArray;
            block5: {
                nodeArray = this.manager.getSelectedNodes();
                if (nodeArray.length == 0) {
                    nodeArray = new Node[]{this.manager.getRootContext()};
                    try {
                        this.manager.setSelectedNodes(nodeArray);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        if ($assertionsDisabled) break block5;
                        throw new AssertionError((Object)propertyVetoException);
                    }
                }
            }
            if ((actionArray = NodeOp.findActions((Node[])nodeArray)).length > 0) {
                this.createPopup(n, n2, Utilities.actionsToPopup((Action[])actionArray, (Component)this));
            }
        }
    }

    void createExtendedPopup(int n, int n2, JMenu jMenu) {
        Node[] nodeArray = this.manager.getSelectedNodes();
        JPopupMenu jPopupMenu = null;
        if (nodeArray.length > 0) {
            Action[] actionArray = NodeOp.findActions((Node[])nodeArray);
            jPopupMenu = Utilities.actionsToPopup((Action[])actionArray, (Component)this);
        } else if (this.manager.getRootContext() != null) {
            jPopupMenu = this.manager.getRootContext().getContextMenu();
        }
        boolean bl = false;
        if (jPopupMenu == null) {
            jPopupMenu = SystemAction.createPopupMenu((SystemAction[])new SystemAction[0]);
        }
        jPopupMenu.add(jMenu);
        this.createPopup(n, n2, jPopupMenu);
    }

    Point getPositionForPopup() {
        int n = this.tree.getLeadSelectionRow();
        if (n < 0) {
            return null;
        }
        Rectangle rectangle = this.tree.getRowBounds(n);
        if (rectangle == null) {
            return null;
        }
        Point point = new Point(rectangle.x, rectangle.y);
        point = SwingUtilities.convertPoint(this.tree, point, this);
        return point;
    }

    static Action takeAction(Action action, Node node) {
        if (action instanceof ContextAwareAction) {
            Lookup lookup = node.getLookup();
            Lookup.Result result = lookup.lookup(new Lookup.Template(Node.class));
            Iterator iterator = result.allInstances().iterator();
            boolean bl = true;
            while (iterator.hasNext() && bl) {
                bl = !node.equals(iterator.next());
            }
            if (bl) {
                lookup = new ProxyLookup(new Lookup[]{Lookups.singleton((Object)node), node.getLookup()});
            }
            Action action2 = ((ContextAwareAction)action).createContextAwareInstance(lookup);
            if (!$assertionsDisabled && action2 == action) {
                throw new AssertionError((Object)("Cannot be same. ContextAwareAction:  " + action + ", ContextAwareInstance: " + action2));
            }
            action = action2;
        }
        return action;
    }

    static final TreePath findSiblingTreePath(TreePath treePath, int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("Indexes of changed children are null.");
        }
        if (treePath == null) {
            throw new IllegalArgumentException("The tree path to parent is null.");
        }
        if (nArray.length == 0) {
            return null;
        }
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        Object[] objectArray = treePath.getPath();
        TreePath treePath2 = null;
        if (treeNode.getChildCount() > 0) {
            int n = objectArray.length + 1;
            Object[] objectArray2 = new Object[n];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            int n2 = nArray[0] - 1;
            if (n2 < 0) {
                n2 = 0;
            }
            objectArray2[n - 1] = treeNode.getChildAt(n2);
            treePath2 = new TreePath(objectArray2);
        } else {
            treePath2 = new TreePath(objectArray);
        }
        return treePath2;
    }

    static {
        $assertionsDisabled = !TreeView.class.desiredAssertionStatus();
        UIManager.put("Tree.scrollsHorizontallyAndVertically", Boolean.TRUE);
        TIME_TO_COLLAPSE = System.getProperty("netbeans.debug.heap") != null ? 0 : 15000;
        isSynth = UIManager.getLookAndFeel().getClass().getName().indexOf("com.sun.java.swing.plaf.gtk") != -1;
    }

    private final class ExplorerTree
    extends JTree
    implements Autoscroll {
        AutoscrollSupport support;
        private String maxPrefix;
        int SEARCH_FIELD_PREFERRED_SIZE;
        int SEARCH_FIELD_SPACE;
        private boolean firstPaint;
        private JTextField searchTextField;
        private JPanel searchpanel;
        private final int heightOfTextField;
        private int originalScrollMode;

        ExplorerTree(TreeModel treeModel) {
            super(treeModel);
            this.SEARCH_FIELD_PREFERRED_SIZE = 160;
            this.SEARCH_FIELD_SPACE = 3;
            this.firstPaint = true;
            this.searchTextField = new JTextField(this){
                private final /* synthetic */ ExplorerTree this$1;
                {
                    this.this$1 = explorerTree;
                }

                public boolean isManagingFocus() {
                    return true;
                }

                public void processKeyEvent(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 27) {
                        ExplorerTree.access$900(this.this$1);
                        keyEvent.consume();
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 3 this$2;
                            {
                                this.this$2 = var1_1;
                            }

                            public void run() {
                                3.access$1000(this.this$2).requestFocus();
                            }
                        });
                    } else {
                        super.processKeyEvent(keyEvent);
                    }
                }

                static /* synthetic */ ExplorerTree access$1000(3 var0) {
                    return var0.this$1;
                }
            };
            this.searchpanel = null;
            this.heightOfTextField = this.searchTextField.getPreferredSize().height;
            this.toggleClickCount = 0;
            this.getInputMap().put(KeyStroke.getKeyStroke("control C"), "none");
            this.getInputMap().put(KeyStroke.getKeyStroke("control V"), "none");
            this.getInputMap().put(KeyStroke.getKeyStroke("control X"), "none");
            this.getInputMap().put(KeyStroke.getKeyStroke("COPY"), "none");
            this.getInputMap().put(KeyStroke.getKeyStroke("PASTE"), "none");
            this.getInputMap().put(KeyStroke.getKeyStroke("CUT"), "none");
            if (Utilities.getOperatingSystem() == 4096) {
                this.getInputMap().put(KeyStroke.getKeyStroke(67, 4), "none");
                this.getInputMap().put(KeyStroke.getKeyStroke(88, 4), "none");
                this.getInputMap().put(KeyStroke.getKeyStroke(86, 4), "none");
            }
            this.setupSearch();
        }

        public void addNotify() {
            super.addNotify();
            ViewTooltips.register(this);
        }

        public void removeNotify() {
            super.removeNotify();
            ViewTooltips.unregister(this);
        }

        public void updateUI() {
            super.updateUI();
            this.setBorder(BorderFactory.createEmptyBorder());
        }

        private void calcRowHeight(Graphics graphics) {
            int n = graphics.getFontMetrics(this.getFont()).getHeight();
            String string = System.getProperty("nb.cellrenderer.fixedheight");
            if (string != null) {
                try {
                    n = Integer.parseInt(string);
                    this.setRowHeight(n);
                    this.firstPaint = false;
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.setRowHeight(Math.max(18, n + 2));
            this.firstPaint = false;
        }

        public void paint(Graphics graphics) {
            new GuardedActions(0, graphics);
        }

        protected void validateTree() {
            new GuardedActions(1, null);
        }

        public void doLayout() {
            new GuardedActions(2, null);
        }

        private void guardedPaint(Graphics graphics) {
            if (this.firstPaint) {
                this.calcRowHeight(graphics);
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                return;
            }
            ExplorerTree.super.paint(graphics);
        }

        private void guardedValidateTree() {
            super.validateTree();
        }

        private void guardedDoLayout() {
            super.doLayout();
            Rectangle rectangle = this.getVisibleRect();
            if (this.searchpanel != null && this.searchpanel.isDisplayable()) {
                int n = Math.min(this.getPreferredSize().width - this.SEARCH_FIELD_SPACE * 2, this.SEARCH_FIELD_PREFERRED_SIZE - this.SEARCH_FIELD_SPACE);
                this.searchpanel.setBounds(Math.max(this.SEARCH_FIELD_SPACE, rectangle.x + rectangle.width - n), rectangle.y + this.SEARCH_FIELD_SPACE, Math.min(rectangle.width, n) - this.SEARCH_FIELD_SPACE, this.heightOfTextField);
            }
        }

        public void setFont(Font font) {
            if (font != this.getFont()) {
                this.firstPaint = true;
                super.setFont(font);
            }
        }

        protected void processFocusEvent(FocusEvent focusEvent) {
            super.processFocusEvent(focusEvent);
            new GuardedActions(3, null);
        }

        private void repaintSelection() {
            int n = this.getSelectionModel().getMinSelectionRow();
            int n2 = this.getSelectionModel().getMaxSelectionRow();
            if (n != -1) {
                if (n == n2) {
                    Rectangle rectangle = this.getRowBounds(n);
                    this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                } else {
                    Rectangle rectangle = this.getRowBounds(n);
                    Rectangle rectangle2 = this.getRowBounds(n2);
                    Rectangle rectangle3 = new Rectangle();
                    rectangle3.x = Math.min(rectangle.x, rectangle2.x);
                    rectangle3.y = rectangle.y;
                    rectangle3.width = this.getWidth();
                    rectangle3.height = rectangle2.y + rectangle2.height - rectangle.y;
                    this.repaint(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                }
            }
        }

        private void prepareSearchPanel() {
            if (this.searchpanel == null) {
                this.searchpanel = new JPanel();
                JLabel jLabel = new JLabel(NbBundle.getMessage((Class)(class$org$openide$explorer$view$TreeView == null ? (class$org$openide$explorer$view$TreeView = TreeView.class$("org.openide.explorer.view.TreeView")) : class$org$openide$explorer$view$TreeView), (String)"LBL_QUICKSEARCH"));
                this.searchpanel.setLayout(new BoxLayout(this.searchpanel, 0));
                this.searchpanel.add(jLabel);
                this.searchpanel.add(this.searchTextField);
                jLabel.setLabelFor(this.searchTextField);
                this.searchpanel.setBorder(BorderFactory.createRaisedBevelBorder());
                jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            }
        }

        private void setupSearch() {
            KeyListener[] keyListenerArray = (KeyListener[])this.getListeners(class$java$awt$event$KeyListener == null ? (class$java$awt$event$KeyListener = TreeView.class$("java.awt.event.KeyListener")) : class$java$awt$event$KeyListener);
            for (int i = 0; i < keyListenerArray.length; ++i) {
                this.removeKeyListener(keyListenerArray[i]);
            }
            this.addKeyListener(new KeyAdapter(this){
                private final /* synthetic */ ExplorerTree this$1;
                {
                    this.this$1 = explorerTree;
                }

                public void keyTyped(KeyEvent keyEvent) {
                    int n = keyEvent.getModifiers();
                    int n2 = keyEvent.getKeyCode();
                    char c = keyEvent.getKeyChar();
                    if (c == '+' || c == '-') {
                        return;
                    }
                    if (n > 0 && n != 1 || keyEvent.isActionKey()) {
                        return;
                    }
                    if (Character.isISOControl(c) || n2 == 16 || n2 == 27) {
                        return;
                    }
                    KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
                    ExplorerTree.access$1200(this.this$1).setText(String.valueOf(keyStroke.getKeyChar()));
                    ExplorerTree.access$1300(this.this$1);
                    keyEvent.consume();
                }
            });
            SearchFieldListener searchFieldListener = new SearchFieldListener();
            this.searchTextField.addKeyListener(searchFieldListener);
            this.searchTextField.addFocusListener(searchFieldListener);
            this.searchTextField.getDocument().addDocumentListener(searchFieldListener);
        }

        private List doSearch(String string) {
            TreePath treePath;
            ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
            int[] nArray = this.getSelectionRows();
            int n = nArray == null || nArray.length == 0 ? 0 : nArray[0];
            int n2 = this.getRowCount();
            if (n2 == 0) {
                return arrayList;
            }
            while ((treePath = this.getNextMatch(string, n %= n2, Position.Bias.Forward)) != null && !arrayList.contains(treePath)) {
                n = TreeView.this.tree.getRowForPath(treePath);
                arrayList.add(treePath);
                String string2 = ((VisualizerNode)treePath.getLastPathComponent()).getDisplayName();
                if (this.maxPrefix == null) {
                    this.maxPrefix = string2;
                }
                this.maxPrefix = this.findMaxPrefix(this.maxPrefix, string2);
                ++n;
            }
            return arrayList;
        }

        private String findMaxPrefix(String string, String string2) {
            String string3 = null;
            int n = 0;
            while (string.regionMatches(true, 0, string2, 0, n)) {
                string3 = string.substring(0, n);
                ++n;
            }
            return string3;
        }

        private void displaySearchField() {
            if (!this.searchTextField.isDisplayable()) {
                JViewport jViewport = TreeView.this.getViewport();
                this.originalScrollMode = jViewport.getScrollMode();
                jViewport.setScrollMode(0);
                this.searchTextField.setFont(this.getFont());
                this.prepareSearchPanel();
                this.add(this.searchpanel);
                this.doLayout();
                this.searchpanel.repaint();
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ ExplorerTree this$1;
                    {
                        this.this$1 = explorerTree;
                    }

                    public void run() {
                        ExplorerTree.access$1200(this.this$1).requestFocus();
                    }
                });
            }
        }

        private void removeSearchField() {
            if (this.searchpanel.isDisplayable()) {
                this.remove(this.searchpanel);
                TreeView.this.getViewport().setScrollMode(this.originalScrollMode);
                Rectangle rectangle = this.searchpanel.getBounds();
                this.repaint(rectangle);
            }
        }

        public void autoscroll(Point point) {
            this.getSupport().autoscroll(point);
        }

        public Insets getAutoscrollInsets() {
            return this.getSupport().getAutoscrollInsets();
        }

        AutoscrollSupport getSupport() {
            if (this.support == null) {
                this.support = new AutoscrollSupport(this, new Insets(15, 10, 15, 10));
            }
            return this.support;
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            if (mouseEvent != null) {
                Point point = mouseEvent.getPoint();
                int n = this.getRowForLocation(point.x, point.y);
                if (n != -1) {
                    TreePath treePath = this.getPathForRow(n);
                    VisualizerNode visualizerNode = (VisualizerNode)treePath.getLastPathComponent();
                    String string = visualizerNode.getShortDescription();
                    String string2 = visualizerNode.getDisplayName();
                    if (string != null && !string.equals(string2)) {
                        return string;
                    }
                }
            }
            return null;
        }

        protected TreeModelListener createTreeModelListener() {
            return new ModelHandler();
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleExplorerTree();
            }
            return this.accessibleContext;
        }

        static /* synthetic */ void access$1300(ExplorerTree explorerTree) {
            explorerTree.displaySearchField();
        }

        private class ModelHandler
        extends JTree.TreeModelHandler {
            ModelHandler() {
                super(ExplorerTree.this);
            }

            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                TreePath[] treePathArray = ExplorerTree.this.getSelectionPaths();
                Enumeration<TreePath> enumeration = ExplorerTree.this.getExpandedDescendants(treeModelEvent.getTreePath());
                super.treeStructureChanged(treeModelEvent);
                if (enumeration != null) {
                    while (enumeration.hasMoreElements()) {
                        ExplorerTree.this.expandPath(enumeration.nextElement());
                    }
                }
                if (treePathArray != null && treePathArray.length > 0) {
                    boolean bl = ExplorerTree.this.isPathSelected(treePathArray[0]);
                    ExplorerTree.this.setSelectionPaths(treePathArray);
                    if (!bl) {
                        ExplorerTree.this.scrollPathToVisible(treePathArray[0]);
                    }
                }
            }

            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                super.treeNodesRemoved(treeModelEvent);
                if (ExplorerDnDManager.getDefault().isDnDActive()) {
                    return;
                }
                if (((ExplorerTree)ExplorerTree.this).TreeView.this.tree.getSelectionCount() == 0) {
                    TreePath treePath = TreeView.findSiblingTreePath(treeModelEvent.getTreePath(), treeModelEvent.getChildIndices());
                    if (treePath == null || treePath.equals(treeModelEvent.getTreePath())) {
                        return;
                    }
                    if (treePath.getPathCount() > 0) {
                        ((ExplorerTree)ExplorerTree.this).TreeView.this.tree.setSelectionPath(treePath);
                    }
                }
            }
        }

        private class AccessibleExplorerTree
        extends JTree.AccessibleJTree {
            AccessibleExplorerTree() {
                super(ExplorerTree.this);
            }

            public String getAccessibleName() {
                return TreeView.this.getAccessibleContext().getAccessibleName();
            }

            public String getAccessibleDescription() {
                return TreeView.this.getAccessibleContext().getAccessibleDescription();
            }
        }

        private class SearchFieldListener
        extends KeyAdapter
        implements DocumentListener,
        FocusListener {
            private List results = new ArrayList();
            private int currentSelectionIndex;

            SearchFieldListener() {
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.searchForNode();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.searchForNode();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.searchForNode();
            }

            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 27) {
                    ExplorerTree.this.removeSearchField();
                    ExplorerTree.this.requestFocus();
                } else if (n == 38) {
                    --this.currentSelectionIndex;
                    this.displaySearchResult();
                    keyEvent.consume();
                } else if (n == 40) {
                    ++this.currentSelectionIndex;
                    this.displaySearchResult();
                    keyEvent.consume();
                } else if (n == 9) {
                    if (ExplorerTree.this.maxPrefix != null) {
                        ExplorerTree.this.searchTextField.setText(ExplorerTree.this.maxPrefix);
                    }
                    keyEvent.consume();
                } else if (n == 10) {
                    ExplorerTree.this.removeSearchField();
                    TreePath treePath = ExplorerTree.this.getSelectionPath();
                    if (treePath != null) {
                        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
                        Node node = Visualizer.findNode(treeNode);
                        if (node.getPreferredAction() != null && node.getPreferredAction().isEnabled()) {
                            node.getPreferredAction().actionPerformed(new ActionEvent(this, 1001, ""));
                        } else {
                            ExplorerTree.this.expandPath(ExplorerTree.this.getSelectionPath());
                        }
                    }
                    ExplorerTree.this.requestFocus();
                    ExplorerTree.this.dispatchEvent(keyEvent);
                }
            }

            private void searchForNode() {
                this.currentSelectionIndex = 0;
                this.results.clear();
                ExplorerTree.this.maxPrefix = null;
                String string = ExplorerTree.this.searchTextField.getText().toUpperCase();
                if (string.length() > 0) {
                    this.results = ExplorerTree.this.doSearch(string);
                    this.displaySearchResult();
                }
            }

            private void displaySearchResult() {
                int n = this.results.size();
                if (n > 0) {
                    if (this.currentSelectionIndex < 0) {
                        this.currentSelectionIndex = n - 1;
                    } else if (this.currentSelectionIndex >= n) {
                        this.currentSelectionIndex = 0;
                    }
                    TreePath treePath = (TreePath)this.results.get(this.currentSelectionIndex);
                    ExplorerTree.this.setSelectionPath(treePath);
                    ExplorerTree.this.scrollPathToVisible(treePath);
                } else {
                    ExplorerTree.this.clearSelection();
                }
            }

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                ExplorerTree.this.removeSearchField();
            }
        }

        private class GuardedActions
        implements Mutex.Action {
            private int type;
            private Object p1;

            public GuardedActions(int n, Object object) {
                this.type = n;
                this.p1 = object;
                Children.MUTEX.readAccess((Mutex.Action)this);
            }

            public Object run() {
                switch (this.type) {
                    case 0: {
                        ExplorerTree.this.guardedPaint((Graphics)this.p1);
                        break;
                    }
                    case 1: {
                        ExplorerTree.this.guardedValidateTree();
                        break;
                    }
                    case 2: {
                        ExplorerTree.this.guardedDoLayout();
                        break;
                    }
                    case 3: {
                        ExplorerTree.this.repaintSelection();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("type: " + this.type);
                    }
                }
                return null;
            }
        }
    }

    final class PopupSupport
    extends MouseAdapter
    implements Runnable,
    FocusListener,
    ActionListener {
        public final Action popup = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(this);
            }

            public boolean isEnabled() {
                return TreeView.this.isFocusOwner() || ((PopupSupport)this).TreeView.this.tree.isFocusOwner();
            }
        };

        PopupSupport() {
        }

        public void run() {
            Point point = TreeView.this.getPositionForPopup();
            if (point == null) {
                point = new Point(0, 0);
            }
            TreeView.this.createPopup(point.x, point.y);
        }

        public void focusGained(FocusEvent focusEvent) {
            focusEvent.getComponent().removeFocusListener(this);
            if (DragDropUtilities.dragAndDropEnabled && TreeView.this.dragActive) {
                TreeView.this.setDragSource(true);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n = TreeView.this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (n != -1 && SwingUtilities.isLeftMouseButton(mouseEvent) && MouseUtils.isDoubleClick((MouseEvent)mouseEvent)) {
                TreePath treePath;
                Node node;
                Action action;
                if (TreeView.this.defaultActionEnabled && (action = TreeView.takeAction((node = Visualizer.findNode((treePath = TreeView.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY())).getLastPathComponent())).getPreferredAction(), node)) != null) {
                    if (action.isEnabled()) {
                        action.actionPerformed(new ActionEvent(node, 1001, ""));
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                    mouseEvent.consume();
                    return;
                }
                if (TreeView.this.tree.isExpanded(n)) {
                    TreeView.this.tree.collapseRow(n);
                } else {
                    TreeView.this.tree.expandRow(n);
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Action action;
            Node[] nodeArray = TreeView.this.manager.getSelectedNodes();
            if (nodeArray.length == 1 && (action = TreeView.takeAction(nodeArray[0].getPreferredAction(), nodeArray[0])) != null) {
                if (action.isEnabled()) {
                    action.actionPerformed(new ActionEvent(nodeArray[0], 1001, ""));
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }
    }

    class PopupAdapter
    extends MouseUtils.PopupMouseAdapter {
        static final /* synthetic */ boolean $assertionsDisabled;

        PopupAdapter() {
        }

        protected void showPopup(MouseEvent mouseEvent) {
            int n = TreeView.this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (n == -1 && !TreeView.this.isRootVisible()) {
                try {
                    TreeView.this.manager.setSelectedNodes(new Node[]{TreeView.this.manager.getRootContext()});
                }
                catch (PropertyVetoException propertyVetoException) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)propertyVetoException);
                    }
                }
            } else if (!TreeView.this.tree.isRowSelected(n)) {
                TreeView.this.tree.setSelectionRow(n);
            }
            if (n != -1 || !TreeView.this.isRootVisible()) {
                Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY(), TreeView.this);
                TreeView.this.createPopup((int)point.getX(), (int)point.getY());
            }
        }

        static {
            $assertionsDisabled = !(class$org$openide$explorer$view$TreeView == null ? (class$org$openide$explorer$view$TreeView = TreeView.class$("org.openide.explorer.view.TreeView")) : class$org$openide$explorer$view$TreeView).desiredAssertionStatus();
        }
    }

    class TreePropertyListener
    implements VetoableChangeListener,
    PropertyChangeListener,
    TreeExpansionListener,
    TreeWillExpandListener,
    TreeSelectionListener,
    Runnable {
        private RequestProcessor.Task scheduled;
        private TreePath[] readAccessPaths;

        TreePropertyListener() {
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (propertyChangeEvent.getPropertyName().equals("selectedNodes")) {
                Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
                if (TreeView.this.isSelectionModeBroken(nodeArray)) {
                    throw new PropertyVetoException("selection mode " + TreeView.this.getSelectionMode() + " broken by " + Arrays.asList(nodeArray), propertyChangeEvent);
                }
                if (!TreeView.this.selectionAccept(nodeArray)) {
                    throw new PropertyVetoException("selection " + Arrays.asList(nodeArray) + " rejected", propertyChangeEvent);
                }
            }
        }

        public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (TreeView.this.manager == null) {
                return;
            }
            if (propertyChangeEvent.getPropertyName().equals("rootContext")) {
                TreeView.this.synchronizeRootContext();
            }
            if (propertyChangeEvent.getPropertyName().equals("exploredContext")) {
                TreeView.this.synchronizeExploredContext();
            }
            if (propertyChangeEvent.getPropertyName().equals("selectedNodes")) {
                TreeView.this.synchronizeSelectedNodes();
            }
        }

        public synchronized void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            if (!TreeView.this.tree.getScrollsOnExpand()) {
                return;
            }
            RequestProcessor.Task task = this.scheduled;
            if (task != null) {
                task.cancel();
            }
            class Request
            implements Runnable {
                private TreePath path;
                private final /* synthetic */ TreePropertyListener this$1;

                public Request(TreePropertyListener treePropertyListener, TreePath treePath) {
                    this.this$1 = treePropertyListener;
                    this.path = treePath;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (!SwingUtilities.isEventDispatchThread()) {
                        SwingUtilities.invokeLater(this);
                        return;
                    }
                    try {
                        if (!TreePropertyListener.access$300((TreePropertyListener)this.this$1).tree.isVisible(this.path)) {
                            return;
                        }
                        if (TreePropertyListener.access$300((TreePropertyListener)this.this$1).treeModel == null) {
                            return;
                        }
                        TreeNode treeNode = (TreeNode)this.path.getLastPathComponent();
                        if (TreePropertyListener.access$300((TreePropertyListener)this.this$1).treeModel.getPathToRoot(treeNode)[0] != TreePropertyListener.access$300((TreePropertyListener)this.this$1).treeModel.getRoot()) {
                            return;
                        }
                        int n = treeNode.getChildCount() - 1;
                        if (n >= 0) {
                            TreeNode treeNode2 = treeNode.getChildAt(n);
                            Rectangle rectangle = TreePropertyListener.access$300((TreePropertyListener)this.this$1).tree.getVisibleRect();
                            Rectangle rectangle2 = TreePropertyListener.access$300((TreePropertyListener)this.this$1).tree.getPathBounds(this.path);
                            Rectangle rectangle3 = TreePropertyListener.access$300((TreePropertyListener)this.this$1).tree.getPathBounds(new TreePath(TreePropertyListener.access$300((TreePropertyListener)this.this$1).treeModel.getPathToRoot(treeNode2)));
                            if (rectangle != null && rectangle2 != null && rectangle3 != null) {
                                TreePropertyListener.access$300((TreePropertyListener)this.this$1).tree.scrollRectToVisible(new Rectangle(rectangle.x, rectangle2.y, 1, rectangle3.y - rectangle2.y + rectangle3.height));
                            }
                        }
                    }
                    finally {
                        this.path = null;
                    }
                }
            }
            this.scheduled = RequestProcessor.getDefault().post((Runnable)new Request(this, treeExpansionEvent.getPath()), 250);
        }

        public synchronized void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            TreeView.this.showNormalCursor();
            class Request
            implements Runnable {
                private TreePath path;
                private final /* synthetic */ TreePropertyListener this$1;

                public Request(TreePropertyListener treePropertyListener, TreePath treePath) {
                    this.this$1 = treePropertyListener;
                    this.path = treePath;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (!SwingUtilities.isEventDispatchThread()) {
                        SwingUtilities.invokeLater(this);
                        return;
                    }
                    try {
                        if (TreePropertyListener.access$300((TreePropertyListener)this.this$1).tree.isExpanded(this.path)) {
                            return;
                        }
                        if (!TreePropertyListener.access$300((TreePropertyListener)this.this$1).tree.isVisible(this.path)) {
                            return;
                        }
                        if (TreePropertyListener.access$300((TreePropertyListener)this.this$1).treeModel == null) {
                            return;
                        }
                        TreeNode treeNode = (TreeNode)this.path.getLastPathComponent();
                        if (TreePropertyListener.access$300((TreePropertyListener)this.this$1).treeModel.getPathToRoot(treeNode)[0] != TreePropertyListener.access$300((TreePropertyListener)this.this$1).treeModel.getRoot()) {
                            return;
                        }
                        TreePropertyListener.access$300((TreePropertyListener)this.this$1).treeModel.nodeStructureChanged(treeNode);
                    }
                    finally {
                        this.path = null;
                    }
                }
            }
            RequestProcessor.getDefault().post((Runnable)new Request(this, treeExpansionEvent.getPath()), TIME_TO_COLLAPSE);
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreePath[] treePathArray = TreeView.this.tree.getSelectionPaths();
            TreeView.this.storeSelectedPaths = Arrays.asList(treePathArray == null ? new TreePath[]{} : treePathArray);
            if (treePathArray == null) {
                if (ExplorerDnDManager.getDefault().isDnDActive()) {
                    return;
                }
                TreeView.this.callSelectionChanged(new Node[0]);
            } else {
                this.readAccessPaths = treePathArray;
                Children.MUTEX.postReadRequest((Runnable)this);
            }
        }

        public void run() {
            if (this.readAccessPaths == null) {
                return;
            }
            TreePath[] treePathArray = this.readAccessPaths;
            this.readAccessPaths = null;
            ArrayList<Node> arrayList = new ArrayList<Node>(treePathArray.length);
            for (int i = 0; i < treePathArray.length; ++i) {
                Node node = Visualizer.findNode(treePathArray[i].getLastPathComponent());
                if (!this.isUnderRoot(TreeView.this.manager.getRootContext(), node)) continue;
                arrayList.add(node);
            }
            TreeView.this.callSelectionChanged(arrayList.toArray(new Node[arrayList.size()]));
        }

        private boolean isUnderRoot(Node node, Node node2) {
            while (node2 != null) {
                if (node2.equals((Object)node)) {
                    return true;
                }
                node2 = node2.getParentNode();
            }
            return false;
        }

        public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        }

        public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            TreePath treePath = treeExpansionEvent.getPath();
            TreeView.this.prepareWaitCursor(DragDropUtilities.secureFindNode(treePath.getLastPathComponent()));
        }

        static /* synthetic */ TreeView access$300(TreePropertyListener treePropertyListener) {
            return treePropertyListener.TreeView.this;
        }
    }

    private static class CursorR
    implements Runnable {
        private Container contentPane;
        private Cursor c;

        private CursorR(Container container, Cursor cursor) {
            this.contentPane = container;
            this.c = cursor;
        }

        public void run() {
            this.contentPane.setCursor(this.c);
        }
    }
}

