/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.proxy;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.util.regex.Pattern;
import javax.net.SocketFactory;
import org.netbeans.modules.proxy.Base64Encoder;
import org.netbeans.modules.proxy.ConnectivitySettings;
import org.netbeans.modules.proxy.InterruptibleInputStream;

public class ClientSocketFactory
extends SocketFactory {
    private static final int CONNECT_TIMEOUT = 20000;
    private static final String AUTH_NONE = "<none>";
    private static final String AUTH_BASIC = "Basic";
    private static final Pattern sConnectionEstablishedPattern = Pattern.compile("HTTP\\/\\d+\\.\\d+\\s+200\\s+");
    private static final Pattern sProxyAuthRequiredPattern = Pattern.compile("HTTP\\/\\d+\\.\\d+\\s+407\\s+");
    private ConnectivitySettings mSettings;

    public ClientSocketFactory(ConnectivitySettings connectivitySettings) {
        this.mSettings = connectivitySettings;
    }

    public Socket createSocket() throws IOException {
        return new Socket(){

            public void connect(SocketAddress socketAddress, int n) throws IOException {
                Socket socket = ClientSocketFactory.this.createSocket((InetSocketAddress)socketAddress, n);
                socket.close();
            }

            public void bind(SocketAddress socketAddress) {
                throw new UnsupportedOperationException();
            }

            protected Object clone() {
                throw new UnsupportedOperationException();
            }

            public synchronized void close() {
            }

            public void connect(SocketAddress socketAddress) {
                throw new UnsupportedOperationException();
            }

            public SocketChannel getChannel() {
                throw new UnsupportedOperationException();
            }

            public InetAddress getInetAddress() {
                throw new UnsupportedOperationException();
            }

            public InputStream getInputStream() {
                throw new UnsupportedOperationException();
            }

            public boolean getKeepAlive() {
                throw new UnsupportedOperationException();
            }

            public InetAddress getLocalAddress() {
                throw new UnsupportedOperationException();
            }

            public int getLocalPort() {
                throw new UnsupportedOperationException();
            }

            public SocketAddress getLocalSocketAddress() {
                throw new UnsupportedOperationException();
            }

            public boolean getOOBInline() {
                throw new UnsupportedOperationException();
            }

            public OutputStream getOutputStream() {
                throw new UnsupportedOperationException();
            }

            public int getPort() {
                throw new UnsupportedOperationException();
            }

            public synchronized int getReceiveBufferSize() {
                throw new UnsupportedOperationException();
            }

            public SocketAddress getRemoteSocketAddress() {
                throw new UnsupportedOperationException();
            }

            public boolean getReuseAddress() {
                throw new UnsupportedOperationException();
            }

            public synchronized int getSendBufferSize() {
                throw new UnsupportedOperationException();
            }

            public int getSoLinger() {
                throw new UnsupportedOperationException();
            }

            public synchronized int getSoTimeout() {
                throw new UnsupportedOperationException();
            }

            public boolean getTcpNoDelay() {
                throw new UnsupportedOperationException();
            }

            public int getTrafficClass() {
                throw new UnsupportedOperationException();
            }

            public boolean isBound() {
                throw new UnsupportedOperationException();
            }

            public boolean isClosed() {
                throw new UnsupportedOperationException();
            }

            public boolean isConnected() {
                throw new UnsupportedOperationException();
            }

            public boolean isInputShutdown() {
                throw new UnsupportedOperationException();
            }

            public boolean isOutputShutdown() {
                throw new UnsupportedOperationException();
            }

            public void sendUrgentData(int n) {
                throw new UnsupportedOperationException();
            }

            public void setKeepAlive(boolean bl) {
                throw new UnsupportedOperationException();
            }

            public void setOOBInline(boolean bl) {
                throw new UnsupportedOperationException();
            }

            public synchronized void setReceiveBufferSize(int n) {
                throw new UnsupportedOperationException();
            }

            public void setReuseAddress(boolean bl) {
                throw new UnsupportedOperationException();
            }

            public synchronized void setSendBufferSize(int n) {
                throw new UnsupportedOperationException();
            }

            public void setSoLinger(boolean bl, int n) {
                throw new UnsupportedOperationException();
            }

            public synchronized void setSoTimeout(int n) {
                throw new UnsupportedOperationException();
            }

            public void setTcpNoDelay(boolean bl) {
                throw new UnsupportedOperationException();
            }

            public void setTrafficClass(int n) {
                throw new UnsupportedOperationException();
            }

            public void shutdownInput() {
                throw new UnsupportedOperationException();
            }

            public void shutdownOutput() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        return this.createSocket(new InetSocketAddress(string, n), 20000);
    }

    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        return this.createSocket(new InetSocketAddress(inetAddress, n), 20000);
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        throw new IOException("Unsupported operation");
    }

    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        throw new IOException("Unsupported operation");
    }

    private Socket getHttpsTunnelSocket(InetSocketAddress inetSocketAddress, int n) throws UnknownHostException, IOException {
        Socket socket = new Socket();
        socket.connect(new InetSocketAddress(this.mSettings.getProxyHost(), this.mSettings.getProxyPort()), n);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new InterruptibleInputStream(socket.getInputStream())));
        DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
        dataOutputStream.writeBytes("CONNECT ");
        dataOutputStream.writeBytes(inetSocketAddress.getHostName() + ":" + inetSocketAddress.getPort());
        dataOutputStream.writeBytes(" HTTP/1.0\r\n");
        dataOutputStream.writeBytes("Connection: Keep-Alive\r\n\r\n");
        dataOutputStream.flush();
        String string = bufferedReader.readLine();
        if (sConnectionEstablishedPattern.matcher(string).find()) {
            while ((string = bufferedReader.readLine()).length() != 0) {
            }
            return socket;
        }
        if (sProxyAuthRequiredPattern.matcher(string).find()) {
            boolean bl = false;
            String string2 = AUTH_NONE;
            while ((string = bufferedReader.readLine()).length() != 0) {
                if (!string.startsWith("Proxy-Authenticate:") || bl || !(string2 = string.substring(19).trim()).equals(AUTH_BASIC)) continue;
                bl = true;
            }
            socket.close();
            if (string2.startsWith(AUTH_BASIC)) {
                return this.authenticateBasic(inetSocketAddress);
            }
            throw new IOException("Unsupported authentication method: " + string2);
        }
        socket.close();
        throw new IOException("HTTP proxy does not support CONNECT command. Received reply: " + string);
    }

    private Socket authenticateBasic(InetSocketAddress inetSocketAddress) throws IOException {
        Socket socket = new Socket(this.mSettings.getProxyHost(), this.mSettings.getProxyPort());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new InterruptibleInputStream(socket.getInputStream())));
        DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
        String string = this.mSettings.getProxyUsername() == null ? "" : this.mSettings.getProxyUsername();
        String string2 = this.mSettings.getProxyPassword() == null ? "" : String.valueOf(this.mSettings.getProxyPassword());
        String string3 = string + ":" + string2;
        String string4 = Base64Encoder.encode(string3.getBytes("US-ASCII"));
        dataOutputStream.writeBytes("CONNECT ");
        dataOutputStream.writeBytes(inetSocketAddress.getHostName() + ":" + inetSocketAddress.getPort());
        dataOutputStream.writeBytes(" HTTP/1.0\r\n");
        dataOutputStream.writeBytes("Connection: Keep-Alive\r\n");
        dataOutputStream.writeBytes("Proxy-Authorization: Basic " + string4 + "\r\n");
        dataOutputStream.writeBytes("\r\n");
        dataOutputStream.flush();
        String string5 = bufferedReader.readLine();
        if (sConnectionEstablishedPattern.matcher(string5).find()) {
            while ((string5 = bufferedReader.readLine()).length() != 0) {
            }
            return socket;
        }
        throw new IOException("Basic authentication failed: " + string5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket getSocks4TunnelSocket(InetSocketAddress inetSocketAddress, int n) throws IOException {
        boolean bl = false;
        Socket socket = new Socket();
        socket.connect(new InetSocketAddress(this.mSettings.getProxyHost(), this.mSettings.getProxyPort()), n);
        try {
            int n2;
            DataInputStream dataInputStream = new DataInputStream(new InterruptibleInputStream(socket.getInputStream()));
            DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
            dataOutputStream.writeByte(4);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeShort(inetSocketAddress.getPort());
            InetAddress inetAddress = inetSocketAddress.getAddress();
            if (inetAddress == null) {
                throw new UnknownHostException(inetSocketAddress.getHostName());
            }
            byte[] byArray = inetAddress.getAddress();
            for (int i = 0; i < byArray.length; ++i) {
                dataOutputStream.writeByte(byArray[i]);
            }
            String string = this.mSettings.getProxyUsername();
            if (string != null) {
                byte[] byArray2 = string.getBytes();
                for (n2 = 0; n2 < byArray2.length; ++n2) {
                    dataOutputStream.writeByte(byArray2[n2]);
                }
            }
            dataOutputStream.writeByte(0);
            int n3 = dataInputStream.read();
            if (n3 != 0) {
                throw new IOException("socks4.not.available." + n3);
            }
            n2 = dataInputStream.read();
            if (n2 != 90) {
                throw new IOException("socks4.error." + n2);
            }
            while (dataInputStream.available() > 0) {
                dataInputStream.read();
            }
            bl = true;
            Socket socket2 = socket;
            return socket2;
        }
        finally {
            if (!bl) {
                socket.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket getSocks5TunnelSocket(InetSocketAddress inetSocketAddress, int n) throws IOException {
        boolean bl = false;
        Socket socket = new Socket();
        socket.connect(new InetSocketAddress(this.mSettings.getProxyHost(), this.mSettings.getProxyPort()), n);
        try {
            int n2;
            String string;
            DataInputStream dataInputStream = new DataInputStream(new InterruptibleInputStream(socket.getInputStream()));
            DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
            dataOutputStream.write(new byte[]{5, 2, 0, 2});
            int n3 = dataInputStream.read();
            if (n3 != 5) {
                throw new IOException("SOCKS5 protocol error: version: " + n3);
            }
            int n4 = dataInputStream.read();
            if (n4 == 255) {
                throw new IOException("SOCKS5 authentication failure: no supported method acccepted by server");
            }
            if (n4 == 2) {
                dataOutputStream.writeByte(1);
                string = this.mSettings.getProxyUsername();
                byte[] byArray = string == null ? new byte[]{} : string.getBytes();
                dataOutputStream.writeByte(byArray.length);
                for (int i = 0; i < byArray.length; ++i) {
                    dataOutputStream.writeByte(byArray[i]);
                }
                String string2 = null;
                if (this.mSettings.getProxyPassword() != null) {
                    string2 = new String(this.mSettings.getProxyPassword());
                }
                byte[] byArray2 = string2 == null ? new byte[]{} : string2.getBytes();
                dataOutputStream.writeByte(byArray2.length);
                for (int i = 0; i < byArray2.length; ++i) {
                    dataOutputStream.writeByte(byArray2[i]);
                }
                n2 = dataInputStream.read();
                if (n2 != 1) {
                    throw new IOException("socks5.auth.error." + n2);
                }
                n2 = dataInputStream.read();
                if (n2 != 0) {
                    throw new IOException("socks5.auth.error." + n2);
                }
            }
            string = inetSocketAddress.getHostName();
            dataOutputStream.write(new byte[]{5, 1, 0, 3, (byte)string.length()});
            dataOutputStream.writeBytes(string);
            dataOutputStream.writeShort(inetSocketAddress.getPort());
            n3 = dataInputStream.read();
            if (n3 != 5) {
                throw new IOException("SOCKS5 protocol error: version: " + n3);
            }
            n2 = dataInputStream.read();
            if (n2 != 0) {
                throw new IOException("SOCKS5 protocol error: " + n2);
            }
            n2 = dataInputStream.read();
            if (n2 != 0) {
                throw new IOException("SOCKS5 protocol error: " + n2);
            }
            int n5 = dataInputStream.read();
            if (n5 == -1) {
                throw new IOException("SOCKS5 protocol error: " + n5);
            }
            for (int i = 0; i < 4; ++i) {
                n2 = dataInputStream.read();
                if (n2 != -1) continue;
                throw new IOException("SOCKS5 error: " + n2);
            }
            n2 = dataInputStream.read();
            n2 = dataInputStream.read();
            bl = true;
            Socket socket2 = socket;
            return socket2;
        }
        finally {
            if (!bl) {
                socket.close();
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Socket createSocket(InetSocketAddress inetSocketAddress, int n) throws UnknownHostException, IOException {
        String string = System.getProperty("socksProxyHost");
        System.getProperties().remove("socksProxyHost");
        try {
            switch (this.mSettings.getConnectionType()) {
                case 1: {
                    try {
                        Socket socket = this.getSocks5TunnelSocket(inetSocketAddress, n);
                        return socket;
                    }
                    catch (IOException iOException) {
                        Socket socket = this.getSocks4TunnelSocket(inetSocketAddress, n);
                        if (string == null) return socket;
                        System.setProperty("socksProxyHost", string);
                        return socket;
                    }
                }
                case 0: {
                    Socket socket = new Socket();
                    socket.connect(inetSocketAddress, n);
                    Socket socket2 = socket;
                    return socket2;
                }
                case 2: {
                    Socket socket = this.getHttpsTunnelSocket(inetSocketAddress, n);
                    return socket;
                }
            }
            throw new IOException("Illegal connection type: " + this.mSettings.getConnectionType());
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (string != null) {
                System.setProperty("socksProxyHost", string);
            }
        }
    }
}

