/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.openfile.OpenFileImpl;
import org.netbeans.modules.openfile.cli.Callback;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.FileSystemAction;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.ViewCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOperation;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class DefaultOpenFileImpl
implements OpenFileImpl {
    static final String JAVA_EXT = ".JAVA";
    static final String TXT_EXT = ".TXT";
    private static final int OPEN_EDITOR_WAIT_PERIOD_MS = 100;
    private static final int OPEN_EDITOR_TOTAL_TIMEOUT_MS = 1000;
    private static final String ZIP_EXT = "zip";
    private static final String JAR_EXT = "jar";
    static final /* synthetic */ boolean $assertionsDisabled;

    protected final void setStatusLine(String string) {
        StatusDisplayer.getDefault().setStatusText(string);
    }

    protected final void clearStatusLine() {
        this.setStatusLine("");
    }

    protected void setStatusLineOpening(String string, boolean bl) {
        this.setStatusLine(NbBundle.getMessage((Class)OpenFileImpl.class, (String)(bl ? "MSG_openingAndWaiting" : "MSG_opening"), (Object)string));
    }

    protected void notifyCannotOpen(String string) {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)OpenFileImpl.class, (String)"MSG_cannotOpenWillClose", (Object)string)));
    }

    private boolean openEditor(EditorCookie editorCookie, int n) {
        StyledDocument styledDocument;
        JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
        if (jEditorPaneArray != null) {
            if (n >= 0) {
                int n2 = this.getCursorOffset(editorCookie.getDocument(), n);
                jEditorPaneArray[0].setCaretPosition(n2);
            }
            Container container = SwingUtilities.getAncestorOfClass(TopComponent.class, jEditorPaneArray[0]);
            if (!$assertionsDisabled && container == null) {
                throw new AssertionError();
            }
            final TopComponent topComponent = (TopComponent)container;
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    topComponent.requestActive();
                }
            });
            return true;
        }
        try {
            styledDocument = editorCookie.openDocument();
        }
        catch (IOException iOException) {
            String string = NbBundle.getMessage((Class)OpenFileImpl.class, (String)"MSG_cannotOpenWillClose");
            ErrorManager.getDefault().notify(4096, ErrorManager.getDefault().annotate((Throwable)iOException, string));
            this.clearStatusLine();
            return false;
        }
        if (n < 0) {
            editorCookie.open();
        } else {
            this.openDocAtLine(editorCookie, styledDocument, n);
        }
        return true;
    }

    private void openDocAtLine(EditorCookie editorCookie, StyledDocument styledDocument, int n) {
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && editorCookie.getDocument() != styledDocument) {
            throw new AssertionError();
        }
        int n2 = this.getCursorOffset(styledDocument, n);
        class SetCursorTask
        implements Runnable {
            private boolean completed = false;
            private PropertyChangeListener listenerToUnregister;
            static final /* synthetic */ boolean $assertionsDisabled;
            private final /* synthetic */ EditorCookie val$editorCookie;
            private final /* synthetic */ int val$offset;

            SetCursorTask(EditorCookie editorCookie, int n) {
                this.val$editorCookie = editorCookie;
                this.val$offset = n;
            }

            private boolean perform() {
                if (EventQueue.isDispatchThread()) {
                    this.run();
                } else {
                    try {
                        EventQueue.invokeAndWait(this);
                    }
                    catch (Exception exception) {
                        ErrorManager.getDefault().notify((Throwable)exception);
                        this.completed = true;
                    }
                }
                return this.completed;
            }

            public void run() {
                if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
                    throw new AssertionError();
                }
                if (this.completed) {
                    return;
                }
                JEditorPane[] jEditorPaneArray = this.val$editorCookie.getOpenedPanes();
                if (jEditorPaneArray != null) {
                    jEditorPaneArray[0].setCaretPosition(this.val$offset);
                    if (this.listenerToUnregister != null) {
                        ((EditorCookie.Observable)this.val$editorCookie).removePropertyChangeListener(this.listenerToUnregister);
                    }
                    this.completed = true;
                }
            }

            private void setListenerToUnregister(PropertyChangeListener propertyChangeListener) {
                this.listenerToUnregister = propertyChangeListener;
            }

            static {
                $assertionsDisabled = !(class$org$netbeans$modules$openfile$DefaultOpenFileImpl == null ? (class$org$netbeans$modules$openfile$DefaultOpenFileImpl = DefaultOpenFileImpl.class$("org.netbeans.modules.openfile.DefaultOpenFileImpl")) : class$org$netbeans$modules$openfile$DefaultOpenFileImpl).desiredAssertionStatus();
            }
        }
        final SetCursorTask setCursorTask = new SetCursorTask(editorCookie, n2);
        editorCookie.open();
        if (setCursorTask.perform()) {
            return;
        }
        if (editorCookie instanceof EditorCookie.Observable) {
            if (!setCursorTask.perform()) {
                PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){
                    {
                    }

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if ("openedPanes".equals(propertyChangeEvent.getPropertyName())) {
                            setCursorTask.perform();
                        }
                    }
                };
                setCursorTask.setListenerToUnregister(propertyChangeListener);
                ((EditorCookie.Observable)editorCookie).addPropertyChangeListener(propertyChangeListener);
                setCursorTask.perform();
            }
        } else {
            for (int i = 0; i < 10; ++i) {
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    ErrorManager.getDefault().notify(4096, (Throwable)interruptedException);
                }
                if (setCursorTask.perform()) break;
            }
            if (!setCursorTask.completed) {
                this.setStatusLine(NbBundle.getMessage((Class)OpenFileImpl.class, (String)"MSG_couldNotOpenAt"));
            }
        }
    }

    private int getCursorOffset(StyledDocument styledDocument, int n) {
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError();
        }
        try {
            return NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Element element = NbDocument.findLineRootElement((StyledDocument)styledDocument);
            int n2 = element.getElementCount();
            if (n >= n2) {
                return NbDocument.findLineOffset((StyledDocument)styledDocument, (int)(n2 - 1));
            }
            throw indexOutOfBoundsException;
        }
    }

    protected boolean openByCookie(Node.Cookie cookie, Class clazz, int n) {
        if (clazz == EditorCookie.Observable.class || clazz == EditorCookie.Observable.class) {
            return this.openEditor((EditorCookie)cookie, n);
        }
        if (clazz == OpenCookie.class) {
            ((OpenCookie)cookie).open();
        } else if (clazz == EditCookie.class) {
            ((EditCookie)cookie).edit();
        } else if (clazz == ViewCookie.class) {
            ((ViewCookie)cookie).view();
        } else {
            throw new IllegalArgumentException();
        }
        return true;
    }

    private final boolean openDataObjectByCookie(DataObject dataObject, int n) {
        Class clazz = OpenCookie.class;
        Node.Cookie cookie = dataObject.getCookie(clazz);
        if (cookie != null || (cookie = dataObject.getCookie(clazz = EditCookie.class)) != null || (cookie = dataObject.getCookie(clazz = ViewCookie.class)) != null) {
            return this.openByCookie(cookie, clazz, n);
        }
        return false;
    }

    private final DataLoader getDefaultLoader() {
        DataLoader dataLoader = null;
        DataLoaderPool dataLoaderPool = DataLoaderPool.getDefault();
        Enumeration enumeration = dataLoaderPool.allLoaders();
        while (enumeration.hasMoreElements()) {
            dataLoader = (DataLoader)enumeration.nextElement();
        }
        return dataLoader;
    }

    public boolean open(FileObject fileObject, int n, Callback.Waiter waiter) {
        Class clazz;
        Node.Cookie cookie;
        DataObject dataObject;
        String string = fileObject.getNameExt();
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
            return false;
        }
        if (n != -1 && ((cookie = dataObject.getCookie(clazz = EditorCookie.Observable.class)) != null || (cookie = dataObject.getCookie(clazz = EditorCookie.class)) != null)) {
            boolean bl = this.openByCookie(cookie, clazz, n);
            this.clearStatusLine();
            return bl;
        }
        final Node node = dataObject.getNodeDelegate();
        final Action action = node.getPreferredAction();
        if (action != null && !(action instanceof FileSystemAction)) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    action.actionPerformed(new ActionEvent(node, 0, null));
                    DefaultOpenFileImpl.this.clearStatusLine();
                }
            });
            return true;
        }
        this.setStatusLineOpening(string, waiter != null);
        boolean bl = this.openDataObjectByCookie(dataObject, n);
        this.clearStatusLine();
        if (bl) {
            return true;
        }
        if (ZIP_EXT.equalsIgnoreCase(fileObject.getExt()) || JAR_EXT.equalsIgnoreCase(fileObject.getExt())) {
            Node node2 = dataObject.getNodeDelegate();
            if (node2 != null) {
                NodeOperation.getDefault().explore(node2);
                return true;
            }
            return false;
        }
        return false;
    }

    public synchronized FileObject findFileObject(File file) {
        return FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
    }

    static {
        $assertionsDisabled = !DefaultOpenFileImpl.class.desiredAssertionStatus();
    }
}

