/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import org.netbeans.modules.openfile.FileChooser;
import org.netbeans.modules.openfile.OpenFile;
import org.netbeans.modules.utilities.Manager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class OpenFileAction
extends CallableSystemAction {
    static /* synthetic */ Class class$org$openide$loaders$DataObject;

    public OpenFileAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        return NbBundle.getMessage((Class)OpenFileAction.class, (String)"LBL_openFile");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(OpenFileAction.class);
    }

    protected String iconResource() {
        return "org/netbeans/modules/openfile/openFile.png";
    }

    protected JFileChooser prepareFileChooser() {
        FileChooser fileChooser = new FileChooser();
        File file = OpenFileAction.findStartingDirectory();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)fileChooser, (File)file);
        HelpCtx.setHelpIDString((JComponent)fileChooser, (String)this.getHelpCtx().getHelpID());
        return fileChooser;
    }

    public static File[] chooseFilesToOpen(JFileChooser jFileChooser) throws UserCancelException {
        File[] fileArray;
        do {
            int n;
            if ((n = jFileChooser.showOpenDialog(WindowManager.getDefault().getMainWindow())) == 0) continue;
            throw new UserCancelException();
        } while ((fileArray = jFileChooser.getSelectedFiles()).length == 0);
        return fileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performAction() {
        if (!Manager.actionActivated((SystemAction)this)) {
            return;
        }
        try {
            File[] fileArray;
            JFileChooser jFileChooser = this.prepareFileChooser();
            try {
                fileArray = OpenFileAction.chooseFilesToOpen(jFileChooser);
            }
            catch (UserCancelException userCancelException) {
                Manager.actionFinished((SystemAction)this);
                return;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                OpenFile.openFile(fileArray[i], -1, null);
            }
        }
        finally {
            Manager.actionFinished((SystemAction)this);
        }
    }

    protected boolean asynchronous() {
        return false;
    }

    private static File findStartingDirectory() {
        Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
        for (int i = 0; i < nodeArray.length; ++i) {
            File file;
            DataObject dataObject = (DataObject)nodeArray[i].getCookie(class$org$openide$loaders$DataObject == null ? OpenFileAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
            if (dataObject == null || (file = FileUtil.toFile((FileObject)dataObject.getPrimaryFile())) == null) continue;
            if (file.isFile()) {
                file = file.getParentFile();
            }
            return file;
        }
        return new File(System.getProperty("user.home"));
    }
}

