/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.EventQueue;
import java.lang.ref.Reference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.netbeans.modules.search.CleanTask;
import org.netbeans.modules.search.PrintDetailsTask;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.ResultTreeChildren;
import org.netbeans.modules.search.ResultView;
import org.netbeans.modules.search.SearchDisplayer;
import org.netbeans.modules.search.SearchTask;
import org.openide.ErrorManager;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openidex.search.SearchGroup;

final class Manager {
    private static final int CLEANUP_TIMEOUT_MILLIS = 3000;
    static final int NO_TASK = 0;
    static final int SEARCHING = 1;
    static final int CLEANING_RESULT = 2;
    static final int PRINTING_DETAILS = 4;
    static final int EVENT_SEARCH_STARTED = 1;
    static final int EVENT_SEARCH_FINISHED = 2;
    static final int EVENT_SEARCH_INTERRUPTED = 3;
    static final int EVENT_SEARCH_CANCELLED = 4;
    private static final Manager instance;
    private boolean moduleBeingUninstalled = false;
    private final Object lock = new Object();
    private int state = 0;
    private int pendingTasks = 0;
    private TaskListener taskListener;
    private SearchTask currentSearchTask;
    private SearchTask pendingSearchTask;
    private PrintDetailsTask currentPrintDetailsTask;
    private PrintDetailsTask pendingPrintDetailsTask;
    private Task searchTask;
    private Task cleanResultTask;
    private Task printDetailsTask;
    private ResultModel resultModelToClean;
    private boolean searchWindowOpen = false;
    private Reference outputWriterRef;
    static final /* synthetic */ boolean $assertionsDisabled;

    static Manager getInstance() {
        return instance;
    }

    private Manager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleSearchTask(SearchTask searchTask) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        Object object = this.lock;
        synchronized (object) {
            ResultView.getInstance().setResultModel(null);
            if (this.currentSearchTask != null) {
                this.currentSearchTask.stop(false);
            }
            if (this.resultModelToClean != null) {
                this.pendingTasks |= 2;
            }
            this.pendingTasks |= 1;
            this.pendingSearchTask = searchTask;
            if (this.state == 0) {
                this.processNextPendingTask();
            } else {
                this.notifySearchPending(this.state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void schedulePrintingDetails(ResultTreeChildren resultTreeChildren, SearchGroup searchGroup) {
        Object object = this.lock;
        synchronized (object) {
            if (!$assertionsDisabled && this.state != 0) {
                throw new AssertionError();
            }
            this.pendingTasks |= 4;
            this.pendingPrintDetailsTask = new PrintDetailsTask(resultTreeChildren.getNodes(), searchGroup);
            this.processNextPendingTask();
        }
    }

    private void notifySearchStarted() {
        this.notifySearchTaskStateChange(1);
    }

    private void notifySearchFinished() {
        this.notifySearchTaskStateChange(2);
    }

    private void notifySearchInterrupted() {
        this.notifySearchTaskStateChange(3);
    }

    private void notifySearchCancelled() {
        this.notifySearchTaskStateChange(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySearchTaskStateChange(int n) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.searchWindowOpen) {
                return;
            }
        }
        this.callOnWindowFromAWT("searchTaskStateChanged", new Integer(n));
    }

    private void notifySearchPending(int n) {
        if (!this.searchWindowOpen) {
            return;
        }
        this.callOnWindowFromAWT("notifySearchPending", new Integer(n));
    }

    private void notifyPrintingDetailsFinished() {
        if (!this.searchWindowOpen) {
            return;
        }
        this.callOnWindowFromAWT("showAllDetailsFinished");
    }

    private void activateResultWindow() {
        Method method;
        try {
            method = ResultView.class.getMethod("requestActive", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException();
        }
        this.callOnWindowFromAWT(method, null);
    }

    private void callOnWindowFromAWT(String string) {
        Method method;
        try {
            method = ResultView.class.getDeclaredMethod(string, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException();
        }
        this.callOnWindowFromAWT(method, null);
    }

    private void callOnWindowFromAWT(String string, Object object) {
        Method method = null;
        Method[] methodArray = ResultView.class.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Class<?>[] classArray;
            Method method2 = methodArray[i];
            if (!method2.getName().equals(string) || (classArray = method2.getParameterTypes()).length != 1) continue;
            Class<?> clazz = classArray[0];
            if (!(object == null && !clazz.isPrimitive() || clazz == Integer.TYPE && object instanceof Integer) && !classArray[0].isInstance(object)) continue;
            method = method2;
        }
        if (method == null) {
            throw new IllegalArgumentException();
        }
        this.callOnWindowFromAWT(method, new Object[]{object});
    }

    private void callOnWindowFromAWT(final Method method, final Object[] objectArray) {
        Runnable runnable = new Runnable(){

            public void run() {
                ResultView resultView = ResultView.getInstance();
                try {
                    method.invoke((Object)resultView, objectArray);
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify((Throwable)exception);
                }
            }
        };
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (InvocationTargetException invocationTargetException) {
                ErrorManager.getDefault().notify((Throwable)invocationTargetException);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(65536, (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void searchWindowOpened() {
        Object object = this.lock;
        synchronized (object) {
            this.searchWindowOpen = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void searchWindowClosed() {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        Object object = this.lock;
        synchronized (object) {
            this.searchWindowOpen = false;
            if (this.moduleBeingUninstalled) {
                return;
            }
            ResultView.getInstance().setResultModel(null);
            if (this.currentSearchTask != null) {
                this.currentSearchTask.stop(false);
            }
            if (this.resultModelToClean != null) {
                this.pendingTasks |= 2;
            }
            this.pendingTasks &= 0xFFFFFFFE;
            this.pendingSearchTask = null;
            if (this.state == 0) {
                this.processNextPendingTask();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNextPendingTask() {
        Object object = this.lock;
        synchronized (object) {
            if (!$assertionsDisabled && this.state != 0) {
                throw new AssertionError();
            }
            if (this.resultModelToClean == null) {
                this.pendingTasks &= 0xFFFFFFFD;
            }
            if ((this.pendingTasks & 4) != 0) {
                if ((this.pendingTasks & 1) != 0) {
                    this.notifySearchPending(4);
                }
                this.startPrintingDetails();
            } else if ((this.pendingTasks & 2) != 0) {
                if ((this.pendingTasks & 1) != 0) {
                    this.notifySearchPending(2);
                }
                this.startCleaning();
            } else if ((this.pendingTasks & 1) != 0) {
                this.startSearching();
            } else if (!$assertionsDisabled && this.pendingTasks != 0) {
                throw new AssertionError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSearching() {
        Object object = this.lock;
        synchronized (object) {
            this.notifySearchStarted();
            ResultModel resultModel = this.pendingSearchTask.getResultModel();
            this.callOnWindowFromAWT("setResultModel", resultModel);
            this.resultModelToClean = resultModel;
            if (this.outputWriterRef != null) {
                SearchDisplayer.clearOldOutput(this.outputWriterRef);
                this.outputWriterRef = null;
                this.activateResultWindow();
            }
            RequestProcessor.Task task = RequestProcessor.getDefault().create((Runnable)this.pendingSearchTask);
            task.addTaskListener(this.getTaskListener());
            task.schedule(0);
            this.currentSearchTask = this.pendingSearchTask;
            this.pendingSearchTask = null;
            this.searchTask = task;
            this.pendingTasks &= 0xFFFFFFFE;
            this.state = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startPrintingDetails() {
        Object object = this.lock;
        synchronized (object) {
            if (this.outputWriterRef != null) {
                SearchDisplayer.clearOldOutput(this.outputWriterRef);
                this.outputWriterRef = null;
            }
            RequestProcessor.Task task = RequestProcessor.getDefault().create((Runnable)this.pendingPrintDetailsTask);
            task.addTaskListener(this.getTaskListener());
            task.schedule(0);
            this.printDetailsTask = task;
            this.pendingTasks &= 0xFFFFFFFB;
            this.currentPrintDetailsTask = this.pendingPrintDetailsTask;
            this.pendingPrintDetailsTask = null;
            this.state = 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCleaning() {
        Object object = this.lock;
        synchronized (object) {
            CleanTask cleanTask = new CleanTask(this.resultModelToClean);
            this.resultModelToClean = null;
            RequestProcessor.Task task = RequestProcessor.getDefault().create((Runnable)cleanTask);
            task.addTaskListener(this.getTaskListener());
            task.schedule(0);
            this.cleanResultTask = task;
            this.pendingTasks &= 0xFFFFFFFD;
            this.state = 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopSearching() {
        Object object = this.lock;
        synchronized (object) {
            if ((this.pendingTasks & 1) != 0) {
                this.pendingTasks &= 0xFFFFFFFE;
                this.pendingSearchTask = null;
                this.notifySearchCancelled();
            } else if (this.currentSearchTask != null) {
                this.currentSearchTask.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void taskFinished(Task task) {
        Object object = this.lock;
        synchronized (object) {
            if (this.moduleBeingUninstalled) {
                this.allTasksFinished();
                return;
            }
            if (task == this.searchTask) {
                if (!$assertionsDisabled && this.state != 1) {
                    throw new AssertionError();
                }
                if (this.currentSearchTask.notifyWhenFinished()) {
                    if (this.currentSearchTask.wasInterrupted()) {
                        this.notifySearchInterrupted();
                    } else {
                        this.notifySearchFinished();
                    }
                }
                this.currentSearchTask = null;
                this.searchTask = null;
                this.state = 0;
            } else if (task == this.cleanResultTask) {
                if (!$assertionsDisabled && this.state != 2) {
                    throw new AssertionError();
                }
                this.cleanResultTask = null;
                this.state = 0;
            } else if (task == this.printDetailsTask) {
                if (!$assertionsDisabled && this.state != 4) {
                    throw new AssertionError();
                }
                this.notifyPrintingDetailsFinished();
                this.outputWriterRef = this.currentPrintDetailsTask.getOutputWriterRef();
                this.currentPrintDetailsTask = null;
                this.printDetailsTask = null;
                this.state = 0;
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            this.processNextPendingTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void allTasksFinished() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doCleanup() {
        Object object = this.lock;
        synchronized (object) {
            this.moduleBeingUninstalled = true;
            if (this.state != 0) {
                if (this.currentSearchTask != null) {
                    this.currentSearchTask.stop(false);
                }
                if (this.currentPrintDetailsTask != null) {
                    this.currentPrintDetailsTask.stop();
                }
                try {
                    this.lock.wait(3000L);
                }
                catch (InterruptedException interruptedException) {
                    ErrorManager.getDefault().notify(4096, (Throwable)interruptedException);
                }
            }
            this.callOnWindowFromAWT("closeResults");
        }
    }

    private TaskListener getTaskListener() {
        if (this.taskListener == null) {
            this.taskListener = new MyTaskListener();
        }
        return this.taskListener;
    }

    static {
        $assertionsDisabled = !Manager.class.desiredAssertionStatus();
        instance = new Manager();
    }

    private class MyTaskListener
    implements TaskListener {
        MyTaskListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void taskFinished(Task task) {
            Object object = Manager.this.lock;
            synchronized (object) {
                Manager.this.taskFinished(task);
            }
        }
    }
}

