/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.EventQueue;
import java.lang.ref.Reference;
import java.lang.reflect.Method;
import org.netbeans.modules.search.SearchDisplayer;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openidex.search.SearchGroup;
import org.openidex.search.SearchType;

public class PrintDetailsTask
implements Runnable {
    private static final int BUFFER_SIZE = 8;
    private final Node[] nodes;
    private final SearchGroup searchGroup;
    private final Node[] buffer = new Node[8];
    private int bufPos = 0;
    private SearchDisplayer displayer;
    private volatile boolean interrupted = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PrintDetailsTask(Node[] nodeArray, SearchGroup searchGroup) {
        this.nodes = nodeArray;
        this.searchGroup = searchGroup;
    }

    public void run() {
        Node[] nodeArray;
        int n;
        this.displayer = new SearchDisplayer();
        this.callDisplayerFromAWT("prepareOutput");
        SearchType[] searchTypeArray = this.searchGroup.getSearchTypes();
        int n2 = 0;
        for (n = 0; n < this.nodes.length; ++n) {
            int n3;
            nodeArray = null;
            for (n3 = 0; n3 < searchTypeArray.length; ++n3) {
                Node[] nodeArray2 = searchTypeArray[n3].getDetails(this.nodes[n]);
                if (nodeArray2 == null || nodeArray2.length == 0) continue;
                nodeArray = nodeArray == null ? nodeArray2 : this.concatNodeArrays(nodeArray, nodeArray2);
            }
            if (nodeArray == null) continue;
            n2 = this.addToBuffer(nodeArray, 0);
            while (n2 < 0) {
                this.printBuffer();
                n3 = nodeArray.length + n2;
                n2 = this.addToBuffer(nodeArray, n3);
            }
            if (n2 == 0) {
                this.printBuffer();
            }
            if (this.interrupted) break;
        }
        if (n2 != 0 && !this.interrupted) {
            n = 8 - n2;
            nodeArray = new Node[n];
            System.arraycopy(this.buffer, 0, nodeArray, 0, n);
            this.displayer.displayNodes(nodeArray);
        }
        this.callDisplayerFromAWT("finishDisplaying");
    }

    void stop() {
        this.interrupted = true;
    }

    public Reference getOutputWriterRef() {
        return this.displayer.getOutputWriterRef();
    }

    private int addToBuffer(Node[] nodeArray, int n) {
        if (!($assertionsDisabled || n >= 0 && n <= nodeArray.length)) {
            throw new AssertionError();
        }
        int n2 = nodeArray.length - n;
        int n3 = this.bufPos + n2;
        int n4 = 8 - n3;
        if (n4 <= 0) {
            n2 += n4;
            n3 = 0;
        }
        System.arraycopy(nodeArray, n, this.buffer, this.bufPos, n2);
        this.bufPos = n3;
        return n4;
    }

    private void printBuffer() {
        this.displayer.displayNodes(this.buffer);
    }

    private Node[] concatNodeArrays(Node[] nodeArray, Node[] nodeArray2) {
        Node[] nodeArray3 = new Node[nodeArray.length + nodeArray2.length];
        System.arraycopy(nodeArray, 0, nodeArray3, 0, nodeArray.length);
        System.arraycopy(nodeArray2, 0, nodeArray3, nodeArray.length, nodeArray2.length);
        return nodeArray3;
    }

    private void callDisplayerFromAWT(String string) {
        try {
            final Method method = SearchDisplayer.class.getDeclaredMethod(string, new Class[0]);
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        method.invoke((Object)PrintDetailsTask.this.displayer, null);
                    }
                    catch (Exception exception) {
                        ErrorManager.getDefault().notify((Throwable)exception);
                    }
                }
            };
            if (EventQueue.isDispatchThread()) {
                runnable.run();
            } else {
                EventQueue.invokeAndWait(runnable);
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
    }

    static {
        $assertionsDisabled = !PrintDetailsTask.class.desiredAssertionStatus();
    }
}

