/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.search.ResultTreeChildren;
import org.netbeans.modules.search.types.FullTextType;
import org.openide.ErrorManager;
import org.openidex.search.SearchGroup;
import org.openidex.search.SearchType;

public final class ResultModel {
    private static final int COUNT_LIMIT = 500;
    private static final int DETAILS_COUNT_LIMIT = 5000;
    private int size = 0;
    private int totalDetailsCount = 0;
    private ResultTreeChildren observer;
    private boolean limitReached = false;
    private List searchTypeList;
    private SearchGroup searchGroup;
    private String finishMessage;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ResultModel(List list, SearchGroup searchGroup) {
        this.searchTypeList = list;
        this.searchGroup = searchGroup;
    }

    void setObserver(ResultTreeChildren resultTreeChildren) {
        this.observer = resultTreeChildren;
    }

    void close() {
        if (this.searchTypeList != null) {
            Iterator iterator = this.searchTypeList.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof FullTextType)) continue;
                ((FullTextType)((Object)e)).destroy();
            }
            this.searchTypeList.clear();
            this.searchTypeList = null;
        }
        this.searchGroup = null;
    }

    synchronized boolean objectFound(Object object) {
        if (!$assertionsDisabled && this.limitReached) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.observer == null) {
            throw new AssertionError();
        }
        int n = this.observer.objectFound(object);
        if (n == -1) {
            return false;
        }
        ++this.size;
        this.totalDetailsCount += n;
        this.limitReached = this.size >= 500 || this.totalDetailsCount >= 5000;
        return !this.limitReached;
    }

    int size() {
        return this.size;
    }

    SearchGroup getSearchGroup() {
        return this.searchGroup;
    }

    List getEnabledSearchTypes() {
        return this.searchTypeList;
    }

    SearchType[] getQueriedSearchTypes() {
        return this.searchGroup.getSearchTypes();
    }

    boolean wasLimitReached() {
        return this.limitReached;
    }

    void searchException(RuntimeException runtimeException) {
        ErrorManager.Annotation[] annotationArray = ErrorManager.getDefault().findAnnotations((Throwable)runtimeException);
        for (int i = 0; i < annotationArray.length; ++i) {
            ErrorManager.Annotation annotation = annotationArray[i];
            if (annotation.getSeverity() != 256) continue;
            this.finishMessage = annotation.getLocalizedMessage();
            if (this.finishMessage == null) continue;
            return;
        }
        this.finishMessage = runtimeException.getLocalizedMessage();
    }

    String getExceptionMsg() {
        return this.finishMessage;
    }

    static {
        $assertionsDisabled = !ResultModel.class.desiredAssertionStatus();
    }
}

