/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.Image;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.io.IOException;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.UIManager;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.ResultView;
import org.netbeans.modules.search.types.FullTextType;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.xml.XMLUtil;
import org.openidex.search.SearchGroup;
import org.openidex.search.SearchHistory;
import org.openidex.search.SearchPattern;
import org.openidex.search.SearchType;

final class ResultTreeChildren
extends Children.Keys
implements Runnable {
    private Set keys;
    private final Comparator comparator;
    private final ResultModel resultModel;
    private boolean sorted = false;
    private boolean hasDetails = false;
    private final int BATCH_LEVEL = 61;
    private final int BATCH_INTERVAL_MS = 759;
    private volatile RequestProcessor.Task batchSetKeys;
    private volatile boolean active = false;
    private int size = 0;
    private ResultView observer;
    static /* synthetic */ Class class$org$netbeans$modules$search$types$FullTextType;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$netbeans$modules$search$RemoveFromSearchAction;
    static /* synthetic */ Class class$org$openide$cookies$OpenCookie;

    public ResultTreeChildren(ResultModel resultModel) {
        this.resultModel = resultModel;
        this.resultModel.setObserver(this);
        this.keys = resultModel.getSearchGroup().getResultObjects();
        this.comparator = new ResultItemsComparator();
    }

    protected void addNotify() {
        this.setKeys(Collections.EMPTY_SET);
        this.active = true;
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Set set = ResultTreeChildren.this.keys;
                synchronized (set) {
                    ResultTreeChildren.this.setKeys(ResultTreeChildren.this.keys);
                }
            }
        });
    }

    protected void removeNotify() {
        this.active = false;
        this.setKeys(Collections.EMPTY_SET);
    }

    void clear() {
        Enumeration enumeration = this.nodes();
        while (enumeration.hasMoreElements()) {
            FoundNode foundNode = (FoundNode)enumeration.nextElement();
            foundNode.originalDataObject.removePropertyChangeListener((PropertyChangeListener)foundNode);
        }
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose() {
        Set set = this.keys;
        synchronized (set) {
            this.keys = Collections.EMPTY_SET;
        }
        this.removeNotify();
        this.resultModel.setObserver(null);
    }

    protected Node[] createNodes(Object object) {
        return new Node[]{this.createFoundNode(object)};
    }

    private FoundNode createFoundNode(Object object) {
        Object object2;
        Node node = this.resultModel.getSearchGroup().getNodeForFoundObject(object);
        if (this.getDetailsCount(object) != 0) {
            this.hasDetails = true;
            object2 = new DetailChildren(node);
        } else {
            object2 = Children.LEAF;
        }
        return new FoundNode(node, (Children)object2, object);
    }

    private int getDetailsCount(Object object) {
        SearchGroup searchGroup = this.resultModel.getSearchGroup();
        SearchType[] searchTypeArray = searchGroup.getSearchTypes();
        int n = 0;
        for (int i = 0; i < searchTypeArray.length; ++i) {
            SearchType searchType = searchTypeArray[i];
            if (searchType.getClass() == (class$org$netbeans$modules$search$types$FullTextType == null ? ResultTreeChildren.class$("org.netbeans.modules.search.types.FullTextType") : class$org$netbeans$modules$search$types$FullTextType)) {
                n += ((FullTextType)searchType).getDetailsCount(object);
                continue;
            }
            Node[] nodeArray = searchType.getDetails(object);
            n += nodeArray != null ? nodeArray.length : 0;
        }
        return n;
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    boolean hasDetails() {
        return this.hasDetails;
    }

    void setObserver(ResultView resultView) {
        this.observer = resultView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int objectFound(Object object) {
        boolean bl;
        if (!$assertionsDisabled && this.observer == null) {
            throw new AssertionError();
        }
        Set set = this.keys;
        synchronized (set) {
            bl = this.keys.add(object);
            if (bl) {
                ++this.size;
            }
        }
        if (bl) {
            int n = this.getDetailsCount(object);
            if (this.size < 61) {
                Set set2 = this.keys;
                synchronized (set2) {
                    this.setKeys(this.keys);
                }
            } else {
                this.batchSetKeys();
            }
            if (this.observer != null) {
                this.observer.objectFound(object);
            }
            return n;
        }
        return -1;
    }

    int getSize() {
        return this.size;
    }

    private void batchSetKeys() {
        if (this.batchSetKeys == null) {
            this.batchSetKeys = RequestProcessor.getDefault().post((Runnable)this, 759);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFoundObject(Object object) {
        boolean bl = false;
        Set set = this.keys;
        synchronized (set) {
            bl = this.keys.remove(object);
        }
        if (bl) {
            this.sort(this.sorted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(boolean bl) {
        AbstractSet abstractSet = bl ? new TreeSet(this.comparator) : new HashSet();
        Set set = this.keys;
        synchronized (set) {
            abstractSet.addAll(this.keys);
        }
        this.setKeys(abstractSet);
        this.sorted = bl;
    }

    public boolean isSorted() {
        return this.sorted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.batchSetKeys = null;
        Set set = this.keys;
        synchronized (set) {
            if (this.active) {
                this.setKeys(this.keys);
            }
        }
    }

    static {
        $assertionsDisabled = !ResultTreeChildren.class.desiredAssertionStatus();
    }

    final class ResultItemsComparator
    implements Comparator {
        private final SearchGroup searchGroup;

        ResultItemsComparator() {
            this.searchGroup = ResultTreeChildren.this.resultModel.getSearchGroup();
        }

        public int compare(Object object, Object object2) {
            Node node;
            if (object == object2) {
                return 0;
            }
            if (object == null) {
                return 1;
            }
            if (object2 == null) {
                return -1;
            }
            Node node2 = this.searchGroup.getNodeForFoundObject(object);
            if (node2 == (node = this.searchGroup.getNodeForFoundObject(object2))) {
                return 0;
            }
            if (node2 == null) {
                return 1;
            }
            if (node == null) {
                return -1;
            }
            int n = node2.getDisplayName().compareTo(node.getDisplayName());
            return n == 0 ? -1 : n;
        }
    }

    final class DetailChildren
    extends Children.Array {
        private final Node parent;

        DetailChildren(Node node) {
            this.parent = node;
        }

        protected void addNotify() {
            this.add(this.createNodes(this.parent));
        }

        protected void removeNotify() {
            this.remove(this.getNodes());
        }

        protected Node[] createNodes(Object object) {
            Node node = (Node)object;
            SearchType[] searchTypeArray = ResultTreeChildren.this.resultModel.getSearchGroup().getSearchTypes();
            ArrayList<Node> arrayList = new ArrayList<Node>(5);
            for (int i = 0; i < searchTypeArray.length; ++i) {
                SearchType searchType = searchTypeArray[i];
                Node[] nodeArray = searchType.getDetails(node);
                if (nodeArray == null || nodeArray.length <= 0) continue;
                for (int j = 0; j < nodeArray.length; ++j) {
                    Node node2 = nodeArray[j];
                    arrayList.add(node2);
                }
            }
            return arrayList.toArray(new Node[arrayList.size()]);
        }
    }

    final class FoundNode
    extends FilterNode
    implements PropertyChangeListener,
    OpenCookie {
        private DataObject originalDataObject;
        private Object foundObject;
        static final /* synthetic */ boolean $assertionsDisabled;

        FoundNode() {
            super(Node.EMPTY);
        }

        FoundNode(Node node, Children children, Object object) {
            super(node, children);
            this.foundObject = object;
            this.originalDataObject = (DataObject)this.getOriginal().getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = ResultTreeChildren.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            if (this.originalDataObject == null) {
                return;
            }
            this.originalDataObject.addPropertyChangeListener((PropertyChangeListener)this);
            FileObject fileObject = this.originalDataObject.getPrimaryFile().getParent();
            if (fileObject != null) {
                this.disableDelegation(56);
                this.setShortDescription("");
            }
        }

        public String getDisplayName() {
            FileObject fileObject = this.originalDataObject.getPrimaryFile().getParent();
            if (fileObject != null) {
                String string = fileObject.getPath();
                String string2 = this.getOriginal().getDisplayName();
                return string2 + " " + string;
            }
            return this.getOriginal().getDisplayName();
        }

        public String getHtmlDisplayName() {
            FileObject fileObject = this.originalDataObject.getPrimaryFile().getParent();
            if (fileObject != null) {
                String string = FileUtil.getFileDisplayName((FileObject)fileObject);
                String string2 = this.getOriginal().getDisplayName();
                try {
                    String string3 = UIManager.getDefaults().getColor("Tree.selectionBackground").equals(UIManager.getDefaults().getColor("controlShadow")) ? "Tree.selectionBorderColor" : "controlShadow";
                    return "<html>" + string2 + " <font color='!" + string3 + "'>" + XMLUtil.toElementContent((String)string);
                }
                catch (CharConversionException charConversionException) {
                    return null;
                }
            }
            return this.getOriginal().getHtmlDisplayName();
        }

        public Action[] getActions(boolean bl) {
            if (bl) {
                return super.getActions(bl);
            }
            ArrayList<Action> arrayList = new ArrayList<Action>(Arrays.asList(super.getActions(bl)));
            int n = arrayList.indexOf(SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = ResultTreeChildren.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)));
            SystemAction systemAction = SystemAction.get((Class)(class$org$netbeans$modules$search$RemoveFromSearchAction == null ? (class$org$netbeans$modules$search$RemoveFromSearchAction = ResultTreeChildren.class$("org.netbeans.modules.search.RemoveFromSearchAction")) : class$org$netbeans$modules$search$RemoveFromSearchAction));
            if (n != -1) {
                arrayList.add(n, (Action)systemAction);
            } else {
                arrayList.add(null);
                arrayList.add((Action)systemAction);
            }
            return arrayList.toArray(new Action[arrayList.size()]);
        }

        public void removeFromSearch() {
            if (this.originalDataObject != null) {
                this.originalDataObject.removePropertyChangeListener((PropertyChangeListener)this);
            }
            ResultTreeChildren.this.removeFoundObject(this.foundObject);
        }

        public void destroy() throws IOException {
            super.destroy();
            if (this.originalDataObject != null) {
                this.originalDataObject.removePropertyChangeListener((PropertyChangeListener)this);
            }
            ResultTreeChildren.this.removeFoundObject(this.foundObject);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("valid".equals(propertyChangeEvent.getPropertyName()) && !this.originalDataObject.isValid()) {
                if (this.originalDataObject != null) {
                    this.originalDataObject.removePropertyChangeListener((PropertyChangeListener)this);
                }
                ResultTreeChildren.this.removeFoundObject(this.foundObject);
            }
        }

        public Image getIcon(int n) {
            if (this.originalDataObject.getPrimaryFile().hasExt("java")) {
                try {
                    BeanInfo beanInfo = Utilities.getBeanInfo(this.originalDataObject.getLoader().getClass());
                    return beanInfo.getIcon(n);
                }
                catch (IntrospectionException introspectionException) {
                    return AbstractNode.EMPTY.getIcon(n);
                }
            }
            return super.getIcon(n);
        }

        public Image getOpenedIcon(int n) {
            if (this.originalDataObject.getPrimaryFile().hasExt("java")) {
                try {
                    BeanInfo beanInfo = Utilities.getBeanInfo(this.originalDataObject.getLoader().getClass());
                    return beanInfo.getIcon(n);
                }
                catch (IntrospectionException introspectionException) {
                    return AbstractNode.EMPTY.getIcon(n);
                }
            }
            return super.getOpenedIcon(n);
        }

        public Node.Cookie getCookie(Class clazz) {
            if ((class$org$openide$cookies$OpenCookie == null ? (class$org$openide$cookies$OpenCookie = ResultTreeChildren.class$("org.openide.cookies.OpenCookie")) : class$org$openide$cookies$OpenCookie).isAssignableFrom(clazz)) {
                return this;
            }
            return super.getCookie(clazz);
        }

        public void open() {
            OpenCookie openCookie;
            SearchType[] searchTypeArray = ResultTreeChildren.this.resultModel.getQueriedSearchTypes();
            for (int i = 0; i < searchTypeArray.length; ++i) {
                SearchType searchType = searchTypeArray[i];
                if (!$assertionsDisabled && !searchType.isValid()) {
                    throw new AssertionError();
                }
                if (!(searchType instanceof FullTextType)) continue;
                SearchPattern searchPattern = ((FullTextType)searchType).createSearchPattern();
                SearchHistory.getDefault().setLastSelected(searchPattern);
                break;
            }
            if ((openCookie = (OpenCookie)super.getCookie(class$org$openide$cookies$OpenCookie == null ? (class$org$openide$cookies$OpenCookie = ResultTreeChildren.class$("org.openide.cookies.OpenCookie")) : class$org$openide$cookies$OpenCookie)) != null) {
                openCookie.open();
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$search$ResultTreeChildren == null ? (class$org$netbeans$modules$search$ResultTreeChildren = ResultTreeChildren.class$("org.netbeans.modules.search.ResultTreeChildren")) : class$org$netbeans$modules$search$ResultTreeChildren).desiredAssertionStatus();
        }
    }
}

