/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.search.Manager;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.ResultTreeChildren;
import org.netbeans.modules.search.SearchPanel;
import org.netbeans.modules.search.SearchTask;
import org.netbeans.modules.search.Utils;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openidex.search.SearchType;

final class ResultView
extends TopComponent
implements ExplorerManager.Provider {
    private volatile boolean hasResults = false;
    private volatile boolean hasDetails = false;
    private volatile boolean searchInProgress = false;
    private static final String ID = "search-results";
    private static WeakReference instance;
    private final ExplorerManager explorerManager;
    private final BeanTreeView treeView;
    private ResultModel resultModel = null;
    private final RootNode root;
    private ResultTreeChildren children;
    private Node[] lastSearchNodes;
    private List lastEnabledSearchTypes;
    private MessageFormat nodeCountFormat;
    private final JButton btnModifySearch = new JButton();
    private final JButton btnShowDetails = new JButton();
    private final JButton btnStop = new JButton();
    private JPanel buttonsPanel;
    private JPanel mainPanel;
    private final JRadioButton sortButton = new JRadioButton();
    private final JRadioButton unsortButton = new JRadioButton();
    static final /* synthetic */ boolean $assertionsDisabled;

    static synchronized ResultView getInstance() {
        ResultView resultView = (ResultView)WindowManager.getDefault().findTopComponent(ID);
        if (resultView == null) {
            resultView = ResultView.getDefault();
        }
        return resultView;
    }

    public static synchronized ResultView getDefault() {
        ResultView resultView;
        if (instance == null) {
            resultView = new ResultView();
            instance = new WeakReference<ResultView>(resultView);
        } else {
            resultView = (ResultView)((Object)instance.get());
            if (resultView == null) {
                resultView = new ResultView();
                instance = new WeakReference<ResultView>(resultView);
            }
        }
        return resultView;
    }

    private ResultView() {
        this.initComponents();
        this.setName("Search Results");
        this.setDisplayName(NbBundle.getMessage((Class)ResultView.class, (String)"TITLE_SEARCH_RESULTS"));
        this.setToolTipText(NbBundle.getMessage((Class)ResultView.class, (String)"TOOLTIP_SEARCH_RESULTS"));
        this.setIcon(Utilities.loadImage((String)"org/netbeans/modules/search/res/find.gif"));
        this.mainPanel.setOpaque(true);
        this.buttonsPanel.add(Box.createHorizontalGlue(), 2);
        this.buttonsPanel.add(Box.createHorizontalStrut(5), 4);
        this.buttonsPanel.add(Box.createHorizontalStrut(5), 6);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.sortButton);
        buttonGroup.add(this.unsortButton);
        this.root = this.createTreeViewRoot();
        this.explorerManager = new ExplorerManager();
        this.explorerManager.setRootContext((Node)this.root);
        this.selectAndActivateNode((Node)this.root);
        this.explorerManager.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                    ResultView.this.nodeSelectionChanged();
                }
            }
        });
        this.setupActions();
        this.treeView = new BeanTreeView();
        this.treeView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ResultView.class, (String)"ACS_TREEVIEW"));
        this.treeView.setBorder(BorderFactory.createEmptyBorder());
        this.mainPanel.add((Component)this.treeView, "Center");
        ButtonListener buttonListener = new ButtonListener();
        this.sortButton.addActionListener(buttonListener);
        this.unsortButton.addActionListener(buttonListener);
        this.btnShowDetails.addActionListener(buttonListener);
        this.btnModifySearch.addActionListener(buttonListener);
        this.btnStop.addActionListener(buttonListener);
        this.initAccessibility();
    }

    private final RootNode createTreeViewRoot() {
        RootNode rootNode = new RootNode();
        rootNode.setName(this.getInitialRootNodeText());
        rootNode.setIconBase("org/netbeans/modules/search/res/find");
        return rootNode;
    }

    private String getInitialRootNodeText() {
        return NbBundle.getMessage((Class)ResultView.class, (String)"TEXT_Search_in_filesystems");
    }

    private void setupActions() {
        String string = "copy-to-clipboard";
        String string2 = "cut-to-clipboard";
        String string3 = "paste-from-clipboard";
        String string4 = "delete";
        ActionMap actionMap = this.getActionMap();
        actionMap.put(string, ExplorerUtils.actionCopy((ExplorerManager)this.explorerManager));
        actionMap.put(string2, ExplorerUtils.actionCut((ExplorerManager)this.explorerManager));
        actionMap.put(string3, ExplorerUtils.actionPaste((ExplorerManager)this.explorerManager));
        actionMap.put(string4, ExplorerUtils.actionDelete((ExplorerManager)this.explorerManager, (boolean)true));
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.explorerManager, (ActionMap)actionMap));
    }

    protected void componentActivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.explorerManager, (boolean)true);
        this.treeView.requestFocusInWindow();
    }

    protected void componentDeactivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.explorerManager, (boolean)false);
    }

    private final void selectAndActivateNode(Node node) {
        Node[] nodeArray = new Node[]{node};
        try {
            this.explorerManager.setSelectedNodes(nodeArray);
            this.setActivatedNodes(nodeArray);
        }
        catch (PropertyVetoException propertyVetoException) {
            ErrorManager.getDefault().notify(4096, (Throwable)propertyVetoException);
            nodeArray = new Node[]{};
            try {
                this.explorerManager.setSelectedNodes(nodeArray);
                this.setActivatedNodes(nodeArray);
            }
            catch (PropertyVetoException propertyVetoException2) {
                ErrorManager.getDefault().notify(4096, (Throwable)propertyVetoException2);
            }
        }
    }

    public int getPersistenceType() {
        return 0;
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    private Object readResolve() throws ObjectStreamException {
        return ResultView.getDefault();
    }

    private void initAccessibility() {
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)ResultView.class);
        this.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_ResultViewTopComponent"));
        this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_ResultViewTopComponent"));
        AccessibleContext accessibleContext = this.treeView.getHorizontalScrollBar().getAccessibleContext();
        accessibleContext.setAccessibleName(resourceBundle.getString("ACSN_HorizontalScrollbar"));
        accessibleContext = this.treeView.getVerticalScrollBar().getAccessibleContext();
        accessibleContext.setAccessibleName(resourceBundle.getString("ACSN_VerticalScrollbar"));
        accessibleContext = this.treeView.getAccessibleContext();
        accessibleContext.setAccessibleName(resourceBundle.getString("ACSN_ResultTree"));
        accessibleContext.setAccessibleDescription(resourceBundle.getString("ACSD_ResultTree"));
        this.sortButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_TEXT_BUTTON_SORT"));
        this.unsortButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_TEXT_BUTTON_UNSORT"));
        this.btnModifySearch.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_TEXT_BUTTON_CUSTOMIZE"));
        this.btnShowDetails.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_TEXT_BUTTON_FILL"));
        this.btnStop.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_TEXT_BUTTON_STOP"));
    }

    void closeResults() {
        this.close();
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.buttonsPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.setBorder(new EmptyBorder(new Insets(0, 0, 2, 0)));
        this.buttonsPanel.setLayout(new BoxLayout(this.buttonsPanel, 0));
        this.buttonsPanel.setBorder(new EmptyBorder(new Insets(5, 0, 0, 0)));
        Mnemonics.setLocalizedText((AbstractButton)this.sortButton, (String)NbBundle.getMessage((Class)ResultView.class, (String)"TEXT_BUTTON_SORT"));
        this.sortButton.setEnabled(false);
        this.buttonsPanel.add(this.sortButton);
        this.unsortButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.unsortButton, (String)NbBundle.getMessage((Class)ResultView.class, (String)"TEXT_BUTTON_UNSORT"));
        this.unsortButton.setEnabled(false);
        this.buttonsPanel.add(this.unsortButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnShowDetails, (String)NbBundle.getMessage((Class)ResultView.class, (String)"TEXT_BUTTON_FILL"));
        this.btnShowDetails.setEnabled(false);
        this.buttonsPanel.add(this.btnShowDetails);
        Mnemonics.setLocalizedText((AbstractButton)this.btnModifySearch, (String)NbBundle.getMessage((Class)ResultView.class, (String)"TEXT_BUTTON_CUSTOMIZE"));
        this.buttonsPanel.add(this.btnModifySearch);
        Mnemonics.setLocalizedText((AbstractButton)this.btnStop, (String)NbBundle.getMessage((Class)ResultView.class, (String)"TEXT_BUTTON_STOP"));
        this.btnStop.setEnabled(false);
        this.buttonsPanel.add(this.btnStop);
        this.mainPanel.add((Component)this.buttonsPanel, "South");
        this.add(this.mainPanel, "Center");
    }

    public void fillOutput() {
        this.btnShowDetails.setEnabled(false);
        Manager.getInstance().schedulePrintingDetails(this.children, this.resultModel.getSearchGroup());
    }

    protected void componentOpened() {
        Manager.getInstance().searchWindowOpened();
        this.root.setDisplayName(this.getInitialRootNodeText());
        this.explorerManager.setRootContext((Node)this.root);
        this.selectAndActivateNode((Node)this.root);
        if (this.lastSearchNodes == null) {
            this.btnModifySearch.setEnabled(false);
        }
    }

    protected void componentClosed() {
        this.rememberInput(null, null);
        Manager.getInstance().searchWindowClosed();
        Node node = Node.EMPTY;
        this.explorerManager.setRootContext(node);
        this.selectAndActivateNode(node);
    }

    void notifySearchPending(int n) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        String string = null;
        switch (n) {
            case 1: {
                string = "TEXT_FINISHING_PREV_SEARCH";
                break;
            }
            case 2: {
                string = "TEXT_CLEANING_RESULT";
                break;
            }
            case 4: {
                string = "TEXT_PRINTING_DETAILS";
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
        this.root.setDisplayName(NbBundle.getMessage((Class)ResultView.class, (String)string));
        this.btnStop.setEnabled(true);
        this.sortButton.setEnabled(false);
        this.unsortButton.setEnabled(false);
    }

    void searchTaskStateChanged(int n) {
        switch (n) {
            case 1: {
                this.searchStarted();
                break;
            }
            case 2: {
                this.searchFinished();
                break;
            }
            case 3: {
                this.searchInterrupted();
                break;
            }
            case 4: {
                this.searchCancelled();
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
    }

    void showAllDetailsFinished() {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        this.updateShowAllDetailsBtn();
    }

    private void searchStarted() {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        this.root.setDisplayName(NbBundle.getMessage((Class)ResultView.class, (String)"TEXT_SEARCHING___"));
        this.nodeCountFormat = new MessageFormat(NbBundle.getMessage((Class)ResultView.class, (String)"TXT_RootSearchedNodes"));
        this.searchInProgress = true;
        this.updateShowAllDetailsBtn();
        this.updateSortUnsortBtns();
        this.btnModifySearch.setEnabled(true);
        this.btnStop.setEnabled(true);
    }

    private void searchFinished() {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        this.setFinalRootNodeText();
        this.searchInProgress = false;
        this.hasDetails = this.children != null ? this.children.hasDetails() : false;
        this.updateShowAllDetailsBtn();
        this.updateSortUnsortBtns();
        this.btnStop.setEnabled(false);
    }

    private void searchInterrupted() {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        this.searchFinished();
    }

    private void searchCancelled() {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        this.root.setDisplayName(NbBundle.getMessage((Class)ResultView.class, (String)"TEXT_TASK_CANCELLED"));
        this.searchInProgress = true;
        this.updateShowAllDetailsBtn();
        this.updateSortUnsortBtns();
        this.btnStop.setEnabled(false);
    }

    private void setFinalRootNodeText() {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        int n = this.resultModel.size();
        if (this.resultModel.wasLimitReached()) {
            this.root.setDisplayName(NbBundle.getMessage((Class)ResultView.class, (String)"TEXT_MSG_FOUND_X_NODES_LIMIT", (Object)new Integer(n)));
            return;
        }
        String string = n == 0 ? NbBundle.getMessage((Class)ResultView.class, (String)"TEXT_MSG_NO_NODE_FOUND") : (n == 1 ? NbBundle.getMessage((Class)ResultView.class, (String)"TEXT_MSG_FOUND_A_NODE") : NbBundle.getMessage((Class)ResultView.class, (String)"TEXT_MSG_FOUND_X_NODES", (Object)new Integer(n)));
        String string2 = this.resultModel.getExceptionMsg();
        String string3 = string2 == null ? string : string + " (" + string2 + ")";
        this.root.setDisplayName(string3);
    }

    private void updateShowAllDetailsBtn() {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        this.btnShowDetails.setEnabled(this.hasResults && !this.searchInProgress && this.hasDetails);
    }

    private void updateSortUnsortBtns() {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        boolean bl = this.hasResults && !this.searchInProgress;
        this.sortButton.setEnabled(bl);
        this.unsortButton.setEnabled(bl);
    }

    void setResultModel(ResultModel resultModel) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if (this.resultModel == null && resultModel == null) {
            return;
        }
        if (this.resultModel != null) {
            if (this.children != null) {
                this.children.clear();
            }
            this.children = null;
        }
        this.resultModel = resultModel;
        if (resultModel != null) {
            this.children = new ResultTreeChildren(resultModel);
            this.setChildren((Children)this.children);
            this.hasResults = !this.children.isEmpty();
            this.hasDetails = this.hasResults && this.children.hasDetails();
            this.children.setObserver(this);
        } else {
            this.hasResults = false;
            this.hasDetails = false;
            this.setChildren(Children.LEAF);
        }
        this.selectAndActivateNode((Node)this.root);
        this.updateShowAllDetailsBtn();
        this.updateSortUnsortBtns();
        if (this.children != null) {
            if (this.children.isSorted()) {
                this.sortButton.setSelected(true);
            } else {
                this.unsortButton.setSelected(true);
            }
        }
    }

    public void objectFound(Object object) {
        this.hasResults = true;
        this.updateRootDisplayName();
    }

    private void updateRootDisplayName() {
        if (!$assertionsDisabled && EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        final String string = this.nodeCountFormat.format(new Object[]{new Integer(this.children.getSize())});
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    ResultView.this.root.setDisplayName(string);
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            ErrorManager.getDefault().notify((Throwable)invocationTargetException);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(65536, (Throwable)exception);
        }
    }

    private void setChildren(Children children) {
        this.root.changeChildren(children);
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    private void nodeSelectionChanged() {
        Node[] nodeArray = this.explorerManager.getSelectedNodes();
        this.setActivatedNodes(nodeArray);
    }

    void rememberInput(Node[] nodeArray, List list) {
        this.lastSearchNodes = nodeArray;
        this.lastEnabledSearchTypes = list;
    }

    private void customizeCriteria() {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.lastSearchNodes == null) {
            throw new AssertionError();
        }
        Node[] nodeArray = this.lastSearchNodes;
        List list = this.lastEnabledSearchTypes;
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        Object object = list.iterator();
        while (object.hasNext()) {
            arrayList.add(((SearchType)object.next()).clone());
        }
        this.lastEnabledSearchTypes = arrayList;
        object = new SearchPanel(arrayList, true);
        ((SearchPanel)object).showDialog();
        if (((SearchPanel)object).getReturnStatus() != 1) {
            return;
        }
        this.rememberInput(nodeArray, Utils.cloneSearchTypes(arrayList));
        Manager.getInstance().scheduleSearchTask(new SearchTask(nodeArray, arrayList, ((SearchPanel)object).getCustomizedSearchTypes()));
    }

    protected String preferredID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private void setNodesSorted(boolean bl) {
        if (!$assertionsDisabled && this.children == null) {
            throw new AssertionError();
        }
        Node[] nodeArray = this.explorerManager.getSelectedNodes();
        this.children.sort(bl);
        try {
            this.explorerManager.setSelectedNodes(nodeArray);
            this.setActivatedNodes(nodeArray);
        }
        catch (PropertyVetoException propertyVetoException) {
            ErrorManager.getDefault().notify(1, (Throwable)propertyVetoException);
            this.selectAndActivateNode((Node)this.root);
        }
    }

    static {
        $assertionsDisabled = !ResultView.class.desiredAssertionStatus();
        instance = null;
    }

    private class RootNode
    extends AbstractNode {
        RootNode() {
            super(Children.LEAF);
        }

        void changeChildren(Children children) {
            super.setChildren(children);
        }

        public Action[] getActions(boolean bl) {
            return new Action[0];
        }
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == ResultView.this.btnStop) {
                Manager.getInstance().stopSearching();
            } else if (object == ResultView.this.btnModifySearch) {
                ResultView.this.customizeCriteria();
            } else if (object == ResultView.this.btnShowDetails) {
                ResultView.this.fillOutput();
            } else if (object == ResultView.this.sortButton) {
                ResultView.this.setNodesSorted(true);
            } else if (object == ResultView.this.unsortButton) {
                ResultView.this.setNodesSorted(false);
            }
        }
    }

    public static final class ResolvableHelper
    implements Serializable {
        static final long serialVersionUID = 7398708142639457544L;

        public Object readResolve() {
            return ResultView.getDefault();
        }
    }
}

