/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.search.FindDialogMemory;
import org.netbeans.modules.search.SearchCriterion;
import org.netbeans.modules.search.SearchProjectSettings;
import org.netbeans.modules.search.SearchTypePanel;
import org.netbeans.modules.search.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openidex.search.SearchType;

public final class SearchPanel
extends JPanel
implements PropertyChangeListener,
FocusListener,
ChangeListener,
ActionListener {
    public static final String PROP_DIALOG_TITLE = "Find Files dialog title";
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private DialogDescriptor dialogDescriptor;
    private final JButton okButton;
    private final JButton cancelButton;
    private Dialog dialog;
    private int returnStatus = 0;
    private List orderedSearchTypePanels;
    private boolean customized;
    private JTabbedPane tabbedPane;

    public SearchPanel(List list) {
        this(list, false);
    }

    public SearchPanel(List list, boolean bl) {
        Object[] objectArray;
        this.orderedSearchTypePanels = new ArrayList(list.size());
        Object object = SearchProjectSettings.getInstance().getSearchCriteria();
        Map map = Utils.sortCriteriaBySearchType((SearchCriterion[])object);
        object = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SearchType searchType = (SearchType)iterator.next();
            objectArray = searchType.getClass().getName();
            if (object.contains(objectArray)) continue;
            object.add(objectArray);
            boolean bl2 = !bl && FindDialogMemory.getDefault().wasSearchTypeUsed(searchType.getClass().getName());
            SearchTypePanel searchTypePanel = new SearchTypePanel(searchType, bl2);
            Collection collection = map == null ? null : (Collection)map.get(objectArray);
            int n = this.orderedSearchTypePanels.indexOf(searchTypePanel);
            if (collection != null) {
                SearchTypePanel searchTypePanel2 = n == -1 ? searchTypePanel : (SearchTypePanel)this.orderedSearchTypePanels.get(n);
                searchTypePanel2.addSavedCriteria(Collections.unmodifiableCollection(collection));
            }
            if (n != -1) continue;
            this.orderedSearchTypePanels.add(searchTypePanel);
            searchTypePanel.addPropertyChangeListener(this);
        }
        this.initComponents();
        iterator = this.orderedSearchTypePanels.iterator();
        while (iterator.hasNext()) {
            this.tabbedPane.add((Component)iterator.next());
        }
        int n = 0;
        if (bl && (n = this.getIndexOfSearchType(FindDialogMemory.getDefault().getLastSearchType())) < 0) {
            n = 0;
        }
        this.tabbedPane.setSelectedIndex(n);
        this.setName(NbBundle.getBundle((Class)SearchPanel.class).getString("TEXT_TITLE_CUSTOMIZE"));
        this.okButton = new JButton(NbBundle.getBundle((Class)SearchPanel.class).getString("TEXT_BUTTON_SEARCH"));
        this.updateIsCustomized();
        this.cancelButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)NbBundle.getBundle((Class)SearchPanel.class).getString("TEXT_BUTTON_CANCEL"));
        objectArray = new Object[]{this.okButton, this.cancelButton};
        this.initAccessibility();
        this.dialogDescriptor = new DialogDescriptor((Object)this, this.getName(), true, objectArray, objectArray[0], 0, null, (ActionListener)this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.doClose(actionEvent.getSource() == this.okButton ? 1 : 0);
    }

    void setTitle(String string) {
        this.dialogDescriptor.setTitle(string);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)SearchPanel.class).getString("ACS_SearchPanel"));
        this.tabbedPane.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)SearchPanel.class).getString("ACSN_Tabs"));
        this.tabbedPane.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)SearchPanel.class).getString("ACSD_Tabs"));
        this.okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)SearchPanel.class).getString("ACS_TEXT_BUTTON_SEARCH"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)SearchPanel.class).getString("ACS_TEXT_BUTTON_CANCEL"));
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.tabbedPane, gridBagConstraints);
    }

    public boolean isCustomized() {
        return this.customized;
    }

    private List getOrderedSearchTypePanels() {
        return new ArrayList(this.orderedSearchTypePanels);
    }

    private String getTabText(int n) {
        try {
            return ((SearchTypePanel)this.getOrderedSearchTypePanels().get(n)).getName();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public SearchType[] getCustomizedSearchTypes() {
        ArrayList<SearchType> arrayList = new ArrayList<SearchType>(this.orderedSearchTypePanels.size());
        Iterator iterator = this.orderedSearchTypePanels.iterator();
        while (iterator.hasNext()) {
            SearchTypePanel searchTypePanel = (SearchTypePanel)iterator.next();
            if (!searchTypePanel.isCustomized()) continue;
            arrayList.add(searchTypePanel.getSearchType());
        }
        return arrayList.toArray(new SearchType[arrayList.size()]);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void doClose(int n) {
        int n2;
        Iterator iterator = this.orderedSearchTypePanels.iterator();
        while (iterator.hasNext()) {
            SearchTypePanel searchTypePanel = (SearchTypePanel)iterator.next();
            searchTypePanel.removePropertyChangeListener(this);
        }
        if (n == 1) {
            FindDialogMemory.getDefault().clearSearchTypesUsed();
        }
        if ((n2 = this.tabbedPane.getSelectedIndex()) >= 0) {
            SearchTypePanel searchTypePanel = this.getSearchTypePanel(n2);
            if (n == 1) {
                FindDialogMemory.getDefault().setLastUsedSearchType(searchTypePanel.getSearchType());
                searchTypePanel.onOk();
            } else {
                searchTypePanel.onCancel();
            }
        }
        this.returnStatus = n;
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    public void showDialog() {
        this.dialog = DialogDisplayer.getDefault().createDialog(this.dialogDescriptor);
        this.dialog.setModal(true);
        this.tabbedPane.addFocusListener(this);
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    public void focusGained(FocusEvent focusEvent) {
        SearchTypePanel searchTypePanel;
        this.tabbedPane.removeFocusListener(this);
        int n = this.tabbedPane.getSelectedIndex();
        if (n >= 0 && (searchTypePanel = this.getSearchTypePanel(n)) != null && searchTypePanel.customizerComponent != null) {
            searchTypePanel.customizerComponent.requestFocus();
        }
        this.tabbedPane.addChangeListener(this);
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
        SearchTypePanel searchTypePanel;
        int n = this.tabbedPane.getSelectedIndex();
        if (n >= 0 && (searchTypePanel = this.getSearchTypePanel(n)) != null) {
            searchTypePanel.initializeWithObject();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("customized".equals(propertyChangeEvent.getPropertyName())) {
            this.updateIsCustomized();
        }
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            this.tabbedPane.setTitleAt(i, this.getTabText(i));
            this.tabbedPane.setIconAt(i, null);
        }
    }

    private void updateIsCustomized() {
        this.customized = this.getCustomizedSearchTypes().length != 0;
        this.okButton.setEnabled(this.isCustomized());
    }

    private SearchTypePanel getSearchTypePanel(int n) {
        SearchTypePanel searchTypePanel = null;
        Iterator iterator = this.getOrderedSearchTypePanels().iterator();
        while (n >= 0 && iterator.hasNext()) {
            searchTypePanel = (SearchTypePanel)iterator.next();
            --n;
        }
        return searchTypePanel;
    }

    private int getIndexOfSearchType(SearchType searchType) {
        if (searchType == null) {
            return -1;
        }
        SearchTypePanel searchTypePanel = null;
        Iterator iterator = this.getOrderedSearchTypePanels().iterator();
        int n = -1;
        while (iterator.hasNext()) {
            ++n;
            searchTypePanel = (SearchTypePanel)iterator.next();
            if (searchTypePanel.getSearchType().getClass() != searchType.getClass()) continue;
            return n;
        }
        return -1;
    }
}

