/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.search.Manager;
import org.netbeans.modules.search.ResultView;
import org.netbeans.modules.search.SearchPanel;
import org.netbeans.modules.search.SearchTask;
import org.netbeans.modules.search.Utils;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openidex.search.SearchInfo;
import org.openidex.search.SearchType;

public final class SearchPerformer
extends NodeAction {
    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return NbBundle.getMessage((Class)SearchPerformer.class, (String)"TEXT_FIND_ACTION_IMPL_NAME");
    }

    static List getTypes(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length == 0) {
            return Collections.EMPTY_LIST;
        }
        Iterator iterator = Utils.getSearchTypes().iterator();
        if (!iterator.hasNext()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<SearchType> arrayList = new ArrayList<SearchType>(5);
        do {
            SearchType searchType;
            if (!(searchType = (SearchType)iterator.next()).enabled(nodeArray) || arrayList.contains(searchType)) continue;
            arrayList.add(searchType);
        } while (iterator.hasNext());
        return arrayList;
    }

    public boolean enable(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length == 0) {
            return false;
        }
        for (int i = 0; i < nodeArray.length; ++i) {
            if (SearchPerformer.canSearch(nodeArray[i])) continue;
            return false;
        }
        Iterator iterator = Utils.getSearchTypes().iterator();
        while (iterator.hasNext()) {
            SearchType searchType = (SearchType)iterator.next();
            if (!searchType.enabled(nodeArray)) continue;
            return true;
        }
        return false;
    }

    private static boolean canSearch(Node node) {
        Lookup lookup = node.getLookup();
        SearchInfo searchInfo = (SearchInfo)lookup.lookup(SearchInfo.class);
        if (searchInfo != null) {
            return searchInfo.canSearch();
        }
        return lookup.lookup(DataObject.Container.class) != null;
    }

    protected boolean asynchronous() {
        return false;
    }

    public void performAction(Node[] nodeArray) {
        Object object;
        List list = SearchPerformer.getTypes(nodeArray);
        if (list.isEmpty()) {
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            arrayList.add(((SearchType)object2.next()).clone());
        }
        object2 = new SearchPanel(arrayList);
        if (nodeArray.length == 1 && (object = nodeArray[0].getValue("Find Files dialog title")) != null && object instanceof String) {
            ((SearchPanel)object2).setTitle((String)object);
        }
        ((SearchPanel)object2).showDialog();
        if (((SearchPanel)object2).getReturnStatus() != 1) {
            return;
        }
        object = ResultView.getInstance();
        ((ResultView)((Object)object)).rememberInput(nodeArray, Utils.cloneSearchTypes(arrayList));
        object.open();
        object.requestActive();
        Manager.getInstance().scheduleSearchTask(new SearchTask(nodeArray, arrayList, ((SearchPanel)object2).getCustomizedSearchTypes()));
    }
}

