/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.modules.search.SearchCriterion;
import org.openide.ErrorManager;
import org.openide.options.SystemOption;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openidex.search.SearchType;

public class SearchProjectSettings
extends SystemOption {
    private static final long serialVersionUID = 6955446757377175182L;
    public static final String PROP_CRITERIA = "search criteria";
    private static SearchCriterion[] searchCriteria;

    public String displayName() {
        return NbBundle.getBundle((Class)SearchProjectSettings.class).getString("TEXT_Search_settings");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(SearchProjectSettings.class);
    }

    private void importOldSettings() {
        ArrayList<SearchCriterion> arrayList = new ArrayList<SearchCriterion>();
        Collection collection = Lookup.getDefault().lookup(new Lookup.Template(SearchType.class)).allInstances();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            SearchType searchType = (SearchType)iterator.next();
            if (!searchType.isValid()) continue;
            try {
                arrayList.add(new SearchCriterion(searchType));
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(4096, (Throwable)iOException);
            }
        }
        if (arrayList.isEmpty()) {
            searchCriteria = new SearchCriterion[0];
        } else {
            searchCriteria = new SearchCriterion[arrayList.size()];
            arrayList.toArray(searchCriteria);
        }
    }

    public SearchCriterion[] getSearchCriteria() {
        if (searchCriteria == null) {
            this.importOldSettings();
        }
        return searchCriteria;
    }

    public void setSearchCriteria(SearchCriterion[] searchCriterionArray) {
        if (searchCriterionArray == null) {
            searchCriterionArray = new SearchCriterion[]{};
        }
        SearchCriterion[] searchCriterionArray2 = searchCriteria;
        searchCriteria = searchCriterionArray;
        this.firePropertyChange(PROP_CRITERIA, searchCriterionArray2, searchCriteria);
    }

    static final SearchProjectSettings getInstance() {
        return (SearchProjectSettings)SharedClassObject.findObject((Class)SearchProjectSettings.class, (boolean)true);
    }

    void addSearchCriterion(SearchCriterion searchCriterion) {
        if (searchCriteria == null) {
            searchCriteria = new SearchCriterion[1];
            SearchProjectSettings.searchCriteria[0] = searchCriterion;
            this.firePropertyChange(PROP_CRITERIA, null, searchCriteria);
        } else {
            SearchCriterion[] searchCriterionArray = searchCriteria;
            searchCriteria = new SearchCriterion[searchCriterionArray.length + 1];
            System.arraycopy(searchCriterionArray, 0, searchCriteria, 0, searchCriterionArray.length);
            SearchProjectSettings.searchCriteria[searchCriterionArray.length] = searchCriterion;
            this.firePropertyChange(PROP_CRITERIA, searchCriterionArray, searchCriteria);
        }
    }

    boolean replaceSearchCriterion(String string, String string2, SearchCriterion searchCriterion) {
        if (searchCriteria == null) {
            return false;
        }
        for (int i = 0; i < searchCriteria.length; ++i) {
            SearchCriterion searchCriterion2 = searchCriteria[i];
            if (!searchCriterion2.name.equals(string) || !searchCriterion2.searchTypeClassName.equals(string2)) continue;
            SearchProjectSettings.searchCriteria[i] = searchCriterion;
            this.markSearchCriteriaChanged();
            return true;
        }
        return false;
    }

    void markSearchCriteriaChanged() {
        this.firePropertyChange(PROP_CRITERIA, null, null);
    }
}

