/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Customizer;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.search.DialogLifetime;
import org.netbeans.modules.search.SearchCriterion;
import org.netbeans.modules.search.SearchProjectSettings;
import org.netbeans.modules.search.SearchTypeInputStream;
import org.netbeans.modules.search.types.FullTextCustomizer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openidex.search.SearchType;

public final class SearchTypePanel
extends JPanel
implements PropertyChangeListener,
ActionListener,
DialogLifetime {
    public static final String PROP_CUSTOMIZED = "customized";
    private static final String MODIFICATOR_SUFFIX = " *";
    private boolean customized;
    private SearchType searchType;
    private boolean initialized = false;
    final Customizer customizer;
    final Component customizerComponent;
    private SearchCriterion[] savedCriteria;
    private String lastSavedName;
    private final JCheckBox applyCheckBox = new JCheckBox();
    private JPanel customizerPanel;
    private final JButton restoreButton = new JButton();
    private final JButton saveButton = new JButton();
    static final /* synthetic */ boolean $assertionsDisabled;

    public SearchTypePanel(SearchType searchType, boolean bl) {
        this.initComponents();
        this.initAccessibility();
        this.searchType = searchType;
        this.customizer = SearchTypePanel.createCustomizer(this.searchType, bl);
        if (this.customizer != null) {
            this.customizerComponent = (Component)((Object)this.customizer);
        } else {
            this.customizerComponent = null;
            this.initialized = true;
            System.err.println("No customizer for " + this.searchType.getName() + ", skipping...");
        }
        this.customizer.setObject(this.searchType);
        if (bl && this.customizer instanceof FullTextCustomizer) {
            ((FullTextCustomizer)this.customizer).initFromHistory();
        }
        this.searchType.addPropertyChangeListener((PropertyChangeListener)this);
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)SearchTypePanel.class);
        Mnemonics.setLocalizedText((AbstractButton)this.applyCheckBox, (String)resourceBundle.getString("TEXT_BUTTON_APPLY"));
        Mnemonics.setLocalizedText((AbstractButton)this.saveButton, (String)resourceBundle.getString("TEXT_BUTTON_SAVE_AS"));
        this.saveButton.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.restoreButton, (String)resourceBundle.getString("TEXT_BUTTON_RESTORE"));
        this.restoreButton.setEnabled(false);
        this.customizerPanel.add(this.customizerComponent, "Center");
        this.setCustomized(this.searchType.isValid());
        this.setName(this.createName());
    }

    private void initAccessibility() {
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)SearchTypePanel.class);
        this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_DIALOG_DESC"));
        this.restoreButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_TEXT_BUTTON_RESTORE"));
        this.saveButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_TEXT_BUTTON_SAVE_AS"));
        this.applyCheckBox.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_TEXT_BUTTON_APPLY"));
    }

    private void initComponents() {
        this.customizerPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.customizerPanel.setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add((Component)this.customizerPanel, gridBagConstraints);
        this.applyCheckBox.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(17, 11, 0, 11);
        this.add((Component)this.applyCheckBox, gridBagConstraints);
        this.saveButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 11, 0);
        this.add((Component)this.saveButton, gridBagConstraints);
        this.restoreButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(11, 11, 11, 11);
        this.add((Component)this.restoreButton, gridBagConstraints);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.applyCheckBox) {
            boolean bl = this.applyCheckBox.isSelected();
            this.setCustomized(bl);
            this.searchType.setValid(bl);
        } else if (object == this.saveButton) {
            this.saveCriterion();
        } else if (object == this.restoreButton) {
            this.restoreCriterion();
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.searchType && "valid".equals(propertyChangeEvent.getPropertyName())) {
            if (propertyChangeEvent.getNewValue().equals(Boolean.FALSE)) {
                this.setCustomized(false);
                return;
            }
            this.setCustomized(true);
        }
    }

    public void onOk() {
        if (this.customizer instanceof DialogLifetime) {
            ((DialogLifetime)((Object)this.customizer)).onOk();
        }
    }

    public void onCancel() {
        if (this.customizer instanceof DialogLifetime) {
            ((DialogLifetime)((Object)this.customizer)).onCancel();
        }
    }

    private String createName() {
        String string = this.searchType.getName();
        if (this.customized) {
            return string + MODIFICATOR_SUFFIX;
        }
        return string;
    }

    private static Customizer createCustomizer(SearchType searchType, boolean bl) {
        Object object;
        Class<?> clazz = searchType.getClass();
        Class<?> clazz2 = null;
        if (SearchTypePanel.isDefaultSearchType(clazz)) {
            object = searchType.getClass().getName();
            if (!$assertionsDisabled && !((String)object).endsWith("Type")) {
                throw new AssertionError();
            }
            int n = ((String)object).length();
            String string = new StringBuffer(n + 6).append(((String)object).substring(0, n - 4)).append("Customizer").toString();
            try {
                clazz2 = Class.forName(string);
            }
            catch (Exception exception) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                ErrorManager.getDefault().notify(65536, (Throwable)exception);
            }
        }
        if (clazz2 == null) {
            try {
                object = Utilities.getBeanInfo(clazz);
            }
            catch (IntrospectionException introspectionException) {
                ErrorManager.getDefault().notify(1, (Throwable)introspectionException);
                return null;
            }
            clazz2 = object.getBeanDescriptor().getCustomizerClass();
        }
        if (clazz2 == null) {
            return null;
        }
        try {
            object = clazz2.newInstance();
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        if (!(object instanceof Component) || !(object instanceof Customizer)) {
            return null;
        }
        return (Customizer)object;
    }

    private static boolean isDefaultSearchType(Class clazz) {
        if (!$assertionsDisabled && !SearchType.class.isAssignableFrom(clazz)) {
            throw new AssertionError();
        }
        String string = "org.netbeans.modules.search.types";
        String string2 = clazz.getName();
        return string2.startsWith(string) && string2.lastIndexOf(46) == string.length();
    }

    private void setCustomized(boolean bl) {
        this.customized = bl;
        this.saveButton.setEnabled(this.customized);
        this.applyCheckBox.setSelected(this.customized);
        this.setName(this.createName());
        this.firePropertyChange(PROP_CUSTOMIZED, !bl, bl);
    }

    public boolean isCustomized() {
        return this.customized;
    }

    private void saveCriterion() {
        String string;
        block2: {
            block1: {
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout(12, 0));
                ResourceBundle resourceBundle = NbBundle.getBundle((Class)SearchTypePanel.class);
                JLabel jLabel = new JLabel();
                Mnemonics.setLocalizedText((JLabel)jLabel, (String)resourceBundle.getString("TEXT_LABEL_NAME"));
                jPanel.add((Component)jLabel, "West");
                jPanel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_SaveAsPanel"));
                JTextField jTextField = this.lastSavedName != null ? new JTextField(this.lastSavedName, 20) : new JTextField(20);
                jTextField.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_TEXT_LABEL_SELECT"));
                jLabel.setLabelFor(jTextField);
                jPanel.add((Component)jTextField, "Center");
                jPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 11));
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jPanel, resourceBundle.getString("TEXT_LABEL_SAVE_CRITERION"));
                Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                do {
                    dialog.setVisible(true);
                    if (!dialogDescriptor.getValue().equals(DialogDescriptor.OK_OPTION)) break block1;
                } while ((string = jTextField.getText()).length() <= 0);
                break block2;
            }
            return;
        }
        this.saveCriterion(string);
        this.lastSavedName = string;
    }

    private void saveCriterion(String string) {
        SearchCriterion searchCriterion;
        SearchType searchType = (SearchType)this.searchType.clone();
        searchType.setName(string);
        try {
            searchCriterion = new SearchCriterion(searchType);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(4096, (Throwable)iOException);
            return;
        }
        String string2 = searchCriterion.searchTypeClassName;
        boolean bl = false;
        if (this.savedCriteria != null) {
            for (int i = 0; i < this.savedCriteria.length; ++i) {
                if (!this.savedCriteria[i].name.equals(string) || !this.savedCriteria[i].searchTypeClassName.equals(string2)) continue;
                bl = true;
                SearchProjectSettings.getInstance().replaceSearchCriterion(string, string2, searchCriterion);
                this.savedCriteria[i] = searchCriterion;
                break;
            }
        }
        if (!bl) {
            SearchProjectSettings.getInstance().addSearchCriterion(searchCriterion);
            this.addSavedCriteria(Collections.singleton(searchCriterion));
        }
    }

    private void restoreCriterion() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)SearchTypePanel.class);
        jPanel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_RestorePanel"));
        JLabel jLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)resourceBundle.getString("TEXT_LABEL_SELECT"));
        JComboBox<SearchCriterion> jComboBox = new JComboBox<SearchCriterion>(this.savedCriteria);
        jComboBox.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_SELECT_CRITERION"));
        jLabel.setLabelFor(jComboBox);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add(jComboBox, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 11));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jPanel, resourceBundle.getString("TEXT_LABEL_RESTORE_CRITERION"));
        DialogDisplayer.getDefault().createDialog(dialogDescriptor).setVisible(true);
        if (dialogDescriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
            SearchCriterion searchCriterion = (SearchCriterion)jComboBox.getSelectedItem();
            this.restoreCriterion(searchCriterion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void restoreCriterion(SearchCriterion var1_1) {
        block11: {
            var3_2 = null;
            try {
                var3_2 = new SearchTypeInputStream(new ByteArrayInputStream(var1_1.criterionData));
                var2_3 = (SearchType)var3_2.readObject();
                var7_4 = null;
                ** if (var3_2 == null) goto lbl-1000
            }
            catch (Throwable var6_12) {
                var7_6 = null;
                if (var3_2 != null) {
                    try {
                        var3_2.close();
                    }
                    catch (IOException var8_9) {
                        // empty catch block
                    }
                }
                throw var6_12;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var3_2.close();
                }
                catch (IOException var8_7) {}
            }
lbl-1000:
            // 2 sources

            {
                break block11;
                catch (Exception var4_10) {
                    var5_11 = NbBundle.getMessage((Class)SearchTypePanel.class, (String)"TEXT_MSG_Error_while_loading_criterion");
                    ErrorManager.getDefault().notify(4096, ErrorManager.getDefault().annotate((Throwable)var4_10, var5_11));
                    var7_5 = null;
                    if (var3_2 != null) {
                        try {
                            var3_2.close();
                        }
                        catch (IOException var8_8) {
                            // empty catch block
                        }
                    }
                    return;
                }
            }
        }
        this.restoreSearchType(var2_3);
    }

    private void restoreSearchType(SearchType searchType) {
        this.searchType.removePropertyChangeListener((PropertyChangeListener)this);
        this.searchType = (SearchType)searchType.clone();
        this.initialized = false;
        this.initializeWithObject();
        this.searchType.addPropertyChangeListener((PropertyChangeListener)this);
        this.setCustomized(true);
    }

    final void initializeWithObject() {
        if (!this.initialized) {
            this.customizer.setObject(this.searchType);
            this.initialized = true;
        }
    }

    public SearchType getSearchType() {
        return this.searchType;
    }

    public boolean equals(Object object) {
        try {
            return this.searchType.getClass().equals(((SearchTypePanel)object).getSearchType().getClass());
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public HelpCtx getHelpCtx() {
        return this.searchType.getHelpCtx();
    }

    void addSavedCriteria(Collection collection) {
        if (collection.isEmpty()) {
            return;
        }
        SearchCriterion[] searchCriterionArray = new SearchCriterion[collection.size()];
        collection.toArray(searchCriterionArray);
        if (this.savedCriteria == null) {
            this.savedCriteria = searchCriterionArray;
            this.restoreButton.setEnabled(true);
        } else {
            SearchCriterion[] searchCriterionArray2 = this.savedCriteria;
            this.savedCriteria = new SearchCriterion[searchCriterionArray2.length + searchCriterionArray.length];
            System.arraycopy(searchCriterionArray2, 0, this.savedCriteria, 0, searchCriterionArray2.length);
            System.arraycopy(searchCriterionArray, 0, this.savedCriteria, searchCriterionArray2.length, searchCriterionArray.length);
        }
    }

    static {
        $assertionsDisabled = !SearchTypePanel.class.desiredAssertionStatus();
    }
}

