/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.types;

import java.io.BufferedReader;
import java.io.CharConversionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.netbeans.modules.search.types.TextDetail;
import org.netbeans.modules.search.types.TextType;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.xml.XMLUtil;
import org.openidex.search.SearchPattern;

public class FullTextType
extends TextType {
    private static final long serialVersionUID = 1L;
    private static final Collection searchableXMimeTypes = new HashSet(17);
    private transient Map detailsMap;
    private static final int MAX_REPORTED_OCCURENCES_ON_LINE = 5;
    private static final int MAX_REPORTED_OCCURENCES_IN_FILE = 200;
    static /* synthetic */ Class class$org$netbeans$modules$search$types$FullTextType$GotoDetailAction;

    public Object clone() {
        FullTextType fullTextType = (FullTextType)((Object)super.clone());
        fullTextType.detailsMap = new HashMap(20);
        return fullTextType;
    }

    public void destroy() {
        if (this.detailsMap != null) {
            this.detailsMap.clear();
        }
    }

    protected String displayName() {
        return NbBundle.getMessage((Class)FullTextType.class, (String)"TEXT_FULLTEXT_CRITERION");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getDetailsMap() {
        if (this.detailsMap != null) {
            return this.detailsMap;
        }
        FullTextType fullTextType = this;
        synchronized (fullTextType) {
            if (this.detailsMap == null) {
                this.detailsMap = new HashMap(20);
            }
        }
        return this.detailsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean testDataObject(DataObject dataObject) {
        IOException iOException422;
        int n;
        BufferedReader bufferedReader;
        InputStream inputStream;
        block37: {
            ArrayList<TextDetail> arrayList;
            block34: {
                IOException iOException2222;
                block35: {
                    FileObject fileObject;
                    String string;
                    SearchPattern searchPattern;
                    block31: {
                        IOException iOException3222;
                        boolean bl;
                        block32: {
                            inputStream = null;
                            bufferedReader = null;
                            searchPattern = this.createSearchPattern();
                            string = "";
                            fileObject = dataObject.getPrimaryFile();
                            if (fileObject != null) break block31;
                            bl = false;
                            Object var16_13 = null;
                            if (bufferedReader == null) break block32;
                            try {
                                bufferedReader.close();
                                bufferedReader = null;
                                inputStream = null;
                            }
                            catch (IOException iOException3222) {
                                ErrorManager.getDefault().notify(1, (Throwable)iOException3222);
                            }
                        }
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                                inputStream = null;
                            }
                            catch (IOException iOException3222) {
                                ErrorManager.getDefault().notify(1, (Throwable)iOException3222);
                            }
                        }
                        return bl;
                    }
                    inputStream = fileObject.getInputStream();
                    bufferedReader = new LineNumberReader(new InputStreamReader(inputStream));
                    arrayList = new ArrayList<TextDetail>(5);
                    int n2 = 0;
                    while (n2 < 200 && (string = ((LineNumberReader)bufferedReader).readLine()) != null) {
                        int n3;
                        if (this.matchString != null) {
                            n = ((LineNumberReader)bufferedReader).getLineNumber();
                            int n4 = this.matchString.length();
                            String string2 = this.caseSensitive ? string : string.toUpperCase();
                            n3 = this.matchString(string2, 0);
                            int n5 = 0;
                            while (n3 >= 0 && n5 < 5) {
                                TextDetail textDetail = new TextDetail(dataObject, searchPattern);
                                textDetail.setLine(n);
                                textDetail.setColumn(n3 + 1);
                                textDetail.setLineText(string);
                                textDetail.setMarkLength(n4);
                                arrayList.add(textDetail);
                                n3 = this.matchString(string2, n3 + 1);
                                ++n5;
                                ++n2;
                            }
                            continue;
                        }
                        if (!this.matchRE(string)) continue;
                        TextDetail textDetail = new TextDetail(dataObject, searchPattern);
                        textDetail.setLine(((LineNumberReader)bufferedReader).getLineNumber());
                        textDetail.setLineText(string);
                        Matcher matcher = this.getMatcher();
                        int n6 = matcher.start();
                        n3 = matcher.end() - n6;
                        textDetail.setColumn(n6 + 1);
                        textDetail.setMarkLength(n3);
                        arrayList.add(textDetail);
                        ++n2;
                    }
                    if (!arrayList.isEmpty()) break block34;
                    n = 0;
                    Object var16_14 = null;
                    if (bufferedReader == null) break block35;
                    try {
                        bufferedReader.close();
                        bufferedReader = null;
                        inputStream = null;
                    }
                    catch (IOException iOException2222) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException2222);
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                        inputStream = null;
                    }
                    catch (IOException iOException2222) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException2222);
                    }
                }
                return n != 0;
            }
            arrayList.trimToSize();
            this.getDetailsMap().put(dataObject, arrayList);
            n = 1;
            Object var16_15 = null;
            if (bufferedReader == null) break block37;
            try {
                bufferedReader.close();
                bufferedReader = null;
                inputStream = null;
            }
            catch (IOException iOException422) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException422);
            }
        }
        if (inputStream != null) {
            try {
                inputStream.close();
                inputStream = null;
            }
            catch (IOException iOException422) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException422);
            }
        }
        return n != 0;
        catch (FileNotFoundException fileNotFoundException) {
            IOException iOException5222;
            boolean bl;
            block39: {
                bl = false;
                Object var16_16 = null;
                if (bufferedReader == null) break block39;
                try {
                    bufferedReader.close();
                    bufferedReader = null;
                    inputStream = null;
                }
                catch (IOException iOException5222) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException5222);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                    inputStream = null;
                }
                catch (IOException iOException5222) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException5222);
                }
            }
            return bl;
        }
        catch (IOException iOException6) {
            IOException iOException7222;
            boolean bl;
            block41: {
                ErrorManager.getDefault().notify(1, (Throwable)iOException6);
                bl = false;
                Object var16_17 = null;
                if (bufferedReader == null) break block41;
                {
                    catch (Throwable throwable) {
                        block43: {
                            IOException iOException8222;
                            Object var16_18 = null;
                            if (bufferedReader != null) {
                                try {
                                    bufferedReader.close();
                                    bufferedReader = null;
                                    inputStream = null;
                                }
                                catch (IOException iOException8222) {
                                    ErrorManager.getDefault().notify(1, (Throwable)iOException8222);
                                }
                            }
                            if (inputStream == null) break block43;
                            try {
                                inputStream.close();
                                inputStream = null;
                            }
                            catch (IOException iOException8222) {
                                ErrorManager.getDefault().notify(1, (Throwable)iOException8222);
                            }
                        }
                        throw throwable;
                    }
                }
                try {
                    bufferedReader.close();
                    bufferedReader = null;
                    inputStream = null;
                }
                catch (IOException iOException7222) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException7222);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                    inputStream = null;
                }
                catch (IOException iOException7222) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException7222);
                }
            }
            return bl;
        }
    }

    protected boolean acceptSearchObject(Object object) {
        DataObject dataObject = (DataObject)object;
        FileObject fileObject = dataObject.getPrimaryFile();
        String string = fileObject.getMIMEType();
        if (string.equals("content/unknown") || string.startsWith("text/")) {
            return true;
        }
        if (string.startsWith("application/")) {
            String string2 = string.substring(12);
            return string2.equals("rtf") || string2.equals("sgml") || string2.startsWith("xml-") || string2.endsWith("+xml") || string2.startsWith("x-") && searchableXMimeTypes.contains(string2.substring(2));
        }
        return false;
    }

    public Node[] getDetails(Object object) {
        List list = (List)this.getDetailsMap().get(object);
        if (list == null) {
            return null;
        }
        ArrayList<DetailNode> arrayList = new ArrayList<DetailNode>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TextDetail textDetail = (TextDetail)iterator.next();
            DetailNode detailNode = new DetailNode(textDetail);
            arrayList.add(detailNode);
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    public Node[] getDetails(Node node) {
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject == null) {
            return null;
        }
        return this.getDetails(dataObject);
    }

    public int getDetailsCount(Object object) {
        List list = (List)this.getDetailsMap().get(object);
        return list != null ? list.size() : 0;
    }

    public SearchPattern createSearchPattern() {
        return SearchPattern.create((String)(this.matchString != null ? this.matchString : this.reString), (boolean)this.wholeWords, (boolean)this.caseSensitive, (this.matchString == null ? 1 : 0) != 0);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(FullTextType.class);
    }

    static {
        searchableXMimeTypes.add("csh");
        searchableXMimeTypes.add("httpd-php");
        searchableXMimeTypes.add("httpd-php-source");
        searchableXMimeTypes.add("javascript");
        searchableXMimeTypes.add("latex");
        searchableXMimeTypes.add("php");
        searchableXMimeTypes.add("sh");
        searchableXMimeTypes.add("tcl");
        searchableXMimeTypes.add("tex");
        searchableXMimeTypes.add("texinfo");
        searchableXMimeTypes.add("troff");
    }

    private static class GotoDetailAction
    extends NodeAction {
        private GotoDetailAction() {
        }

        public String getName() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$search$types$FullTextType == null ? (class$org$netbeans$modules$search$types$FullTextType = FullTextType.class$("org.netbeans.modules.search.types.FullTextType")) : class$org$netbeans$modules$search$types$FullTextType)).getString("LBL_GotoDetailAction");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(class$org$netbeans$modules$search$types$FullTextType$GotoDetailAction == null ? (class$org$netbeans$modules$search$types$FullTextType$GotoDetailAction = FullTextType.class$("org.netbeans.modules.search.types.FullTextType$GotoDetailAction")) : class$org$netbeans$modules$search$types$FullTextType$GotoDetailAction);
        }

        protected boolean enable(Node[] nodeArray) {
            return nodeArray != null && nodeArray.length != 0 && nodeArray[0] instanceof DetailNode;
        }

        protected void performAction(Node[] nodeArray) {
            if (this.enable(nodeArray)) {
                ((DetailNode)nodeArray[0]).gotoDetail();
            }
        }

        protected boolean asynchronous() {
            return false;
        }
    }

    private static class DetailNode
    extends AbstractNode
    implements OutputListener {
        private TextDetail txtDetail;

        public DetailNode(TextDetail textDetail) {
            super(Children.LEAF);
            this.txtDetail = textDetail;
            this.setDefaultAction(SystemAction.get((Class)(class$org$netbeans$modules$search$types$FullTextType$GotoDetailAction == null ? (class$org$netbeans$modules$search$types$FullTextType$GotoDetailAction = FullTextType.class$("org.netbeans.modules.search.types.FullTextType$GotoDetailAction")) : class$org$netbeans$modules$search$types$FullTextType$GotoDetailAction)));
            this.setShortDescription(DetailNode.getShortDesc(textDetail));
            this.setValue("output line", DetailNode.getFullDesc(textDetail));
        }

        protected SystemAction[] createActions() {
            return new SystemAction[]{SystemAction.get((Class)(class$org$netbeans$modules$search$types$FullTextType$GotoDetailAction == null ? (class$org$netbeans$modules$search$types$FullTextType$GotoDetailAction = FullTextType.class$("org.netbeans.modules.search.types.FullTextType$GotoDetailAction")) : class$org$netbeans$modules$search$types$FullTextType$GotoDetailAction))};
        }

        public String getName() {
            return this.txtDetail.getLineText() + "      [" + DetailNode.getName(this.txtDetail) + "]";
        }

        public String getHtmlDisplayName() {
            String string;
            if (this.txtDetail.getMarkLength() > 0 && this.txtDetail.getColumn() > 0) {
                try {
                    StringBuffer stringBuffer = new StringBuffer();
                    String string2 = this.txtDetail.getLineText();
                    int n = this.txtDetail.getColumn() - 1;
                    stringBuffer.append(XMLUtil.toElementContent((String)string2.substring(0, n)));
                    stringBuffer.append("<b>");
                    int n2 = n + this.txtDetail.getMarkLength();
                    stringBuffer.append(XMLUtil.toElementContent((String)string2.substring(n, n2)));
                    stringBuffer.append("</b>");
                    if (this.txtDetail.getLineText().length() > n2) {
                        stringBuffer.append(XMLUtil.toElementContent((String)string2.substring(n2)));
                    }
                    string = stringBuffer.toString();
                }
                catch (CharConversionException charConversionException) {
                    return null;
                }
            }
            try {
                string = XMLUtil.toElementContent((String)this.txtDetail.getLineText());
            }
            catch (CharConversionException charConversionException) {
                return null;
            }
            try {
                return string + "      <font color='!controlShadow'>[" + XMLUtil.toElementContent((String)DetailNode.getName(this.txtDetail)) + "]";
            }
            catch (CharConversionException charConversionException) {
                return null;
            }
        }

        private void gotoDetail() {
            this.txtDetail.showDetail(2);
        }

        private void showDetail() {
            this.txtDetail.showDetail(1);
        }

        public void outputLineSelected(OutputEvent outputEvent) {
            this.txtDetail.showDetail(1);
        }

        public void outputLineAction(OutputEvent outputEvent) {
            this.txtDetail.showDetail(2);
        }

        public void outputLineCleared(OutputEvent outputEvent) {
            this.txtDetail.showDetail(3);
        }

        private static String getName(TextDetail textDetail) {
            int n = textDetail.getLine();
            int n2 = textDetail.getColumn();
            if (n2 > 0) {
                return NbBundle.getMessage((Class)(class$org$netbeans$modules$search$types$FullTextType == null ? (class$org$netbeans$modules$search$types$FullTextType = FullTextType.class$("org.netbeans.modules.search.types.FullTextType")) : class$org$netbeans$modules$search$types$FullTextType), (String)"TEXT_DETAIL_FMT_NAME1", (Object)Integer.toString(n), (Object)Integer.toString(n2));
            }
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$search$types$FullTextType == null ? (class$org$netbeans$modules$search$types$FullTextType = FullTextType.class$("org.netbeans.modules.search.types.FullTextType")) : class$org$netbeans$modules$search$types$FullTextType), (String)"TEXT_DETAIL_FMT_NAME2", (Object)Integer.toString(n));
        }

        private static String getShortDesc(TextDetail textDetail) {
            int n = textDetail.getLine();
            int n2 = textDetail.getColumn();
            if (n2 > 0) {
                return NbBundle.getMessage((Class)(class$org$netbeans$modules$search$types$FullTextType == null ? (class$org$netbeans$modules$search$types$FullTextType = FullTextType.class$("org.netbeans.modules.search.types.FullTextType")) : class$org$netbeans$modules$search$types$FullTextType), (String)"TEXT_DETAIL_FMT_SHORT1", (Object[])new Object[]{Integer.toString(n), Integer.toString(n2)});
            }
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$search$types$FullTextType == null ? (class$org$netbeans$modules$search$types$FullTextType = FullTextType.class$("org.netbeans.modules.search.types.FullTextType")) : class$org$netbeans$modules$search$types$FullTextType), (String)"TEXT_DETAIL_FMT_SHORT2", (Object)Integer.toString(n));
        }

        private static String getFullDesc(TextDetail textDetail) {
            String string = textDetail.getDataObject().getPrimaryFile().getNameExt();
            String string2 = textDetail.getLineText();
            int n = textDetail.getLine();
            int n2 = textDetail.getColumn();
            if (n2 > 0) {
                return NbBundle.getMessage((Class)(class$org$netbeans$modules$search$types$FullTextType == null ? (class$org$netbeans$modules$search$types$FullTextType = FullTextType.class$("org.netbeans.modules.search.types.FullTextType")) : class$org$netbeans$modules$search$types$FullTextType), (String)"TEXT_DETAIL_FMT_FULL1", (Object[])new Object[]{string2, string, Integer.toString(n), Integer.toString(n2)});
            }
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$search$types$FullTextType == null ? (class$org$netbeans$modules$search$types$FullTextType = FullTextType.class$("org.netbeans.modules.search.types.FullTextType")) : class$org$netbeans$modules$search$types$FullTextType), (String)"TEXT_DETAIL_FMT_FULL2", (Object[])new Object[]{string2, string, Integer.toString(n)});
        }
    }
}

