/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.types;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.Customizer;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.search.DialogLifetime;
import org.netbeans.modules.search.FindDialogMemory;
import org.netbeans.modules.search.types.TextType;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openidex.search.SearchPattern;

public abstract class TextCustomizer
extends JPanel
implements Customizer,
DialogLifetime,
ItemListener,
KeyListener {
    private TextType peer;
    private final JCheckBox caseSensitiveCheckBox = new JCheckBox();
    private JPanel jPanel1;
    private final JCheckBox regexpCheckBox = new JCheckBox();
    private JComboBox substringComboBox;
    private final JCheckBox wholeWordsCheckBox = new JCheckBox();
    static final /* synthetic */ boolean $assertionsDisabled;

    public TextCustomizer() {
        this.initComponents();
        this.initAccessibility();
        this.initTextFieldListeners();
        TitledBorder titledBorder = new TitledBorder(this.getBorderLabel());
        titledBorder.setBorder(new CompoundBorder());
        this.setBorder(titledBorder);
        this.initHistory();
    }

    protected String getBorderLabel() {
        return null;
    }

    private void initAccessibility() {
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)TextCustomizer.class);
        this.substringComboBox.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_PROP_SUBSTRING"));
        this.substringComboBox.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_PROP_SUBSTRING"));
        this.caseSensitiveCheckBox.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_TEXT_LABEL_CASE_SENSITIVE"));
        this.wholeWordsCheckBox.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_TEXT_LABEL_WHOLE_WORDS"));
        this.regexpCheckBox.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_TEXT_LABEL_RE"));
    }

    private void initTextFieldListeners() {
        class TextChangeListener
        implements DocumentListener {
            private JTextField textField;

            TextChangeListener(JTextField jTextField) {
                this.textField = jTextField;
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.documentChanged();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.documentChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.documentChanged();
            }

            private void documentChanged() {
                TextCustomizer.this.stringChanged();
            }
        }
        ((JTextField)this.substringComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(new TextChangeListener((JTextField)this.substringComboBox.getEditor().getEditorComponent()));
    }

    private void initHistory() {
        List list = this.getSearchPatterns();
        if (!list.isEmpty()) {
            HashSet<String> hashSet = new HashSet<String>(list.size());
            Vector<String> vector = new Vector<String>(list.size());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = ((SearchPattern)iterator.next()).getSearchExpression();
                if (!hashSet.add(string)) continue;
                vector.add(string);
            }
            this.substringComboBox.setModel(new DefaultComboBoxModel(vector));
            this.substringComboBox.setSelectedIndex(-1);
        }
    }

    public void initFromHistory() {
        Object e = this.getSearchPatterns().get(0);
        if (e != null) {
            this.putCurrentSearchPattern((SearchPattern)e);
        }
    }

    private void initComponents() {
        this.substringComboBox = new JComboBox();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.substringComboBox.setEditable(true);
        this.substringComboBox.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.substringComboBox.setMinimumSize(null);
        this.substringComboBox.setOpaque(false);
        this.substringComboBox.setPreferredSize(null);
        this.substringComboBox.addItemListener(this);
        this.activateEnterKeyBypass();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 11);
        this.add((Component)this.substringComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.caseSensitiveCheckBox, (String)NbBundle.getMessage((Class)TextCustomizer.class, (String)"TEXT_LABEL_CASE_SENSITIVE"));
        this.caseSensitiveCheckBox.setBorder(null);
        this.caseSensitiveCheckBox.addItemListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 12, 0, 11);
        this.add((Component)this.caseSensitiveCheckBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.wholeWordsCheckBox, (String)NbBundle.getMessage((Class)TextCustomizer.class, (String)"TEXT_LABEL_WHOLE_WORDS"));
        this.wholeWordsCheckBox.setBorder(null);
        this.wholeWordsCheckBox.addItemListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 12, 0, 11);
        this.add((Component)this.wholeWordsCheckBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.regexpCheckBox, (String)NbBundle.getMessage((Class)TextCustomizer.class, (String)"TEXT_LABEL_RE"));
        this.regexpCheckBox.setBorder(null);
        this.regexpCheckBox.addItemListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 12, 0, 11);
        this.add((Component)this.regexpCheckBox, gridBagConstraints);
    }

    private void activateEnterKeyBypass() {
        Component component = this.substringComboBox.getEditor().getEditorComponent();
        if (!(component instanceof JTextField)) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return;
        }
        ((JTextField)component).addKeyListener(this);
    }

    public void keyPressed(KeyEvent keyEvent) {
        JButton jButton;
        JRootPane jRootPane;
        if (keyEvent.getKeyCode() == 10 && keyEvent.getModifiersEx() == 0 && (jRootPane = SwingUtilities.getRootPane(this)) != null && (jButton = jRootPane.getDefaultButton()) != null && jButton.isEnabled()) {
            keyEvent.consume();
            jButton.doClick();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private String getComboText() {
        return ((JTextField)this.substringComboBox.getEditor().getEditorComponent()).getText();
    }

    private void regexpChkBoxChanged() {
        this.enableUI();
        if (this.peer == null) {
            return;
        }
        String string = this.getComboText();
        if (string == null || string.length() == 0) {
            return;
        }
        if (!this.regexpCheckBox.isSelected()) {
            this.peer.setMatchString(string);
            this.substringComboBox.getEditor().getEditorComponent().setForeground(this.getForegroundColor());
        } else {
            try {
                this.peer.setRe(string);
                this.substringComboBox.getEditor().getEditorComponent().setForeground(this.getForegroundColor());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.substringComboBox.getEditor().getEditorComponent().setForeground(this.getErrorForegroundColor());
            }
        }
    }

    private void stringChanged() {
        if (this.peer == null) {
            return;
        }
        String string = this.getComboText();
        if (!this.regexpCheckBox.isSelected()) {
            this.peer.setMatchString(string);
            this.substringComboBox.getEditor().getEditorComponent().setForeground(this.getForegroundColor());
        } else {
            try {
                this.peer.setRe(string);
                this.substringComboBox.getEditor().getEditorComponent().setForeground(this.getForegroundColor());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.substringComboBox.getEditor().getEditorComponent().setForeground(this.getErrorForegroundColor());
            }
        }
    }

    public void setObject(Object object) {
        this.peer = (TextType)((Object)object);
        this.substringComboBox.setForeground(this.getForegroundColor());
        Boolean bl = null;
        String string = this.peer.getRe();
        if (string.length() != 0) {
            bl = Boolean.TRUE;
        } else {
            string = this.peer.getMatchString();
            if (string.length() != 0) {
                bl = Boolean.FALSE;
            } else {
                string = this.getComboText();
            }
        }
        if (bl != null) {
            this.substringComboBox.setSelectedItem(string);
            this.regexpCheckBox.setSelected(bl);
            this.caseSensitiveCheckBox.setSelected(this.peer.isCaseSensitive());
            this.wholeWordsCheckBox.setSelected(this.peer.getWholeWords());
        } else if (string != null && string.length() != 0) {
            this.stringChanged();
        }
        this.enableUI();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void requestFocus() {
        JTextField jTextField = (JTextField)this.substringComboBox.getEditor().getEditorComponent();
        int n = jTextField.getText().length();
        if (n > 0) {
            jTextField.setCaretPosition(0);
            jTextField.moveCaretPosition(n);
        }
        jTextField.requestFocus();
    }

    private Color findColor(String string, Color color) {
        Color color2 = UIManager.getDefaults().getColor(string);
        if (color2 != null) {
            return color2;
        }
        return color;
    }

    private Color getForegroundColor() {
        return this.findColor("TextField.foreground", Color.black);
    }

    private Color getErrorForegroundColor() {
        return this.findColor("TextField.errorForeground", Color.red);
    }

    private void enableUI() {
        boolean bl = this.regexpCheckBox.isSelected();
        this.regexpCheckBox.setEnabled(true);
        this.caseSensitiveCheckBox.setEnabled(!bl);
        this.wholeWordsCheckBox.setEnabled(!bl);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.substringComboBox) {
            this.stringChanged();
        } else if (object == this.wholeWordsCheckBox) {
            this.peer.setWholeWords(this.wholeWordsCheckBox.isSelected());
        } else if (object == this.caseSensitiveCheckBox) {
            this.peer.setCaseSensitive(this.caseSensitiveCheckBox.isSelected());
        } else if (object == this.regexpCheckBox) {
            this.regexpChkBoxChanged();
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    private SearchPattern getCurrentSearchPattern() {
        return SearchPattern.create((String)this.getComboText(), (boolean)this.wholeWordsCheckBox.isSelected(), (boolean)this.caseSensitiveCheckBox.isSelected(), (boolean)this.regexpCheckBox.isSelected());
    }

    private void putCurrentSearchPattern(SearchPattern searchPattern) {
        if (!$assertionsDisabled && searchPattern == null) {
            throw new AssertionError();
        }
        this.substringComboBox.setSelectedItem(searchPattern.getSearchExpression());
        this.wholeWordsCheckBox.setSelected(searchPattern.isWholeWords());
        this.caseSensitiveCheckBox.setSelected(searchPattern.isMatchCase());
        this.regexpCheckBox.setSelected(searchPattern.isRegExp());
        this.enableUI();
    }

    private void initCheckBoxes(SearchPattern searchPattern) {
        this.wholeWordsCheckBox.setSelected(searchPattern.isWholeWords());
        this.caseSensitiveCheckBox.setSelected(searchPattern.isMatchCase());
        this.regexpCheckBox.setSelected(searchPattern.isRegExp());
        this.enableUI();
    }

    protected abstract List getSearchPatterns();

    protected abstract void addSearchPattern(SearchPattern var1);

    public void onOk() {
        SearchPattern searchPattern = this.getCurrentSearchPattern();
        if (searchPattern != null) {
            this.addSearchPattern(searchPattern);
            String string = searchPattern.getSearchExpression();
            if (string != null && string.length() != 0) {
                FindDialogMemory.getDefault().setSearchTypeUsed(((Object)((Object)this.peer)).getClass().getName(), true);
            }
        }
    }

    public void onCancel() {
    }

    static {
        $assertionsDisabled = !TextCustomizer.class.desiredAssertionStatus();
    }
}

