/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.types;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.modules.search.types.DataObjectType;

public abstract class TextType
extends DataObjectType {
    private static final long serialVersionUID = 3L;
    private static final String WORD_SEPARATORS = " \t,;.:+-*/\\()[]{}<>=&|\"'`~!?@#%^\n\r";
    protected boolean caseSensitive;
    protected boolean wholeWords;
    protected transient String ciMatchString;
    protected String matchString;
    protected String reString;
    protected transient Pattern pattern;
    private transient Matcher matcher;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (!this.caseSensitive && this.matchString != null) {
            this.ciMatchString = this.matchString.toUpperCase();
        }
        if (this.reString != null) {
            this.setRe(this.reString);
        }
    }

    protected boolean match(String string) {
        if (this.matchString != null) {
            if (!this.caseSensitive) {
                string = string.toUpperCase();
            }
            return this.matchString(string, 0) >= 0;
        }
        return this.matchRE(string);
    }

    protected boolean matchRE(String string) {
        this.matcher = this.pattern.matcher(string);
        return this.matcher.find();
    }

    protected Matcher getMatcher() {
        return this.matcher;
    }

    protected int matchString(String string, int n) {
        int n2 = string.indexOf(this.caseSensitive ? this.matchString : this.ciMatchString, n);
        if (this.wholeWords && n2 >= 0) {
            if (n2 > 0 && WORD_SEPARATORS.indexOf(string.charAt(n2 - 1)) < 0) {
                n2 = -1;
            } else {
                int n3 = this.matchString.length();
                if (n2 + n3 < string.length() && WORD_SEPARATORS.indexOf(string.charAt(n2 + n3)) < 0) {
                    n2 = -1;
                }
            }
        }
        return n2;
    }

    public String getMatchString() {
        if (this.matchString == null) {
            return "";
        }
        return this.matchString;
    }

    public void setMatchString(String string) {
        if (string == null) {
            this.setValid(false);
            throw new IllegalArgumentException();
        }
        if (string.length() == 0) {
            string = null;
        } else if (!this.caseSensitive) {
            this.ciMatchString = string.toUpperCase();
        }
        this.matchString = string;
        this.pattern = null;
        this.reString = null;
        this.setValid(string != null);
    }

    public String getRe() {
        if (this.reString == null) {
            return "";
        }
        return this.reString;
    }

    public void setRe(String string) {
        this.setReImpl(string);
    }

    private void setReImpl(String string) {
        if (string == null) {
            this.setValid(false);
            throw new IllegalArgumentException();
        }
        if (string.length() == 0) {
            string = null;
        } else {
            try {
                this.pattern = Pattern.compile(string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.setValid(false);
                throw new IllegalArgumentException();
            }
        }
        this.reString = string;
        this.matchString = null;
        this.setValid(string != null);
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean bl) {
        if (bl == this.caseSensitive) {
            return;
        }
        this.caseSensitive = bl;
        if (this.matchString != null) {
            this.ciMatchString = bl ? null : this.matchString.toUpperCase();
        }
    }

    public boolean getWholeWords() {
        return this.wholeWords;
    }

    public void setWholeWords(boolean bl) {
        if (bl == this.wholeWords) {
            return;
        }
        this.wholeWords = bl;
    }
}

