/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.bluej.upgrade;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.netbeans.bluej.upgrade.AutoUpgradePanel;
import org.netbeans.bluej.upgrade.Copy;
import org.netbeans.bluej.upgrade.IncludeExclude;
import org.netbeans.bluej.util.Util;
import org.openide.ErrorManager;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.XMLFileSystem;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;
import org.xml.sax.SAXException;

public final class AutoUpgrade {
    private static final List VERSION_TO_CHECK = Collections.EMPTY_LIST;

    public static void main(String[] args) throws Exception {
        String[] version = new String[1];
        File sourceFolder = AutoUpgrade.checkPrevious(version);
        if (sourceFolder != null) {
            if (!AutoUpgrade.showUpgradeDialog(sourceFolder)) {
                throw new UserCancelException();
            }
            AutoUpgrade.doUpgrade(sourceFolder, version[0]);
        }
    }

    private static File checkPrevious(String[] version) {
        String userHome = System.getProperty("user.home");
        File sourceFolder = null;
        if (userHome != null) {
            File userHomeFile = new File(userHome);
            boolean exists = userHomeFile.isDirectory();
            Iterator it = VERSION_TO_CHECK.iterator();
            while (it.hasNext() && sourceFolder == null) {
                String ver = (String)it.next();
                sourceFolder = new File(userHomeFile.getAbsolutePath(), ver);
                if (sourceFolder.isDirectory()) {
                    version[0] = sourceFolder.getName();
                    break;
                }
                sourceFolder = null;
            }
            return sourceFolder;
        }
        return null;
    }

    private static boolean showUpgradeDialog(File source) {
        Util.setDefaultLookAndFeel();
        JOptionPane p = new JOptionPane(new AutoUpgradePanel(source.getAbsolutePath()), 3, 0);
        JDialog d = p.createDialog(null, NbBundle.getMessage((Class)AutoUpgrade.class, (String)"MSG_Confirmation_Title"));
        d.setModal(true);
        d.setVisible(true);
        return new Integer(0).equals(p.getValue());
    }

    static void doUpgrade(File source, String oldVersion) throws IOException, PropertyVetoException {
        Set includeExclude;
        File userdir = new File(System.getProperty("netbeans.user", ""));
        try {
            InputStreamReader r = new InputStreamReader(AutoUpgrade.class.getResourceAsStream("copy" + oldVersion), "utf-8");
            includeExclude = IncludeExclude.create(r);
            ((Reader)r).close();
        }
        catch (IOException ex) {
            IOException e = new IOException("Cannot import from version: " + oldVersion);
            e.initCause(ex);
            throw e;
        }
        ErrorManager.getDefault().log(256, "Import: Old version: " + oldVersion + ". Importing from " + source + " to " + userdir);
        File oldConfig = new File(source, "config");
        LocalFileSystem lfs = new LocalFileSystem();
        lfs.setRootDirectory(oldConfig);
        XMLFileSystem xmlfs = null;
        try {
            URL url = AutoUpgrade.class.getResource("layer" + oldVersion + ".xml");
            xmlfs = new XMLFileSystem(url);
        }
        catch (SAXException ex) {
            IOException e = new IOException("Cannot import from version: " + oldVersion);
            e.initCause(ex);
            throw e;
        }
        MultiFileSystem old = AutoUpgrade.createLayeredSystem(lfs, xmlfs);
        FileSystem mine = Repository.getDefault().getDefaultFileSystem();
        Copy.copyDeep(old.getRoot(), mine.getRoot(), includeExclude);
    }

    static MultiFileSystem createLayeredSystem(LocalFileSystem lfs, XMLFileSystem xmlfs) {
        MultiFileSystem old = new MultiFileSystem(new FileSystem[]{lfs, xmlfs}){
            {
                this.setPropagateMasks(true);
            }
        };
        return old;
    }
}

