/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Timer;
import org.netbeans.modules.form.FormCookie;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormNode;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponentCookie;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.actions.TestAction;
import org.openide.ErrorManager;
import org.openide.actions.PasteAction;
import org.openide.awt.UndoRedo;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.Utilities;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ClipboardEvent;
import org.openide.util.datatransfer.ClipboardListener;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;
import org.openide.util.datatransfer.PasteType;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ComponentInspector
extends TopComponent
implements ExplorerManager.Provider {
    private ExplorerManager explorerManager;
    private TestAction testAction = (TestAction)SystemAction.findObject((Class)TestAction.class, (boolean)true);
    private PasteAction pasteAction = (PasteAction)SystemAction.findObject((Class)PasteAction.class, (boolean)true);
    private CopyCutActionPerformer copyActionPerformer = new CopyCutActionPerformer(true);
    private CopyCutActionPerformer cutActionPerformer = new CopyCutActionPerformer(false);
    private DeleteActionPerformer deleteActionPerformer = new DeleteActionPerformer();
    private ClipboardListener clipboardListener;
    private FormEditor focusedForm;
    private EmptyInspectorNode emptyInspectorNode;
    private BeanTreeView treeView;
    private static final String EMPTY_INSPECTOR_ICON_BASE = "org/netbeans/modules/form/resources/emptyInspector";
    private static final String iconURL = "org/netbeans/modules/form/resources/inspector.png";
    private static ComponentInspector instance;
    static /* synthetic */ Class class$org$netbeans$modules$form$RADComponentCookie;
    static /* synthetic */ Class class$org$netbeans$modules$form$FormCookie;

    public static synchronized ComponentInspector getDefault() {
        if (instance == null) {
            instance = new ComponentInspector();
        }
        return instance;
    }

    public static synchronized ComponentInspector getInstance() {
        if (instance == null) {
            TopComponent topComponent = WindowManager.getDefault().findTopComponent("ComponentInspector");
            if (instance == null) {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Can not find ComponentInspector component for its ID. Returned " + topComponent));
                instance = new ComponentInspector();
            }
        }
        return instance;
    }

    public int getPersistenceType() {
        return 0;
    }

    private ComponentInspector() {
        this.explorerManager = new ExplorerManager();
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.explorerManager, (ActionMap)this.setupActionMap(this.getActionMap())));
        this.emptyInspectorNode = new EmptyInspectorNode();
        this.explorerManager.setRootContext((Node)this.emptyInspectorNode);
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)new NodeSelectionListener());
        this.setLayout(new BorderLayout());
        this.createComponents();
        this.setIcon(Utilities.loadImage((String)iconURL));
        this.setName(FormUtils.getBundleString("CTL_InspectorTitle"));
        this.setToolTipText(FormUtils.getBundleString("HINT_ComponentInspector"));
    }

    ActionMap setupActionMap(ActionMap actionMap) {
        actionMap.put("copy-to-clipboard", this.copyActionPerformer);
        actionMap.put("cut-to-clipboard", this.cutActionPerformer);
        actionMap.put("delete", this.deleteActionPerformer);
        return actionMap;
    }

    private void createComponents() {
        this.treeView = new BeanTreeView();
        this.treeView.setDragSource(true);
        this.treeView.setDropTarget(true);
        this.treeView.getAccessibleContext().setAccessibleName(FormUtils.getBundleString("ACS_ComponentTree"));
        this.treeView.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_ComponentTree"));
        this.add("Center", (Component)this.treeView);
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public UndoRedo getUndoRedo() {
        UndoRedo.Manager manager = this.focusedForm != null ? this.focusedForm.getFormUndoRedoManager() : null;
        return manager != null ? manager : super.getUndoRedo();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("gui.component-inspector");
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected void componentActivated() {
        this.attachActions();
    }

    protected void componentDeactivated() {
        this.detachActions();
    }

    synchronized void attachActions() {
        ExplorerUtils.activateActions((ExplorerManager)this.explorerManager, (boolean)true);
        this.updatePasteAction();
        Clipboard clipboard = this.getClipboard();
        if (clipboard instanceof ExClipboard) {
            ExClipboard exClipboard = (ExClipboard)clipboard;
            if (this.clipboardListener == null) {
                this.clipboardListener = new ClipboardChangesListener();
            }
            exClipboard.addClipboardListener(this.clipboardListener);
        }
    }

    synchronized void detachActions() {
        ExplorerUtils.activateActions((ExplorerManager)this.explorerManager, (boolean)false);
        Clipboard clipboard = this.getClipboard();
        if (clipboard instanceof ExClipboard) {
            ExClipboard exClipboard = (ExClipboard)clipboard;
            exClipboard.removeClipboardListener(this.clipboardListener);
        }
    }

    public void focusForm(FormEditor formEditor) {
        if (this.focusedForm != formEditor) {
            this.focusFormInAwtThread(formEditor, 0);
        }
    }

    public void focusForm(FormEditor formEditor, boolean bl) {
        if (this.focusedForm != formEditor) {
            this.focusFormInAwtThread(formEditor, bl ? 1 : -1);
        }
    }

    private void focusFormInAwtThread(final FormEditor formEditor, final int n) {
        if (EventQueue.isDispatchThread()) {
            this.focusFormImpl(formEditor, n);
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ComponentInspector.this.focusFormImpl(formEditor, n);
                }
            });
        }
    }

    private void focusFormImpl(FormEditor formEditor, int n) {
        this.focusedForm = formEditor;
        if (formEditor == null) {
            this.testAction.setFormModel(null);
            this.removeAll();
            this.createComponents();
            this.revalidate();
            this.getExplorerManager().setRootContext((Node)this.emptyInspectorNode);
        } else {
            Node[] nodeArray = FormEditor.getFormDesigner(formEditor.getFormModel()).getSelectedComponentNodes();
            this.testAction.setFormModel(formEditor.getFormModel());
            Node node = formEditor.getFormRootNode();
            if (node == null) {
                System.err.println("Warning: FormEditorSupport.getFormRootNode() returns null");
                this.getExplorerManager().setRootContext((Node)this.emptyInspectorNode);
            } else {
                this.getExplorerManager().setRootContext(node);
            }
            try {
                this.getExplorerManager().setSelectedNodes(nodeArray);
            }
            catch (PropertyVetoException propertyVetoException) {
                propertyVetoException.printStackTrace();
            }
        }
        if (n > 0) {
            this.open();
        } else if (n < 0) {
            this.close();
        }
    }

    public FormEditor getFocusedForm() {
        return this.focusedForm;
    }

    void setSelectedNodes(Node[] nodeArray, FormEditor formEditor) throws PropertyVetoException {
        if (formEditor == this.focusedForm) {
            this.getExplorerManager().setSelectedNodes(nodeArray);
        }
    }

    Node[] getSelectedNodes() {
        return this.getExplorerManager().getSelectedNodes();
    }

    private void updatePasteAction() {
        if (EventQueue.isDispatchThread()) {
            this.updatePasteActionInAwtThread();
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ComponentInspector.this.updatePasteActionInAwtThread();
                }
            });
        }
    }

    private void updatePasteActionInAwtThread() {
        Clipboard clipboard;
        Transferable transferable;
        Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
        if (nodeArray != null && nodeArray.length == 1 && (transferable = (clipboard = this.getClipboard()).getContents((Object)this)) != null) {
            Node node = nodeArray[0];
            PasteType[] pasteTypeArray = node.getPasteTypes(transferable);
            if (pasteTypeArray.length != 0) {
                this.pasteAction.setPasteTypes(pasteTypeArray);
                return;
            }
            boolean bl = false;
            try {
                bl = transferable.isDataFlavorSupported(ExTransferable.multiFlavor);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl) {
                try {
                    int n;
                    MultiTransferObject multiTransferObject = (MultiTransferObject)transferable.getTransferData(ExTransferable.multiFlavor);
                    int n2 = multiTransferObject.getCount();
                    Transferable[] transferableArray = new Transferable[n2];
                    PasteType[] pasteTypeArray2 = new PasteType[n2];
                    for (n = 0; n < n2; ++n) {
                        transferableArray[n] = multiTransferObject.getTransferableAt(n);
                        pasteTypeArray = node.getPasteTypes(transferableArray[n]);
                        if (pasteTypeArray.length == 0) break;
                        pasteTypeArray2[n] = pasteTypeArray[0];
                    }
                    if (n == n2) {
                        this.pasteAction.setPasteTypes(new PasteType[]{new MultiPasteType(transferableArray, pasteTypeArray2)});
                        return;
                    }
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify(1, (Throwable)exception);
                }
            }
        }
        this.pasteAction.setPasteTypes(null);
    }

    private Clipboard getClipboard() {
        Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(Clipboard.class);
        if (clipboard == null) {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return clipboard;
    }

    protected String preferredID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        return this.treeView.requestFocusInWindow();
    }

    public static final class ResolvableHelper
    implements Serializable {
        static final long serialVersionUID = 7424646018839457544L;

        public Object readResolve() {
            return ComponentInspector.getDefault();
        }
    }

    private static class EmptyInspectorNode
    extends AbstractNode {
        public EmptyInspectorNode() {
            super(Children.LEAF);
            this.setIconBase(ComponentInspector.EMPTY_INSPECTOR_ICON_BASE);
        }

        public boolean canRename() {
            return false;
        }
    }

    private class MultiPasteType
    extends PasteType
    implements Mutex.ExceptionAction {
        private Transferable[] transIn;
        private PasteType[] pasteTypes;

        MultiPasteType(Transferable[] transferableArray, PasteType[] pasteTypeArray) {
            this.transIn = transferableArray;
            this.pasteTypes = pasteTypeArray;
        }

        public Transferable paste() throws IOException {
            if (EventQueue.isDispatchThread()) {
                return this.doPaste();
            }
            try {
                return (Transferable)Mutex.EVENT.readAccess((Mutex.ExceptionAction)this);
            }
            catch (MutexException mutexException) {
                Exception exception = mutexException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                exception.printStackTrace();
                return ExTransferable.EMPTY;
            }
        }

        public Object run() throws Exception {
            return this.doPaste();
        }

        private Transferable doPaste() throws IOException {
            Transferable[] transferableArray = new Transferable[this.transIn.length];
            for (int i = 0; i < this.pasteTypes.length; ++i) {
                Transferable transferable = this.pasteTypes[i].paste();
                transferableArray[i] = transferable != null ? transferable : this.transIn[i];
            }
            return new ExTransferable.Multi(transferableArray);
        }
    }

    private class CopyCutActionPerformer
    extends AbstractAction
    implements ActionPerformer {
        private boolean copy;

        public CopyCutActionPerformer(boolean bl) {
            this.copy = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.performAction(null);
        }

        public void performAction(SystemAction systemAction) {
            Transferable[] transferableArray;
            Transferable transferable;
            Node[] nodeArray = ComponentInspector.this.getExplorerManager().getSelectedNodes();
            if (nodeArray == null || nodeArray.length == 0) {
                transferable = null;
            } else if (nodeArray.length == 1) {
                transferable = this.getTransferableOwner(nodeArray[0]);
            } else {
                transferableArray = new Transferable[nodeArray.length];
                for (int i = 0; i < nodeArray.length; ++i) {
                    transferableArray[i] = this.getTransferableOwner(nodeArray[i]);
                    if (transferableArray[i] != null) continue;
                    return;
                }
                transferable = new ExTransferable.Multi(transferableArray);
            }
            if (transferable != null) {
                transferableArray = ComponentInspector.this.getClipboard();
                transferableArray.setContents(transferable, new StringSelection(""));
            }
        }

        private Transferable getTransferableOwner(Node node) {
            try {
                return this.copy ? node.clipboardCopy() : node.clipboardCut();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
                return null;
            }
        }
    }

    private class DeleteActionPerformer
    extends AbstractAction
    implements ActionPerformer,
    Mutex.Action {
        private Node[] nodesToDestroy;

        private DeleteActionPerformer() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.performAction(null);
        }

        public void performAction(SystemAction systemAction) {
            Node[] nodeArray = ComponentInspector.this.getExplorerManager().getSelectedNodes();
            if (nodeArray == null || nodeArray.length == 0) {
                return;
            }
            for (int i = 0; i < nodeArray.length; ++i) {
                if (nodeArray[i].canDestroy()) continue;
                return;
            }
            try {
                ComponentInspector.this.getExplorerManager().setSelectedNodes(new Node[0]);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.nodesToDestroy = nodeArray;
            if (EventQueue.isDispatchThread()) {
                this.doDelete();
            } else {
                Mutex.EVENT.readAccess((Mutex.Action)this);
            }
        }

        public Object run() {
            this.doDelete();
            return null;
        }

        private void doDelete() {
            if (this.nodesToDestroy != null) {
                for (int i = 0; i < this.nodesToDestroy.length; ++i) {
                    try {
                        this.nodesToDestroy[i].destroy();
                        continue;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                this.nodesToDestroy = null;
            }
        }
    }

    private class ClipboardChangesListener
    implements ClipboardListener {
        private ClipboardChangesListener() {
        }

        public void clipboardChanged(ClipboardEvent clipboardEvent) {
            if (!clipboardEvent.isConsumed()) {
                ComponentInspector.this.updatePasteAction();
            }
        }
    }

    private class NodeSelectionListener
    implements PropertyChangeListener,
    ActionListener,
    Runnable {
        private Timer timer = new Timer(150, this);

        NodeSelectionListener() {
            this.timer.setCoalesce(true);
            this.timer.setRepeats(false);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            FormDesigner formDesigner;
            if (!"selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                return;
            }
            if (ComponentInspector.this.focusedForm == null || (formDesigner = ComponentInspector.this.focusedForm.getFormDesigner()) == null) {
                return;
            }
            Node[] nodeArray = ComponentInspector.this.getExplorerManager().getSelectedNodes();
            if (formDesigner.getDesignerMode() == 1) {
                if (nodeArray.length > 0) {
                    RADComponentCookie rADComponentCookie = (RADComponentCookie)nodeArray[0].getCookie(class$org$netbeans$modules$form$RADComponentCookie == null ? (class$org$netbeans$modules$form$RADComponentCookie = ComponentInspector.class$("org.netbeans.modules.form.RADComponentCookie")) : class$org$netbeans$modules$form$RADComponentCookie);
                    if (rADComponentCookie != null && rADComponentCookie.getRADComponent() == formDesigner.getConnectionSource() && nodeArray.length > 1) {
                        rADComponentCookie = (RADComponentCookie)nodeArray[nodeArray.length - 1].getCookie(class$org$netbeans$modules$form$RADComponentCookie == null ? (class$org$netbeans$modules$form$RADComponentCookie = ComponentInspector.class$("org.netbeans.modules.form.RADComponentCookie")) : class$org$netbeans$modules$form$RADComponentCookie);
                    }
                    if (rADComponentCookie != null) {
                        formDesigner.connectBean(rADComponentCookie.getRADComponent(), true);
                    }
                }
            } else if (propertyChangeEvent.getSource() == ComponentInspector.this.getExplorerManager()) {
                formDesigner.clearSelectionImpl();
                for (int i = 0; i < nodeArray.length; ++i) {
                    Node node;
                    FormCookie formCookie = (FormCookie)nodeArray[i].getCookie(class$org$netbeans$modules$form$FormCookie == null ? ComponentInspector.class$("org.netbeans.modules.form.FormCookie") : class$org$netbeans$modules$form$FormCookie);
                    if (formCookie == null || !((node = formCookie.getOriginalNode()) instanceof RADComponentNode)) continue;
                    formDesigner.addComponentToSelectionImpl(((RADComponentNode)node).getRADComponent());
                }
                formDesigner.repaintSelection();
            }
            for (int i = 0; i < nodeArray.length; ++i) {
                ((FormNode)nodeArray[i]).updateCookies();
            }
            this.timer.restart();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EventQueue.invokeLater(this);
        }

        public void run() {
            FormDesigner formDesigner;
            Node[] nodeArray = ComponentInspector.this.getExplorerManager().getSelectedNodes();
            ComponentInspector.this.setActivatedNodes(nodeArray);
            FormDesigner formDesigner2 = formDesigner = ComponentInspector.this.focusedForm != null ? ComponentInspector.this.focusedForm.getFormDesigner() : null;
            if (formDesigner != null) {
                formDesigner.setActivatedNodes(nodeArray);
            }
            ComponentInspector.this.updatePasteAction();
            this.timer.stop();
        }
    }
}

