/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.MenuComponent;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.OverlayLayout;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.undo.UndoableEdit;
import org.jdesktop.layout.Baseline;
import org.jdesktop.layout.LayoutStyle;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.ComponentInspector;
import org.netbeans.modules.form.ComponentLayer;
import org.netbeans.modules.form.Event;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormEditorSupport;
import org.netbeans.modules.form.FormLAF;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormModelEvent;
import org.netbeans.modules.form.FormModelListener;
import org.netbeans.modules.form.FormNode;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormToolBar;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.HandleLayer;
import org.netbeans.modules.form.InPlaceEditLayer;
import org.netbeans.modules.form.NonVisualTray;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.RADConnectionPropertyEditor;
import org.netbeans.modules.form.RADMenuComponent;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.RADVisualFormContainer;
import org.netbeans.modules.form.VisualReplicator;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutDesigner;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutdesign.VisualMapper;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.netbeans.modules.form.wizard.ConnectionWizard;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.FileSystemAction;
import org.openide.awt.UndoRedo;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;

public class FormDesigner
extends TopComponent
implements MultiViewElement {
    static final String PROP_DESIGNER_SIZE = "designerSize";
    private JLayeredPane layeredPane;
    private ComponentLayer componentLayer;
    private HandleLayer handleLayer;
    private NonVisualTray nonVisualTray;
    private FormToolBar formToolBar;
    private InPlaceEditLayer textEditLayer;
    private FormProperty editedProperty;
    private InPlaceEditLayer.FinishListener finnishListener;
    private FormModel formModel;
    private FormModelListener formModelListener;
    private RADVisualComponent topDesignComponent;
    private FormEditor formEditor;
    private List selectedComponents = new ArrayList();
    private List selectedLayoutComponents = new ArrayList();
    private VisualReplicator replicator;
    private LayoutDesigner layoutDesigner;
    private List designerActions;
    private List resizabilityActions;
    private JToggleButton[] resizabilityButtons;
    private int designerMode;
    static final int MODE_SELECT = 0;
    static final int MODE_CONNECT = 1;
    static final int MODE_ADD = 2;
    private boolean initialized = false;
    private boolean firstLayout;
    private RADComponent connectionSource;
    private RADComponent connectionTarget;
    MultiViewElementCallback multiViewObserver;
    private ExplorerManager explorerManager;
    private FormProxyLookup lookup;
    private static String iconURL = "org/netbeans/modules/form/resources/formDesigner.gif";
    private boolean hasPropertyChangeListener = false;
    static /* synthetic */ Class class$javax$swing$JComponent;
    static /* synthetic */ Class class$javax$swing$RootPaneContainer;
    static /* synthetic */ Class class$org$netbeans$modules$form$FormDesigner;
    static /* synthetic */ Class class$java$awt$Component;
    static /* synthetic */ Class class$org$openide$nodes$Node;

    FormDesigner(FormEditor formEditor) {
        this.setIcon(Utilities.loadImage((String)iconURL));
        this.setLayout(new BorderLayout());
        FormLoaderSettings formLoaderSettings = FormLoaderSettings.getInstance();
        Color color = formLoaderSettings.getFormDesignerBackgroundColor();
        Color color2 = formLoaderSettings.getFormDesignerBorderColor();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 12, 12));
        jPanel.setBackground(color);
        JLabel jLabel = new JLabel(FormUtils.getBundleString("LBL_FormLoading"));
        jLabel.setOpaque(true);
        jLabel.setPreferredSize(new Dimension(410, 310));
        jLabel.setHorizontalAlignment(0);
        jPanel.add(jLabel);
        jLabel.setBorder(new CompoundBorder(new LineBorder(color2, 5), new EmptyBorder(new Insets(6, 6, 6, 6))));
        this.add(jPanel, "Center");
        this.formEditor = formEditor;
        if (formEditor != null) {
            this.explorerManager = new ExplorerManager();
            ActionMap actionMap = ComponentInspector.getInstance().setupActionMap(this.getActionMap());
            FormDataObject formDataObject = formEditor.getFormDataObject();
            this.lookup = new FormProxyLookup(new Lookup[]{ExplorerUtils.createLookup((ExplorerManager)this.explorerManager, (ActionMap)actionMap), Lookups.fixed((Object[])new Object[]{formDataObject, PaletteUtils.getPalette()}), formDataObject.getNodeDelegate().getLookup()});
            this.associateLookup((Lookup)this.lookup);
            this.formToolBar = new FormToolBar(this);
        }
    }

    void initialize() {
        this.initialized = true;
        this.firstLayout = true;
        this.removeAll();
        this.componentLayer = new ComponentLayer();
        this.handleLayer = new HandleLayer(this);
        this.nonVisualTray = FormEditor.isNonVisualTrayEnabled() ? new NonVisualTray(this.formEditor.getFormModel()) : null;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.componentLayer, "Center");
        if (this.nonVisualTray != null) {
            jPanel.add((Component)this.nonVisualTray, "South");
        }
        this.layeredPane = new JLayeredPane(){

            protected void paintChildren(Graphics graphics) {
                FormDesigner.this.handleLayer.maskDraggingComponents();
                super.paintChildren(graphics);
            }
        };
        this.layeredPane.setLayout(new OverlayLayout(this.layeredPane));
        this.layeredPane.add((Component)jPanel, new Integer(1000));
        this.layeredPane.add((Component)this.handleLayer, new Integer(1001));
        JScrollPane jScrollPane = new JScrollPane(this.layeredPane);
        jScrollPane.setBorder(null);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(5);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(5);
        this.add(jScrollPane, "Center");
        this.explorerManager.setRootContext(this.formEditor.getFormRootNode());
        if (!this.hasPropertyChangeListener) {
            this.addPropertyChangeListener("activatedNodes", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    try {
                        Lookup[] lookupArray = FormDesigner.this.lookup.getSubLookups();
                        Node[] nodeArray = (Node[])propertyChangeEvent.getOldValue();
                        Node[] nodeArray2 = (Node[])propertyChangeEvent.getNewValue();
                        Lookup lookup = lookupArray[lookupArray.length - 1];
                        Node node = FormDesigner.this.formEditor.getFormDataObject().getNodeDelegate();
                        if (!(lookup instanceof NoNodeLookup) && nodeArray.length >= 1 && !nodeArray[0].equals((Object)node)) {
                            FormDesigner.this.switchLookup();
                        } else if (lookup instanceof NoNodeLookup && nodeArray2.length == 0) {
                            FormDesigner.this.switchLookup();
                        }
                        ArrayList<Node> arrayList = new ArrayList<Node>(nodeArray2.length);
                        arrayList.addAll(Arrays.asList(nodeArray2));
                        arrayList.remove(node);
                        FormDesigner.this.explorerManager.setSelectedNodes(arrayList.toArray(new Node[arrayList.size()]));
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        propertyVetoException.printStackTrace();
                    }
                }
            });
            this.hasPropertyChangeListener = true;
        }
        this.formModel = this.formEditor.getFormModel();
        if (this.formModelListener == null) {
            this.formModelListener = new FormListener();
        }
        this.formModel.addFormModelListener(this.formModelListener);
        this.replicator = new VisualReplicator(null, new Class[]{Window.class, Applet.class, MenuComponent.class}, 3);
        this.resetTopDesignComponent(false);
        this.handleLayer.setViewOnly(this.formModel.isReadOnly());
        if (this.formModel.getLayoutModel() != null) {
            this.layoutDesigner = new LayoutDesigner(this.formModel.getLayoutModel(), new LayoutMapper());
        }
        this.updateWholeDesigner();
        this.formEditor.reinstallListener();
    }

    void reset(FormEditor formEditor) {
        if (this.initialized) {
            this.clearSelection();
        }
        this.initialized = false;
        this.removeAll();
        this.componentLayer = null;
        this.handleLayer = null;
        this.nonVisualTray = null;
        this.layeredPane = null;
        if (this.textEditLayer != null) {
            if (this.textEditLayer.isVisible()) {
                this.textEditLayer.finishEditing(false);
            }
            this.textEditLayer.removeFinishListener(this.getFinnishListener());
            this.textEditLayer = null;
        }
        if (this.formModel != null) {
            if (this.formModelListener != null) {
                this.formModel.removeFormModelListener(this.formModelListener);
            }
            this.topDesignComponent = null;
            this.formModel = null;
        }
        this.replicator = null;
        this.layoutDesigner = null;
        this.connectionSource = null;
        this.connectionTarget = null;
        this.formEditor = formEditor;
    }

    private void switchLookup() {
        Lookup[] lookupArray = this.lookup.getSubLookups();
        Lookup lookup = this.formEditor.getFormDataObject().getNodeDelegate().getLookup();
        int n = lookupArray.length - 1;
        lookupArray[n] = lookupArray[n] instanceof NoNodeLookup ? lookup : new NoNodeLookup(lookup);
        this.lookup.setSubLookups(lookupArray);
    }

    FormModel getFormModel() {
        return this.formModel;
    }

    HandleLayer getHandleLayer() {
        return this.handleLayer;
    }

    ComponentLayer getComponentLayer() {
        return this.componentLayer;
    }

    NonVisualTray getNonVisualTray() {
        return this.nonVisualTray;
    }

    FormToolBar getFormToolBar() {
        return this.formToolBar;
    }

    public LayoutDesigner getLayoutDesigner() {
        return this.layoutDesigner;
    }

    FormEditor getFormEditor() {
        return this.formEditor;
    }

    public Action[] getActions() {
        Action[] actionArray = super.getActions();
        SystemAction systemAction = SystemAction.get((Class)FileSystemAction.class);
        if (!Arrays.asList(actionArray).contains(systemAction)) {
            Action[] actionArray2 = new Action[actionArray.length + 1];
            System.arraycopy(actionArray, 0, actionArray2, 0, actionArray.length);
            actionArray2[actionArray.length] = systemAction;
            actionArray = actionArray2;
        }
        return actionArray;
    }

    public Object getComponent(RADComponent rADComponent) {
        return this.replicator.getClonedComponent(rADComponent.getId());
    }

    public Object getComponent(String string) {
        return this.replicator.getClonedComponent(string);
    }

    public RADComponent getMetaComponent(Object object) {
        String string = this.replicator.getClonedComponentId(object);
        return string != null ? this.formModel.getMetaComponent(string) : null;
    }

    public RADVisualComponent getTopDesignComponent() {
        return this.topDesignComponent;
    }

    boolean isTopRADComponent() {
        RADComponent rADComponent = this.formModel.getTopRADComponent();
        return rADComponent != null && rADComponent == this.topDesignComponent;
    }

    public void setTopDesignComponent(RADVisualComponent rADVisualComponent, boolean bl) {
        this.highlightTopDesignComponentName(false);
        this.topDesignComponent = rADVisualComponent;
        this.highlightTopDesignComponentName(!this.isTopRADComponent());
        FormDataObject formDataObject = this.formEditor.getFormDataObject();
        if (formDataObject != null) {
            formDataObject.getFormEditorSupport().updateMVTCDisplayName();
        }
        if (bl) {
            this.setSelectedComponent(this.topDesignComponent);
            this.updateWholeDesigner();
        }
    }

    private void highlightTopDesignComponentName(boolean bl) {
        RADComponentNode rADComponentNode;
        if (this.topDesignComponent != null && (rADComponentNode = this.topDesignComponent.getNodeReference()) != null) {
            rADComponentNode.highlightDisplayName(bl);
        }
    }

    public void resetTopDesignComponent(boolean bl) {
        this.setTopDesignComponent(this.formModel.getTopRADComponent() instanceof RADVisualComponent ? (RADVisualComponent)this.formModel.getTopRADComponent() : null, bl);
    }

    public boolean isInDesignedTree(RADComponent rADComponent) {
        return this.topDesignComponent != null && (this.topDesignComponent == rADComponent || this.topDesignComponent.isParentComponent(rADComponent));
    }

    void updateWholeDesigner() {
        if (this.formModelListener != null) {
            this.formModelListener.formChanged(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateComponentLayer(boolean bl) {
        boolean bl2 = this.firstLayout;
        this.firstLayout = false;
        if (this.getLayoutDesigner() == null) {
            return;
        }
        this.componentLayer.revalidate();
        RepaintManager.currentManager(this.componentLayer).validateInvalidComponents();
        LayoutModel layoutModel = this.formModel.getLayoutModel();
        Object object = layoutModel.getChangeMark();
        UndoableEdit undoableEdit = layoutModel.getUndoableEdit();
        boolean bl3 = true;
        try {
            if (this.getLayoutDesigner().updateCurrentState() && bl) {
                this.formModel.fireFormChanged();
            }
            bl3 = false;
            Object var8_7 = null;
            if (!(bl2 && !bl3 || object.equals(layoutModel.getChangeMark()))) {
                this.formModel.addUndoableEdit(undoableEdit);
            }
            if (bl3) {
                this.formModel.forceUndoOfCompoundEdit();
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (!(bl2 && !bl3 || object.equals(layoutModel.getChangeMark()))) {
                this.formModel.addUndoableEdit(undoableEdit);
            }
            if (bl3) {
                this.formModel.forceUndoOfCompoundEdit();
            }
            throw throwable;
        }
        layoutModel.endUndoableEdit();
        this.updateResizabilityActions();
        this.componentLayer.repaint();
    }

    void updateContainerLayout(RADVisualContainer rADVisualContainer) {
        this.replicator.updateContainerLayout(rADVisualContainer);
        this.componentLayer.revalidate();
        this.componentLayer.repaint();
    }

    public static Container createFormView(final RADVisualComponent rADVisualComponent, final Class clazz) throws Exception {
        return (Container)FormLAF.executeWithLookAndFeel(new Mutex.ExceptionAction(){

            public Object run() throws Exception {
                VisualReplicator visualReplicator = new VisualReplicator(clazz, null, 0);
                visualReplicator.setTopMetaComponent(rADVisualComponent);
                return visualReplicator.createClone();
            }
        });
    }

    Container getTopVisualContainer() {
        RADVisualComponent rADVisualComponent = this.replicator.getTopMetaComponent();
        if (!(rADVisualComponent instanceof RADVisualContainer)) {
            return null;
        }
        return ((RADVisualContainer)rADVisualComponent).getContainerDelegate(this.replicator.getClonedComponent(rADVisualComponent));
    }

    Point pointFromComponentToHandleLayer(Point point, Component component) {
        Component component2;
        JLayeredPane jLayeredPane = this.layeredPane;
        for (component2 = component; component2 != jLayeredPane; component2 = component2.getParent()) {
            point.x += component2.getX();
            point.y += component2.getY();
        }
        for (component2 = this.handleLayer; component2 != jLayeredPane; component2 = component2.getParent()) {
            point.x -= component2.getX();
            point.y -= component2.getY();
        }
        return point;
    }

    Point pointFromHandleToComponentLayer(Point point, Component component) {
        Component component2;
        JLayeredPane jLayeredPane = this.layeredPane;
        for (component2 = this.handleLayer; component2 != jLayeredPane; component2 = component2.getParent()) {
            point.x += component2.getX();
            point.y += component2.getY();
        }
        for (component2 = component; component2 != jLayeredPane; component2 = component2.getParent()) {
            point.x -= component2.getX();
            point.y -= component2.getY();
        }
        return point;
    }

    boolean isCoordinatesRoot(Component component) {
        return this.layeredPane == component;
    }

    private Rectangle componentBoundsToTop(Component component) {
        Serializable serializable;
        if (component == null) {
            return null;
        }
        Container container = this.getTopVisualContainer();
        int n = 0;
        int n2 = 0;
        if (component != container) {
            for (serializable = component.getParent(); serializable != container && serializable != null; serializable = ((Component)serializable).getParent()) {
                n += ((Component)serializable).getX();
                n2 += ((Component)serializable).getY();
            }
        } else {
            n = -container.getX();
            n2 = -container.getY();
        }
        serializable = component.getBounds();
        ((Rectangle)serializable).x += n;
        ((Rectangle)serializable).y += n2;
        return serializable;
    }

    void setDesignerMode(int n) {
        this.formToolBar.updateDesignerMode(n);
        if (n == this.designerMode) {
            return;
        }
        this.designerMode = n;
        this.resetConnection();
        if (n == 1) {
            this.clearSelection();
        }
        this.handleLayer.endDragging(null);
        this.updateResizabilityActions();
    }

    int getDesignerMode() {
        return this.designerMode;
    }

    void toggleSelectionMode() {
        this.setDesignerMode(0);
        PaletteUtils.clearPaletteSelection();
    }

    void toggleConnectionMode() {
        this.setDesignerMode(1);
        PaletteUtils.clearPaletteSelection();
    }

    void toggleAddMode() {
        this.setDesignerMode(2);
        PaletteUtils.clearPaletteSelection();
    }

    Dimension getDesignerSize() {
        return this.componentLayer.getDesignerSize();
    }

    void setDesignerSize(Dimension dimension, Dimension dimension2) {
        if (this.topDesignComponent instanceof RADVisualFormContainer) {
            ((RADVisualFormContainer)this.topDesignComponent).setDesignerSize(dimension);
        } else if (this.topDesignComponent != null) {
            if (this.topDesignComponent == this.formModel.getTopRADComponent()) {
                dimension2 = (Dimension)this.topDesignComponent.getAuxValue(PROP_DESIGNER_SIZE);
                this.topDesignComponent.setAuxValue(PROP_DESIGNER_SIZE, dimension);
            }
            if (dimension2 == null) {
                dimension2 = this.getDesignerSize();
            }
            this.getFormModel().fireSyntheticPropertyChanged(this.topDesignComponent, PROP_DESIGNER_SIZE, dimension2, dimension);
        }
    }

    public void resetDesignerSize() {
        this.setDesignerSize(null, null);
    }

    void storeDesignerSize(Dimension dimension) {
        if (this.topDesignComponent instanceof RADVisualFormContainer) {
            ((RADVisualFormContainer)this.topDesignComponent).setDesignerSizeImpl(dimension);
        } else if (this.topDesignComponent == this.formModel.getTopRADComponent()) {
            this.topDesignComponent.setAuxValue(PROP_DESIGNER_SIZE, dimension);
        }
    }

    private void setupDesignerSize() {
        RADVisualFormContainer rADVisualFormContainer;
        Dimension dimension = null;
        RADVisualFormContainer rADVisualFormContainer2 = rADVisualFormContainer = this.topDesignComponent instanceof RADVisualFormContainer ? (RADVisualFormContainer)this.topDesignComponent : null;
        if (rADVisualFormContainer == null || rADVisualFormContainer.getFormSizePolicy() == 0 || !this.isFreeDesignContainer()) {
            if (rADVisualFormContainer != null) {
                dimension = rADVisualFormContainer.getDesignerSize();
            }
            if (dimension == null) {
                dimension = (Dimension)this.topDesignComponent.getAuxValue(PROP_DESIGNER_SIZE);
            }
            if (!(dimension != null || this.formModel.isFreeDesignDefaultLayout() && this.topDesignComponent != this.formModel.getTopRADComponent())) {
                dimension = new Dimension(400, 300);
            }
        }
        Dimension dimension2 = this.componentLayer.setDesignerSize(dimension);
        this.storeDesignerSize(dimension2);
    }

    private void checkDesignerSize() {
        if ((this.formModel.isFreeDesignDefaultLayout() || this.isFreeDesignContainer()) && this.topDesignComponent instanceof RADVisualComponent && (!(this.topDesignComponent instanceof RADVisualFormContainer) || ((RADVisualFormContainer)this.topDesignComponent).getFormSizePolicy() != 0)) {
            Component component = (Component)this.getComponent(this.topDesignComponent);
            Component component2 = this.getTopVisualContainer();
            if (component2 == null) {
                component2 = component;
            }
            int n = component.getWidth() - component2.getWidth();
            int n2 = component.getHeight() - component2.getHeight();
            Dimension dimension = new Dimension(this.getDesignerSize());
            dimension.width -= n;
            dimension.height -= n2;
            Dimension dimension2 = component2.getMinimumSize();
            boolean bl = false;
            if (dimension.width < dimension2.width) {
                dimension.width = dimension2.width;
                bl = true;
            }
            if (dimension.height < dimension2.height) {
                dimension.height = dimension2.height;
                bl = true;
            }
            if (bl) {
                dimension.width += n;
                dimension.height += n2;
                if (this.formModel.isCompoundEditInProgress()) {
                    FormModelEvent formModelEvent = new FormModelEvent(this.formModel, 11);
                    formModelEvent.setComponentAndContainer(this.topDesignComponent, null);
                    formModelEvent.setProperty(PROP_DESIGNER_SIZE, this.getDesignerSize(), dimension);
                    this.formModel.addUndoableEdit(formModelEvent.getUndoableEdit());
                }
                this.componentLayer.setDesignerSize(dimension);
                this.storeDesignerSize(dimension);
            }
        }
    }

    private boolean isFreeDesignContainer() {
        return this.topDesignComponent instanceof RADVisualContainer && ((RADVisualContainer)this.topDesignComponent).getLayoutSupport() == null;
    }

    List getSelectedComponents() {
        return this.selectedComponents;
    }

    Node[] getSelectedComponentNodes() {
        Node[] nodeArray = new Node[this.selectedComponents.size()];
        Iterator iterator = this.selectedComponents.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            RADComponent rADComponent = (RADComponent)iterator.next();
            nodeArray[n++] = rADComponent.getNodeReference();
        }
        return nodeArray;
    }

    List getSelectedLayoutComponents() {
        return this.selectedLayoutComponents;
    }

    boolean isComponentSelected(RADComponent rADComponent) {
        return this.selectedComponents.contains(rADComponent);
    }

    void setSelectedComponent(RADComponent rADComponent) {
        this.clearSelectionImpl();
        this.addComponentToSelectionImpl(rADComponent);
        this.repaintSelection();
        this.updateComponentInspector();
    }

    void setSelectedComponents(RADComponent[] rADComponentArray) {
        this.clearSelectionImpl();
        for (int i = 0; i < rADComponentArray.length; ++i) {
            this.addComponentToSelectionImpl(rADComponentArray[i]);
        }
        this.repaintSelection();
        this.updateComponentInspector();
    }

    void setSelectedNode(FormNode formNode) {
        if (formNode instanceof RADComponentNode) {
            this.setSelectedComponent(((RADComponentNode)formNode).getRADComponent());
        } else {
            this.clearSelectionImpl();
            this.repaintSelection();
            ComponentInspector componentInspector = ComponentInspector.getInstance();
            if (componentInspector.getFocusedForm() != this.formEditor) {
                return;
            }
            Node[] nodeArray = new Node[]{formNode};
            try {
                componentInspector.setSelectedNodes(nodeArray, this.formEditor);
            }
            catch (PropertyVetoException propertyVetoException) {
                propertyVetoException.printStackTrace();
            }
        }
    }

    void addComponentToSelection(RADComponent rADComponent) {
        this.addComponentToSelectionImpl(rADComponent);
        this.repaintSelection();
        this.updateComponentInspector();
    }

    void addComponentsToSelection(RADComponent[] rADComponentArray) {
        for (int i = 0; i < rADComponentArray.length; ++i) {
            this.addComponentToSelectionImpl(rADComponentArray[i]);
        }
        this.repaintSelection();
        this.updateComponentInspector();
    }

    void removeComponentFromSelection(RADComponent rADComponent) {
        this.removeComponentFromSelectionImpl(rADComponent);
        this.repaintSelection();
        this.updateComponentInspector();
    }

    public void clearSelection() {
        this.clearSelectionImpl();
        this.repaintSelection();
        this.updateComponentInspector();
    }

    void addComponentToSelectionImpl(RADComponent rADComponent) {
        if (rADComponent != null) {
            this.selectedComponents.add(rADComponent);
            RADVisualComponent rADVisualComponent = this.componentToLayoutComponent(rADComponent);
            if (rADVisualComponent != null) {
                this.selectedLayoutComponents.add(rADVisualComponent);
                this.ensureComponentIsShown((RADVisualComponent)rADComponent);
                this.selectionChanged();
            }
        }
    }

    RADVisualComponent componentToLayoutComponent(RADComponent rADComponent) {
        if (rADComponent instanceof RADVisualComponent) {
            RADVisualComponent rADVisualComponent = (RADVisualComponent)rADComponent;
            RADVisualContainer rADVisualContainer = rADVisualComponent.getParentContainer();
            if (rADVisualContainer != null && JScrollPane.class.isAssignableFrom(rADVisualContainer.getBeanInstance().getClass()) && this.isInDesignedTree(rADVisualContainer)) {
                return rADVisualContainer;
            }
            return this.isInDesignedTree(rADVisualComponent) ? rADVisualComponent : null;
        }
        return null;
    }

    void removeComponentFromSelectionImpl(RADComponent rADComponent) {
        this.selectedComponents.remove(rADComponent);
        this.selectedLayoutComponents.remove(rADComponent);
        this.selectionChanged();
    }

    void clearSelectionImpl() {
        this.selectedComponents.clear();
        this.selectedLayoutComponents.clear();
        this.selectionChanged();
    }

    void selectionChanged() {
        this.updateDesignerActions();
        this.updateResizabilityActions();
    }

    void repaintSelection() {
        this.handleLayer.repaint();
    }

    private void updateDesignerActions() {
        Object object;
        LayoutComponent layoutComponent;
        Object object2;
        Collection collection = this.selectedLayoutComponentIds();
        boolean bl = false;
        if (collection.size() >= 2 && (object2 = this.commonParent(collection)) != null && (layoutComponent = ((LayoutModel)(object = this.formModel.getLayoutModel())).getLayoutComponent(((RADComponent)object2).getId())) != null && layoutComponent.isLayoutContainer()) {
            bl = true;
        }
        object2 = this.getDesignerActions(true).iterator();
        while (object2.hasNext()) {
            object = (Action)object2.next();
            object.setEnabled(bl);
        }
    }

    void setResizabilityButtons(JToggleButton[] jToggleButtonArray) {
        this.resizabilityButtons = jToggleButtonArray;
    }

    public JToggleButton[] getResizabilityButtons() {
        return this.resizabilityButtons;
    }

    public void updateResizabilityActions() {
        int n;
        Collection collection = this.componentIds();
        LayoutModel layoutModel = this.getFormModel().getLayoutModel();
        LayoutDesigner layoutDesigner = this.getLayoutDesigner();
        Iterator iterator = collection.iterator();
        boolean[] blArray = new boolean[2];
        boolean[] blArray2 = new boolean[2];
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            LayoutComponent layoutComponent = layoutModel.getLayoutComponent(string);
            for (n = 0; n < 2; ++n) {
                if (layoutDesigner.isComponentResizing(layoutComponent, n == 0 ? 0 : 1)) {
                    blArray[n] = true;
                    continue;
                }
                blArray2[n] = true;
            }
        }
        for (int i = 0; i < 2; ++i) {
            boolean bl = blArray[i];
            n = blArray2[i];
            this.getResizabilityButtons()[i].setSelected(n == 0 && bl);
            ((ResizabilityAction)this.getResizabilityActions().toArray()[i]).setEnabled(bl || n != 0);
        }
    }

    RADVisualComponent getNextVisualComponent(boolean bl) {
        RADVisualComponent rADVisualComponent = null;
        int n = this.selectedComponents.size();
        if (n > 0) {
            if (n > 1) {
                return null;
            }
            Object e = this.selectedComponents.get(0);
            if (e instanceof RADVisualComponent) {
                rADVisualComponent = (RADVisualComponent)e;
            } else {
                return null;
            }
        }
        return this.getNextVisualComponent(rADVisualComponent, bl);
    }

    RADVisualComponent getNextVisualComponent(RADVisualComponent rADVisualComponent, boolean bl) {
        RADVisualComponent[] rADVisualComponentArray;
        if (rADVisualComponent == null) {
            return this.topDesignComponent;
        }
        if (this.getComponent(rADVisualComponent) == null) {
            return null;
        }
        if (bl) {
            RADVisualComponent[] rADVisualComponentArray2;
            if (rADVisualComponent instanceof RADVisualContainer && (rADVisualComponentArray2 = ((RADVisualContainer)rADVisualComponent).getSubComponents()).length > 0) {
                return rADVisualComponentArray2[0];
            }
            if (rADVisualComponent == this.topDesignComponent) {
                return this.topDesignComponent;
            }
            RADVisualContainer rADVisualContainer = rADVisualComponent.getParentContainer();
            if (rADVisualContainer == null) {
                return null;
            }
            int n = rADVisualContainer.getIndexOf(rADVisualComponent);
            while (n >= 0) {
                rADVisualComponentArray2 = rADVisualContainer.getSubComponents();
                if (n + 1 < rADVisualComponentArray2.length) {
                    return rADVisualComponentArray2[n + 1];
                }
                if (rADVisualContainer == this.topDesignComponent) break;
                rADVisualComponent = rADVisualContainer;
                if ((rADVisualContainer = rADVisualComponent.getParentContainer()) == null) {
                    return null;
                }
                n = rADVisualContainer.getIndexOf(rADVisualComponent);
            }
            return this.topDesignComponent;
        }
        if (rADVisualComponent != this.topDesignComponent) {
            RADVisualContainer rADVisualContainer = rADVisualComponent.getParentContainer();
            if (rADVisualContainer == null) {
                return null;
            }
            int n = rADVisualContainer.getIndexOf(rADVisualComponent);
            if (n >= 0) {
                if (n == 0) {
                    return rADVisualContainer;
                }
                rADVisualComponentArray = rADVisualContainer.getSubComponents();
                rADVisualComponent = rADVisualComponentArray[n - 1];
            } else {
                rADVisualComponent = this.topDesignComponent;
            }
        }
        while (rADVisualComponent instanceof RADVisualContainer && (rADVisualComponentArray = ((RADVisualContainer)rADVisualComponent).getSubComponents()).length > 0) {
            rADVisualComponent = rADVisualComponentArray[rADVisualComponentArray.length - 1];
        }
        return rADVisualComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void align(boolean bl, int n, int n2) {
        Object object;
        Object object2;
        Object object3 = null;
        Iterator iterator = this.getDesignerActions(true).iterator();
        while (iterator.hasNext()) {
            object2 = (Action)iterator.next();
            if (!(object2 instanceof AlignAction) || ((AlignAction)(object = (AlignAction)object2)).getAlignment() != n2 || ((AlignAction)object).getDimension() != n) continue;
            object3 = object;
            break;
        }
        if (object3 == null || !object3.isEnabled()) {
            return;
        }
        object2 = this.selectedLayoutComponentIds();
        object = this.commonParent((Collection)object2);
        LayoutModel layoutModel = this.formModel.getLayoutModel();
        Object object4 = layoutModel.getChangeMark();
        UndoableEdit undoableEdit = layoutModel.getUndoableEdit();
        boolean bl2 = true;
        try {
            this.getLayoutDesigner().align((Collection)object2, bl, n, n2);
            bl2 = false;
            Object var13_12 = null;
            this.formModel.fireContainerLayoutChanged((RADVisualContainer)object, null, null, null);
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            this.formModel.fireContainerLayoutChanged((RADVisualContainer)object, null, null, null);
            if (!object4.equals(layoutModel.getChangeMark())) {
                this.formModel.addUndoableEdit(undoableEdit);
            }
            if (bl2) {
                this.formModel.forceUndoOfCompoundEdit();
            }
            throw throwable;
        }
        if (!object4.equals(layoutModel.getChangeMark())) {
            this.formModel.addUndoableEdit(undoableEdit);
        }
        if (bl2) {
            this.formModel.forceUndoOfCompoundEdit();
        }
    }

    public Collection getDesignerActions(boolean bl) {
        if (this.designerActions == null) {
            this.designerActions = new LinkedList();
            this.designerActions.add(new AlignAction(0, 0, true));
            this.designerActions.add(new AlignAction(0, 1, true));
            this.designerActions.add(new AlignAction(1, 0, true));
            this.designerActions.add(new AlignAction(1, 1, true));
            this.designerActions.add(new AlignAction(0, 0, false));
            this.designerActions.add(new AlignAction(0, 1, false));
            this.designerActions.add(new AlignAction(1, 0, false));
            this.designerActions.add(new AlignAction(1, 1, false));
        }
        return bl ? this.designerActions.subList(0, 4) : this.designerActions;
    }

    public Collection getResizabilityActions() {
        if (this.resizabilityActions == null) {
            this.resizabilityActions = new LinkedList();
            this.resizabilityActions.add(new ResizabilityAction(0));
            this.resizabilityActions.add(new ResizabilityAction(1));
        }
        return this.resizabilityActions;
    }

    Collection selectedLayoutComponentIds() {
        Iterator iterator = this.getSelectedLayoutComponents().iterator();
        LinkedList<String> linkedList = new LinkedList<String>();
        while (iterator.hasNext()) {
            RADComponent rADComponent = (RADComponent)iterator.next();
            linkedList.add(rADComponent.getId());
        }
        return linkedList;
    }

    private RADComponent commonParent(Collection collection) {
        RADComponent rADComponent = null;
        Iterator iterator = collection.iterator();
        FormModel formModel = this.getFormModel();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            RADComponent rADComponent2 = formModel.getMetaComponent(string);
            RADComponent rADComponent3 = rADComponent2.getParentComponent();
            if (rADComponent == null) {
                rADComponent = rADComponent3;
            }
            if (rADComponent3 != null && rADComponent == rADComponent3) continue;
            return null;
        }
        return rADComponent;
    }

    void updateComponentInspector() {
        ComponentInspector componentInspector = ComponentInspector.getInstance();
        if (componentInspector.getFocusedForm() != this.formEditor) {
            return;
        }
        Node[] nodeArray = this.getSelectedComponentNodes();
        try {
            this.setActivatedNodes(nodeArray);
            componentInspector.setSelectedNodes(nodeArray, this.formEditor);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
    }

    void updateVisualSettings() {
        this.componentLayer.updateVisualSettings();
        if (this.nonVisualTray != null) {
            this.nonVisualTray.updateVisualSettings();
        }
        this.layeredPane.revalidate();
        this.layeredPane.repaint();
    }

    private void ensureComponentIsShown(RADVisualComponent rADVisualComponent) {
        Component component = (Component)this.getComponent(rADVisualComponent);
        if (component == null) {
            return;
        }
        if (component.isShowing()) {
            return;
        }
        if (!this.isInDesignedTree(rADVisualComponent)) {
            return;
        }
        Component component2 = (Component)this.getComponent(this.topDesignComponent);
        if (component2 == null || !component2.isShowing()) {
            return;
        }
        RADVisualComponent rADVisualComponent2 = rADVisualComponent;
        for (RADVisualContainer rADVisualContainer = rADVisualComponent.getParentContainer(); rADVisualContainer != null; rADVisualContainer = rADVisualContainer.getParentContainer()) {
            Container container = (Container)this.getComponent(rADVisualContainer);
            LayoutSupportManager layoutSupportManager = rADVisualContainer.getLayoutSupport();
            if (layoutSupportManager != null) {
                Container container2 = rADVisualContainer.getContainerDelegate(container);
                layoutSupportManager.selectComponent(rADVisualComponent2.getComponentIndex());
                layoutSupportManager.arrangeContainer(container, container2);
            }
            if (rADVisualContainer == this.topDesignComponent || container.isShowing()) break;
            rADVisualComponent2 = rADVisualContainer;
        }
    }

    void connectBean(RADComponent rADComponent, boolean bl) {
        if (this.connectionSource == null) {
            this.connectionSource = rADComponent;
            this.handleLayer.repaint();
        } else {
            if (rADComponent == this.connectionSource) {
                if (this.connectionTarget != null) {
                    this.resetConnection();
                    this.toggleSelectionMode();
                }
                return;
            }
            this.connectionTarget = rADComponent;
            this.handleLayer.repaint();
            if (bl) {
                if (this.connectionTarget != null) {
                    this.createConnection(this.connectionSource, this.connectionTarget);
                }
                this.toggleSelectionMode();
            }
        }
    }

    public RADComponent getConnectionSource() {
        return this.connectionSource;
    }

    public RADComponent getConnectionTarget() {
        return this.connectionTarget;
    }

    public void resetConnection() {
        if (this.connectionSource != null || this.connectionTarget != null) {
            this.connectionSource = null;
            this.connectionTarget = null;
            this.handleLayer.repaint();
        }
    }

    private void createConnection(RADComponent rADComponent, RADComponent rADComponent2) {
        ConnectionWizard connectionWizard = new ConnectionWizard(this.formModel, rADComponent, rADComponent2);
        if (connectionWizard.show()) {
            final Event event = connectionWizard.getSelectedEvent();
            final String string = connectionWizard.getEventName();
            String string2 = connectionWizard.getGeneratedCode();
            this.formModel.getFormEvents().attachEvent(event, string, string2);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FormDesigner.this.formModel.getFormEvents().attachEvent(event, string, null);
                }
            });
        }
    }

    public void startInPlaceEditing(RADComponent rADComponent) {
        if (this.formModel.isReadOnly()) {
            return;
        }
        if (this.textEditLayer != null && this.textEditLayer.isVisible()) {
            return;
        }
        if (!this.isEditableInPlace(rADComponent)) {
            return;
        }
        Component component = (Component)this.getComponent(rADComponent);
        if (component == null) {
            this.notifyCannotEditInPlace();
            return;
        }
        RADProperty rADProperty = rADComponent.getBeanProperty("text");
        if (rADProperty == null) {
            return;
        }
        String string = null;
        try {
            Object object = rADProperty.getRealValue();
            if (!(object instanceof String)) {
                object = "";
            }
            string = (String)object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        this.editedProperty = rADProperty;
        if (this.textEditLayer == null) {
            this.textEditLayer = new InPlaceEditLayer();
            this.textEditLayer.setVisible(false);
            this.textEditLayer.addFinishListener(this.getFinnishListener());
            this.layeredPane.add((Component)this.textEditLayer, new Integer(2001));
        }
        try {
            this.textEditLayer.setEditedComponent(component, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.notifyCannotEditInPlace();
            return;
        }
        this.textEditLayer.setVisible(true);
        this.handleLayer.setVisible(false);
        this.textEditLayer.requestFocus();
    }

    private InPlaceEditLayer.FinishListener getFinnishListener() {
        if (this.finnishListener == null) {
            this.finnishListener = new InPlaceEditLayer.FinishListener(){

                public void editingFinished(boolean bl) {
                    FormDesigner.this.finishInPlaceEditing(FormDesigner.this.textEditLayer.isTextChanged());
                }
            };
        }
        return this.finnishListener;
    }

    private void finishInPlaceEditing(boolean bl) {
        if (bl) {
            try {
                Object object = this.editedProperty.getValue();
                if (object instanceof String) {
                    this.editedProperty.setValue(this.textEditLayer.getEditedText());
                } else {
                    PropertyEditor propertyEditor = this.editedProperty.findDefaultEditor();
                    this.editedProperty.setValue(new FormProperty.ValueWithEditor((Object)this.textEditLayer.getEditedText(), propertyEditor));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.textEditLayer.setVisible(false);
        this.handleLayer.setVisible(true);
        this.handleLayer.requestFocus();
        this.editedProperty = null;
    }

    public boolean isEditableInPlace(RADComponent rADComponent) {
        Component component = (Component)this.getComponent(rADComponent);
        if (component == null) {
            return false;
        }
        for (RADComponent rADComponent2 = rADComponent.getParentComponent(); rADComponent2 != null; rADComponent2 = rADComponent2.getParentComponent()) {
            if ((class$javax$swing$JComponent == null ? FormDesigner.class$("javax.swing.JComponent") : class$javax$swing$JComponent).isAssignableFrom(rADComponent2.getBeanClass()) || (class$javax$swing$RootPaneContainer == null ? FormDesigner.class$("javax.swing.RootPaneContainer") : class$javax$swing$RootPaneContainer).isAssignableFrom(rADComponent2.getBeanClass())) continue;
            return false;
        }
        return InPlaceEditLayer.supportsEditingFor(rADComponent.getBeanClass(), false);
    }

    private void notifyCannotEditInPlace() {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)FormUtils.getBundleString("MSG_ComponentNotShown"), 2));
    }

    public int getPersistenceType() {
        return 2;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("gui.formeditor");
    }

    public void componentActivated() {
        if (this.formModel == null) {
            return;
        }
        this.formEditor.setFormDesigner(this);
        ComponentInspector componentInspector = ComponentInspector.getInstance();
        if (componentInspector.getFocusedForm() != this.formEditor) {
            componentInspector.focusForm(this.formEditor);
            if (this.getDesignerMode() == 1) {
                this.clearSelection();
            } else {
                this.updateComponentInspector();
            }
        }
        componentInspector.attachActions();
        if (this.textEditLayer == null || !this.textEditLayer.isVisible()) {
            this.handleLayer.requestFocus();
        }
    }

    public void componentDeactivated() {
        if (this.formModel == null) {
            return;
        }
        if (this.textEditLayer != null && this.textEditLayer.isVisible()) {
            this.textEditLayer.finishEditing(false);
        }
        ComponentInspector.getInstance().detachActions();
        this.resetConnection();
    }

    public UndoRedo getUndoRedo() {
        UndoRedo.Manager manager = this.formModel != null ? this.formModel.getUndoRedoManager() : null;
        return manager != null ? manager : super.getUndoRedo();
    }

    protected String preferredID() {
        return this.formEditor.getFormDataObject().getName();
    }

    public JComponent getToolbarRepresentation() {
        return this.getFormToolBar();
    }

    public JComponent getVisualRepresentation() {
        return this;
    }

    public void setMultiViewCallback(MultiViewElementCallback multiViewElementCallback) {
        this.multiViewObserver = multiViewElementCallback;
        multiViewElementCallback.getTopComponent().putClientProperty((Object)"formDesigner", (Object)this);
        if (this.formEditor != null) {
            FormDataObject formDataObject = this.formEditor.getFormDataObject();
            formDataObject.getFormEditorSupport().setTopComponent(multiViewElementCallback.getTopComponent());
        }
    }

    public void requestVisible() {
        if (this.multiViewObserver != null) {
            this.multiViewObserver.requestVisible();
        } else {
            super.requestVisible();
        }
    }

    public void requestActive() {
        if (this.multiViewObserver != null) {
            this.multiViewObserver.requestActive();
        } else {
            super.requestActive();
        }
    }

    public void componentClosed() {
        super.componentClosed();
        if (this.formModel != null) {
            if (this.formModelListener != null) {
                this.formModel.removeFormModelListener(this.formModelListener);
            }
            this.topDesignComponent = null;
            this.formModel = null;
        }
    }

    public void componentShowing() {
        super.componentShowing();
        if (!this.formEditor.isFormLoaded()) {
            this.formEditor.loadFormDesigner();
            if (!this.formEditor.isFormLoaded()) {
                this.removeAll();
                return;
            }
        }
        if (!this.initialized) {
            this.initialize();
        }
        FormEditorSupport.checkFormGroupVisibility();
    }

    public void componentHidden() {
        super.componentHidden();
        FormEditorSupport.checkFormGroupVisibility();
    }

    public void componentOpened() {
        super.componentOpened();
        if (this.formEditor == null && this.multiViewObserver != null) {
            this.multiViewObserver.getTopComponent().close();
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    FormEditorSupport.checkFormGroupVisibility();
                }
            });
        }
    }

    public CloseOperationState canCloseElement() {
        if (!FormEditorSupport.isLastView(this.multiViewObserver.getTopComponent())) {
            return CloseOperationState.STATE_OK;
        }
        return MultiViewFactory.createUnsafeCloseState((String)"ID_FORM_CLOSING", (Action)MultiViewFactory.NOOP_CLOSE_ACTION, (Action)MultiViewFactory.NOOP_CLOSE_ACTION);
    }

    private Collection componentIds() {
        LinkedList<String> linkedList = new LinkedList<String>();
        List list = this.getSelectedLayoutComponents();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            RADVisualComponent rADVisualComponent = (RADVisualComponent)iterator.next();
            if (rADVisualComponent.getParentContainer() == null || rADVisualComponent.getParentLayoutSupport() != null) continue;
            linkedList.add(rADVisualComponent.getId());
        }
        return linkedList;
    }

    static class FormProxyLookup
    extends ProxyLookup {
        FormProxyLookup(Lookup[] lookupArray) {
            super(lookupArray);
        }

        Lookup[] getSubLookups() {
            return this.getLookups();
        }

        void setSubLookups(Lookup[] lookupArray) {
            this.setLookups(lookupArray);
        }
    }

    private class ResizabilityAction
    extends AbstractAction {
        private static final String ICON_BASE = "org/netbeans/modules/form/resources/resize_";
        private int dimension;

        ResizabilityAction(int n) {
            this.dimension = n;
            String string = n == 0 ? "h" : "v";
            String string2 = ICON_BASE + string + ".png";
            this.putValue("SmallIcon", new ImageIcon(Utilities.loadImage((String)string2)));
            this.putValue("ShortDescription", FormUtils.getBundleString("CTL_ResizeButton_" + string));
            this.setEnabled(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            Iterator iterator;
            FormModel formModel = FormDesigner.this.getFormModel();
            LayoutModel layoutModel = formModel.getLayoutModel();
            Object object = layoutModel.getChangeMark();
            UndoableEdit undoableEdit = layoutModel.getUndoableEdit();
            boolean bl = true;
            LayoutDesigner layoutDesigner = FormDesigner.this.getLayoutDesigner();
            Collection collection = FormDesigner.this.componentIds();
            HashSet<RADVisualContainer> hashSet = new HashSet<RADVisualContainer>();
            try {
                Iterator iterator2 = collection.iterator();
                while (iterator2.hasNext()) {
                    String string = (String)iterator2.next();
                    LayoutComponent layoutComponent = layoutModel.getLayoutComponent(string);
                    boolean bl2 = FormDesigner.this.getResizabilityButtons()[this.dimension].isSelected();
                    if (layoutDesigner.isComponentResizing(layoutComponent, this.dimension) == bl2) continue;
                    layoutDesigner.setComponentResizing(layoutComponent, this.dimension, bl2);
                    RADVisualComponent rADVisualComponent = (RADVisualComponent)formModel.getMetaComponent(string);
                    hashSet.add(rADVisualComponent.getParentContainer());
                }
                bl = false;
                Object var16_15 = null;
                iterator = hashSet.iterator();
            }
            catch (Throwable throwable) {
                Object var16_16 = null;
                Iterator iterator3 = hashSet.iterator();
                while (iterator3.hasNext()) {
                    formModel.fireContainerLayoutChanged((RADVisualContainer)iterator3.next(), null, null, null);
                }
                if (!object.equals(layoutModel.getChangeMark())) {
                    formModel.addUndoableEdit(undoableEdit);
                }
                if (bl) {
                    formModel.forceUndoOfCompoundEdit();
                }
                throw throwable;
            }
            while (iterator.hasNext()) {
                formModel.fireContainerLayoutChanged((RADVisualContainer)iterator.next(), null, null, null);
            }
            if (!object.equals(layoutModel.getChangeMark())) {
                formModel.addUndoableEdit(undoableEdit);
            }
            if (bl) {
                formModel.forceUndoOfCompoundEdit();
            }
        }
    }

    private class AlignAction
    extends AbstractAction {
        private static final String ICON_BASE = "org/netbeans/modules/form/resources/align_";
        private int dimension;
        private int alignment;
        private boolean closed;

        AlignAction(int n, int n2, boolean bl) {
            boolean bl2;
            this.dimension = n;
            this.alignment = n2;
            this.closed = bl;
            boolean bl3 = n == 0;
            boolean bl4 = bl2 = n2 == 0;
            String string = n2 == 2 ? (bl3 ? "ch" : "cv") : (bl3 ? (bl2 ? "l" : "r") : (bl2 ? "u" : "d"));
            String string2 = ICON_BASE + string + ".png";
            this.putValue("SmallIcon", new ImageIcon(Utilities.loadImage((String)string2)));
            this.putValue("ShortDescription", FormUtils.getBundleString("CTL_AlignAction_" + string));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FormDesigner.this.align(this.closed, this.dimension, this.alignment);
        }

        public int getDimension() {
            return this.dimension;
        }

        public int getAlignment() {
            return this.alignment;
        }
    }

    private static class NoNodeLookup
    extends Lookup {
        private final Lookup delegate;

        public NoNodeLookup(Lookup lookup) {
            this.delegate = lookup;
        }

        public Object lookup(Class clazz) {
            return clazz == (class$org$openide$nodes$Node == null ? (class$org$openide$nodes$Node = FormDesigner.class$("org.openide.nodes.Node")) : class$org$openide$nodes$Node) ? null : this.delegate.lookup(clazz);
        }

        public Lookup.Result lookup(Lookup.Template template) {
            if (template.getType() == (class$org$openide$nodes$Node == null ? (class$org$openide$nodes$Node = FormDesigner.class$("org.openide.nodes.Node")) : class$org$openide$nodes$Node)) {
                return Lookup.EMPTY.lookup(new Lookup.Template(class$org$openide$nodes$Node == null ? (class$org$openide$nodes$Node = FormDesigner.class$("org.openide.nodes.Node")) : class$org$openide$nodes$Node));
            }
            return this.delegate.lookup(template);
        }
    }

    private class FormListener
    implements FormModelListener,
    Runnable {
        private FormModelEvent[] events;
        static final /* synthetic */ boolean $assertionsDisabled;

        private FormListener() {
        }

        public void formChanged(FormModelEvent[] formModelEventArray) {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(new Runnable(this, formModelEventArray){
                    private final /* synthetic */ FormModelEvent[] val$events;
                    private final /* synthetic */ FormListener this$1;
                    {
                        this.this$1 = formListener;
                        this.val$events = formModelEventArray;
                    }

                    public void run() {
                        FormListener.access$1200(this.this$1, this.val$events);
                    }
                });
            } else {
                this.processEvents(formModelEventArray);
            }
        }

        private void processEvents(FormModelEvent[] formModelEventArray) {
            boolean bl;
            if (formModelEventArray == null) {
                bl = true;
            } else {
                bl = false;
                boolean bl2 = false;
                for (int i = 0; i < formModelEventArray.length; ++i) {
                    FormModelEvent formModelEvent = formModelEventArray[i];
                    if (formModelEvent.isModifying()) {
                        bl2 = true;
                    }
                    if (formModelEvent.getChangeType() != 7) continue;
                    bl = true;
                    break;
                }
                if (!bl2) {
                    return;
                }
                if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
                    throw new AssertionError();
                }
            }
            this.events = formModelEventArray;
            if (bl) {
                FormLAF.executeWithLookAndFeel(this);
            } else {
                this.run();
            }
        }

        public void run() {
            if (this.events == null) {
                Object object = FormDesigner.this.topDesignComponent == null ? null : FormDesigner.this.replicator.getClonedComponent(FormDesigner.this.topDesignComponent);
                Dimension dimension = object instanceof Component ? ((Component)object).getSize() : null;
                FormDesigner.this.replicator.setTopMetaComponent(FormDesigner.this.topDesignComponent);
                Component component = (Component)FormDesigner.this.replicator.createClone();
                if (component != null) {
                    component.setVisible(true);
                    FormDesigner.this.componentLayer.setTopDesignComponent(component);
                    if (dimension != null) {
                        FormDesigner.this.componentLayer.setDesignerSize(dimension);
                        FormDesigner.this.checkDesignerSize();
                    } else {
                        FormDesigner.this.setupDesignerSize();
                    }
                    if (FormDesigner.this.getLayoutDesigner() != null) {
                        FormDesigner.this.getLayoutDesigner().externalSizeChangeHappened();
                    }
                    EventQueue.invokeLater(new Runnable(this){
                        private final /* synthetic */ FormListener this$1;
                        {
                            this.this$1 = formListener;
                        }

                        public void run() {
                            FormDesigner.access$1800(FormListener.access$1700(this.this$1), false);
                        }
                    });
                }
                return;
            }
            FormModelEvent[] formModelEventArray = this.events;
            this.events = null;
            int n = 0;
            ComponentContainer componentContainer = null;
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < formModelEventArray.length; ++i) {
                Object object;
                FormModelEvent formModelEvent = formModelEventArray[i];
                int n2 = formModelEvent.getChangeType();
                ComponentContainer componentContainer2 = formModelEvent.getContainer();
                if (n2 == 4 || n2 == 5 || n2 == 6) {
                    if (n != 4 && n != 5 && n != 6 || componentContainer != componentContainer2) {
                        FormDesigner.this.replicator.updateContainerLayout((RADVisualContainer)componentContainer2);
                        bl = true;
                    }
                } else if (n2 == 7) {
                    if ((componentContainer2 instanceof RADVisualContainer || componentContainer2 instanceof RADMenuComponent) && (n != 7 || componentContainer != componentContainer2)) {
                        FormDesigner.this.replicator.updateAddedComponents(componentContainer2);
                        bl = true;
                    }
                } else if (n2 == 8) {
                    object = formModelEvent.getComponent();
                    if (object instanceof RADVisualComponent && (object == FormDesigner.this.topDesignComponent || ((RADComponent)object).isParentComponent(FormDesigner.this.topDesignComponent))) {
                        FormDesigner.this.resetTopDesignComponent(false);
                        FormDesigner.this.updateWholeDesigner();
                        return;
                    }
                    FormDesigner.this.replicator.removeComponent(formModelEvent.getComponent(), formModelEvent.getContainer());
                    bl = true;
                } else if (n2 == 9) {
                    if (n != 9 || componentContainer != componentContainer2) {
                        FormDesigner.this.replicator.reorderComponents(componentContainer2);
                        bl = true;
                    }
                } else if (n2 == 10) {
                    object = formModelEvent.getComponentProperty();
                    RADComponent rADComponent = formModelEvent.getComponent();
                    FormDesigner.this.replicator.updateComponentProperty((RADProperty)((Object)object));
                    this.updateConnectedProperties((RADProperty)((Object)object), rADComponent);
                    bl = true;
                } else if (n2 == 11 && FormDesigner.PROP_DESIGNER_SIZE.equals(formModelEvent.getPropertyName())) {
                    object = (Dimension)formModelEvent.getNewPropertyValue();
                    if (object != null) {
                        FormDesigner.this.componentLayer.setDesignerSize((Dimension)object);
                        bl2 = false;
                        bl = true;
                    } else {
                        bl2 = true;
                        bl = true;
                    }
                }
                n = n2;
                componentContainer = componentContainer2;
            }
            if (bl) {
                if (bl2) {
                    FormDesigner.this.setupDesignerSize();
                } else {
                    FormDesigner.this.checkDesignerSize();
                }
                LayoutDesigner layoutDesigner = FormDesigner.this.getLayoutDesigner();
                if (layoutDesigner != null && FormDesigner.this.formModel.isCompoundEditInProgress()) {
                    FormDesigner.this.getLayoutDesigner().externalSizeChangeHappened();
                }
                FormDesigner.this.updateComponentLayer(true);
            }
        }

        private void updateConnectedProperties(RADProperty rADProperty, RADComponent rADComponent) {
            Iterator iterator = FormDesigner.this.formModel.getMetaComponents().iterator();
            while (iterator.hasNext()) {
                RADComponent rADComponent2 = (RADComponent)iterator.next();
                RADProperty[] rADPropertyArray = rADComponent2.getKnownBeanProperties();
                for (int i = 0; i < rADPropertyArray.length; ++i) {
                    try {
                        RADConnectionPropertyEditor.RADConnectionDesignValue rADConnectionDesignValue;
                        Object object;
                        if (!rADPropertyArray[i].isChanged() || !((object = rADPropertyArray[i].getValue()) instanceof RADConnectionPropertyEditor.RADConnectionDesignValue) || (rADConnectionDesignValue = (RADConnectionPropertyEditor.RADConnectionDesignValue)object).getRADComponent() == null || rADConnectionDesignValue.getProperty() == null || !rADComponent.getName().equals(rADConnectionDesignValue.getRADComponent().getName()) || !rADProperty.getName().equals(rADConnectionDesignValue.getProperty().getName())) continue;
                        FormDesigner.this.replicator.updateComponentProperty(rADPropertyArray[i]);
                        continue;
                    }
                    catch (Exception exception) {
                        ErrorManager.getDefault().notify((Throwable)exception);
                    }
                }
            }
        }

        static /* synthetic */ void access$1200(FormListener formListener, FormModelEvent[] formModelEventArray) {
            formListener.processEvents(formModelEventArray);
        }

        static /* synthetic */ FormDesigner access$1700(FormListener formListener) {
            return formListener.FormDesigner.this;
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$form$FormDesigner == null ? (class$org$netbeans$modules$form$FormDesigner = FormDesigner.class$("org.netbeans.modules.form.FormDesigner")) : class$org$netbeans$modules$form$FormDesigner).desiredAssertionStatus();
        }
    }

    private class LayoutMapper
    implements VisualMapper,
    LayoutConstants {
        private LayoutStyle layoutStyle;
        static final /* synthetic */ boolean $assertionsDisabled;

        private LayoutMapper() {
        }

        public Rectangle getComponentBounds(String string) {
            Component component = this.getVisualComponent(string, true, false);
            Rectangle rectangle = null;
            if (component != null) {
                rectangle = FormDesigner.this.componentBoundsToTop(component);
            }
            if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                FormDesigner.this.getLayoutDesigner().testCode.add("  compBounds.put(\"" + string + "\", new Rectangle(" + rectangle.x + ", " + rectangle.y + ", " + rectangle.width + ", " + rectangle.height + "));");
            }
            return rectangle;
        }

        public Rectangle getContainerInterior(String string) {
            Component component = this.getVisualComponent(string, true, false);
            if (component == null) {
                return null;
            }
            RADVisualContainer rADVisualContainer = (RADVisualContainer)this.getMetaComponent(string);
            Container container = rADVisualContainer.getContainerDelegate(component);
            Rectangle rectangle = FormDesigner.this.componentBoundsToTop(container);
            Insets insets = container.getInsets();
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
            if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                FormDesigner.this.getLayoutDesigner().testCode.add("  contInterior.put(\"" + string + "\", new Rectangle(" + rectangle.x + ", " + rectangle.y + ", " + rectangle.width + ", " + rectangle.height + "));");
            }
            return rectangle;
        }

        public Dimension getComponentMinimumSize(String string) {
            Component component = this.getVisualComponent(string, false, false);
            Dimension dimension = null;
            if (component != null) {
                dimension = component.getMinimumSize();
            }
            if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                FormDesigner.this.getLayoutDesigner().testCode.add("  compMinSize.put(\"" + string + "\", new Dimension(" + new Double(dimension.getWidth()).intValue() + ", " + new Double(dimension.getHeight()).intValue() + "));");
            }
            return dimension;
        }

        public Dimension getComponentPreferredSize(String string) {
            Component component = this.getVisualComponent(string, false, false);
            Dimension dimension = null;
            if (component != null) {
                dimension = component.getPreferredSize();
            }
            if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                FormDesigner.this.getLayoutDesigner().testCode.add("  compPrefSize.put(\"" + string + "\", new Dimension(" + new Double(dimension.getWidth()).intValue() + ", " + new Double(dimension.getHeight()).intValue() + "));");
            }
            return dimension;
        }

        public boolean hasExplicitPreferredSize(String string) {
            JComponent jComponent = (JComponent)this.getVisualComponent(string, false, true);
            boolean bl = false;
            if (jComponent != null) {
                bl = jComponent.isPreferredSizeSet();
            }
            if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                FormDesigner.this.getLayoutDesigner().testCode.add("  hasExplicitPrefSize.put(\"" + string + "\", new Boolean(" + bl + "));");
            }
            return bl;
        }

        public int getBaselinePosition(String string, int n, int n2) {
            int n3 = -1;
            JComponent jComponent = (JComponent)this.getVisualComponent(string, true, true);
            if (jComponent instanceof JScrollPane || jComponent instanceof JPanel || jComponent instanceof JTabbedPane) {
                n3 = 0;
            }
            if (n3 == -1) {
                n3 = jComponent != null ? Baseline.getBaseline((JComponent)jComponent, (int)n, (int)n2) : 0;
            }
            if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                String string2 = string + "-" + n + "-" + n2;
                FormDesigner.this.getLayoutDesigner().testCode.add("  baselinePosition.put(\"" + string2 + "\", new Integer(" + n3 + "));");
            }
            return n3;
        }

        public int getPreferredPadding(String string, String string2, int n, int n2, int n3) {
            String string3 = null;
            if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                string3 = string + "-" + string2 + "-" + n + "-" + n2 + "-" + n3;
            }
            JComponent jComponent = (JComponent)this.getVisualComponent(string, true, true);
            JComponent jComponent2 = (JComponent)this.getVisualComponent(string2, true, true);
            if (jComponent == null || jComponent2 == null) {
                if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                    FormDesigner.this.getLayoutDesigner().testCode.add("  prefPadding.put(\"" + string3 + "\", new Integer(10)); // comp1Id-comp2Id-dimension-comp2Alignment-paddingType");
                }
                return 10;
            }
            if (!$assertionsDisabled && n != 0 && n != 1) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && n2 != 0 && n2 != 1) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && n3 != 0 && n3 != 1 && n3 != 2) {
                throw new AssertionError();
            }
            int n4 = n3 == 2 ? 3 : (n3 == 0 ? 0 : 1);
            int n5 = 0;
            n5 = n == 0 ? (n3 == 2 ? (n2 == 0 ? 7 : 3) : (n2 == 0 ? 3 : 7)) : (n2 == 0 ? 5 : 1);
            int n6 = this.getLayoutStyle().getPreferredGap(jComponent, jComponent2, n4, n5, null);
            if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                FormDesigner.this.getLayoutDesigner().testCode.add("  prefPadding.put(\"" + string3 + "\", new Integer(" + n6 + ")); // comp1Id-comp2Id-dimension-comp2Alignment-paddingType");
            }
            return n6;
        }

        public int getPreferredPaddingInParent(String string, String string2, int n, int n2) {
            String string3 = null;
            if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                string3 = string + "-" + string2 + "-" + n + "-" + n2;
            }
            JComponent jComponent = null;
            Container container = (Container)this.getVisualComponent(string, true, false);
            if (container != null) {
                RADVisualContainer rADVisualContainer = (RADVisualContainer)this.getMetaComponent(string);
                container = rADVisualContainer.getContainerDelegate(container);
                jComponent = (JComponent)this.getVisualComponent(string2, true, true);
            }
            if (jComponent == null) {
                if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                    FormDesigner.this.getLayoutDesigner().testCode.add("  prefPaddingInParent.put(\"" + string3 + "\", new Integer(10)); // parentId-compId-dimension-compAlignment");
                }
                return 10;
            }
            if (!$assertionsDisabled && n != 0 && n != 1) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && n2 != 0 && n2 != 1) {
                throw new AssertionError();
            }
            int n3 = n == 0 ? (n2 == 0 ? 7 : 3) : (n2 == 0 ? 1 : 5);
            int n4 = this.getLayoutStyle().getContainerGap(jComponent, n3, container);
            if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                FormDesigner.this.getLayoutDesigner().testCode.add("  prefPaddingInParent.put(\"" + string3 + "\", new Integer(" + n4 + ")); // parentId-compId-dimension-compAlignment");
            }
            return n4;
        }

        public boolean[] getComponentResizability(String string, boolean[] blArray) {
            blArray[1] = true;
            blArray[0] = true;
            return blArray;
        }

        public void rebuildLayout(String string) {
            FormDesigner.this.replicator.updateContainerLayout((RADVisualContainer)this.getMetaComponent(string));
            FormDesigner.this.replicator.getLayoutBuilder(string).doLayout();
        }

        private RADComponent getMetaComponent(String string) {
            RADVisualComponent rADVisualComponent;
            RADComponent rADComponent = FormDesigner.this.formModel.getMetaComponent(string);
            if (rADComponent == null && (rADVisualComponent = FormDesigner.this.formModel.getComponentCreator().getPrecreatedMetaComponent()) != null && rADVisualComponent.getId().equals(string)) {
                rADComponent = rADVisualComponent;
            }
            return rADComponent;
        }

        private Component getVisualComponent(String string, boolean bl, boolean bl2) {
            Object object;
            Object object2 = FormDesigner.this.getComponent(string);
            if (object2 == null) {
                RADComponent rADComponent;
                object = FormDesigner.this.formModel.getComponentCreator().getPrecreatedMetaComponent();
                if (object != null && ((RADComponent)object).getId().equals(string)) {
                    object2 = ((RADComponent)object).getBeanInstance();
                }
                if (object2 == null && !bl && (rADComponent = this.getMetaComponent(string)) != null) {
                    object2 = rADComponent.getBeanInstance();
                }
            }
            Class clazz = bl2 ? (class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = FormDesigner.class$("javax.swing.JComponent")) : class$javax$swing$JComponent) : (class$java$awt$Component == null ? (class$java$awt$Component = FormDesigner.class$("java.awt.Component")) : class$java$awt$Component);
            object = clazz;
            return object2 != null && ((Class)object).isAssignableFrom(object2.getClass()) ? (Component)object2 : null;
        }

        private LayoutStyle getLayoutStyle() {
            if (this.layoutStyle == null) {
                this.layoutStyle = LayoutStyle.getSharedInstance();
            }
            return this.layoutStyle;
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$form$FormDesigner == null ? (class$org$netbeans$modules$form$FormDesigner = FormDesigner.class$("org.netbeans.modules.form.FormDesigner")) : class$org$netbeans$modules$form$FormDesigner).desiredAssertionStatus();
        }
    }
}

