/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.actions;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.netbeans.modules.form.actions.CustomizeEmptySpaceAction;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutdesign.LayoutUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class EmptySpaceCustomizer
extends JPanel {
    JComboBox leftSize = new JComboBox();
    JComboBox rightSize = new JComboBox();
    JComboBox topSize = new JComboBox();
    JComboBox bottomSize = new JComboBox();
    JCheckBox leftResizable = new JCheckBox();
    JCheckBox rightResizable = new JCheckBox();
    JCheckBox topResizable = new JCheckBox();
    JCheckBox bottomResizable = new JCheckBox();
    LayoutModel model;
    String compId;
    String padding;

    EmptySpaceCustomizer(LayoutModel layoutModel, String string) {
        this.model = layoutModel;
        this.compId = string;
        this.initComponents();
        LayoutComponent layoutComponent = layoutModel.getLayoutComponent(string);
        this.initValues(layoutComponent, 0, 0, this.leftSize, this.leftResizable);
        this.initValues(layoutComponent, 0, 1, this.rightSize, this.rightResizable);
        this.initValues(layoutComponent, 1, 0, this.topSize, this.topResizable);
        this.initValues(layoutComponent, 1, 1, this.bottomSize, this.bottomResizable);
    }

    private void initValues(LayoutComponent layoutComponent, int n, int n2, JComboBox jComboBox, JCheckBox jCheckBox) {
        LayoutInterval layoutInterval = LayoutUtils.getAdjacentEmptySpace(layoutComponent, n, n2);
        if (layoutInterval != null) {
            int n3 = layoutInterval.getPreferredSize(false);
            int n4 = layoutInterval.getMaximumSize(false);
            jComboBox.setSelectedItem(n3 == -1 ? this.padding : "" + n3);
            jCheckBox.setSelected(n4 != -2 && n4 != n3);
        } else {
            jComboBox.setSelectedItem(NbBundle.getMessage((Class)CustomizeEmptySpaceAction.class, (String)"VALUE_NoEmptySpace"));
            jComboBox.setEnabled(false);
            jCheckBox.setEnabled(false);
        }
    }

    boolean checkValues() {
        return this.checkValue(this.leftSize) && this.checkValue(this.rightSize) && this.checkValue(this.topSize) && this.checkValue(this.bottomSize);
    }

    private boolean checkValue(JComboBox jComboBox) {
        Object object = jComboBox.getSelectedItem();
        if (jComboBox.isEnabled() && !object.equals(this.padding)) {
            try {
                int n = Integer.parseInt((String)object);
                if (n < 0) {
                    this.notify("MSG_NegativeSpaceSize");
                    return false;
                }
                if (n > Short.MAX_VALUE) {
                    this.notify("MSG_TooLargeSpaceSize");
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.notify("MSG_CorruptedSpaceSize");
                return false;
            }
        }
        return true;
    }

    private void notify(String string) {
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getBundle((Class)CustomizeEmptySpaceAction.class).getString(string));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
    }

    void applyValues() {
        LayoutComponent layoutComponent = this.model.getLayoutComponent(this.compId);
        this.applyValues(layoutComponent, 0, 0, this.leftSize, this.leftResizable);
        this.applyValues(layoutComponent, 0, 1, this.rightSize, this.rightResizable);
        this.applyValues(layoutComponent, 1, 0, this.topSize, this.topResizable);
        this.applyValues(layoutComponent, 1, 1, this.bottomSize, this.bottomResizable);
    }

    private void applyValues(LayoutComponent layoutComponent, int n, int n2, JComboBox jComboBox, JCheckBox jCheckBox) {
        LayoutInterval layoutInterval = LayoutUtils.getAdjacentEmptySpace(layoutComponent, n, n2);
        if (layoutInterval != null) {
            int n3;
            int n4 = layoutInterval.getPreferredSize(false);
            int n5 = layoutInterval.getMaximumSize(false);
            boolean bl = n5 != -2 && n5 != n4;
            boolean bl2 = jCheckBox.isSelected();
            Object object = jComboBox.getSelectedItem();
            if (object.equals(this.padding)) {
                n3 = -1;
            } else {
                try {
                    n3 = Integer.parseInt((String)object);
                    if (n3 < 0) {
                        n3 = n4;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    n3 = n4;
                }
            }
            if (n4 != n3 || bl != bl2) {
                this.model.setIntervalSize(layoutInterval, bl2 ? -1 : -2, n3, bl2 ? Short.MAX_VALUE : -2);
            }
        }
    }

    private void initComponents() {
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)EmptySpaceCustomizer.class);
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder(resourceBundle.getString("TITLE_EmptySpace")));
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        JLabel jLabel5 = new JLabel(resourceBundle.getString("NAME_SpaceSize"));
        JLabel jLabel6 = new JLabel(resourceBundle.getString("NAME_SpaceResizable"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 6, 3, 0);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(3, 6, 6, 0);
        this.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 6, 3, 6);
        this.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(0, 6, 3, 6);
        this.add((Component)jLabel6, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.leftResizable, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.add((Component)this.rightResizable, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.add((Component)this.topResizable, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.add((Component)this.bottomResizable, gridBagConstraints);
        jLabel.setLabelFor(this.leftSize);
        jLabel2.setLabelFor(this.rightSize);
        jLabel3.setLabelFor(this.topSize);
        jLabel4.setLabelFor(this.bottomSize);
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)resourceBundle.getString("NAME_LeftSpace"));
        Mnemonics.setLocalizedText((JLabel)jLabel2, (String)resourceBundle.getString("NAME_RightSpace"));
        Mnemonics.setLocalizedText((JLabel)jLabel3, (String)resourceBundle.getString("NAME_TopSpace"));
        Mnemonics.setLocalizedText((JLabel)jLabel4, (String)resourceBundle.getString("NAME_BottomSpace"));
        this.leftSize.setEditable(true);
        this.rightSize.setEditable(true);
        this.topSize.setEditable(true);
        this.bottomSize.setEditable(true);
        this.padding = resourceBundle.getString("VALUE_DefaultPadding");
        this.leftSize.setModel(new DefaultComboBoxModel<String>(new String[]{this.padding}));
        this.rightSize.setModel(new DefaultComboBoxModel<String>(new String[]{this.padding}));
        this.topSize.setModel(new DefaultComboBoxModel<String>(new String[]{this.padding}));
        this.bottomSize.setModel(new DefaultComboBoxModel<String>(new String[]{this.padding}));
        this.leftResizable.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_LeftResizable"));
        this.rightResizable.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_RightResizable"));
        this.topResizable.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_TopResizable"));
        this.bottomResizable.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_BottomResizable"));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 6, 3, 6);
        this.add((Component)this.leftSize, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.add((Component)this.rightSize, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.add((Component)this.topSize, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(3, 6, 6, 6);
        this.add((Component)this.bottomSize, gridBagConstraints);
    }
}

