/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.actions;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.EventSetDescriptor;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.netbeans.modules.form.Event;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentCookie;
import org.openide.awt.JMenuPlus;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;

public class EventsAction
extends CookieAction {
    private ActionListener menuItemListener;

    protected int mode() {
        return 8;
    }

    protected Class[] cookieClasses() {
        return new Class[]{RADComponentCookie.class};
    }

    public String getName() {
        return NbBundle.getBundle((Class)EventsAction.class).getString("ACT_Events");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected void performAction(Node[] nodeArray) {
    }

    public JMenuItem getMenuPresenter() {
        return this.getPopupPresenter();
    }

    public JMenuItem getPopupPresenter() {
        JMenuPlus jMenuPlus = new JMenuPlus(NbBundle.getBundle((Class)EventsAction.class).getString("ACT_Events"));
        jMenuPlus.setEnabled(this.isEnabled());
        HelpCtx.setHelpIDString((JComponent)jMenuPlus, (String)EventsAction.class.getName());
        jMenuPlus.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent menuEvent) {
                JMenu jMenu = (JMenu)menuEvent.getSource();
                EventsAction.this.createEventSubmenu(jMenu);
            }

            public void menuDeselected(MenuEvent menuEvent) {
            }

            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        return jMenuPlus;
    }

    private void createEventSubmenu(JMenu jMenu) {
        Node[] nodeArray;
        if (jMenu.getMenuComponentCount() > 0) {
            jMenu.removeAll();
        }
        if ((nodeArray = this.getActivatedNodes()).length == 0) {
            return;
        }
        RADComponentCookie rADComponentCookie = (RADComponentCookie)nodeArray[0].getCookie(RADComponentCookie.class);
        if (rADComponentCookie == null) {
            return;
        }
        RADComponent rADComponent = rADComponentCookie.getRADComponent();
        if (rADComponent == null) {
            return;
        }
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)EventsAction.class);
        boolean bl = rADComponent.isReadOnly();
        Event[] eventArray = bl ? rADComponent.getKnownEvents() : rADComponent.getAllEvents();
        EventSetDescriptor eventSetDescriptor = null;
        JMenuPlus jMenuPlus = null;
        boolean bl2 = false;
        for (int i = 0; i < eventArray.length; ++i) {
            Event event = eventArray[i];
            String[] stringArray = event.getEventHandlers();
            AbstractButton abstractButton = null;
            if (stringArray.length == 0) {
                if (!bl) {
                    abstractButton = new EventMenuItem(MessageFormat.format(resourceBundle.getString("FMT_CTL_EventNoHandlers"), event.getName()), event, null);
                }
            } else if (stringArray.length == 1) {
                abstractButton = new EventMenuItem(MessageFormat.format(resourceBundle.getString("FMT_CTL_EventOneHandler"), event.getName(), stringArray[0]), event, stringArray[0]);
            } else {
                abstractButton = new JMenuPlus(MessageFormat.format(resourceBundle.getString("FMT_CTL_EventMultipleHandlers"), event.getName()));
                for (int j = 0; j < stringArray.length; ++j) {
                    EventMenuItem eventMenuItem = new EventMenuItem(MessageFormat.format(resourceBundle.getString("FMT_CTL_HandlerFromMultiple"), stringArray[j]), event, stringArray[j]);
                    eventMenuItem.addActionListener(this.getMenuItemListener());
                    HelpCtx.setHelpIDString((JComponent)eventMenuItem, (String)(class$org$netbeans$modules$form$actions$EventsAction == null ? EventsAction.class$("org.netbeans.modules.form.actions.EventsAction") : class$org$netbeans$modules$form$actions$EventsAction).getName());
                    EventsAction.setBoldFontForMenuText(eventMenuItem);
                    ((JMenu)abstractButton).add(eventMenuItem);
                }
            }
            if (abstractButton == null) continue;
            if (event.getEventSetDescriptor() != eventSetDescriptor) {
                if (bl2) {
                    EventsAction.setBoldFontForMenuText(jMenuPlus);
                }
                String string = event.getEventSetDescriptor().getName();
                jMenuPlus = new JMenuPlus(string.substring(0, 1).toUpperCase() + string.substring(1));
                HelpCtx.setHelpIDString((JComponent)jMenuPlus, (String)(class$org$netbeans$modules$form$actions$EventsAction == null ? EventsAction.class$("org.netbeans.modules.form.actions.EventsAction") : class$org$netbeans$modules$form$actions$EventsAction).getName());
                EventsAction.addSortedMenuItem(jMenu, (JMenuItem)jMenuPlus);
                bl2 = false;
                eventSetDescriptor = event.getEventSetDescriptor();
            }
            if (!(abstractButton instanceof JMenu)) {
                abstractButton.addActionListener(this.getMenuItemListener());
            }
            HelpCtx.setHelpIDString((JComponent)abstractButton, (String)(class$org$netbeans$modules$form$actions$EventsAction == null ? EventsAction.class$("org.netbeans.modules.form.actions.EventsAction") : class$org$netbeans$modules$form$actions$EventsAction).getName());
            if (stringArray.length > 0 && !bl) {
                bl2 = true;
                EventsAction.setBoldFontForMenuText((JMenuItem)abstractButton);
            }
            EventsAction.addSortedMenuItem(jMenuPlus, (JMenuItem)abstractButton);
        }
        if (bl2) {
            EventsAction.setBoldFontForMenuText(jMenuPlus);
        }
    }

    private static void setBoldFontForMenuText(JMenuItem jMenuItem) {
        Font font = jMenuItem.getFont();
        jMenuItem.setFont(font.deriveFont(font.getStyle() | 1));
    }

    private static void addSortedMenuItem(JMenu jMenu, JMenuItem jMenuItem) {
        int n = jMenu.getMenuComponentCount();
        String string = jMenuItem.getText();
        for (int i = 0; i < n; ++i) {
            String string2 = ((JMenuItem)jMenu.getMenuComponent(i)).getText();
            if (string.compareTo(string2) >= 0) continue;
            jMenu.add((Component)jMenuItem, i);
            return;
        }
        jMenu.add(jMenuItem);
    }

    private ActionListener getMenuItemListener() {
        if (this.menuItemListener == null) {
            this.menuItemListener = new EventMenuItemListener();
        }
        return this.menuItemListener;
    }

    private static class EventMenuItemListener
    implements ActionListener {
        private EventMenuItemListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (!(object instanceof EventMenuItem)) {
                return;
            }
            EventMenuItem eventMenuItem = (EventMenuItem)object;
            Event event = ((EventMenuItem)object).getEvent();
            Node.Property property = event.getComponent().getPropertyByName(event.getId());
            if (property != null) {
                String string = eventMenuItem.getHandlerName();
                event.getComponent().getFormModel().getFormEvents().attachEvent(event, string, null);
                try {
                    if (string == null) {
                        string = (String)property.getValue();
                    }
                    property.setValue((Object)string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static class EventMenuItem
    extends JMenuItem {
        private Event event;
        private String handlerName;

        EventMenuItem(String string, Event event, String string2) {
            super(string);
            this.event = event;
            this.handlerName = string2;
        }

        Event getEvent() {
            return this.event;
        }

        String getHandlerName() {
            return this.handlerName;
        }
    }
}

