/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.actions;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.modules.form.RADProperty;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PropertyAction
extends AbstractAction {
    private static final String OK_COMMAND = "OK";
    private static final String CANCEL_COMMAND = "Cancel";
    private static final String RESTORE_COMMAND = "Restore";
    private RADProperty property;
    private Dialog dialog;

    public PropertyAction(RADProperty rADProperty) {
        this.property = rADProperty;
        String string = (String)rADProperty.getValue("actionName");
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer(rADProperty.getName());
            stringBuffer.setCharAt(0, Character.toUpperCase(stringBuffer.charAt(0)));
            string = stringBuffer.toString();
        }
        this.putValue("Name", string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            PropertyEditor propertyEditor = this.property.getPropertyEditor();
            propertyEditor.setValue(this.property.getValue());
            final Component component = propertyEditor.getCustomEditor();
            Object[] objectArray = this.buttons();
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)component, (String)this.getValue("Name"), true, objectArray, DialogDescriptor.CANCEL_OPTION, 0, HelpCtx.DEFAULT_HELP, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        String string = actionEvent.getActionCommand();
                        if (PropertyAction.OK_COMMAND.equals(string)) {
                            Object object = ((EnhancedCustomPropertyEditor)component).getPropertyValue();
                            PropertyAction.this.property.setValue(object);
                        } else if (PropertyAction.RESTORE_COMMAND.equals(string)) {
                            PropertyAction.this.property.restoreDefaultValue();
                        }
                        PropertyAction.this.dialog.dispose();
                    }
                    catch (Exception exception) {
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getBundle((Class)(class$org$netbeans$modules$form$actions$PropertyAction == null ? (class$org$netbeans$modules$form$actions$PropertyAction = PropertyAction.class$("org.netbeans.modules.form.actions.PropertyAction")) : class$org$netbeans$modules$form$actions$PropertyAction)).getString("MSG_InvalidValue"));
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    }
                }
            });
            dialogDescriptor.setClosingOptions(new Object[0]);
            this.dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            this.dialog.setVisible(true);
            this.dialog = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Object[] buttons() {
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)PropertyAction.class);
        JButton jButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)resourceBundle.getString("CTL_OK"));
        jButton.setActionCommand(OK_COMMAND);
        JButton jButton2 = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton2, (String)resourceBundle.getString("CTL_Cancel"));
        jButton2.setActionCommand(CANCEL_COMMAND);
        if (this.property.isDefaultValue()) {
            return new Object[]{jButton, jButton2};
        }
        JButton jButton3 = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton3, (String)resourceBundle.getString("CTL_RestoreDefault"));
        jButton3.setActionCommand(RESTORE_COMMAND);
        return new Object[]{jButton, jButton3, jButton2};
    }
}

