/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors2;

import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.border.Border;
import org.netbeans.modules.form.BeanSupport;
import org.netbeans.modules.form.CreationDescriptor;
import org.netbeans.modules.form.CreationFactory;
import org.netbeans.modules.form.FormDesignValue;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyContext;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.editors2.BorderEditor;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.Utilities;

public class BorderDesignSupport
implements FormDesignValue {
    private Border theBorder;
    private boolean borderNeedsUpdate;
    private boolean propertiesNeedInit;
    private CreationDescriptor creationDesc;
    private FormPropertyContext propertyContext = null;
    private FormProperty[] properties = null;

    public BorderDesignSupport(Class clazz) throws Exception {
        this.creationDesc = CreationFactory.getDescriptor(clazz);
        if (this.creationDesc == null) {
            this.creationDesc = new CreationDescriptor(clazz);
            CreationFactory.registerDescriptor(this.creationDesc);
        }
        this.theBorder = (Border)CreationFactory.createInstance(clazz);
    }

    public BorderDesignSupport(Border border) {
        this.creationDesc = CreationFactory.getDescriptor(border.getClass());
        if (this.creationDesc == null) {
            this.creationDesc = new CreationDescriptor(border.getClass());
            CreationFactory.registerDescriptor(this.creationDesc);
        }
        this.setBorder(border);
    }

    public BorderDesignSupport(BorderDesignSupport borderDesignSupport, FormPropertyContext formPropertyContext) throws Exception {
        this(borderDesignSupport.getBorderClass());
        this.createProperties();
        this.setPropertyContext(formPropertyContext);
        int n = 3;
        if (borderDesignSupport.propertyContext.getFormModel() == formPropertyContext.getFormModel()) {
            n |= 4;
        }
        FormUtils.copyProperties(borderDesignSupport.getProperties(), this.properties, n);
    }

    public FormDesignValue copy(FormModel formModel) {
        try {
            return new BorderDesignSupport(this, BorderEditor.createFormPropertyContext(formModel));
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
            return null;
        }
    }

    public Border getBorder() {
        if (this.borderNeedsUpdate) {
            this.updateBorder();
        }
        return this.theBorder;
    }

    public void setBorder(Border border) {
        this.theBorder = border;
        if (this.properties != null) {
            for (int i = 0; i < this.properties.length; ++i) {
                try {
                    this.properties[i].reinstateProperty();
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    continue;
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            this.propertiesNeedInit = false;
        } else {
            this.propertiesNeedInit = true;
        }
        this.borderNeedsUpdate = false;
    }

    public Class getBorderClass() {
        return this.creationDesc.getDescribedClass();
    }

    public String getDisplayName() {
        return Utilities.getShortClassName(this.theBorder.getClass());
    }

    public void setPropertyContext(FormPropertyContext formPropertyContext) {
        if (this.properties != null && this.propertyContext != formPropertyContext) {
            for (int i = 0; i < this.properties.length; ++i) {
                if (this.properties[i].getValueType().isPrimitive()) continue;
                this.properties[i].setPropertyContext(formPropertyContext);
            }
        }
        this.propertyContext = formPropertyContext;
    }

    public Node.Property[] getProperties() {
        if (this.properties == null) {
            this.createProperties();
        }
        return this.properties;
    }

    public Node.Property getPropertyOfName(String string) {
        Node.Property[] propertyArray = this.getProperties();
        for (int i = 0; i < propertyArray.length; ++i) {
            if (!propertyArray[i].getName().equals(string)) continue;
            return propertyArray[i];
        }
        return null;
    }

    private void createProperties() {
        BeanInfo beanInfo = BeanSupport.createBeanInfo(this.theBorder.getClass());
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        ArrayList<BorderProperty> arrayList = new ArrayList<BorderProperty>();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
            if (propertyDescriptor.isHidden() || propertyDescriptor.getWriteMethod() == null && !CreationFactory.containsProperty(this.creationDesc, propertyDescriptor.getName())) continue;
            BorderProperty borderProperty = new BorderProperty(propertyDescriptor.getPropertyType().isPrimitive() ? null : this.propertyContext, propertyDescriptor);
            if (this.propertiesNeedInit) {
                try {
                    borderProperty.reinstateProperty();
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            arrayList.add(borderProperty);
        }
        this.properties = new FormProperty[arrayList.size()];
        arrayList.toArray(this.properties);
        this.propertiesNeedInit = false;
    }

    public String getJavaInitializationString() {
        if (this.properties == null) {
            this.createProperties();
        }
        CreationDescriptor.Creator creator = this.creationDesc.findBestCreator(this.properties, 3);
        return creator.getJavaCreationCode(this.properties);
    }

    void updateBorder() {
        if (this.properties == null) {
            this.createProperties();
        }
        CreationDescriptor.Creator creator = this.creationDesc.findBestCreator(this.properties, 3);
        try {
            this.theBorder = (Border)CreationFactory.createInstance(this.creationDesc.getDescribedClass(), this.properties, 3);
            FormProperty[] formPropertyArray = CreationFactory.getRemainingProperties(creator, this.properties);
            for (int i = 0; i < formPropertyArray.length; ++i) {
                formPropertyArray[i].reinstateTarget();
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
    }

    public Object getDesignValue() {
        return this.getBorder();
    }

    public String getDescription() {
        return this.getDisplayName();
    }

    public class BorderProperty
    extends FormProperty {
        private PropertyDescriptor desc;

        public BorderProperty(FormPropertyContext formPropertyContext, PropertyDescriptor propertyDescriptor) {
            super(formPropertyContext, propertyDescriptor.getName(), propertyDescriptor.getPropertyType(), propertyDescriptor.getDisplayName(), propertyDescriptor.getShortDescription());
            this.desc = propertyDescriptor;
            if (propertyDescriptor.getWriteMethod() == null) {
                this.setAccessType(2);
            } else if (propertyDescriptor.getReadMethod() == null) {
                this.setAccessType(1);
            }
        }

        public Object getTargetValue() throws IllegalAccessException, InvocationTargetException {
            Method method = this.desc.getReadMethod();
            return method.invoke((Object)BorderDesignSupport.this.theBorder, new Object[0]);
        }

        public void setTargetValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            Method method = this.desc.getWriteMethod();
            method.invoke((Object)BorderDesignSupport.this.theBorder, object);
        }

        protected Object getRealValue(Object object) {
            Object object2 = super.getRealValue(object);
            if (object2 == FormDesignValue.IGNORED_VALUE && "title".equals(this.desc.getName())) {
                object2 = ((FormDesignValue)object).getDescription();
            }
            return object2;
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public Object getDefaultValue() {
            Method method = this.desc.getReadMethod();
            Object object = null;
            if (method != null) {
                try {
                    object = method.invoke(BeanSupport.getDefaultInstance(BorderDesignSupport.this.theBorder.getClass()), new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return object;
        }

        public PropertyEditor getExpliciteEditor() {
            if (this.desc.getPropertyEditorClass() != null) {
                try {
                    return (PropertyEditor)this.desc.getPropertyEditorClass().newInstance();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return null;
        }

        protected Method getWriteMethod() {
            return this.desc.getWriteMethod();
        }

        protected void propertyValueChanged(Object object, Object object2) {
            super.propertyValueChanged(object, object2);
            BorderDesignSupport.this.borderNeedsUpdate = (this.getAccessType() & 2) != 0;
        }
    }
}

