/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.netbeans.modules.form.BeanPropertyEditor;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormDesignValue;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyContext;
import org.netbeans.modules.form.FormPropertyEditorManager;
import org.netbeans.modules.form.NamedPropertyEditor;
import org.netbeans.modules.form.editors2.BorderDesignSupport;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.propertysheet.PropertySheetView;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.explorer.view.ListView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public final class BorderEditor
extends PropertyEditorSupport
implements FormAwareEditor,
XMLPropertyEditor,
NamedPropertyEditor,
BeanPropertyEditor {
    private static final String UNKNOWN_BORDER_BASE = "org/netbeans/modules/form/editors2/unknownBorder";
    private static final String NO_BORDER_BASE = "org/netbeans/modules/form/editors2/nullBorder";
    private static Node.Property[] EMPTY_PROPERTIES = new Node.Property[0];
    private Object current = null;
    private FormPropertyContext propertyContext;
    private BorderDesignSupport borderSupport;
    private BorderPanel bPanel = null;
    private static final String XML_BORDER = "Border";
    private static final String ATTR_INFO = "info";
    private static final String PROP_NAME = "PropertyName";
    private static final String ID_BI_NULL_BORDER = "null";
    private static final String XML_TITLED_BORDER = "TitledBorder";
    private static final String ID_BI_TITLED = "org.netbeans.modules.form.compat2.border.TitledBorderInfo";
    private static final String ATTR_TITLE = "title";
    private static final String ATTR_TITLE_X = "titleX";
    private static final String ATTR_BORDER = "innerBorder";
    private static final String ATTR_JUSTIFICATION = "justification";
    private static final String ATTR_POSITION = "position";
    private static final String ATTR_FONT = "font";
    private static final String ATTR_TITLE_COLOR = "color";
    private static final String XML_ETCHED_BORDER = "EtchetBorder";
    private static final String ID_BI_ETCHED = "org.netbeans.modules.form.compat2.border.EtchedBorderInfo";
    private static final String ATTR_ETCH_TYPE = "bevelType";
    private static final String ATTR_HIGHLIGHT = "highlight";
    private static final String ATTR_SHADOW = "shadow";
    private static final String XML_LINE_BORDER = "LineBorder";
    private static final String ID_BI_LINE = "org.netbeans.modules.form.compat2.border.LineBorderInfo";
    private static final String ATTR_THICKNESS = "thickness";
    private static final String ATTR_LINE_COLOR = "color";
    private static final String ATTR_CORNERS = "roundedCorners";
    private static final String XML_EMPTY_BORDER = "EmptyBorder";
    private static final String ID_BI_EMPTY = "org.netbeans.modules.form.compat2.border.EmptyBorderInfo";
    private static final String ATTR_TOP = "top";
    private static final String ATTR_LEFT = "left";
    private static final String ATTR_RIGHT = "right";
    private static final String ATTR_BOTTOM = "bottom";
    private static final String XML_COMPOUND_BORDER = "CompundBorder";
    private static final String ID_BI_COMPOUND = "org.netbeans.modules.form.compat2.border.CompoundBorderInfo";
    private static final String ATTR_OUTSIDE = "outside";
    private static final String ATTR_INSIDE = "inside";
    private static final String XML_BEVEL_BORDER = "BevelBorder";
    private static final String ID_BI_BEVEL = "org.netbeans.modules.form.compat2.border.BevelBorderInfo";
    private static final String ID_BI_SOFTBEVEL = "org.netbeans.modules.form.compat2.border.SoftBevelBorderInfo";
    private static final String ATTR_BEVEL_TYPE = "bevelType";
    private static final String ATTR_HIGHLIGHT_OUTER = "highlightOuter";
    private static final String ATTR_HIGHLIGHT_INNER = "highlightInner";
    private static final String ATTR_SHADOW_OUTER = "shadowOuter";
    private static final String ATTR_SHADOW_INNER = "shadowInner";
    private static final String XML_MATTE_COLOR_BORDER = "MatteColorBorder";
    private static final String XML_MATTE_ICON_BORDER = "MatteIconBorder";
    private static final String ID_BI_MATTECOLOR = "org.netbeans.modules.form.compat2.border.MatteColorBorderInfo";
    private static final String ID_BI_MATTEICON = "org.netbeans.modules.form.compat2.border.MatteIconBorderInfo";
    private static final String ATTR_MATTE_COLOR = "color";
    private static final String ATTR_MATTE_ICON = "icon";

    public void setFormModel(FormModel formModel) {
        this.propertyContext = BorderEditor.createFormPropertyContext(formModel);
    }

    public static FormPropertyContext createFormPropertyContext(FormModel formModel) {
        return new FormPropertyContext.DefaultImpl(formModel);
    }

    public Object getValue() {
        return this.current;
    }

    public void setValue(Object object) {
        if (this.current == object) {
            return;
        }
        this.current = object;
        this.borderSupport = null;
        if (object instanceof BorderDesignSupport) {
            this.borderSupport = (BorderDesignSupport)object;
        } else if (object instanceof Border && !(object instanceof UIResource)) {
            this.borderSupport = new BorderDesignSupport((Border)object);
        }
        if (this.borderSupport != null) {
            this.borderSupport.setPropertyContext(this.propertyContext);
            if (this.bPanel != null) {
                this.bPanel.setValue(object);
            }
        }
    }

    public String getAsText() {
        return null;
    }

    public void setAsText(String string) {
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        Object object = this.getValue();
        String string = object == null ? BorderEditor.getBundle().getString("LAB_NoBorder") : (this.borderSupport != null ? "[" + this.borderSupport.getDisplayName() + "]" : "[" + Utilities.getShortClassName(object.getClass()) + "]");
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.drawString(string, rectangle.x, rectangle.y + (rectangle.height - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent());
    }

    public String getJavaInitializationString() {
        Object object = this.getValue();
        if (object == null) {
            return ID_BI_NULL_BORDER;
        }
        if (this.borderSupport != null) {
            return this.borderSupport.getJavaInitializationString();
        }
        return null;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        if (this.bPanel == null) {
            this.bPanel = new BorderPanel();
        }
        this.bPanel.setValue(this.current);
        return this.bPanel;
    }

    public String getDisplayName() {
        return BorderEditor.getBundle().getString("CTL_BorderEditor_DisplayName");
    }

    void updateBorder(Node node) {
        if (node instanceof NoBorderNode) {
            this.borderSupport = null;
            this.current = null;
        } else if (node instanceof UnknownBorderNode) {
            this.current = ((UnknownBorderNode)node).getBorder();
        } else {
            this.borderSupport = ((BorderNode)node).getBorderSupport();
            this.current = this.borderSupport;
        }
    }

    private static ResourceBundle getBundle() {
        return NbBundle.getBundle((Class)BorderEditor.class);
    }

    public org.w3c.dom.Node storeToXML(Document document) {
        Object object = this.getValue();
        if ((object instanceof BorderDesignSupport || object instanceof Border) && this.borderSupport != null) {
            org.w3c.dom.Node node = null;
            Class clazz = this.borderSupport.getBorderClass();
            if (clazz.isAssignableFrom(TitledBorder.class)) {
                node = this.storeTitledBorder(document);
            } else if (clazz.isAssignableFrom(EtchedBorder.class)) {
                node = this.storeEtchedBorder(document);
            } else if (clazz.isAssignableFrom(LineBorder.class)) {
                node = this.storeLineBorder(document);
            } else if (clazz.isAssignableFrom(EmptyBorder.class)) {
                node = this.storeEmptyBorder(document);
            } else if (clazz.isAssignableFrom(CompoundBorder.class)) {
                node = this.storeCompoundBorder(document);
            } else if (SoftBevelBorder.class.isAssignableFrom(clazz)) {
                node = this.storeBevelBorder(document, ID_BI_SOFTBEVEL);
            } else if (BevelBorder.class.isAssignableFrom(clazz)) {
                node = this.storeBevelBorder(document, ID_BI_BEVEL);
            } else if (clazz.isAssignableFrom(MatteBorder.class)) {
                node = this.storeMatteBorder(document);
            }
            return node;
        }
        if (object == null) {
            return this.storeNullBorder(document);
        }
        return null;
    }

    public void readFromXML(org.w3c.dom.Node node) throws IOException {
        if (!XML_BORDER.equals(node.getNodeName())) {
            IOException iOException = new IOException("Missing \"Border\" XML element");
            ErrorManager.getDefault().annotate((Throwable)iOException, BorderEditor.getBundle().getString("MSG_ERR_MissingMainElement"));
            throw iOException;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = namedNodeMap.getNamedItem(ATTR_INFO).getNodeValue();
        if (ID_BI_NULL_BORDER.equals(string)) {
            return;
        }
        org.w3c.dom.Node node2 = null;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            node2 = nodeList.item(i);
            break;
        }
        if (node2 == null) {
            IOException iOException = new IOException("Missing border data");
            ErrorManager.getDefault().annotate((Throwable)iOException, BorderEditor.getBundle().getString("MSG_ERR_MissingBorderData"));
            throw iOException;
        }
        if (ID_BI_TITLED.equals(string)) {
            this.readTitledBorder(node2);
        } else if (ID_BI_ETCHED.equals(string)) {
            this.readEtchedBorder(node2);
        } else if (ID_BI_LINE.equals(string)) {
            this.readLineBorder(node2);
        } else if (ID_BI_EMPTY.equals(string)) {
            this.readEmptyBorder(node2);
        } else if (ID_BI_COMPOUND.equals(string)) {
            this.readCompoundBorder(node2);
        } else if (ID_BI_SOFTBEVEL.equals(string)) {
            this.readBevelBorder(node2, SoftBevelBorder.class);
        } else if (ID_BI_BEVEL.equals(string)) {
            this.readBevelBorder(node2, BevelBorder.class);
        } else if (ID_BI_MATTECOLOR.equals(string) || ID_BI_MATTEICON.equals(string)) {
            this.readMatteBorder(node2);
        } else if (ID_BI_NULL_BORDER.equals(string)) {
            this.borderSupport = null;
        }
        this.current = this.borderSupport;
    }

    private Element createBorderInfoNode(Document document, String string) {
        Element element = document.createElement(XML_BORDER);
        element.setAttribute(ATTR_INFO, string);
        return element;
    }

    private static void writeProperty(String string, FormProperty formProperty, Element element, Document document) {
        org.w3c.dom.Node node = null;
        PropertyEditor propertyEditor = formProperty.getCurrentEditor();
        if (propertyEditor instanceof XMLPropertyEditor) {
            Object object;
            try {
                object = formProperty.getValue();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
            propertyEditor.setValue(object);
            node = ((XMLPropertyEditor)propertyEditor).storeToXML(document);
            if (node != null) {
                element.appendChild(node);
                if (node.getNodeType() == 1) {
                    ((Element)node).setAttribute(PROP_NAME, string);
                }
                return;
            }
        }
    }

    private static Object readProperty(String string, String string2, BorderDesignSupport borderDesignSupport, org.w3c.dom.Node node) throws IOException {
        boolean bl = false;
        Object object = null;
        org.w3c.dom.Node node2 = null;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1 || !((Element)nodeList.item(i)).getAttribute(PROP_NAME).equals(string)) continue;
            node2 = nodeList.item(i);
            break;
        }
        if (node2 != null) {
            FormProperty formProperty = (FormProperty)borderDesignSupport.getPropertyOfName(string2);
            if (formProperty == null) {
                IOException iOException = new IOException("Unknown property");
                ErrorManager.getDefault().annotate((Throwable)iOException, MessageFormat.format(BorderEditor.getBundle().getString("FMT_ERR_UnknownProperty"), string2, borderDesignSupport.getBorderClass().getName()));
                throw iOException;
            }
            IOException iOException = null;
            PropertyEditor[] propertyEditorArray = FormPropertyEditorManager.getAllEditors(formProperty);
            for (int i = 0; i < propertyEditorArray.length && !bl; ++i) {
                PropertyEditor propertyEditor = propertyEditorArray[i];
                if (!(propertyEditor instanceof XMLPropertyEditor)) continue;
                try {
                    formProperty.getPropertyContext().initPropertyEditor(propertyEditor);
                    ((XMLPropertyEditor)propertyEditor).readFromXML(node2);
                    object = propertyEditor.getValue();
                    formProperty.setValue(object);
                    formProperty.setCurrentEditor(propertyEditor);
                    bl = true;
                    continue;
                }
                catch (IOException iOException2) {
                    iOException = iOException2;
                    continue;
                }
                catch (Exception exception) {
                    iOException = new IOException();
                    ErrorManager.getDefault().annotate((Throwable)iOException, (Throwable)exception);
                }
            }
            if (!bl && iOException != null) {
                ErrorManager.getDefault().annotate((Throwable)iOException, MessageFormat.format(BorderEditor.getBundle().getString("FMT_ERR_CannotReadBorderProperty"), string));
                throw iOException;
            }
        }
        return object;
    }

    private org.w3c.dom.Node storeNullBorder(Document document) {
        try {
            return this.createBorderInfoNode(document, ID_BI_NULL_BORDER);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private org.w3c.dom.Node storeTitledBorder(Document document) {
        try {
            Object object;
            Element element = document.createElement(XML_TITLED_BORDER);
            FormProperty formProperty = (FormProperty)this.borderSupport.getPropertyOfName("border");
            if (formProperty != null && formProperty.isChanged()) {
                BorderEditor.writeProperty(ATTR_BORDER, formProperty, element, document);
            }
            if ((formProperty = (FormProperty)this.borderSupport.getPropertyOfName(ATTR_TITLE)) != null && formProperty.isChanged()) {
                object = formProperty.getRealValue();
                element.setAttribute(ATTR_TITLE, object instanceof String ? (String)object : "");
                Object object2 = formProperty.getValue();
                if (object2 instanceof FormDesignValue) {
                    BorderEditor.writeProperty(ATTR_TITLE_X, formProperty, element, document);
                }
            }
            if ((formProperty = (FormProperty)this.borderSupport.getPropertyOfName("titleJustification")) != null && formProperty.isChanged()) {
                element.setAttribute(ATTR_JUSTIFICATION, formProperty.getRealValue().toString());
            }
            if ((formProperty = (FormProperty)this.borderSupport.getPropertyOfName("titlePosition")) != null && formProperty.isChanged()) {
                element.setAttribute(ATTR_POSITION, formProperty.getRealValue().toString());
            }
            if ((formProperty = (FormProperty)this.borderSupport.getPropertyOfName("titleFont")) != null && formProperty.isChanged()) {
                BorderEditor.writeProperty(ATTR_FONT, formProperty, element, document);
            }
            if ((formProperty = (FormProperty)this.borderSupport.getPropertyOfName("titleColor")) != null && formProperty.isChanged()) {
                BorderEditor.writeProperty("color", formProperty, element, document);
            }
            object = this.createBorderInfoNode(document, ID_BI_TITLED);
            object.appendChild(element);
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void readTitledBorder(org.w3c.dom.Node node) throws IOException {
        if (!XML_TITLED_BORDER.equals(node.getNodeName())) {
            throw new IOException("Invalid format: missing \"TitledBorder\" element.");
        }
        try {
            FormProperty formProperty;
            org.w3c.dom.Node node2;
            NamedNodeMap namedNodeMap = node.getAttributes();
            this.borderSupport = new BorderDesignSupport(TitledBorder.class);
            this.borderSupport.setPropertyContext(this.propertyContext);
            BorderEditor.readProperty(ATTR_BORDER, "border", this.borderSupport, node);
            Object object = BorderEditor.readProperty(ATTR_TITLE_X, ATTR_TITLE, this.borderSupport, node);
            if (object == null && (node2 = namedNodeMap.getNamedItem(ATTR_TITLE)) != null && (formProperty = (FormProperty)this.borderSupport.getPropertyOfName(ATTR_TITLE)) != null) {
                formProperty.setValue(node2.getNodeValue());
            }
            if ((node2 = namedNodeMap.getNamedItem(ATTR_JUSTIFICATION)) != null && (formProperty = (FormProperty)this.borderSupport.getPropertyOfName("titleJustification")) != null) {
                formProperty.setValue(new Integer(node2.getNodeValue()));
            }
            if ((node2 = namedNodeMap.getNamedItem(ATTR_POSITION)) != null && (formProperty = (FormProperty)this.borderSupport.getPropertyOfName("titlePosition")) != null) {
                formProperty.setValue(new Integer(node2.getNodeValue()));
            }
            BorderEditor.readProperty(ATTR_FONT, "titleFont", this.borderSupport, node);
            BorderEditor.readProperty("color", "titleColor", this.borderSupport, node);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            IOException iOException = new IOException();
            ErrorManager.getDefault().annotate((Throwable)iOException, (Throwable)exception);
            throw iOException;
        }
    }

    public org.w3c.dom.Node storeEtchedBorder(Document document) {
        try {
            Element element = document.createElement(XML_ETCHED_BORDER);
            FormProperty formProperty = (FormProperty)this.borderSupport.getPropertyOfName("etchType");
            if (formProperty != null && formProperty.isChanged()) {
                element.setAttribute("bevelType", formProperty.getRealValue().toString());
            }
            if ((formProperty = (FormProperty)this.borderSupport.getPropertyOfName("highlightColor")) != null && formProperty.isChanged()) {
                BorderEditor.writeProperty(ATTR_HIGHLIGHT, formProperty, element, document);
            }
            if ((formProperty = (FormProperty)this.borderSupport.getPropertyOfName("shadowColor")) != null && formProperty.isChanged()) {
                BorderEditor.writeProperty(ATTR_SHADOW, formProperty, element, document);
            }
            Element element2 = this.createBorderInfoNode(document, ID_BI_ETCHED);
            element2.appendChild(element);
            return element2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void readEtchedBorder(org.w3c.dom.Node node) throws IOException {
        if (!XML_ETCHED_BORDER.equals(node.getNodeName())) {
            throw new IOException("Invalid format: missing \"EtchetBorder\" element.");
        }
        try {
            FormProperty formProperty;
            NamedNodeMap namedNodeMap = node.getAttributes();
            this.borderSupport = new BorderDesignSupport(EtchedBorder.class);
            this.borderSupport.setPropertyContext(this.propertyContext);
            org.w3c.dom.Node node2 = namedNodeMap.getNamedItem("bevelType");
            if (node2 != null && (formProperty = (FormProperty)this.borderSupport.getPropertyOfName("etchType")) != null) {
                formProperty.setValue(new Integer(node2.getNodeValue()));
            }
            BorderEditor.readProperty(ATTR_HIGHLIGHT, "highlightColor", this.borderSupport, node);
            BorderEditor.readProperty(ATTR_SHADOW, "shadowColor", this.borderSupport, node);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            IOException iOException = new IOException();
            ErrorManager.getDefault().annotate((Throwable)iOException, (Throwable)exception);
            throw iOException;
        }
    }

    public org.w3c.dom.Node storeLineBorder(Document document) {
        try {
            Element element = document.createElement(XML_LINE_BORDER);
            FormProperty formProperty = (FormProperty)this.borderSupport.getPropertyOfName("lineColor");
            if (formProperty != null && formProperty.isChanged()) {
                BorderEditor.writeProperty("color", formProperty, element, document);
            }
            if ((formProperty = (FormProperty)this.borderSupport.getPropertyOfName(ATTR_THICKNESS)) != null && formProperty.isChanged()) {
                element.setAttribute(ATTR_THICKNESS, formProperty.getRealValue().toString());
            }
            if ((formProperty = (FormProperty)this.borderSupport.getPropertyOfName(ATTR_CORNERS)) != null && formProperty.isChanged()) {
                element.setAttribute(ATTR_CORNERS, formProperty.getRealValue().toString());
            }
            Element element2 = this.createBorderInfoNode(document, ID_BI_LINE);
            element2.appendChild(element);
            return element2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void readLineBorder(org.w3c.dom.Node node) throws IOException {
        if (!XML_LINE_BORDER.equals(node.getNodeName())) {
            throw new IOException("Invalid format: missing \"LineBorder\" element.");
        }
        try {
            FormProperty formProperty;
            NamedNodeMap namedNodeMap = node.getAttributes();
            this.borderSupport = new BorderDesignSupport(LineBorder.class);
            this.borderSupport.setPropertyContext(this.propertyContext);
            BorderEditor.readProperty("color", "lineColor", this.borderSupport, node);
            org.w3c.dom.Node node2 = namedNodeMap.getNamedItem(ATTR_THICKNESS);
            if (node2 != null && (formProperty = (FormProperty)this.borderSupport.getPropertyOfName(ATTR_THICKNESS)) != null) {
                formProperty.setValue(new Integer(node2.getNodeValue()));
            }
            if ((node2 = namedNodeMap.getNamedItem(ATTR_CORNERS)) != null && (formProperty = (FormProperty)this.borderSupport.getPropertyOfName(ATTR_CORNERS)) != null) {
                formProperty.setValue(Boolean.valueOf(node2.getNodeValue()));
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            IOException iOException = new IOException();
            ErrorManager.getDefault().annotate((Throwable)iOException, (Throwable)exception);
            throw iOException;
        }
    }

    public org.w3c.dom.Node storeEmptyBorder(Document document) {
        try {
            Object object;
            Object object2;
            Element element = document.createElement(XML_EMPTY_BORDER);
            FormProperty formProperty = (FormProperty)this.borderSupport.getPropertyOfName("borderInsets");
            if (formProperty != null && formProperty.isChanged() && (object2 = formProperty.getRealValue()) instanceof Insets) {
                object = (Insets)object2;
                element.setAttribute(ATTR_TOP, Integer.toString(((Insets)object).top));
                element.setAttribute(ATTR_LEFT, Integer.toString(((Insets)object).left));
                element.setAttribute(ATTR_BOTTOM, Integer.toString(((Insets)object).bottom));
                element.setAttribute(ATTR_RIGHT, Integer.toString(((Insets)object).right));
            }
            object = this.createBorderInfoNode(document, ID_BI_EMPTY);
            object.appendChild(element);
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void readEmptyBorder(org.w3c.dom.Node node) throws IOException {
        if (!XML_EMPTY_BORDER.equals(node.getNodeName())) {
            throw new IOException("Invalid format: missing \"EmptyBorder\" element.");
        }
        try {
            FormProperty formProperty;
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = 1;
            int n2 = 1;
            int n3 = 1;
            int n4 = 1;
            org.w3c.dom.Node node2 = namedNodeMap.getNamedItem(ATTR_TOP);
            if (node2 != null) {
                n = Integer.parseInt(node2.getNodeValue());
            }
            if ((node2 = namedNodeMap.getNamedItem(ATTR_LEFT)) != null) {
                n2 = Integer.parseInt(node2.getNodeValue());
            }
            if ((node2 = namedNodeMap.getNamedItem(ATTR_BOTTOM)) != null) {
                n3 = Integer.parseInt(node2.getNodeValue());
            }
            if ((node2 = namedNodeMap.getNamedItem(ATTR_RIGHT)) != null) {
                n4 = Integer.parseInt(node2.getNodeValue());
            }
            this.borderSupport = new BorderDesignSupport(EmptyBorder.class);
            this.borderSupport.setPropertyContext(this.propertyContext);
            if ((n != 1 || n2 != 1 || n3 != 1 || n4 != 1) && (formProperty = (FormProperty)this.borderSupport.getPropertyOfName("borderInsets")) != null) {
                formProperty.setValue(new Insets(n, n2, n3, n4));
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException();
            ErrorManager.getDefault().annotate((Throwable)iOException, (Throwable)exception);
            throw iOException;
        }
    }

    private org.w3c.dom.Node storeCompoundBorder(Document document) {
        try {
            Element element = document.createElement(XML_COMPOUND_BORDER);
            FormProperty formProperty = (FormProperty)this.borderSupport.getPropertyOfName("outsideBorder");
            if (formProperty != null && formProperty.isChanged()) {
                BorderEditor.writeProperty(ATTR_OUTSIDE, formProperty, element, document);
            }
            if ((formProperty = (FormProperty)this.borderSupport.getPropertyOfName("insideBorder")) != null && formProperty.isChanged()) {
                BorderEditor.writeProperty(ATTR_INSIDE, formProperty, element, document);
            }
            Element element2 = this.createBorderInfoNode(document, ID_BI_COMPOUND);
            element2.appendChild(element);
            return element2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void readCompoundBorder(org.w3c.dom.Node node) throws IOException {
        if (!XML_COMPOUND_BORDER.equals(node.getNodeName())) {
            throw new IOException("Invalid format: missing \"CompundBorder\" element.");
        }
        try {
            NamedNodeMap namedNodeMap = node.getAttributes();
            this.borderSupport = new BorderDesignSupport(CompoundBorder.class);
            this.borderSupport.setPropertyContext(this.propertyContext);
            BorderEditor.readProperty(ATTR_OUTSIDE, "outsideBorder", this.borderSupport, node);
            BorderEditor.readProperty(ATTR_INSIDE, "insideBorder", this.borderSupport, node);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            IOException iOException = new IOException();
            ErrorManager.getDefault().annotate((Throwable)iOException, (Throwable)exception);
            throw iOException;
        }
    }

    public org.w3c.dom.Node storeBevelBorder(Document document, String string) {
        try {
            Element element = document.createElement(XML_BEVEL_BORDER);
            FormProperty formProperty = (FormProperty)this.borderSupport.getPropertyOfName("bevelType");
            if (formProperty != null && formProperty.isChanged()) {
                element.setAttribute("bevelType", formProperty.getRealValue().toString());
            }
            if ((formProperty = (FormProperty)this.borderSupport.getPropertyOfName("highlightOuterColor")) != null && formProperty.isChanged()) {
                BorderEditor.writeProperty(ATTR_HIGHLIGHT_OUTER, formProperty, element, document);
            }
            if ((formProperty = (FormProperty)this.borderSupport.getPropertyOfName("highlightInnerColor")) != null && formProperty.isChanged()) {
                BorderEditor.writeProperty(ATTR_HIGHLIGHT_INNER, formProperty, element, document);
            }
            if ((formProperty = (FormProperty)this.borderSupport.getPropertyOfName("shadowOuterColor")) != null && formProperty.isChanged()) {
                BorderEditor.writeProperty(ATTR_SHADOW_OUTER, formProperty, element, document);
            }
            if ((formProperty = (FormProperty)this.borderSupport.getPropertyOfName("shadowInnerColor")) != null && formProperty.isChanged()) {
                BorderEditor.writeProperty(ATTR_SHADOW_INNER, formProperty, element, document);
            }
            Element element2 = this.createBorderInfoNode(document, string);
            element2.appendChild(element);
            return element2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void readBevelBorder(org.w3c.dom.Node node, Class clazz) throws IOException {
        if (!XML_BEVEL_BORDER.equals(node.getNodeName())) {
            throw new IOException("Invalid format: missing \"BevelBorder\" element.");
        }
        try {
            FormProperty formProperty;
            NamedNodeMap namedNodeMap = node.getAttributes();
            this.borderSupport = new BorderDesignSupport(clazz);
            org.w3c.dom.Node node2 = namedNodeMap.getNamedItem("bevelType");
            if (node2 != null && (formProperty = (FormProperty)this.borderSupport.getPropertyOfName("bevelType")) != null) {
                formProperty.setValue(new Integer(node2.getNodeValue()));
            }
            BorderEditor.readProperty(ATTR_HIGHLIGHT_OUTER, "highlightOuterColor", this.borderSupport, node);
            BorderEditor.readProperty(ATTR_HIGHLIGHT_INNER, "highlightInnerColor", this.borderSupport, node);
            BorderEditor.readProperty(ATTR_SHADOW_OUTER, "shadowOuterColor", this.borderSupport, node);
            BorderEditor.readProperty(ATTR_SHADOW_INNER, "shadowInnerColor", this.borderSupport, node);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            IOException iOException = new IOException();
            ErrorManager.getDefault().annotate((Throwable)iOException, (Throwable)exception);
            throw iOException;
        }
    }

    public org.w3c.dom.Node storeMatteBorder(Document document) {
        try {
            Object object;
            Object object2;
            String string;
            Element element;
            FormProperty formProperty = (FormProperty)this.borderSupport.getPropertyOfName("tileIcon");
            if (formProperty.isChanged()) {
                element = document.createElement(XML_MATTE_ICON_BORDER);
                string = ID_BI_MATTEICON;
                BorderEditor.writeProperty(ATTR_MATTE_ICON, formProperty, element, document);
            } else {
                element = document.createElement(XML_MATTE_COLOR_BORDER);
                string = ID_BI_MATTECOLOR;
            }
            formProperty = (FormProperty)this.borderSupport.getPropertyOfName("matteColor");
            if (formProperty != null && formProperty.isChanged()) {
                BorderEditor.writeProperty("color", formProperty, element, document);
            }
            if ((formProperty = (FormProperty)this.borderSupport.getPropertyOfName("borderInsets")) != null && formProperty.isChanged() && (object2 = formProperty.getRealValue()) instanceof Insets) {
                object = (Insets)object2;
                element.setAttribute(ATTR_TOP, Integer.toString(((Insets)object).top));
                element.setAttribute(ATTR_LEFT, Integer.toString(((Insets)object).left));
                element.setAttribute(ATTR_BOTTOM, Integer.toString(((Insets)object).bottom));
                element.setAttribute(ATTR_RIGHT, Integer.toString(((Insets)object).right));
            }
            object = this.createBorderInfoNode(document, string);
            object.appendChild(element);
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void readMatteBorder(org.w3c.dom.Node node) throws IOException {
        if (!XML_MATTE_COLOR_BORDER.equals(node.getNodeName()) && !XML_MATTE_ICON_BORDER.equals(node.getNodeName())) {
            throw new IOException("Invalid format: missing \"MatteColorBorder\" or \"MatteIconBorder\" element.");
        }
        try {
            FormProperty formProperty;
            this.borderSupport = new BorderDesignSupport(MatteBorder.class);
            this.borderSupport.setPropertyContext(this.propertyContext);
            BorderEditor.readProperty(ATTR_MATTE_ICON, "tileIcon", this.borderSupport, node);
            BorderEditor.readProperty("color", "matteColor", this.borderSupport, node);
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = 1;
            int n2 = 1;
            int n3 = 1;
            int n4 = 1;
            org.w3c.dom.Node node2 = namedNodeMap.getNamedItem(ATTR_TOP);
            if (node2 != null) {
                n = Integer.parseInt(node2.getNodeValue());
            }
            if ((node2 = namedNodeMap.getNamedItem(ATTR_LEFT)) != null) {
                n2 = Integer.parseInt(node2.getNodeValue());
            }
            if ((node2 = namedNodeMap.getNamedItem(ATTR_BOTTOM)) != null) {
                n3 = Integer.parseInt(node2.getNodeValue());
            }
            if ((node2 = namedNodeMap.getNamedItem(ATTR_RIGHT)) != null) {
                n4 = Integer.parseInt(node2.getNodeValue());
            }
            if ((n != 1 || n2 != 1 || n3 != 1 || n4 != 1) && (formProperty = (FormProperty)this.borderSupport.getPropertyOfName("borderInsets")) != null) {
                formProperty.setValue(new Insets(n, n2, n3, n4));
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            IOException iOException = new IOException();
            ErrorManager.getDefault().annotate((Throwable)iOException, (Throwable)exception);
            throw iOException;
        }
    }

    public boolean valueIsBeanProperty() {
        return !this.isSupportedBorder();
    }

    private boolean isSupportedBorder() {
        if (this.getValue() == null) {
            return true;
        }
        Class clazz = this.borderSupport.getBorderClass();
        return clazz.isAssignableFrom(TitledBorder.class) || clazz.isAssignableFrom(EtchedBorder.class) || clazz.isAssignableFrom(LineBorder.class) || clazz.isAssignableFrom(EmptyBorder.class) || clazz.isAssignableFrom(CompoundBorder.class) || SoftBevelBorder.class.isAssignableFrom(clazz) || BevelBorder.class.isAssignableFrom(clazz) || clazz.isAssignableFrom(MatteBorder.class);
    }

    public Node.Property[] getProperties() {
        if (this.getValue() == null) {
            return EMPTY_PROPERTIES;
        }
        return this.borderSupport.getProperties();
    }

    public void intializeFromType(Class clazz) throws Exception {
        this.borderSupport = new BorderDesignSupport(clazz);
        this.borderSupport.setPropertyContext(this.propertyContext);
        this.current = this.borderSupport;
    }

    static final class UnknownBorderNode
    extends AbstractNode {
        private Object border;

        UnknownBorderNode(Object object) {
            super(Children.LEAF);
            this.setBorder(object);
            this.setIconBase(BorderEditor.UNKNOWN_BORDER_BASE);
        }

        void setBorder(Object object) {
            this.border = object;
            String string = object.getClass().getName();
            int n = string.lastIndexOf(46);
            String string2 = n < 0 ? string : string.substring(n + 1);
            this.setDisplayName(new MessageFormat(BorderEditor.getBundle().getString("LAB_FMT_UnknownBorder")).format(new Object[]{string, string2}));
        }

        Object getBorder() {
            return this.border;
        }
    }

    static final class NoBorderNode
    extends AbstractNode {
        NoBorderNode() {
            super(Children.LEAF);
            this.setDisplayName(BorderEditor.getBundle().getString("LAB_NoBorder"));
            this.setIconBase(BorderEditor.NO_BORDER_BASE);
        }
    }

    final class BorderNode
    extends FilterNode
    implements PropertyChangeListener {
        private BorderDesignSupport nodeBorder;
        private Node.PropertySet[] properties;

        BorderNode(BorderDesignSupport borderDesignSupport, Node node) {
            super(node, FilterNode.Children.LEAF);
            this.nodeBorder = borderDesignSupport;
        }

        public Node.PropertySet[] getPropertySets() {
            if (this.properties == null) {
                Node.Property[] propertyArray = this.nodeBorder.getProperties();
                Sheet.Set set = Sheet.createPropertiesSet();
                set.put(propertyArray);
                for (int i = 0; i < propertyArray.length; ++i) {
                    if (!(propertyArray[i] instanceof FormProperty)) continue;
                    ((FormProperty)propertyArray[i]).addPropertyChangeListener(this);
                }
                this.properties = new Node.PropertySet[]{set};
            }
            return this.properties;
        }

        public BorderDesignSupport getBorderSupport() {
            return this.nodeBorder;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            BorderEditor.this.updateBorder((Node)this);
        }
    }

    final class BorderPanel
    extends JPanel
    implements PropertyChangeListener,
    VetoableChangeListener,
    ExplorerManager.Provider {
        private ExplorerManager manager = new ExplorerManager();
        private Node selectNode = null;

        private BorderPanel() {
            this.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)this);
            this.getExplorerManager().addVetoableChangeListener((VetoableChangeListener)this);
            this.setLayout(new BorderLayout());
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
            ResourceBundle resourceBundle = BorderEditor.getBundle();
            ListView listView = new ListView();
            listView.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_AvailableBorders"));
            JLabel jLabel = new JLabel(resourceBundle.getString("LAB_AvailableBorders"));
            jLabel.setDisplayedMnemonic(resourceBundle.getString("LAB_AvailableBorders_Mnemonic").charAt(0));
            jLabel.setLabelFor((Component)listView);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout(0, 2));
            jPanel.add((Component)jLabel, "North");
            jPanel.add("Center", (Component)listView);
            PropertySheetView propertySheetView = new PropertySheetView();
            JSplitPane jSplitPane = new JSplitPane(0);
            jSplitPane.setTopComponent(jPanel);
            jSplitPane.setBottomComponent((Component)propertySheetView);
            jSplitPane.setUI(new BasicSplitPaneUI());
            jSplitPane.setBorder(BorderFactory.createEmptyBorder());
            jSplitPane.setDividerLocation(170);
            jSplitPane.setContinuousLayout(true);
            this.add("Center", jSplitPane);
            this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_BorderCustomEditor"));
        }

        public void addNotify() {
            super.addNotify();
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    try {
                        this.getExplorerManager().setSelectedNodes(new Node[]{selectNode});
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            });
        }

        void setValue(Object object) {
            Object object2;
            Object object3;
            Object object4;
            ArrayList<BorderNode> arrayList = new ArrayList<BorderNode>(10);
            this.selectNode = null;
            PaletteItem[] paletteItemArray = PaletteUtils.getAllItems();
            for (int i = 0; i < paletteItemArray.length; ++i) {
                object4 = paletteItemArray[i];
                if (!((PaletteItem)object4).isBorder()) continue;
                object3 = null;
                try {
                    object3 = new BorderDesignSupport(((PaletteItem)object4).getComponentClass());
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify(1, (Throwable)exception);
                }
                if (object3 == null) continue;
                if (BorderEditor.this.borderSupport != null && BorderEditor.this.borderSupport.getBorderClass() == object3.getBorderClass()) {
                    try {
                        object3 = new BorderDesignSupport(BorderEditor.this.borderSupport, BorderEditor.this.propertyContext);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        continue;
                    }
                    object2 = new BorderNode((BorderDesignSupport)object3, ((PaletteItem)object4).getNode());
                    this.selectNode = object2;
                } else {
                    object3.setPropertyContext(BorderEditor.this.propertyContext);
                    object2 = new BorderNode((BorderDesignSupport)object3, ((PaletteItem)object4).getNode());
                }
                arrayList.add((BorderNode)object2);
            }
            AbstractNode abstractNode = new AbstractNode((Children)new Children.Array());
            object4 = new NoBorderNode();
            if (object == null) {
                this.selectNode = object4;
            }
            abstractNode.getChildren().add(new Node[]{object4});
            object3 = new Node[arrayList.size()];
            arrayList.toArray((T[])object3);
            Arrays.sort(object3, new Comparator(this){
                private final /* synthetic */ BorderPanel this$1;
                {
                    this.this$1 = borderPanel;
                }

                public int compare(Object object, Object object2) {
                    return ((Node)object).getDisplayName().compareTo(((Node)object2).getDisplayName());
                }
            });
            abstractNode.getChildren().add(object3);
            if (this.selectNode == null) {
                object2 = new UnknownBorderNode(object);
                abstractNode.getChildren().add(new Node[]{object2});
                this.selectNode = object2;
            }
            this.getExplorerManager().setRootContext((Node)abstractNode);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Node[] nodeArray;
            if ("selectedNodes".equals(propertyChangeEvent.getPropertyName()) && (nodeArray = (Node[])propertyChangeEvent.getNewValue()).length == 1) {
                BorderEditor.this.updateBorder(nodeArray[0]);
            }
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            Node[] nodeArray;
            if ("selectedNodes".equals(propertyChangeEvent.getPropertyName()) && (nodeArray = (Node[])propertyChangeEvent.getNewValue()).length != 1) {
                throw new PropertyVetoException("", propertyChangeEvent);
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(360, 440);
        }

        public ExplorerManager getExplorerManager() {
            return this.manager;
        }
    }
}

