/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign;

import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutRegion;

public final class LayoutComponent
implements LayoutConstants {
    private String componentId;
    private LayoutComponent parentComponent;
    private LayoutInterval[] layoutIntervals;
    private boolean[] resizability;
    private LayoutInterval[] layoutRoots;
    private List subComponents;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private int horizontalLinkId = -1;
    private int verticalLinkId = -1;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LayoutComponent(String string, boolean bl) {
        int n;
        this.componentId = string;
        this.layoutIntervals = new LayoutInterval[2];
        for (n = 0; n < 2; ++n) {
            this.layoutIntervals[n] = new LayoutInterval(101);
            this.layoutIntervals[n].setComponent(this);
            this.layoutIntervals[n].setSizes(-2, -1, -2);
        }
        if (bl) {
            this.layoutRoots = new LayoutInterval[2];
            for (n = 0; n < 2; ++n) {
                this.layoutRoots[n] = new LayoutInterval(103);
            }
        }
    }

    public LayoutComponent(String string, boolean bl, int n, int n2) {
        this(string, bl);
        if (bl) {
            for (int i = 0; i < 2; ++i) {
                LayoutInterval layoutInterval = new LayoutInterval(101);
                layoutInterval.setSizes(0, i == 0 ? n : n2, Short.MAX_VALUE);
                this.layoutRoots[i].add(layoutInterval, 0);
            }
        } else {
            this.layoutIntervals[0].setPreferredSize(n);
            this.layoutIntervals[1].setPreferredSize(n2);
        }
    }

    void setLayoutInterval(LayoutInterval layoutInterval, int n) {
        this.layoutIntervals[n] = layoutInterval;
    }

    void setResizability(boolean[] blArray) {
        this.resizability = blArray;
    }

    boolean[] getResizability() {
        return this.resizability;
    }

    public String getId() {
        return this.componentId;
    }

    public LayoutComponent getParent() {
        return this.parentComponent;
    }

    public boolean isParentOf(LayoutComponent layoutComponent) {
        do {
            if ((layoutComponent = layoutComponent.getParent()) != this) continue;
            return true;
        } while (layoutComponent != null);
        return false;
    }

    public LayoutInterval getLayoutInterval(int n) {
        return this.layoutIntervals[n];
    }

    public boolean isLayoutContainer() {
        return this.layoutRoots != null;
    }

    public LayoutInterval getLayoutRoot(int n) {
        return this.layoutRoots[n];
    }

    LayoutInterval[] getLayoutRoots() {
        return this.layoutRoots;
    }

    public Iterator getSubcomponents() {
        return this.subComponents != null && this.subComponents.size() > 0 ? this.subComponents.iterator() : Collections.EMPTY_LIST.iterator();
    }

    int getSubComponentCount() {
        return this.subComponents == null ? 0 : this.subComponents.size();
    }

    LayoutComponent getSubComponent(int n) {
        return (LayoutComponent)this.subComponents.get(n);
    }

    int indexOf(LayoutComponent layoutComponent) {
        return this.subComponents != null ? this.subComponents.indexOf(layoutComponent) : -1;
    }

    int add(LayoutComponent layoutComponent, int n) {
        if (!$assertionsDisabled && !this.isLayoutContainer()) {
            throw new AssertionError();
        }
        if (this.subComponents == null) {
            this.subComponents = new LinkedList();
        }
        if (n < 0) {
            n = this.subComponents.size();
        }
        this.subComponents.add(n, layoutComponent);
        layoutComponent.parentComponent = this;
        return n;
    }

    int remove(LayoutComponent layoutComponent) {
        int n;
        if (this.subComponents != null) {
            n = this.subComponents.indexOf(layoutComponent);
            if (n >= 0) {
                this.subComponents.remove(n);
                layoutComponent.parentComponent = null;
            }
        } else {
            n = -1;
        }
        return n;
    }

    void setLayoutContainer(boolean bl, LayoutInterval[] layoutIntervalArray) {
        if (bl != this.isLayoutContainer()) {
            if (bl) {
                if (layoutIntervalArray == null) {
                    this.layoutRoots = new LayoutInterval[2];
                    for (int i = 0; i < 2; ++i) {
                        this.layoutRoots[i] = new LayoutInterval(103);
                    }
                } else {
                    this.layoutRoots = layoutIntervalArray;
                }
            } else {
                this.layoutRoots = null;
                this.subComponents = null;
            }
        }
    }

    static LayoutComponent getCommonParent(LayoutComponent layoutComponent, LayoutComponent layoutComponent2) {
        Iterator iterator = LayoutComponent.parentsOfComponent(layoutComponent).iterator();
        Iterator iterator2 = LayoutComponent.parentsOfComponent(layoutComponent2).iterator();
        LayoutComponent layoutComponent3 = (LayoutComponent)iterator.next();
        LayoutComponent layoutComponent4 = (LayoutComponent)iterator2.next();
        LayoutComponent layoutComponent5 = null;
        while (layoutComponent3 == layoutComponent4) {
            layoutComponent5 = layoutComponent3;
            if (!iterator.hasNext()) break;
            layoutComponent3 = (LayoutComponent)iterator.next();
            if (!iterator2.hasNext()) break;
            layoutComponent4 = (LayoutComponent)iterator2.next();
        }
        return layoutComponent5;
    }

    private static List parentsOfComponent(LayoutComponent layoutComponent) {
        LinkedList<LayoutComponent> linkedList = new LinkedList<LayoutComponent>();
        while (layoutComponent != null) {
            linkedList.add(0, layoutComponent);
            layoutComponent = layoutComponent.getParent();
        }
        return linkedList;
    }

    void setCurrentBounds(Rectangle rectangle, int n) {
        LayoutRegion layoutRegion = this.layoutIntervals[0].getCurrentSpace();
        layoutRegion.set(rectangle, n > 0 ? rectangle.y + n : Integer.MIN_VALUE);
        for (int i = 1; i < this.layoutIntervals.length; ++i) {
            this.layoutIntervals[i].setCurrentSpace(layoutRegion);
        }
    }

    void setCurrentInterior(Rectangle rectangle) {
        LayoutRegion layoutRegion = null;
        for (int i = 0; i < this.layoutRoots.length; ++i) {
            if (layoutRegion == null) {
                layoutRegion = this.layoutRoots[i].getCurrentSpace();
                layoutRegion.set(rectangle, Integer.MIN_VALUE);
                continue;
            }
            this.layoutRoots[i].setCurrentSpace(layoutRegion);
        }
    }

    public boolean isLinkSized(int n) {
        if (n == 0) {
            return -1 != this.horizontalLinkId;
        }
        return -1 != this.verticalLinkId;
    }

    public int getLinkSizeId(int n) {
        if (n == 0) {
            return this.horizontalLinkId;
        }
        return this.verticalLinkId;
    }

    public void setLinkSizeId(int n, int n2) {
        if (n2 == 0) {
            this.horizontalLinkId = n;
        } else {
            this.verticalLinkId = n;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    void firePropertyChange(String string, Object object, Object object2) {
        this.propertyChangeSupport.firePropertyChange(string, object, object2);
    }

    static {
        $assertionsDisabled = !LayoutComponent.class.desiredAssertionStatus();
    }
}

