/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutRegion;

public final class LayoutInterval
implements LayoutConstants {
    static final int ATTRIBUTE_FILL = 1;
    static final int ATTRIBUTE_FORMER_FILL = 2;
    static final int ATTR_CLOSED_GROUP = 32;
    static final int ATTR_DESIGN_CONTAINER_GAP = 4;
    static final int ATTR_DESIGN_RESIZING = 8;
    static final int ATTR_DESIGN_SUPPRESSED_RESIZING = 16;
    static final int ATTR_ALIGN_PRE = 64;
    static final int ATTR_ALIGN_POST = 128;
    static final int DESIGN_ATTRS = 220;
    static final int ATTR_PERSISTENT_MASK = 35;
    private int type;
    private int attributes;
    private int alignment = -1;
    private LayoutInterval parentInterval;
    private int groupAlignment = 0;
    private List subIntervals;
    private LayoutComponent layoutComponent;
    private int minSize;
    private int prefSize;
    private int maxSize;
    private LayoutRegion currentSpace;
    static final /* synthetic */ boolean $assertionsDisabled;

    LayoutInterval(int n) {
        this.type = n;
        this.minSize = -1;
        this.prefSize = -1;
        if (n == 102 || n == 103) {
            this.subIntervals = new ArrayList();
            this.maxSize = -1;
        } else {
            if (!$assertionsDisabled && n != 101) {
                throw new AssertionError();
            }
            this.maxSize = -2;
        }
    }

    void setAlignment(int n) {
        this.alignment = n;
    }

    void setGroupAlignment(int n) {
        if (!($assertionsDisabled || n != -1 && this.type == 103)) {
            throw new AssertionError();
        }
        this.groupAlignment = n;
    }

    void setComponent(LayoutComponent layoutComponent) {
        this.layoutComponent = layoutComponent;
    }

    void setMinimumSize(int n) {
        if (!$assertionsDisabled && !this.isSingle() && n != -2 && n != -1) {
            throw new AssertionError();
        }
        this.minSize = n;
    }

    void setPreferredSize(int n) {
        if (!($assertionsDisabled || n != -2 && this.isSingle() || n == -1)) {
            throw new AssertionError();
        }
        this.prefSize = n;
    }

    void setMaximumSize(int n) {
        if (!($assertionsDisabled || this.isSingle() && n != -1 || this.isGroup() && (n == -2 || n == -1))) {
            throw new AssertionError();
        }
        this.maxSize = n;
    }

    void setSize(int n) {
        this.setMinimumSize(n);
        this.setPreferredSize(n);
        this.setMaximumSize(n);
    }

    void setSizes(int n, int n2, int n3) {
        this.setMinimumSize(n);
        this.setPreferredSize(n2);
        this.setMaximumSize(n3);
    }

    int getMinimumSize() {
        return this.minSize;
    }

    int getPreferredSize() {
        return this.prefSize;
    }

    int getMaximumSize() {
        return this.maxSize;
    }

    public int getType() {
        return this.type;
    }

    public int getAlignment() {
        return this.alignment == -1 && this.parentInterval != null && this.parentInterval.isParallel() ? this.parentInterval.getGroupAlignment() : this.alignment;
    }

    public int getGroupAlignment() {
        return this.groupAlignment;
    }

    public int getMinimumSize(boolean bl) {
        if (!bl) {
            return this.minSize;
        }
        if (this.hasAttribute(16)) {
            if (!$assertionsDisabled && this.hasAttribute(8)) {
                throw new AssertionError();
            }
            return -2;
        }
        if (this.hasAttribute(8)) {
            return this.isEmptySpace() && this.getPreferredSize(bl) != 0 ? -1 : 0;
        }
        return this.minSize;
    }

    public int getPreferredSize(boolean bl) {
        return this.prefSize;
    }

    public int getMaximumSize(boolean bl) {
        if (!bl) {
            return this.maxSize;
        }
        if (this.hasAttribute(16)) {
            if (!$assertionsDisabled && this.hasAttribute(8)) {
                throw new AssertionError();
            }
            return -2;
        }
        if (this.hasAttribute(8)) {
            return Short.MAX_VALUE;
        }
        return this.maxSize;
    }

    public int getSubIntervalCount() {
        return this.subIntervals != null ? this.subIntervals.size() : 0;
    }

    public Iterator getSubIntervals() {
        return this.subIntervals != null ? this.subIntervals.iterator() : Collections.EMPTY_LIST.iterator();
    }

    public LayoutComponent getComponent() {
        return this.layoutComponent;
    }

    public boolean isParallel() {
        return this.type == 103;
    }

    public boolean isSequential() {
        return this.type == 102;
    }

    public boolean isComponent() {
        return this.layoutComponent != null;
    }

    public boolean isEmptySpace() {
        return this.type == 101 && this.layoutComponent == null;
    }

    public boolean isDefaultPadding(boolean bl) {
        return this.isEmptySpace() && (this.getMinimumSize(bl) == -1 || this.getPreferredSize(bl) == -1);
    }

    public boolean isSingle() {
        return this.type == 101;
    }

    public boolean isGroup() {
        return this.type == 102 || this.type == 103;
    }

    boolean hasAttribute(int n) {
        return (this.attributes & n) == n;
    }

    void setAttribute(int n) {
        this.attributes |= n;
    }

    void unsetAttribute(int n) {
        this.attributes &= ~n;
    }

    void setAttributes(int n) {
        this.attributes = n;
    }

    int getAttributes() {
        return this.attributes;
    }

    int getRawAlignment() {
        return this.alignment;
    }

    public LayoutInterval getParent() {
        return this.parentInterval;
    }

    int add(LayoutInterval layoutInterval, int n) {
        if (n < 0) {
            n = this.subIntervals.size();
        }
        this.subIntervals.add(n, layoutInterval);
        layoutInterval.parentInterval = this;
        return n;
    }

    int remove(LayoutInterval layoutInterval) {
        int n = this.subIntervals.indexOf(layoutInterval);
        if (n >= 0) {
            this.subIntervals.remove(n);
            layoutInterval.parentInterval = null;
        }
        return n;
    }

    LayoutInterval remove(int n) {
        LayoutInterval layoutInterval = (LayoutInterval)this.subIntervals.get(n);
        this.subIntervals.remove(n);
        layoutInterval.parentInterval = null;
        return layoutInterval;
    }

    LayoutInterval getSubInterval(int n) {
        return this.subIntervals != null ? (LayoutInterval)this.subIntervals.get(n) : null;
    }

    int indexOf(LayoutInterval layoutInterval) {
        return this.subIntervals != null ? this.subIntervals.indexOf(layoutInterval) : -1;
    }

    boolean isParentOf(LayoutInterval layoutInterval) {
        if (this.isGroup()) {
            do {
                if ((layoutInterval = layoutInterval.getParent()) != this) continue;
                return true;
            } while (layoutInterval != null);
        }
        return false;
    }

    LayoutRegion getCurrentSpace() {
        if (!$assertionsDisabled && this.isEmptySpace()) {
            throw new AssertionError();
        }
        if (this.currentSpace == null) {
            this.currentSpace = new LayoutRegion();
        }
        return this.currentSpace;
    }

    void setCurrentSpace(LayoutRegion layoutRegion) {
        this.currentSpace = layoutRegion;
    }

    static LayoutInterval getFirstParent(LayoutInterval layoutInterval, int n) {
        LayoutInterval layoutInterval2;
        for (layoutInterval2 = layoutInterval.getParent(); layoutInterval2 != null && layoutInterval2.getType() != n; layoutInterval2 = layoutInterval2.getParent()) {
        }
        return layoutInterval2;
    }

    static LayoutInterval getRoot(LayoutInterval layoutInterval) {
        while (layoutInterval.getParent() != null) {
            layoutInterval = layoutInterval.getParent();
        }
        return layoutInterval;
    }

    static LayoutInterval getCommonParent(LayoutInterval[] layoutIntervalArray) {
        if (!($assertionsDisabled || layoutIntervalArray != null && layoutIntervalArray.length > 0)) {
            throw new AssertionError();
        }
        LayoutInterval layoutInterval = layoutIntervalArray[0].getParent();
        for (int i = 1; i < layoutIntervalArray.length; ++i) {
            layoutInterval = LayoutInterval.getCommonParent(layoutInterval, layoutIntervalArray[i]);
        }
        return layoutInterval;
    }

    static LayoutInterval getCommonParent(LayoutInterval layoutInterval, LayoutInterval layoutInterval2) {
        Iterator iterator = LayoutInterval.parentsOfInterval(layoutInterval).iterator();
        Iterator iterator2 = LayoutInterval.parentsOfInterval(layoutInterval2).iterator();
        LayoutInterval layoutInterval3 = (LayoutInterval)iterator.next();
        LayoutInterval layoutInterval4 = (LayoutInterval)iterator2.next();
        if (!$assertionsDisabled && layoutInterval3 != layoutInterval4) {
            throw new AssertionError();
        }
        LayoutInterval layoutInterval5 = null;
        while (layoutInterval3 == layoutInterval4) {
            layoutInterval5 = layoutInterval3;
            if (!iterator.hasNext()) break;
            layoutInterval3 = (LayoutInterval)iterator.next();
            if (!iterator2.hasNext()) break;
            layoutInterval4 = (LayoutInterval)iterator2.next();
        }
        return layoutInterval5;
    }

    private static List parentsOfInterval(LayoutInterval layoutInterval) {
        LinkedList<LayoutInterval> linkedList = new LinkedList<LayoutInterval>();
        while (layoutInterval != null) {
            linkedList.add(0, layoutInterval);
            layoutInterval = layoutInterval.getParent();
        }
        return linkedList;
    }

    static int getCount(LayoutInterval layoutInterval, int n, boolean bl) {
        int n2 = 0;
        Iterator iterator = layoutInterval.getSubIntervals();
        while (iterator.hasNext()) {
            LayoutInterval layoutInterval2 = (LayoutInterval)iterator.next();
            if (!layoutInterval.isSequential() && n != Integer.MAX_VALUE && layoutInterval2.getAlignment() != n && !LayoutInterval.wantResize(layoutInterval2) || bl && layoutInterval2.isEmptySpace()) continue;
            ++n2;
        }
        return n2;
    }

    static LayoutInterval getDirectNeighbor(LayoutInterval layoutInterval, int n, boolean bl) {
        LayoutInterval layoutInterval2 = layoutInterval.getParent();
        if (layoutInterval2 == null || layoutInterval2.isParallel()) {
            return null;
        }
        LayoutInterval layoutInterval3 = null;
        int n2 = n == 0 ? -1 : 1;
        int n3 = layoutInterval2.getSubIntervalCount();
        for (int i = layoutInterval2.indexOf(layoutInterval) + n2; i >= 0 && i < n3 && layoutInterval3 == null; i += n2) {
            LayoutInterval layoutInterval4 = layoutInterval2.getSubInterval(i);
            if (bl && layoutInterval4.isEmptySpace()) continue;
            layoutInterval3 = layoutInterval4;
        }
        return layoutInterval3;
    }

    static LayoutInterval getNeighbor(LayoutInterval layoutInterval, int n, boolean bl, boolean bl2, boolean bl3) {
        if (!$assertionsDisabled && n != 0 && n != 1) {
            throw new AssertionError();
        }
        LayoutInterval layoutInterval2 = null;
        LayoutInterval layoutInterval3 = layoutInterval;
        int n2 = n == 0 ? -1 : 1;
        while (true) {
            layoutInterval = layoutInterval3;
            layoutInterval3 = layoutInterval.getParent();
            if (bl3 && layoutInterval3 != null && layoutInterval3.isParallel() && !LayoutInterval.isAlignedAtBorder(layoutInterval, n)) {
                layoutInterval3 = null;
            }
            if (layoutInterval3 != null && layoutInterval3.isParallel()) continue;
            if (layoutInterval3 != null) {
                layoutInterval2 = LayoutInterval.getDirectNeighbor(layoutInterval, n, bl);
            }
            if (layoutInterval2 != null || layoutInterval3 == null || !bl2) break;
        }
        return layoutInterval2;
    }

    static LayoutInterval getNeighbor(LayoutInterval layoutInterval, int n, int n2) {
        if (!$assertionsDisabled && n2 != 0 && n2 != 1) {
            throw new AssertionError();
        }
        LayoutInterval layoutInterval2 = null;
        LayoutInterval layoutInterval3 = layoutInterval;
        while (true) {
            layoutInterval = layoutInterval3;
            if ((layoutInterval3 = layoutInterval3.getParent()) != null && layoutInterval3.getType() != n) continue;
            if (layoutInterval3 != null) {
                List list = layoutInterval3.subIntervals;
                int n3 = list.indexOf(layoutInterval);
                if (n2 == 0 && n3 > 0) {
                    layoutInterval2 = (LayoutInterval)list.get(n3 - 1);
                } else if (n2 == 1 && n3 + 1 < list.size()) {
                    layoutInterval2 = (LayoutInterval)list.get(n3 + 1);
                }
            }
            if (layoutInterval3 == null || layoutInterval2 != null) break;
        }
        return layoutInterval2;
    }

    static boolean startsWithEmptySpace(LayoutInterval layoutInterval, int n) {
        if (!$assertionsDisabled && n != 0 && n != 1) {
            throw new AssertionError();
        }
        if (layoutInterval.isSingle()) {
            return layoutInterval.isEmptySpace();
        }
        if (layoutInterval.isSequential()) {
            int n2 = n == 0 ? 0 : layoutInterval.getSubIntervalCount() - 1;
            return LayoutInterval.startsWithEmptySpace(layoutInterval.getSubInterval(n2), n);
        }
        Iterator iterator = layoutInterval.getSubIntervals();
        while (iterator.hasNext()) {
            LayoutInterval layoutInterval2 = (LayoutInterval)iterator.next();
            if (!LayoutInterval.startsWithEmptySpace(layoutInterval2, n)) continue;
            return true;
        }
        return false;
    }

    static boolean isAlignedAtBorder(LayoutInterval layoutInterval, int n) {
        if (n != 0 && n != 1) {
            return false;
        }
        LayoutInterval layoutInterval2 = layoutInterval.getParent();
        if (layoutInterval2 == null) {
            return false;
        }
        if (layoutInterval2.isSequential()) {
            int n2 = n == 0 ? 0 : layoutInterval2.getSubIntervalCount() - 1;
            return layoutInterval == layoutInterval2.getSubInterval(n2);
        }
        return layoutInterval.getAlignment() == n || LayoutInterval.wantResize(layoutInterval);
    }

    static boolean isAlignedAtBorder(LayoutInterval layoutInterval, LayoutInterval layoutInterval2, int n) {
        do {
            if (LayoutInterval.isAlignedAtBorder(layoutInterval, n)) continue;
            return false;
        } while ((layoutInterval = layoutInterval.getParent()) != layoutInterval2);
        return true;
    }

    static boolean isPlacedAtBorder(LayoutInterval layoutInterval, int n, int n2) {
        if (n2 != 0 && n2 != 1) {
            return false;
        }
        LayoutInterval layoutInterval2 = layoutInterval.getParent();
        if (layoutInterval2 == null) {
            return false;
        }
        if (layoutInterval.isEmptySpace()) {
            if (layoutInterval2.isSequential()) {
                int n3 = n2 == 0 ? 0 : layoutInterval2.getSubIntervalCount() - 1;
                return layoutInterval == layoutInterval2.getSubInterval(n3);
            }
            return true;
        }
        return LayoutRegion.distance(layoutInterval.getCurrentSpace(), layoutInterval2.getCurrentSpace(), n, n2, n2) == 0;
    }

    static boolean isPlacedAtBorder(LayoutInterval layoutInterval, LayoutInterval layoutInterval2, int n, int n2) {
        if (n2 != 0 && n2 != 1) {
            return false;
        }
        if (layoutInterval.isEmptySpace()) {
            LayoutInterval layoutInterval3 = layoutInterval.getParent();
            if (layoutInterval3.isSequential()) {
                int n3;
                int n4 = n3 = n2 == 0 ? 0 : layoutInterval3.getSubIntervalCount() - 1;
                if (layoutInterval != layoutInterval3.getSubInterval(n3)) {
                    return false;
                }
            }
            if (layoutInterval3 == layoutInterval2) {
                return true;
            }
            layoutInterval = layoutInterval3;
        }
        return LayoutRegion.distance(layoutInterval.getCurrentSpace(), layoutInterval2.getCurrentSpace(), n, n2, n2) == 0 && layoutInterval2.isParentOf(layoutInterval);
    }

    static boolean isBorderInterval(LayoutInterval layoutInterval, int n, boolean bl) {
        LayoutInterval layoutInterval2 = layoutInterval.getParent();
        if (layoutInterval2 != null && (n == 0 || n == 1)) {
            if (layoutInterval2.isSequential()) {
                int n2;
                int n3 = n2 = n == 0 ? 0 : layoutInterval2.getSubIntervalCount() - 1;
                while (n2 >= 0 && n2 < layoutInterval2.getSubIntervalCount()) {
                    LayoutInterval layoutInterval3 = layoutInterval2.getSubInterval(n2);
                    if (layoutInterval3 == layoutInterval) {
                        return true;
                    }
                    if (bl || !layoutInterval3.isEmptySpace()) {
                        return false;
                    }
                    n2 += n == 0 ? 1 : -1;
                }
            } else {
                return !bl || layoutInterval.getAlignment() == n || LayoutInterval.wantResize(layoutInterval);
            }
        }
        return false;
    }

    static boolean isClosedGroup(LayoutInterval layoutInterval, int n) {
        if (!$assertionsDisabled && !layoutInterval.isParallel()) {
            throw new AssertionError();
        }
        if (layoutInterval.hasAttribute(32) || layoutInterval.getGroupAlignment() == 2 || layoutInterval.getGroupAlignment() == 3) {
            return true;
        }
        Iterator iterator = layoutInterval.getSubIntervals();
        while (iterator.hasNext()) {
            LayoutInterval layoutInterval2 = (LayoutInterval)iterator.next();
            if (layoutInterval2.getAlignment() != n && !LayoutInterval.wantResize(layoutInterval2)) continue;
            return true;
        }
        return false;
    }

    static boolean isExplicitlyClosedGroup(LayoutInterval layoutInterval) {
        return layoutInterval.hasAttribute(32);
    }

    static boolean isDefaultPadding(LayoutInterval layoutInterval) {
        return layoutInterval.isEmptySpace() && (layoutInterval.getMinimumSize() == -1 || layoutInterval.getPreferredSize() == -1);
    }

    static boolean isFixedDefaultPadding(LayoutInterval layoutInterval) {
        return !(!layoutInterval.isEmptySpace() || layoutInterval.getMinimumSize() != -1 && layoutInterval.getMinimumSize() != -2 || layoutInterval.getPreferredSize() != -1 || layoutInterval.getMaximumSize() != -1 && layoutInterval.getMaximumSize() != -2);
    }

    static boolean canResize(LayoutInterval layoutInterval) {
        int n = layoutInterval.getMaximumSize();
        int n2 = layoutInterval.getPreferredSize();
        if (!$assertionsDisabled && !layoutInterval.isGroup() && n == -1) {
            throw new AssertionError();
        }
        return n != n2 && n != -2 || n == -1;
    }

    static boolean wantResize(LayoutInterval layoutInterval) {
        return LayoutInterval.canResize(layoutInterval) && (!layoutInterval.isGroup() || LayoutInterval.contentWantResize(layoutInterval));
    }

    static boolean wantResizeInLayout(LayoutInterval layoutInterval) {
        if (!LayoutInterval.wantResize(layoutInterval)) {
            return false;
        }
        while (layoutInterval.getParent() != null) {
            if (LayoutInterval.canResize(layoutInterval = layoutInterval.getParent())) continue;
            return false;
        }
        return true;
    }

    static boolean contentWantResize(LayoutInterval layoutInterval) {
        boolean bl = false;
        Iterator iterator = layoutInterval.getSubIntervals();
        while (iterator.hasNext()) {
            if (!LayoutInterval.wantResize((LayoutInterval)iterator.next())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    static int getIntervalCurrentSize(LayoutInterval layoutInterval, int n) {
        int n2;
        int n3;
        if (!layoutInterval.isEmptySpace()) {
            return layoutInterval.getCurrentSpace().size(n);
        }
        LayoutInterval layoutInterval2 = layoutInterval.getParent();
        if (layoutInterval2.isSequential()) {
            int n4 = layoutInterval2.indexOf(layoutInterval);
            n3 = n4 > 0 ? layoutInterval2.getSubInterval((int)(n4 - 1)).getCurrentSpace().positions[n][1] : layoutInterval2.getCurrentSpace().positions[n][0];
            n2 = n4 + 1 < layoutInterval2.getSubIntervalCount() ? layoutInterval2.getSubInterval((int)(n4 + 1)).getCurrentSpace().positions[n][0] : layoutInterval2.getCurrentSpace().positions[n][1];
        } else {
            n3 = layoutInterval2.getCurrentSpace().positions[n][0];
            n2 = layoutInterval2.getCurrentSpace().positions[n][1];
        }
        return n2 - n3;
    }

    static int getEffectiveAlignment(LayoutInterval layoutInterval) {
        LayoutInterval layoutInterval2 = layoutInterval.getParent();
        if (layoutInterval2.isParallel()) {
            return layoutInterval.getAlignment();
        }
        if (LayoutInterval.wantResize(layoutInterval)) {
            return -1;
        }
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        Iterator iterator = layoutInterval2.getSubIntervals();
        do {
            LayoutInterval layoutInterval3;
            if ((layoutInterval3 = (LayoutInterval)iterator.next()) == layoutInterval) {
                bl = false;
                continue;
            }
            if (!LayoutInterval.wantResize(layoutInterval3)) continue;
            if (bl) {
                bl2 = false;
                continue;
            }
            bl3 = false;
        } while (iterator.hasNext());
        if (bl2 && !bl3) {
            return 0;
        }
        if (!bl2 && bl3) {
            return 1;
        }
        if (bl2 && bl3) {
            return layoutInterval2.getAlignment();
        }
        return -1;
    }

    static int getEffectiveAlignment(LayoutInterval layoutInterval, int n) {
        if (!$assertionsDisabled && n != 0 && n != 1) {
            throw new AssertionError();
        }
        boolean bl = LayoutInterval.wantResize(layoutInterval);
        LayoutInterval layoutInterval2 = layoutInterval.getParent();
        if (layoutInterval2.isParallel()) {
            return bl ? n : layoutInterval.getAlignment();
        }
        int n2 = layoutInterval2.getSubIntervalCount();
        int n3 = n == 0 ? 1 : -1;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        for (int i = n == 0 ? 0 : n2 - 1; i >= 0 && i < n2; i += n3) {
            LayoutInterval layoutInterval3 = layoutInterval2.getSubInterval(i);
            if (layoutInterval3 == layoutInterval) {
                bl2 = false;
                continue;
            }
            if (!LayoutInterval.wantResize(layoutInterval3)) continue;
            if (bl2) {
                bl3 = false;
                continue;
            }
            bl4 = false;
        }
        if (bl3 && !bl4) {
            return n;
        }
        if (!bl3 && bl4) {
            return n ^ 1;
        }
        if (bl3 && bl4) {
            return bl ? n : layoutInterval2.getAlignment();
        }
        return -1;
    }

    static int getEffectiveAlignmentInParent(LayoutInterval layoutInterval, LayoutInterval layoutInterval2, int n) {
        if (!$assertionsDisabled && !layoutInterval2.isParentOf(layoutInterval)) {
            throw new AssertionError();
        }
        int n2 = n;
        do {
            n2 = LayoutInterval.getEffectiveAlignment(layoutInterval, n2);
            if (n2 == 0 || n2 == 1) continue;
            for (layoutInterval = layoutInterval.getParent(); layoutInterval != layoutInterval2; layoutInterval = layoutInterval.getParent()) {
                if (LayoutInterval.getEffectiveAlignment(layoutInterval) == n2) continue;
                return -1;
            }
        } while (layoutInterval != layoutInterval2);
        return n2;
    }

    static LayoutInterval cloneInterval(LayoutInterval layoutInterval, LayoutInterval layoutInterval2) {
        layoutInterval2 = layoutInterval2 == null ? new LayoutInterval(layoutInterval.getType()) : layoutInterval2;
        layoutInterval2.setAlignment(layoutInterval.getAlignment());
        layoutInterval2.setAttributes(layoutInterval.getAttributes());
        if (layoutInterval.getType() == 103) {
            layoutInterval2.setGroupAlignment(layoutInterval.getGroupAlignment());
        }
        layoutInterval2.setSizes(layoutInterval.getMinimumSize(), layoutInterval.getPreferredSize(), layoutInterval.getMaximumSize());
        return layoutInterval2;
    }

    static {
        $assertionsDisabled = !LayoutInterval.class.desiredAssertionStatus();
    }
}

