/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign.support;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutdesign.support.SwingLayoutUtils;

public class SwingLayoutBuilder {
    private LayoutModel layoutModel;
    private Container container;
    private LayoutComponent containerLC;
    private Map componentIDMap = new HashMap();
    private boolean designMode;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SwingLayoutBuilder(LayoutModel layoutModel, Container container, String string, boolean bl) {
        this.layoutModel = layoutModel;
        this.container = container;
        this.containerLC = layoutModel.getLayoutComponent(string);
        this.designMode = bl;
    }

    public void setupContainerLayout(Component[] componentArray, String[] stringArray) {
        for (int i = 0; i < componentArray.length; ++i) {
            this.componentIDMap.put(stringArray[i], componentArray[i]);
        }
        this.createLayout();
    }

    public void removeComponentsFromContainer(Component[] componentArray, String[] stringArray) {
        if (componentArray.length != stringArray.length) {
            throw new IllegalArgumentException("Sizes must match");
        }
        for (int i = 0; i < componentArray.length; ++i) {
            this.componentIDMap.remove(stringArray[i]);
        }
        this.createLayout();
    }

    public void clearContainer() {
        this.container.removeAll();
        this.componentIDMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createLayout() {
        Object var1_1 = null;
        boolean bl = true;
        this.container.removeAll();
        try {
            GroupLayout groupLayout = new GroupLayout(this.container);
            this.container.setLayout((LayoutManager)groupLayout);
            LayoutInterval layoutInterval = this.containerLC.getLayoutRoot(0);
            GroupLayout.Group group = this.composeGroup(groupLayout, layoutInterval, true, true);
            groupLayout.setHorizontalGroup(group);
            LayoutInterval layoutInterval2 = this.containerLC.getLayoutRoot(1);
            GroupLayout.Group group2 = this.composeGroup(groupLayout, layoutInterval2, true, true);
            groupLayout.setVerticalGroup(group2);
            this.composeLinks(groupLayout);
            groupLayout.layoutContainer(this.container);
            groupLayout.invalidateLayout(this.container);
            bl = false;
        }
        finally {
            if (bl) {
                this.container.setLayout(null);
            }
        }
    }

    public void doLayout() {
        this.container.doLayout();
    }

    public static boolean isRelevantContainer(Container container) {
        return container.getLayout() != null && container.getLayout().getClass().getName().equals("org.jdesktop.layout.GroupLayout");
    }

    private GroupLayout.Group composeGroup(GroupLayout groupLayout, LayoutInterval layoutInterval, boolean bl, boolean bl2) {
        GroupLayout.SequentialGroup sequentialGroup = null;
        if (layoutInterval.isGroup()) {
            if (layoutInterval.isParallel()) {
                int n = SwingLayoutBuilder.convertAlignment(layoutInterval.getGroupAlignment());
                boolean bl3 = layoutInterval.getMaximumSize(this.designMode) == -2;
                sequentialGroup = groupLayout.createParallelGroup(n, !bl3);
            } else if (layoutInterval.isSequential()) {
                sequentialGroup = groupLayout.createSequentialGroup();
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            Iterator iterator = layoutInterval.getSubIntervals();
            while (iterator.hasNext()) {
                LayoutInterval layoutInterval2 = (LayoutInterval)iterator.next();
                this.fillGroup(groupLayout, (GroupLayout.Group)sequentialGroup, layoutInterval2, bl, bl2 && (!layoutInterval.isSequential() || !iterator.hasNext()));
                if (!bl || !layoutInterval.isSequential()) continue;
                bl = false;
            }
        } else {
            sequentialGroup = groupLayout.createSequentialGroup();
            this.fillGroup(groupLayout, (GroupLayout.Group)sequentialGroup, layoutInterval, true, true);
        }
        return sequentialGroup;
    }

    private void fillGroup(GroupLayout groupLayout, GroupLayout.Group group, LayoutInterval layoutInterval, boolean bl, boolean bl2) {
        if (layoutInterval.isGroup()) {
            if (group instanceof GroupLayout.SequentialGroup) {
                if (layoutInterval.getAlignment() != -1) {
                    System.err.println("WARNING: Ignoring non-default alignment of interval in sequential group.");
                }
                ((GroupLayout.SequentialGroup)group).add(this.composeGroup(groupLayout, layoutInterval, bl, bl2));
            } else {
                int n = SwingLayoutBuilder.convertAlignment(layoutInterval.getAlignment());
                ((GroupLayout.ParallelGroup)group).add(n, this.composeGroup(groupLayout, layoutInterval, bl, bl2));
            }
        } else {
            int n = layoutInterval.getMinimumSize(this.designMode);
            int n2 = layoutInterval.getPreferredSize(this.designMode);
            int n3 = this.convertSize(n, layoutInterval);
            int n4 = this.convertSize(n2, layoutInterval);
            int n5 = this.convertSize(layoutInterval.getMaximumSize(this.designMode), layoutInterval);
            if (layoutInterval.isComponent()) {
                int n6 = layoutInterval.getAlignment();
                LayoutComponent layoutComponent = layoutInterval.getComponent();
                Component component = (Component)this.componentIDMap.get(layoutComponent.getId());
                if (!$assertionsDisabled && component == null) {
                    throw new AssertionError();
                }
                if (n == -1) {
                    boolean bl3;
                    boolean bl4 = bl3 = layoutComponent.getLayoutInterval(0) != layoutInterval;
                    if (!bl3 && component.getClass().getName().equals("javax.swing.JComboBox")) {
                        n3 = 0;
                    } else if (n2 >= 0) {
                        int n7;
                        Dimension dimension = component.getMinimumSize();
                        int n8 = n7 = !bl3 ? dimension.width : dimension.height;
                        if (n7 > n2) {
                            n3 = this.convertSize(-2, layoutInterval);
                        }
                    }
                }
                if (group instanceof GroupLayout.SequentialGroup) {
                    if (n6 != -1) {
                        System.err.println("WARNING: Ignoring non-default alignment of interval in sequential group.");
                    }
                    ((GroupLayout.SequentialGroup)group).add(component, n3, n4, n5);
                } else {
                    GroupLayout.ParallelGroup parallelGroup = (GroupLayout.ParallelGroup)group;
                    int n9 = SwingLayoutBuilder.convertAlignment(n6);
                    parallelGroup.add(n9, component, n3, n4, n5);
                }
            } else {
                if (!$assertionsDisabled && !layoutInterval.isEmptySpace()) {
                    throw new AssertionError();
                }
                if (layoutInterval.isDefaultPadding(this.designMode)) {
                    if (!$assertionsDisabled && !(group instanceof GroupLayout.SequentialGroup)) {
                        throw new AssertionError();
                    }
                    GroupLayout.SequentialGroup sequentialGroup = (GroupLayout.SequentialGroup)group;
                    if (bl || bl2) {
                        sequentialGroup.addContainerGap(n4, n5);
                    } else {
                        sequentialGroup.addPreferredGap(0, n4, n5);
                    }
                } else {
                    if (n3 < 0) {
                        n3 = n4;
                    }
                    n3 = Math.min(n4, n3);
                    n5 = Math.max(n4, n5);
                    if (group instanceof GroupLayout.SequentialGroup) {
                        ((GroupLayout.SequentialGroup)group).add(n3, n4, n5);
                    } else {
                        ((GroupLayout.ParallelGroup)group).add(n3, n4, n5);
                    }
                }
            }
        }
    }

    private static int convertAlignment(int n) {
        int n2 = 0;
        switch (n) {
            case -1: {
                n2 = 1;
                break;
            }
            case 0: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
        return n2;
    }

    private int convertSize(int n, LayoutInterval layoutInterval) {
        int n2;
        switch (n) {
            case -1: {
                n2 = -1;
                break;
            }
            case -2: {
                n2 = layoutInterval.isEmptySpace() ? this.convertSize(layoutInterval.getPreferredSize(this.designMode), layoutInterval) : -2;
                break;
            }
            default: {
                if (!$assertionsDisabled && n < 0) {
                    throw new AssertionError();
                }
                n2 = n;
            }
        }
        return n2;
    }

    private void composeLinks(GroupLayout groupLayout) {
        this.composeLinks(groupLayout, 0);
        this.composeLinks(groupLayout, 1);
    }

    private void composeLinks(GroupLayout groupLayout, int n) {
        Map map = SwingLayoutUtils.createLinkSizeGroups(this.containerLC, n);
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            List list = (List)map.get(iterator.next());
            ArrayList<Component> arrayList = new ArrayList<Component>();
            for (int i = 0; i < list.size(); ++i) {
                String string = (String)list.get(i);
                LayoutComponent layoutComponent = this.layoutModel.getLayoutComponent(string);
                if (layoutComponent == null) continue;
                Component component = (Component)this.componentIDMap.get(layoutComponent.getId());
                if (component == null) {
                    return;
                }
                arrayList.add(component);
            }
            Component[] componentArray = arrayList.toArray(new Component[arrayList.size()]);
            if (componentArray == null) continue;
            if (n == 0) {
                groupLayout.linkSize(componentArray, 1);
            }
            if (n != 1) continue;
            groupLayout.linkSize(componentArray, 2);
        }
    }

    static {
        $assertionsDisabled = !SwingLayoutBuilder.class.desiredAssertionStatus();
    }
}

