/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.layoutsupport.DefaultLayoutSupport;
import org.netbeans.modules.form.layoutsupport.LayoutSupportDelegate;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class LayoutSupportRegistry {
    private static Map containerToLayoutDelegate;
    private static Map layoutToLayoutDelegate;
    private static boolean needPaletteRescan;
    public static final String DEFAULT_SUPPORT = "<default>";
    private static FileChangeListener paletteListener;
    private static Map instanceMap;
    private Reference formModelRef;
    static /* synthetic */ Class class$org$netbeans$modules$form$palette$PaletteItem;
    static /* synthetic */ Class class$org$netbeans$modules$form$layoutsupport$LayoutSupportDelegate;
    static /* synthetic */ Class class$java$awt$LayoutManager;
    static /* synthetic */ Class class$java$awt$Container;

    private LayoutSupportRegistry(FormModel formModel) {
        this.formModelRef = new WeakReference<FormModel>(formModel);
    }

    public static LayoutSupportRegistry getRegistry(FormModel formModel) {
        LayoutSupportRegistry layoutSupportRegistry;
        if (instanceMap == null) {
            instanceMap = new WeakHashMap();
            layoutSupportRegistry = null;
        } else {
            layoutSupportRegistry = (LayoutSupportRegistry)instanceMap.get(formModel);
        }
        if (layoutSupportRegistry == null) {
            layoutSupportRegistry = new LayoutSupportRegistry(formModel);
            instanceMap.put(formModel, layoutSupportRegistry);
        }
        return layoutSupportRegistry;
    }

    public Class getSupportClassForContainer(Class clazz) {
        String string = (String)LayoutSupportRegistry.getContainersMap().get(clazz.getName());
        if (string == null) {
            string = this.findSuperClass(LayoutSupportRegistry.getContainersMap(), clazz);
        }
        return string != null ? this.loadClass(string) : null;
    }

    public String getSupportNameForContainer(String string) {
        Class clazz;
        String string2 = (String)LayoutSupportRegistry.getContainersMap().get(string);
        if (string2 == null && (clazz = this.loadClass(string)) != null) {
            string2 = this.findSuperClass(LayoutSupportRegistry.getContainersMap(), clazz);
        }
        return string2;
    }

    public Class getSupportClassForLayout(Class clazz) {
        String string = (String)LayoutSupportRegistry.getLayoutsMap().get(clazz.getName());
        if (string == null && needPaletteRescan) {
            string = LayoutSupportRegistry.scanPalette(clazz.getName());
        }
        if (string == null) {
            string = this.findSuperClass(LayoutSupportRegistry.getLayoutsMap(), clazz);
        }
        return string != null ? this.loadClass(string) : null;
    }

    public String getSupportNameForLayout(String string) {
        Class clazz;
        String string2 = (String)LayoutSupportRegistry.getLayoutsMap().get(string);
        if (string2 == null && needPaletteRescan) {
            string2 = LayoutSupportRegistry.scanPalette(string);
        }
        if (string2 == null && (clazz = this.loadClass(string)) != null) {
            string2 = this.findSuperClass(LayoutSupportRegistry.getLayoutsMap(), clazz);
        }
        return string2;
    }

    public static void registerSupportForContainer(Class clazz, Class clazz2) {
        LayoutSupportRegistry.getContainersMap().put(clazz.getName(), clazz2.getName());
    }

    public static void registerSupportForContainer(String string, String string2) {
        LayoutSupportRegistry.getContainersMap().put(string, string2);
    }

    public static void registertSupportForLayout(Class clazz, Class clazz2) {
        LayoutSupportRegistry.getLayoutsMap().put(clazz.getName(), clazz2.getName());
    }

    public static void registerSupportForLayout(String string, String string2) {
        LayoutSupportRegistry.getLayoutsMap().put(string, string2);
    }

    public LayoutSupportDelegate createSupportForContainer(Class clazz) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class clazz2 = this.getSupportClassForContainer(clazz);
        if (clazz2 == null) {
            return null;
        }
        return (LayoutSupportDelegate)clazz2.newInstance();
    }

    public LayoutSupportDelegate createSupportForLayout(Class clazz) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String string = this.getSupportNameForLayout(clazz.getName());
        if (string == null) {
            return null;
        }
        if (string == DEFAULT_SUPPORT) {
            return new DefaultLayoutSupport(clazz);
        }
        return (LayoutSupportDelegate)this.loadClass(string).newInstance();
    }

    public static LayoutSupportDelegate createSupportInstance(Class clazz) throws InstantiationException, IllegalAccessException {
        return (LayoutSupportDelegate)clazz.newInstance();
    }

    private String findSuperClass(Map map, Class clazz) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Class clazz2 = this.loadClass(string);
            if (clazz2 == null || !clazz2.isAssignableFrom(clazz)) continue;
            return (String)entry.getValue();
        }
        return null;
    }

    private static String scanPalette(String string) {
        boolean bl;
        FileObject fileObject = PaletteUtils.getPaletteFolder();
        boolean bl2 = bl = paletteListener == null;
        if (bl) {
            paletteListener = new FileChangeAdapter(){

                public void fileDataCreated(FileEvent fileEvent) {
                    needPaletteRescan = true;
                }

                public void fileFolderCreated(FileEvent fileEvent) {
                    needPaletteRescan = true;
                    fileEvent.getFile().addFileChangeListener((FileChangeListener)this);
                }

                public void fileDeleted(FileEvent fileEvent) {
                    fileEvent.getFile().removeFileChangeListener((FileChangeListener)this);
                }
            };
            fileObject.addFileChangeListener(paletteListener);
        }
        String string2 = null;
        FileObject[] fileObjectArray = fileObject.getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            FileObject fileObject2 = fileObjectArray[i];
            if (!fileObject2.isFolder()) continue;
            if (bl) {
                fileObject2.addFileChangeListener(paletteListener);
            }
            FileObject[] fileObjectArray2 = fileObject2.getChildren();
            for (int j = 0; j < fileObjectArray2.length; ++j) {
                Object object;
                Class clazz;
                Class clazz2;
                block12: {
                    Class clazz3;
                    DataObject dataObject = null;
                    try {
                        dataObject = DataObject.find((FileObject)fileObjectArray2[j]);
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        continue;
                    }
                    PaletteItem paletteItem = (PaletteItem)dataObject.getCookie(class$org$netbeans$modules$form$palette$PaletteItem == null ? LayoutSupportRegistry.class$("org.netbeans.modules.form.palette.PaletteItem") : class$org$netbeans$modules$form$palette$PaletteItem);
                    if (paletteItem == null || !paletteItem.isLayout() || (clazz3 = paletteItem.getComponentClass()) == null) continue;
                    clazz2 = null;
                    clazz = null;
                    if ((class$org$netbeans$modules$form$layoutsupport$LayoutSupportDelegate == null ? LayoutSupportRegistry.class$("org.netbeans.modules.form.layoutsupport.LayoutSupportDelegate") : class$org$netbeans$modules$form$layoutsupport$LayoutSupportDelegate).isAssignableFrom(clazz3)) {
                        clazz2 = clazz3;
                        try {
                            object = (LayoutSupportDelegate)clazz2.newInstance();
                            clazz = object.getSupportedClass();
                            break block12;
                        }
                        catch (Exception exception) {
                            ErrorManager.getDefault().notify(1, (Throwable)exception);
                            continue;
                        }
                    }
                    if ((class$java$awt$LayoutManager == null ? LayoutSupportRegistry.class$("java.awt.LayoutManager") : class$java$awt$LayoutManager).isAssignableFrom(clazz3)) {
                        clazz = clazz3;
                    }
                }
                if (clazz == null) continue;
                if ((class$java$awt$Container == null ? LayoutSupportRegistry.class$("java.awt.Container") : class$java$awt$Container).isAssignableFrom(clazz)) {
                    object = LayoutSupportRegistry.getContainersMap();
                } else {
                    if (!(class$java$awt$LayoutManager == null ? LayoutSupportRegistry.class$("java.awt.LayoutManager") : class$java$awt$LayoutManager).isAssignableFrom(clazz)) continue;
                    object = LayoutSupportRegistry.getLayoutsMap();
                }
                String string3 = clazz.getName();
                if (object.get(string3) != null) continue;
                String string4 = clazz2 != null ? clazz2.getName() : DEFAULT_SUPPORT;
                object.put(string3, string4);
                if (!string3.equals(string)) continue;
                string2 = string4;
            }
        }
        needPaletteRescan = false;
        return string2;
    }

    private Class loadClass(String string) {
        try {
            return FormUtils.loadClass(string, (FormModel)this.formModelRef.get());
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
        catch (LinkageError linkageError) {
            ErrorManager.getDefault().notify(1, (Throwable)linkageError);
        }
        return null;
    }

    private static Map getContainersMap() {
        if (containerToLayoutDelegate == null) {
            containerToLayoutDelegate = new HashMap();
            containerToLayoutDelegate.put("javax.swing.JScrollPane", "org.netbeans.modules.form.layoutsupport.delegates.JScrollPaneSupport");
            containerToLayoutDelegate.put("java.awt.ScrollPane", "org.netbeans.modules.form.layoutsupport.delegates.ScrollPaneSupport");
            containerToLayoutDelegate.put("javax.swing.JSplitPane", "org.netbeans.modules.form.layoutsupport.delegates.JSplitPaneSupport");
            containerToLayoutDelegate.put("javax.swing.JTabbedPane", "org.netbeans.modules.form.layoutsupport.delegates.JTabbedPaneSupport");
            containerToLayoutDelegate.put("javax.swing.JLayeredPane", "org.netbeans.modules.form.layoutsupport.delegates.JLayeredPaneSupport");
            containerToLayoutDelegate.put("javax.swing.JToolBar", "org.netbeans.modules.form.layoutsupport.delegates.JToolBarSupport");
        }
        return containerToLayoutDelegate;
    }

    private static Map getLayoutsMap() {
        if (layoutToLayoutDelegate == null) {
            layoutToLayoutDelegate = new HashMap();
            layoutToLayoutDelegate.put("java.awt.BorderLayout", "org.netbeans.modules.form.layoutsupport.delegates.BorderLayoutSupport");
            layoutToLayoutDelegate.put("java.awt.FlowLayout", "org.netbeans.modules.form.layoutsupport.delegates.FlowLayoutSupport");
            layoutToLayoutDelegate.put("javax.swing.BoxLayout", "org.netbeans.modules.form.layoutsupport.delegates.BoxLayoutSupport");
            layoutToLayoutDelegate.put("java.awt.GridBagLayout", "org.netbeans.modules.form.layoutsupport.delegates.GridBagLayoutSupport");
            layoutToLayoutDelegate.put("java.awt.GridLayout", "org.netbeans.modules.form.layoutsupport.delegates.GridLayoutSupport");
            layoutToLayoutDelegate.put("java.awt.CardLayout", "org.netbeans.modules.form.layoutsupport.delegates.CardLayoutSupport");
            layoutToLayoutDelegate.put("org.netbeans.lib.awtextra.AbsoluteLayout", "org.netbeans.modules.form.layoutsupport.delegates.AbsoluteLayoutSupport");
        }
        return layoutToLayoutDelegate;
    }

    static {
        needPaletteRescan = true;
    }
}

