/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.delegates;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.beans.PropertyVetoException;
import java.lang.reflect.Constructor;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.codestructure.CodeExpression;
import org.netbeans.modules.form.codestructure.CodeGroup;
import org.netbeans.modules.form.codestructure.CodeStructure;
import org.netbeans.modules.form.codestructure.FormCodeSupport;
import org.netbeans.modules.form.layoutsupport.AbstractLayoutSupport;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.openide.nodes.Node;

public class BoxLayoutSupport
extends AbstractLayoutSupport {
    private int axis = 0;
    private FormProperty[] properties;
    private static Constructor boxLayoutConstructor;

    public Class getSupportedClass() {
        return BoxLayout.class;
    }

    public void acceptContainerLayoutChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        this.updateLayoutInstance();
        super.acceptContainerLayoutChange(propertyChangeEvent);
    }

    public int getNewIndex(Container container, Container container2, Component component, int n, Point point, Point point2) {
        if (!(container2.getLayout() instanceof BoxLayout)) {
            return -1;
        }
        Component[] componentArray = container2.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] == component) continue;
            Rectangle rectangle = componentArray[i].getBounds();
            if (!(this.axis == 0 ? point.x < rectangle.x + rectangle.width / 2 : point.y < rectangle.y + rectangle.height / 2)) continue;
            return i;
        }
        return componentArray.length;
    }

    public boolean paintDragFeedback(Container container, Container container2, Component component, LayoutConstraints layoutConstraints, int n, Graphics graphics) {
        Rectangle rectangle;
        if (!(container2.getLayout() instanceof BoxLayout)) {
            return false;
        }
        Component[] componentArray = container2.getComponents();
        if (componentArray.length == 0 || componentArray.length == 1 && componentArray[0] == component) {
            Insets insets = container2.getInsets();
            rectangle = this.axis == 0 ? new Rectangle(insets.left, insets.top + (container2.getHeight() - insets.top - insets.bottom - 20) / 2, 30, 20) : new Rectangle(insets.left + (container2.getWidth() - insets.left - insets.right - 30) / 2, insets.top, 30, 20);
        } else if (n < 0 || n >= componentArray.length) {
            Component component2 = componentArray[componentArray.length - 1];
            if (component2 == component) {
                component2 = componentArray[componentArray.length - 2];
            }
            Rectangle rectangle2 = component2.getBounds();
            rectangle = this.axis == 0 ? new Rectangle(rectangle2.x + rectangle2.width - 10, rectangle2.y, 20, rectangle2.height) : new Rectangle(rectangle2.x, rectangle2.y + rectangle2.height - 10, rectangle2.width, 20);
        } else {
            Rectangle rectangle3 = componentArray[n].getBounds();
            rectangle = this.axis == 0 ? new Rectangle(rectangle3.x - 10, rectangle3.y, 20, rectangle3.height) : new Rectangle(rectangle3.x, rectangle3.y - 10, rectangle3.width, 20);
        }
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        return true;
    }

    public void setLayoutToContainer(Container container, Container container2) {
        container2.setLayout(this.cloneLayoutInstance(container, container2));
    }

    public void addComponentsToContainer(Container container, Container container2, Component[] componentArray, int n) {
        ((LayoutManager2)container2.getLayout()).invalidateLayout(container2);
        super.addComponentsToContainer(container, container2, componentArray, n);
    }

    protected LayoutManager createDefaultLayoutInstance() {
        return new BoxLayout(new JPanel(), 0);
    }

    protected LayoutManager cloneLayoutInstance(Container container, Container container2) {
        return new BoxLayout(container2, this.axis);
    }

    protected void readInitLayoutCode(CodeExpression codeExpression, CodeGroup codeGroup) {
        CodeExpression[] codeExpressionArray = codeExpression.getOrigin().getCreationParameters();
        if (codeExpressionArray.length == 2) {
            FormCodeSupport.readPropertyExpression(codeExpressionArray[1], this.getProperties()[0], false);
            this.updateLayoutInstance();
        }
    }

    protected CodeExpression createInitLayoutCode(CodeGroup codeGroup) {
        CodeStructure codeStructure = this.getCodeStructure();
        CodeExpression[] codeExpressionArray = new CodeExpression[]{this.getLayoutContext().getContainerDelegateCodeExpression(), codeStructure.createExpression(FormCodeSupport.createOrigin(this.getProperties()[0]))};
        return codeStructure.createExpression(BoxLayoutSupport.getBoxLayoutConstructor(), codeExpressionArray);
    }

    protected FormProperty[] getProperties() {
        if (this.properties == null) {
            this.properties = new FormProperty[1];
            this.properties[0] = new FormProperty("axis", Integer.TYPE, BoxLayoutSupport.getBundle().getString("PROP_axis"), BoxLayoutSupport.getBundle().getString("HINT_axis")){

                public Object getTargetValue() {
                    return new Integer(BoxLayoutSupport.this.axis);
                }

                public void setTargetValue(Object object) {
                    int n = (Integer)object;
                    if (n == 0 || n == 1) {
                        BoxLayoutSupport.this.axis = n;
                    }
                }

                public boolean supportsDefaultValue() {
                    return true;
                }

                public Object getDefaultValue() {
                    return new Integer(0);
                }

                public PropertyEditor getExpliciteEditor() {
                    return new BoxAxisEditor();
                }
            };
        }
        return this.properties;
    }

    protected Node.Property getProperty(String string) {
        return "axis".equals(string) ? this.getProperties()[0] : null;
    }

    private static Constructor getBoxLayoutConstructor() {
        if (boxLayoutConstructor == null) {
            try {
                boxLayoutConstructor = BoxLayout.class.getConstructor(Container.class, Integer.TYPE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
        }
        return boxLayoutConstructor;
    }

    static /* synthetic */ ResourceBundle access$100() {
        return BoxLayoutSupport.getBundle();
    }

    static /* synthetic */ ResourceBundle access$200() {
        return BoxLayoutSupport.getBundle();
    }

    public static final class BoxAxisEditor
    extends PropertyEditorSupport {
        private final String[] tags = new String[]{BoxLayoutSupport.access$100().getString("VALUE_axis_x"), BoxLayoutSupport.access$200().getString("VALUE_axis_y")};
        private final Integer[] values = new Integer[]{new Integer(0), new Integer(1)};
        private final String[] javaInitStrings = new String[]{"javax.swing.BoxLayout.X_AXIS", "javax.swing.BoxLayout.Y_AXIS"};

        public String[] getTags() {
            return this.tags;
        }

        public String getAsText() {
            Object object = this.getValue();
            if (this.values[0].equals(object)) {
                return this.tags[0];
            }
            if (this.values[1].equals(object)) {
                return this.tags[1];
            }
            return null;
        }

        public void setAsText(String string) {
            if (this.tags[0].equals(string)) {
                this.setValue(this.values[0]);
            } else if (this.tags[1].equals(string)) {
                this.setValue(this.values[1]);
            }
        }

        public String getJavaInitializationString() {
            Object object = this.getValue();
            for (int i = 0; i < this.values.length; ++i) {
                if (!this.values[i].equals(object)) continue;
                return this.javaInitStrings[i];
            }
            return null;
        }
    }
}

