/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.delegates;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.ScrollPane;
import org.netbeans.modules.form.fakepeer.FakePeerSupport;
import org.netbeans.modules.form.layoutsupport.AbstractLayoutSupport;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;

public class ScrollPaneSupport
extends AbstractLayoutSupport {
    public Class getSupportedClass() {
        return ScrollPane.class;
    }

    public int getNewIndex(Container container, Container container2, Component component, int n, Point point, Point point2) {
        if (container.getComponentCount() > 1) {
            return -1;
        }
        return 0;
    }

    public boolean paintDragFeedback(Container container, Container container2, Component component, LayoutConstraints layoutConstraints, int n, Graphics graphics) {
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        graphics.drawRect(0, 0, dimension.width, dimension.height);
        return true;
    }

    public void addComponentsToContainer(Container container, Container container2, Component[] componentArray, int n) {
        if (componentArray.length == 0) {
            return;
        }
        if (container instanceof ScrollPane) {
            ScrollPane scrollPane = (ScrollPane)container;
            Component component = null;
            if (scrollPane.getComponentCount() > 0) {
                component = scrollPane.getComponent(0);
            }
            try {
                scrollPane.add(componentArray[0]);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (System.getProperty("java.version").startsWith("1.5") && scrollPane.getPeer() != null) {
                Component component2 = scrollPane.getComponent(0);
                component2.removeNotify();
                ScrollPaneSupport.ensureFakePeerAttached(component2);
                component2.addNotify();
                scrollPane.validate();
            }
            ScrollPaneSupport.ensureFakePeerAttached(component);
        }
    }

    public boolean removeComponentFromContainer(Container container, Container container2, Component component) {
        return false;
    }

    private static void ensureFakePeerAttached(Component component) {
        FakePeerSupport.attachFakePeer(component);
        if (component instanceof Container) {
            FakePeerSupport.attachFakePeerRecursively((Container)component);
        }
    }
}

