/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.form.palette.AddToPaletteWizard;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.HelpCtx;

class ChooseLibraryWizardPanel
implements WizardDescriptor.Panel {
    private LibrarySelector librarySelector;
    private EventListenerList listenerList;

    ChooseLibraryWizardPanel() {
    }

    public Component getComponent() {
        if (this.librarySelector == null) {
            this.librarySelector = new LibrarySelector();
            this.librarySelector.setName(PaletteUtils.getBundleString("CTL_SelectLibrary_Caption"));
            this.librarySelector.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(0));
            this.librarySelector.list.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    ChooseLibraryWizardPanel.this.fireStateChanged();
                }
            });
        }
        return this.librarySelector;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("beans.adding");
    }

    public boolean isValid() {
        return this.librarySelector != null && this.librarySelector.getSelectedLibraries() != null;
    }

    public void readSettings(Object object) {
    }

    public void storeSettings(Object object) {
        if (this.librarySelector != null) {
            Object object2;
            Library[] libraryArray = this.librarySelector.getSelectedLibraries();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            for (int i = 0; i < libraryArray.length; ++i) {
                object2 = libraryArray[i].getContent("classpath");
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    Object object3;
                    int n;
                    URL uRL = (URL)iterator.next();
                    if ("jar".equals(uRL.getProtocol()) && (n = ((String)(object3 = uRL.getPath())).lastIndexOf(33)) != -1) {
                        try {
                            uRL = new URL(((String)object3).substring(0, n));
                        }
                        catch (MalformedURLException malformedURLException) {
                            ErrorManager.getDefault().notify(1, (Throwable)malformedURLException);
                            continue;
                        }
                    }
                    object3 = FileUtil.toFile((FileObject)URLMapper.findFileObject((URL)uRL));
                    String string = ((File)object3).getAbsolutePath();
                    hashMap.put(string, object3);
                    hashMap2.put(string, libraryArray[i].getName());
                }
            }
            File[] fileArray = new File[hashMap.size()];
            hashMap.values().toArray(fileArray);
            object2 = (AddToPaletteWizard)((Object)object);
            ((AddToPaletteWizard)((Object)object2)).setJARFiles(fileArray);
            ((AddToPaletteWizard)((Object)object2)).libraryNameMap = hashMap2;
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.listenerList != null) {
            this.listenerList.remove(ChangeListener.class, changeListener);
        }
    }

    void fireStateChanged() {
        if (this.listenerList == null) {
            return;
        }
        ChangeEvent changeEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ChangeListener == null ? ChooseLibraryWizardPanel.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    private static class LibraryRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final Border hasFocusBorder = new LineBorder(UIManager.getColor("List.focusCellHighlight"));
        private static final Border noFocusBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);

        public LibraryRenderer() {
            this.setOpaque(true);
            this.setBorder(noFocusBorder);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Library library = (Library)object;
            this.setText(library.getDisplayName());
            if (bl) {
                this.setBackground(UIManager.getColor("List.selectionBackground"));
                this.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setBorder(bl2 ? hasFocusBorder : noFocusBorder);
            return this;
        }
    }

    static class LibrarySelector
    extends JPanel {
        JList list = new JList();
        List libList;

        LibrarySelector() {
            this.list.setCellRenderer(new LibraryRenderer());
            this.list.setLayoutOrientation(1);
            this.list.setVisibleRowCount(0);
            this.updateLibraryList();
            this.setLayout(new GridBagLayout());
            JLabel jLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)jLabel, (String)PaletteUtils.getBundleString("CTL_Libraries"));
            jLabel.setLabelFor(this.list);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 6, 0);
            gridBagConstraints.anchor = 17;
            this.add((Component)jLabel, gridBagConstraints);
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setViewportView(this.list);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)jScrollPane, gridBagConstraints);
        }

        Library[] getSelectedLibraries() {
            Object[] objectArray = this.list.getSelectedValues();
            Library[] libraryArray = new Library[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                libraryArray[i] = (Library)objectArray[i];
            }
            return libraryArray;
        }

        void updateLibraryList() {
            Library[] libraryArray = LibraryManager.getDefault().getLibraries();
            this.libList = new ArrayList(libraryArray.length);
            for (int i = 0; i < libraryArray.length; ++i) {
                if (!libraryArray[i].getType().equals("j2se")) continue;
                this.libList.add(libraryArray[i]);
            }
            this.list.setModel(new AbstractListModel(this){
                private final /* synthetic */ LibrarySelector this$0;
                {
                    this.this$0 = librarySelector;
                }

                public int getSize() {
                    return this.this$0.libList.size();
                }

                public Object getElementAt(int n) {
                    return this.this$0.libList.get(n);
                }
            });
        }

        public void addNotify() {
            super.addNotify();
            this.list.requestFocus();
        }

        public Dimension getPreferredSize() {
            return new Dimension(400, 300);
        }
    }
}

