/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.lang.reflect.Field;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.netbeans.modules.form.palette.ScrollPopupMenu;
import org.openide.awt.JMenuPlus;
import org.openide.explorer.view.MenuView;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.util.Utilities;

public class PaletteMenuView
extends JMenuPlus {
    private Node menuNode;
    private NodeAcceptor menuAction;
    private boolean hacked = false;
    private boolean filled = false;
    private int level;
    private static int maxHeight = Utilities.getUsableScreenBounds().height - 25;

    public PaletteMenuView(NodeAcceptor nodeAcceptor) {
        this(PaletteUtils.getPaletteNode(), nodeAcceptor);
    }

    public PaletteMenuView(Node node, NodeAcceptor nodeAcceptor) {
        this(node, nodeAcceptor, 0);
    }

    private PaletteMenuView(Node node, NodeAcceptor nodeAcceptor, int n) {
        this.menuNode = node;
        this.menuAction = nodeAcceptor;
        this.level = n;
        this.setText(node.getDisplayName());
        this.getSubNodes();
    }

    public JPopupMenu getPopupMenu() {
        Object object;
        if (!this.hacked) {
            try {
                object = JMenu.class.getDeclaredField("popupMenu");
                ((Field)object).setAccessible(true);
                if (((Field)object).get((Object)this) == null) {
                    ScrollPopupMenu scrollPopupMenu = new ScrollPopupMenu(maxHeight);
                    scrollPopupMenu.setInvoker((Component)((Object)this));
                    ((Field)object).set((Object)this, scrollPopupMenu);
                }
                this.hacked = true;
            }
            catch (Exception exception) {
                System.out.println("[WARNING] Cannot create scrollable popup menu.");
            }
        }
        object = super.getPopupMenu();
        this.fillSubMenu((JPopupMenu)object);
        return object;
    }

    private void fillSubMenu(JPopupMenu jPopupMenu) {
        if (!this.filled) {
            this.filled = true;
            jPopupMenu.addPopupMenuListener(new PopupListener(jPopupMenu));
            this.removeAll();
            Node[] nodeArray = this.getSubNodes();
            if (nodeArray.length > 0) {
                for (int i = 0; i < nodeArray.length; ++i) {
                    this.add((JMenuItem)(nodeArray[i].isLeaf() ? new MenuView.MenuItem(nodeArray[i], this.menuAction) : new PaletteMenuView(nodeArray[i], this.menuAction, this.level + 1)));
                }
            } else {
                JMenuItem jMenuItem = new JMenuItem(PaletteUtils.getBundleString("CTL_EmptyPaletteMenu"));
                jMenuItem.setEnabled(false);
                this.add(jMenuItem);
            }
        }
    }

    private Node[] getSubNodes() {
        return this.level == 0 ? PaletteUtils.getCategoryNodes(this.menuNode, true) : PaletteUtils.getItemNodes(this.menuNode, true);
    }

    protected Point getPopupMenuOrigin() {
        int n = 0;
        int n2 = 0;
        JPopupMenu jPopupMenu = this.getPopupMenu();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        Dimension dimension3 = jPopupMenu.getSize();
        if (dimension3.width == 0) {
            dimension3 = jPopupMenu.getPreferredSize();
        }
        if (dimension3.height > maxHeight) {
            dimension3.height = maxHeight + 2;
            dimension3.width += 14;
        }
        Point point = this.getLocationOnScreen();
        Container container = this.getParent();
        if (container instanceof JPopupMenu) {
            n = this.getComponentOrientation().isLeftToRight() ? (point.x + dimension2.width + dimension3.width < dimension.width ? dimension2.width : 0 - dimension3.width) : (point.x < dimension3.width ? dimension2.width : 0 - dimension3.width);
            if (point.y + dimension3.height < dimension.height) {
                n2 = 0;
            } else {
                n2 = dimension2.height - dimension3.height;
                if (n2 < -point.y) {
                    n2 = -point.y + 6;
                }
            }
        } else {
            n = this.getComponentOrientation().isLeftToRight() ? (point.x + dimension3.width < dimension.width ? 0 : dimension2.width - dimension3.width) : (point.x + dimension2.width < dimension3.width ? 0 : dimension2.width - dimension3.width);
            n2 = point.y + dimension2.height + dimension3.height < dimension.height ? dimension2.height : -dimension3.height;
        }
        return new Point(n, n2);
    }

    private class PopupListener
    implements PopupMenuListener {
        private JPopupMenu popup;

        PopupListener(JPopupMenu jPopupMenu) {
            this.popup = jPopupMenu;
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            PaletteMenuView.this.filled = false;
            this.popup.removePopupMenuListener(this);
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }
    }
}

