/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.form.palette.FormPaletteActions;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.project.ClassSource;
import org.netbeans.spi.palette.PaletteActions;
import org.netbeans.spi.palette.PaletteController;
import org.netbeans.spi.palette.PaletteFactory;
import org.netbeans.spi.palette.PaletteFilter;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class PaletteUtils {
    private static FileObject paletteFolder;
    private static DataFolder paletteDataFolder;
    private static PaletteController palette;

    private PaletteUtils() {
    }

    static String getItemComponentDescription(PaletteItem paletteItem) {
        ClassSource classSource = paletteItem.getComponentClassSource();
        if (classSource == null || classSource.getCPRootCount() == 0) {
            String string = classSource.getClassName();
            if (string != null) {
                if (string.startsWith("javax.") || string.startsWith("java.")) {
                    return PaletteUtils.getBundleString("MSG_StandardJDKComponent");
                }
                if (string.startsWith("org.netbeans.")) {
                    return PaletteUtils.getBundleString("MSG_NetBeansComponent");
                }
            }
        } else {
            String string = classSource.getCPRootType(0);
            String string2 = classSource.getCPRootName(0);
            if ("jar".equals(string)) {
                return MessageFormat.format(PaletteUtils.getBundleString("FMT_ComponentFromJar"), string2);
            }
            if ("library".equals(string)) {
                Library library = LibraryManager.getDefault().getLibrary(string2);
                return MessageFormat.format(PaletteUtils.getBundleString("FMT_ComponentFromLibrary"), library != null ? library.getDisplayName() : string2);
            }
            if ("project".equals(string)) {
                try {
                    Project project = FileOwnerQuery.getOwner((URI)new File(string2).toURI());
                    return MessageFormat.format(PaletteUtils.getBundleString("FMT_ComponentFromProject"), project == null ? string2 : FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return PaletteUtils.getBundleString("MSG_UnspecifiedComponent");
    }

    public static FileObject getPaletteFolder() {
        if (paletteFolder != null) {
            return paletteFolder;
        }
        try {
            paletteFolder = Repository.getDefault().getDefaultFileSystem().findResource("FormDesignerPalette");
            if (paletteFolder == null) {
                paletteFolder = Repository.getDefault().getDefaultFileSystem().getRoot().createFolder("FormDesignerPalette");
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Palette folder not found and cannot be created.");
        }
        return paletteFolder;
    }

    static Node getPaletteNode() {
        return PaletteUtils.getPaletteDataFolder().getNodeDelegate();
    }

    public static PaletteController getPalette() {
        if (null == palette) {
            try {
                PaletteFilter paletteFilter = new PaletteFilter(){

                    public boolean isValidCategory(Lookup lookup) {
                        FilterNode filterNode = (FilterNode)lookup.lookup(class$org$openide$nodes$Node == null ? (class$org$openide$nodes$Node = PaletteUtils.class$("org.openide.nodes.Node")) : class$org$openide$nodes$Node);
                        return PaletteUtils.representsValidPaletteCategory((Node)filterNode);
                    }

                    public boolean isValidItem(Lookup lookup) {
                        return true;
                    }
                };
                palette = PaletteFactory.createPalette((String)"FormDesignerPalette", (PaletteActions)new FormPaletteActions(), (PaletteFilter)paletteFilter, null);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
        }
        return palette;
    }

    static DataFolder getPaletteDataFolder() {
        if (paletteDataFolder == null) {
            paletteDataFolder = DataFolder.findFolder((FileObject)PaletteUtils.getPaletteFolder());
        }
        return paletteDataFolder;
    }

    public static void clearPaletteSelection() {
        PaletteUtils.getPalette().clearSelection();
    }

    public static PaletteItem getSelectedItem() {
        Lookup lookup = PaletteUtils.getPalette().getSelectedItem();
        return (PaletteItem)lookup.lookup(PaletteItem.class);
    }

    public static void selectItem(PaletteItem paletteItem) {
        if (null == paletteItem) {
            PaletteUtils.getPalette().clearSelection();
        } else {
            Node node = (Node)PaletteUtils.getPalette().getRoot().lookup(Node.class);
            Node[] nodeArray = PaletteUtils.getCategoryNodes(node, false, true);
            for (int i = 0; i < nodeArray.length; ++i) {
                Node[] nodeArray2 = PaletteUtils.getItemNodes(nodeArray[i], true);
                for (int j = 0; j < nodeArray2.length; ++j) {
                    PaletteItem paletteItem2 = (PaletteItem)nodeArray2[j].getLookup().lookup(class$org$netbeans$modules$form$palette$PaletteItem == null ? PaletteUtils.class$("org.netbeans.modules.form.palette.PaletteItem") : class$org$netbeans$modules$form$palette$PaletteItem);
                    if (!paletteItem.equals(paletteItem2)) continue;
                    PaletteUtils.getPalette().setSelectedItem(nodeArray[i].getLookup(), nodeArray2[j].getLookup());
                }
            }
        }
    }

    public static PaletteItem[] getAllItems() {
        HashSet<PaletteItem> hashSet = null;
        Node[] nodeArray = PaletteUtils.getCategoryNodes(PaletteUtils.getPaletteNode(), false, false);
        for (int i = 0; i < nodeArray.length; ++i) {
            Node[] nodeArray2 = PaletteUtils.getItemNodes(nodeArray[i], true);
            for (int j = 0; j < nodeArray2.length; ++j) {
                PaletteItem paletteItem = (PaletteItem)nodeArray2[j].getLookup().lookup(class$org$netbeans$modules$form$palette$PaletteItem == null ? PaletteUtils.class$("org.netbeans.modules.form.palette.PaletteItem") : class$org$netbeans$modules$form$palette$PaletteItem);
                if (null == paletteItem) continue;
                if (null == hashSet) {
                    hashSet = new HashSet<PaletteItem>();
                }
                hashSet.add(paletteItem);
            }
        }
        PaletteItem[] paletteItemArray = null != hashSet ? hashSet.toArray(new PaletteItem[hashSet.size()]) : new PaletteItem[]{};
        return paletteItemArray;
    }

    static String getBundleString(String string) {
        return NbBundle.getBundle((Class)PaletteUtils.class).getString(string);
    }

    public static Node[] getItemNodes(Node node, boolean bl) {
        Node[] nodeArray = node.getChildren().getNodes(true);
        return nodeArray;
    }

    public static Node[] getCategoryNodes(Node node, boolean bl) {
        return PaletteUtils.getCategoryNodes(node, bl, true);
    }

    private static Node[] getCategoryNodes(Node node, boolean bl, boolean bl2) {
        Node[] nodeArray = node.getChildren().getNodes(true);
        ArrayList<Node> arrayList = null;
        for (int i = 0; i < nodeArray.length; ++i) {
            if (bl && PaletteUtils.isVisibleCategoryNode(nodeArray[i], bl) || !bl && (!bl2 || PaletteUtils.representsValidPaletteCategory(nodeArray[i]))) {
                if (arrayList == null) continue;
                arrayList.add(nodeArray[i]);
                continue;
            }
            if (arrayList != null) continue;
            arrayList = new ArrayList<Node>(nodeArray.length);
            for (int j = 0; j < i; ++j) {
                arrayList.add(nodeArray[j]);
            }
        }
        if (arrayList != null) {
            nodeArray = new Node[arrayList.size()];
            arrayList.toArray(nodeArray);
        }
        return nodeArray;
    }

    static boolean isVisibleCategoryNode(Node node, boolean bl) {
        DataFolder dataFolder = (DataFolder)node.getCookie(DataFolder.class);
        return dataFolder != null && (!bl || PaletteUtils.representsVisibleCategory(node));
    }

    private static boolean representsVisibleCategory(Node node) {
        Object object = node.getValue("psa_isVisible");
        DataFolder dataFolder = (DataFolder)node.getCookie(DataFolder.class);
        if (dataFolder == null) {
            return false;
        }
        if (null == object || "null".equals(object)) {
            object = dataFolder.getPrimaryFile().getAttribute("isVisible");
        }
        if (object == null) {
            object = Boolean.TRUE;
        }
        return Boolean.valueOf(object.toString()) != false && PaletteUtils.representsValidPaletteCategory(node);
    }

    private static boolean representsValidPaletteCategory(Node node) {
        DataFolder dataFolder = (DataFolder)node.getCookie(DataFolder.class);
        return dataFolder != null && !Boolean.TRUE.equals(dataFolder.getPrimaryFile().getAttribute("isNoPaletteCategory"));
    }
}

